/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenSubjectExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenConditionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkDuplicatedLabels", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirWhenConditionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenConditionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenConditionChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,69:1\n45#2:70\n*S KotlinDebug\n*F\n+ 1 FirWhenConditionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenConditionChecker\n*L\n41#1:70\n*E\n"})
public final class FirWhenConditionChecker
extends FirExpressionChecker<FirWhenExpression> {
    @NotNull
    public static final FirWhenConditionChecker INSTANCE = new FirWhenConditionChecker();

    private FirWhenConditionChecker() {
    }

    @Override
    public void check(@NotNull FirWhenExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirWhenBranch branch : expression2.getBranches()) {
            FirExpression condition = branch.getCondition();
            if (condition instanceof FirElseIfTrueCondition) continue;
            FirHelpersKt.checkCondition(condition, context2, reporter);
        }
        if (expression2.getSubject() != null) {
            this.checkDuplicatedLabels(expression2, context2, reporter);
        }
    }

    private final void checkDuplicatedLabels(FirWhenExpression expression2, CheckerContext context2, DiagnosticReporter reporter) {
        HashSet<Pair> checkedTypes = new HashSet<Pair>();
        HashSet checkedConstants = new HashSet();
        for (FirWhenBranch branch : expression2.getBranches()) {
            ConeKotlinType coneType;
            FirExpression condition = branch.getCondition();
            if (condition instanceof FirEqualityOperatorCall) {
                Object value2;
                Object object;
                FirCall $this$arguments$iv = (FirCall)((Object)condition);
                boolean $i$f$getArguments = false;
                List<FirExpression> arguments2 = $this$arguments$iv.getArgumentList().getArguments();
                if (arguments2.size() != 2 || !(FirExpressionUtilKt.unwrapSmartcastExpression(arguments2.get(0)) instanceof FirWhenSubjectExpression)) continue;
                FirExpression targetExpression = arguments2.get(1);
                if (targetExpression instanceof FirConstExpression) {
                    object = ((FirConstExpression)targetExpression).getValue();
                } else if (targetExpression instanceof FirQualifiedAccessExpression) {
                    FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(((FirQualifiedAccessExpression)targetExpression).getCalleeReference(), false, 1, null);
                    object = firCallableSymbol instanceof FirEnumEntrySymbol ? (FirEnumEntrySymbol)firCallableSymbol : null;
                    if (object == null) {
                        continue;
                    }
                } else {
                    FirClassLikeSymbol<?> classSymbol;
                    if (!(targetExpression instanceof FirResolvedQualifier) || ((FirResolvedQualifier)targetExpression).getSymbol() == null || FirHelpersKt.getClassKind(classSymbol) != ClassKind.OBJECT) continue;
                    object = classSymbol.getClassId();
                }
                if (checkedConstants.add(value2 = object)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)condition.getSource(), FirErrors.INSTANCE.getDUPLICATE_LABEL_IN_WHEN(), (DiagnosticContext)context2, null, 8, null);
                continue;
            }
            if (!(condition instanceof FirTypeOperatorCall) || checkedTypes.add(TuplesKt.to((Object)(coneType = FirTypeUtilsKt.getConeType(((FirTypeOperatorCall)condition).getConversionTypeRef())), (Object)((Object)((FirTypeOperatorCall)condition).getOperation())))) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirTypeOperatorCall)condition).getConversionTypeRef().getSource(), FirErrors.INSTANCE.getDUPLICATE_LABEL_IN_WHEN(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

