/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKindKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInlineCheckerPlatformSpecificComponent;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInlineCheckerPlatformSpecificComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirInlineDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PublishedApiEffectiveVisibilityKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J6\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0014\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\u00180\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\"\u0010\u001d\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\u00180\u0017*\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkCallableDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "checkCanBeInlined", "", "effectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "checkNothingToInline", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "checkParameters", "overriddenSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "checkParametersInNotInline", "isInlinableDefaultValue", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getOverriddenSymbols", "InlineFunctionBodyContext", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirInlineDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInlineDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,492:1\n43#2:493\n46#2:494\n46#2:495\n40#2:496\n37#2,10:497\n28#2:513\n1747#3,3:507\n1747#3,3:510\n*S KotlinDebug\n*F\n+ 1 FirInlineDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker\n*L\n43#1:493\n360#1:494\n364#1:495\n411#1:496\n421#1:497,10\n470#1:513\n422#1:507,3\n425#1:510,3\n*E\n"})
public final class FirInlineDeclarationChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirInlineDeclarationChecker INSTANCE = new FirInlineDeclarationChecker();

    private FirInlineDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirFunction declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirMemberDeclaration $this$isInline$iv = declaration;
        boolean $i$f$isInline = false;
        if (!$this$isInline$iv.getStatus().isInline()) {
            this.checkParametersInNotInline(declaration, context2, reporter);
            return;
        }
        FirInlineCheckerPlatformSpecificComponent firInlineCheckerPlatformSpecificComponent = FirInlineCheckerPlatformSpecificComponentKt.getInlineCheckerExtension(context2.getSession());
        boolean bl = firInlineCheckerPlatformSpecificComponent != null ? !firInlineCheckerPlatformSpecificComponent.isGenerallyOk(declaration, context2, reporter) : false;
        if (bl) {
            return;
        }
        if (!(declaration instanceof FirPropertyAccessor) && !(declaration instanceof FirSimpleFunction)) {
            return;
        }
        this.checkCallableDeclaration(declaration, context2, reporter);
    }

    private final void checkParameters(FirSimpleFunction function2, List<? extends FirCallableSymbol<? extends FirCallableDeclaration>> overriddenSymbols2, CheckerContext context2, DiagnosticReporter reporter) {
        block9: {
            for (FirValueParameter firValueParameter : function2.getValueParameters()) {
                ConeKotlinType coneType = FirTypeUtilsKt.getConeType(firValueParameter.getReturnTypeRef());
                FunctionTypeKind functionKind = FunctionalTypeUtilsKt.functionTypeKind(coneType, context2.getSession());
                boolean isFunctionalType = functionKind != null;
                FunctionTypeKind functionTypeKind = functionKind;
                boolean isSuspendFunctionType = functionTypeKind != null ? FunctionTypeKindKt.isSuspendOrKSuspendFunction(functionTypeKind) : false;
                FirExpression defaultValue = firValueParameter.getDefaultValue();
                if (!isFunctionalType && (firValueParameter.isNoinline() || firValueParameter.isCrossinline())) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firValueParameter.getSource(), FirErrors.INSTANCE.getILLEGAL_INLINE_PARAMETER_MODIFIER(), (DiagnosticContext)context2, null, 8, null);
                }
                if (firValueParameter.isNoinline()) continue;
                FirMemberDeclaration $this$isSuspend$iv = function2;
                boolean $i$f$isSuspend = false;
                if ($this$isSuspend$iv.getStatus().isSuspend() && defaultValue != null && isSuspendFunctionType) {
                    FirInlineCheckerPlatformSpecificComponent firInlineCheckerPlatformSpecificComponent = FirInlineCheckerPlatformSpecificComponentKt.getInlineCheckerExtension(context2.getSession());
                    if (firInlineCheckerPlatformSpecificComponent != null) {
                        firInlineCheckerPlatformSpecificComponent.checkSuspendFunctionalParameterWithDefaultValue(firValueParameter, context2, reporter);
                    }
                }
                if (isSuspendFunctionType && !firValueParameter.isCrossinline()) {
                    $this$isSuspend$iv = function2;
                    $i$f$isSuspend = false;
                    if (!$this$isSuspend$iv.getStatus().isSuspend()) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firValueParameter.getSource(), FirErrors.INSTANCE.getINLINE_SUSPEND_FUNCTION_TYPE_UNSUPPORTED(), (DiagnosticContext)context2, null, 8, null);
                    }
                }
                if (ConeTypeUtilsKt.isNullable(coneType) && isFunctionalType) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firValueParameter.getSource(), FirErrors.INSTANCE.getNULLABLE_INLINE_PARAMETER(), (Object)firValueParameter.getSymbol(), (Object)function2.getSymbol(), (DiagnosticContext)context2, null, 32, null);
                }
                if (!isFunctionalType || defaultValue == null || this.isInlinableDefaultValue(defaultValue)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)defaultValue.getSource(), FirErrors.INSTANCE.getINVALID_DEFAULT_FUNCTIONAL_PARAMETER_FOR_INLINE(), (Object)firValueParameter.getSymbol(), (DiagnosticContext)context2, null, 16, null);
            }
            if (!((Collection)overriddenSymbols2).isEmpty()) {
                for (FirTypeParameter firTypeParameter : function2.getTypeParameters()) {
                    if (!firTypeParameter.isReified()) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firTypeParameter.getSource(), FirErrors.INSTANCE.getREIFIED_TYPE_PARAMETER_IN_OVERRIDE(), (DiagnosticContext)context2, null, 8, null);
                }
            }
            FirInlineCheckerPlatformSpecificComponent firInlineCheckerPlatformSpecificComponent = FirInlineCheckerPlatformSpecificComponentKt.getInlineCheckerExtension(context2.getSession());
            if (firInlineCheckerPlatformSpecificComponent == null) break block9;
            firInlineCheckerPlatformSpecificComponent.checkFunctionalParametersWithInheritedDefaultValues(function2, context2, reporter, overriddenSymbols2);
        }
    }

    private final void checkParametersInNotInline(FirFunction function2, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirValueParameter param : function2.getValueParameters()) {
            if (!param.isNoinline() && !param.isCrossinline()) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)param.getSource(), FirErrors.INSTANCE.getILLEGAL_INLINE_PARAMETER_MODIFIER(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final List<FirCallableSymbol<? extends FirCallableDeclaration>> getOverriddenSymbols(FirCallableDeclaration $this$getOverriddenSymbols, CheckerContext context2) {
        FirMemberDeclaration $this$isOverride$iv = $this$getOverriddenSymbols;
        boolean $i$f$isOverride = false;
        if (!$this$isOverride$iv.getStatus().isOverride()) {
            return CollectionsKt.emptyList();
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag($this$getOverriddenSymbols);
        FirClassLikeSymbol<?> firClassLikeSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession()) : null;
        FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if (firClassSymbol == null) {
            return CollectionsKt.emptyList();
        }
        FirClassSymbol classSymbol = firClassSymbol;
        FirTypeScope scope2 = FirHelpersKt.unsubstitutedScope(classSymbol, context2);
        scope2.processFunctionsByName($this$getOverriddenSymbols.getSymbol().getName(), (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)getOverriddenSymbols.1.INSTANCE));
        return FirTypeScopeKt.getDirectOverriddenMembers(scope2, $this$getOverriddenSymbols.getSymbol(), true);
    }

    private final void checkNothingToInline(FirSimpleFunction function2, CheckerContext context2, DiagnosticReporter reporter) {
        boolean hasInlinableParameters;
        FirSession session;
        block15: {
            boolean bl;
            boolean bl2;
            block14: {
                block17: {
                    block16: {
                        FirMemberDeclaration $this$isExpect$iv = function2;
                        boolean $i$f$isExpect = false;
                        if ($this$isExpect$iv.getStatus().isExpect()) break block16;
                        FirMemberDeclaration $this$isSuspend$iv = function2;
                        boolean $i$f$isSuspend = false;
                        if (!$this$isSuspend$iv.getStatus().isSuspend()) break block17;
                    }
                    return;
                }
                Iterable $this$any$iv = function2.getTypeParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeParameter it = (FirTypeParameter)element$iv;
                        boolean bl3 = false;
                        if (!it.getSymbol().isReified()) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return;
            }
            session = context2.getSession();
            Iterable $this$any$iv = function2.getValueParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirValueParameter param = (FirValueParameter)element$iv;
                    boolean bl4 = false;
                    ConeKotlinType type2 = FirTypeUtilsKt.getConeType(param.getReturnTypeRef());
                    boolean bl5 = !param.isNoinline() && !ConeTypeUtilsKt.isNullable(type2) && (FunctionalTypeUtilsKt.isBasicFunctionType(type2, session) || FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType(type2, session));
                    if (!bl5) continue;
                    bl = true;
                    break block15;
                }
                bl = hasInlinableParameters = false;
            }
        }
        if (hasInlinableParameters) {
            return;
        }
        if (FirHelpersKt.isInlineOnly(function2, session)) {
            return;
        }
        if (DeclarationUtilsKt.needsMultiFieldValueClassFlattening(function2.getReturnTypeRef(), session)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)function2.getSource(), FirErrors.INSTANCE.getNOTHING_TO_INLINE(), (DiagnosticContext)context2, null, 8, null);
    }

    private final boolean checkCanBeInlined(FirCallableDeclaration declaration, EffectiveVisibility effectiveVisibility, CheckerContext context2, DiagnosticReporter reporter) {
        if (ClassMembersKt.containingClassLookupTag(declaration) == null) {
            return true;
        }
        if (Intrinsics.areEqual((Object)effectiveVisibility, (Object)EffectiveVisibility.PrivateInClass.INSTANCE)) {
            return true;
        }
        if (!DeclarationUtilsKt.isEffectivelyFinal(declaration, context2)) {
            KtSourceElement ktSourceElement = declaration.getSource();
            if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getDECLARATION_CANT_BE_INLINED(), (DiagnosticContext)context2, null, 8, null);
            }
            return false;
        }
        return true;
    }

    private final boolean isInlinableDefaultValue(FirExpression expression2) {
        return expression2 instanceof FirCallableReferenceAccess || expression2 instanceof FirFunctionCall || expression2 instanceof FirLambdaArgumentExpression || expression2 instanceof FirAnonymousFunctionExpression || expression2 instanceof FirConstExpression && ((FirConstExpression)expression2).getValue() == null;
    }

    public final void checkCallableDeclaration(@NotNull FirCallableDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean canBeInlined;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration instanceof FirPropertyAccessor) {
            return;
        }
        List<FirCallableSymbol<? extends FirCallableDeclaration>> overriddenSymbols2 = this.getOverriddenSymbols(declaration, context2);
        if (declaration instanceof FirSimpleFunction) {
            this.checkParameters((FirSimpleFunction)declaration, overriddenSymbols2, context2, reporter);
            this.checkNothingToInline((FirSimpleFunction)declaration, context2, reporter);
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if ((canBeInlined = this.checkCanBeInlined(declaration, (EffectiveVisibility)object, context2, reporter)) && !((Collection)overriddenSymbols2).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getOVERRIDE_BY_INLINE(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001EB+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ9\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J3\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b%J,\u0010&\u001a\u00020\u00022\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J3\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*2\f\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b+J6\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\f\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J3\u00101\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\f\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b2J,\u00103\u001a\u00020\u00022\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J,\u00104\u001a\u00020\u00022\n\u0010'\u001a\u0006\u0012\u0002\b\u0003052\u0006\u00106\u001a\u00020*2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J6\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u00020*2\f\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u0001052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u00109\u001a\u00020\u00112\f\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001aH\u0002J\u0018\u0010:\u001a\u00020\u00022\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0003H\u0016J\u0018\u0010>\u001a\u00020\u00022\u0006\u0010?\u001a\u00020@2\u0006\u0010=\u001a\u00020\u0003H\u0016J\u0010\u0010A\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030BH\u0002J\u0010\u0010C\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\u001aH\u0002J\u0014\u0010D\u001a\u00020\u0011*\u00020*2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "inlineFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "inlineFunEffectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "inlinableParameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Ljava/util/List;Lorg/jetbrains/kotlin/fir/FirSession;)V", "getInlineFunction", "()Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "isEffectivelyPrivateApiFunction", "", "prohibitProtectedCallFromInline", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "checkAccessedDeclaration", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext$AccessedDeclarationVisibilityData;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "accessedSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "declarationVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "context", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAccessedDeclaration$checkers", "checkArgumentsOfCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "targetSymbol", "checkArgumentsOfCall$checkers", "checkPrivateClassMemberAccess", "calledDeclaration", "checkQualifiedAccess", "qualifiedAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "checkQualifiedAccess$checkers", "checkReceiver", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "receiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkReceiversOfQualifiedAccessExpression", "checkReceiversOfQualifiedAccessExpression$checkers", "checkRecursion", "checkSuperCalls", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "callExpression", "checkVisibilityAndAccess", "accessExpression", "isInvokeOrInlineExtension", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitSmartCastExpression", "smartCastExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirSmartCastExpression;", "isDefinedInInlineFunction", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "isInsidePrivateClass", "partOfCall", "AccessedDeclarationVisibilityData", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirInlineDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInlineDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext\n+ 2 publishedApiEffectiveVisibility.kt\norg/jetbrains/kotlin/fir/resolve/transformers/PublishedApiEffectiveVisibilityKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,492:1\n45#2,2:493\n45#2,2:496\n19#3:495\n45#3:498\n28#3:505\n18#3:513\n44#3:514\n44#3:515\n56#3:516\n59#4,4:499\n45#4:509\n288#5,2:503\n1747#5,3:506\n1747#5,3:510\n*S KotlinDebug\n*F\n+ 1 FirInlineDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext\n*L\n77#1:493,2\n78#1:496,2\n77#1:495\n78#1:498\n144#1:505\n234#1:513\n327#1:514\n328#1:515\n334#1:516\n136#1:499,4\n215#1:509\n141#1:503,2\n200#1:506,3\n215#1:510,3\n*E\n"})
    public static final class InlineFunctionBodyContext
    extends FirDefaultVisitor<Unit, CheckerContext> {
        @NotNull
        private final FirFunction inlineFunction;
        @NotNull
        private final EffectiveVisibility inlineFunEffectiveVisibility;
        @NotNull
        private final List<FirValueParameterSymbol> inlinableParameters;
        @NotNull
        private final FirSession session;
        private final boolean isEffectivelyPrivateApiFunction;
        private final boolean prohibitProtectedCallFromInline;

        public InlineFunctionBodyContext(@NotNull FirFunction inlineFunction2, @NotNull EffectiveVisibility inlineFunEffectiveVisibility, @NotNull List<FirValueParameterSymbol> inlinableParameters, @NotNull FirSession session) {
            Intrinsics.checkNotNullParameter((Object)inlineFunction2, (String)"inlineFunction");
            Intrinsics.checkNotNullParameter((Object)inlineFunEffectiveVisibility, (String)"inlineFunEffectiveVisibility");
            Intrinsics.checkNotNullParameter(inlinableParameters, (String)"inlinableParameters");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.inlineFunction = inlineFunction2;
            this.inlineFunEffectiveVisibility = inlineFunEffectiveVisibility;
            this.inlinableParameters = inlinableParameters;
            this.session = session;
            this.isEffectivelyPrivateApiFunction = this.inlineFunEffectiveVisibility.getPrivateApi();
            this.prohibitProtectedCallFromInline = FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).supportsFeature(LanguageFeature.ProhibitProtectedCallFromInline);
        }

        @NotNull
        public final FirFunction getInlineFunction() {
            return this.inlineFunction;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull CheckerContext data2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        }

        @Override
        public void visitSmartCastExpression(@NotNull FirSmartCastExpression smartCastExpression, @NotNull CheckerContext data2) {
            Intrinsics.checkNotNullParameter((Object)smartCastExpression, (String)"smartCastExpression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        }

        @NotNull
        public final AccessedDeclarationVisibilityData checkAccessedDeclaration$checkers(@NotNull KtSourceElement source, @NotNull FirBasedSymbol<?> accessedSymbol, @NotNull Visibility declarationVisibility, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            EffectiveVisibility recordedEffectiveVisibility;
            boolean $i$f$getEffectiveVisibility;
            FirBasedSymbol $this$effectiveVisibility$iv;
            EffectiveVisibility effectiveVisibility;
            boolean $i$f$getPublishedApiEffectiveVisibility;
            FirBasedSymbol<?> $this$publishedApiEffectiveVisibility$iv;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter(accessedSymbol, (String)"accessedSymbol");
            Intrinsics.checkNotNullParameter((Object)declarationVisibility, (String)"declarationVisibility");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirBasedSymbol<?> firBasedSymbol = accessedSymbol;
            if (firBasedSymbol instanceof FirCallableSymbol) {
                $this$publishedApiEffectiveVisibility$iv = accessedSymbol;
                $i$f$getPublishedApiEffectiveVisibility = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase($this$publishedApiEffectiveVisibility$iv, FirResolvePhase.STATUS);
                effectiveVisibility = PublishedApiEffectiveVisibilityKt.getPublishedApiEffectiveVisibility($this$publishedApiEffectiveVisibility$iv.getFir());
                if (effectiveVisibility == null) {
                    $this$effectiveVisibility$iv = (FirCallableSymbol)accessedSymbol;
                    $i$f$getEffectiveVisibility = false;
                    effectiveVisibility = ((FirCallableSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
                }
            } else if (firBasedSymbol instanceof FirClassLikeSymbol) {
                $this$publishedApiEffectiveVisibility$iv = accessedSymbol;
                $i$f$getPublishedApiEffectiveVisibility = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase($this$publishedApiEffectiveVisibility$iv, FirResolvePhase.STATUS);
                effectiveVisibility = PublishedApiEffectiveVisibilityKt.getPublishedApiEffectiveVisibility($this$publishedApiEffectiveVisibility$iv.getFir());
                if (effectiveVisibility == null) {
                    $this$effectiveVisibility$iv = (FirClassLikeSymbol)accessedSymbol;
                    $i$f$getEffectiveVisibility = false;
                    effectiveVisibility = ((FirClassLikeSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
                }
            } else {
                AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
                throw null;
            }
            EffectiveVisibility it = recordedEffectiveVisibility = effectiveVisibility;
            boolean bl = false;
            EffectiveVisibility accessedDeclarationEffectiveVisibility = Intrinsics.areEqual((Object)it, (Object)EffectiveVisibility.Local.INSTANCE) ? (EffectiveVisibility)EffectiveVisibility.Public.INSTANCE : it;
            boolean isCalledFunPublicOrPublishedApi = accessedDeclarationEffectiveVisibility.getPublicApi();
            boolean isInlineFunPublicOrPublishedApi = this.inlineFunEffectiveVisibility.getPublicApi();
            if (isInlineFunPublicOrPublishedApi && !isCalledFunPublicOrPublishedApi && declarationVisibility != Visibilities.Local.INSTANCE) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_PUBLIC_CALL_FROM_PUBLIC_INLINE(), this.inlineFunction.getSymbol(), accessedSymbol, (DiagnosticContext)context2, null, 32, null);
            } else {
                this.checkPrivateClassMemberAccess(accessedSymbol, source, context2, reporter);
            }
            return new AccessedDeclarationVisibilityData(isInlineFunPublicOrPublishedApi, isCalledFunPublicOrPublishedApi, accessedDeclarationEffectiveVisibility);
        }

        public final void checkReceiversOfQualifiedAccessExpression$checkers(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @Nullable FirBasedSymbol<?> targetSymbol, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)qualifiedAccessExpression, (String)"qualifiedAccessExpression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            this.checkReceiver(qualifiedAccessExpression, qualifiedAccessExpression.getDispatchReceiver(), targetSymbol, context2, reporter);
            this.checkReceiver(qualifiedAccessExpression, qualifiedAccessExpression.getExtensionReceiver(), targetSymbol, context2, reporter);
        }

        public final void checkArgumentsOfCall$checkers(@NotNull FirFunctionCall functionCall, @Nullable FirBasedSymbol<?> targetSymbol, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (context2.isContractBody()) {
                return;
            }
            FirNamedFunctionSymbol firNamedFunctionSymbol = targetSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)targetSymbol : null;
            if (firNamedFunctionSymbol == null) {
                return;
            }
            FirNamedFunctionSymbol calledFunctionSymbol = firNamedFunctionSymbol;
            FirCall $this$resolvedArgumentMapping$iv = functionCall;
            boolean $i$f$getResolvedArgumentMapping = false;
            FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
            LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
            if (linkedHashMap == null) {
                return;
            }
            LinkedHashMap<FirExpression, FirValueParameter> argumentMapping = linkedHashMap;
            for (Map.Entry entry : ((Map)argumentMapping).entrySet()) {
                KtDiagnosticFactory1<FirBasedSymbol<?>> ktDiagnosticFactory1;
                FirValueParameterSymbol valueParameterOfOriginalInlineFunction;
                Object v2;
                FirExpression argument2;
                FirValueParameter valueParameter2;
                block9: {
                    FirVariableSymbol resolvedArgumentSymbol;
                    FirExpression wrappedArgument = (FirExpression)entry.getKey();
                    valueParameter2 = (FirValueParameter)entry.getValue();
                    argument2 = FirExpressionUtilKt.unwrapArgument(wrappedArgument);
                    FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(argument2);
                    if ((firCallableSymbol instanceof FirVariableSymbol ? (FirVariableSymbol)firCallableSymbol : null) == null) continue;
                    resolvedArgumentSymbol = resolvedArgumentSymbol;
                    Iterable $this$firstOrNull$iv = this.inlinableParameters;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)resolvedArgumentSymbol)) continue;
                        v2 = element$iv;
                        break block9;
                    }
                    v2 = null;
                }
                if ((valueParameterOfOriginalInlineFunction = (FirValueParameterSymbol)v2) == null) continue;
                FirCallableSymbol $this$isInline$iv = calledFunctionSymbol;
                boolean $i$f$isInline = false;
                if ($this$isInline$iv.getRawStatus().isInline()) {
                    if (valueParameter2.isNoinline()) {
                        ktDiagnosticFactory1 = FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE();
                    } else {
                        if (!valueParameter2.isCrossinline() || valueParameterOfOriginalInlineFunction.isCrossinline()) continue;
                        ktDiagnosticFactory1 = FirErrors.INSTANCE.getNON_LOCAL_RETURN_NOT_ALLOWED();
                    }
                } else {
                    ktDiagnosticFactory1 = FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE();
                }
                KtDiagnosticFactory1<FirBasedSymbol<?>> factory2 = ktDiagnosticFactory1;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)argument2.getSource(), factory2, (Object)valueParameterOfOriginalInlineFunction, (DiagnosticContext)context2, null, 16, null);
            }
        }

        private final void checkReceiver(FirQualifiedAccessExpression qualifiedAccessExpression, FirExpression receiverExpression, FirBasedSymbol<?> targetSymbol, CheckerContext context2, DiagnosticReporter reporter) {
            FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(receiverExpression);
            if (firCallableSymbol == null) {
                return;
            }
            FirCallableSymbol<?> receiverSymbol = firCallableSymbol;
            if (CollectionsKt.contains((Iterable)this.inlinableParameters, receiverSymbol) && !this.isInvokeOrInlineExtension(targetSymbol)) {
                KtSourceElement ktSourceElement = receiverExpression.getSource();
                if (ktSourceElement == null) {
                    ktSourceElement = qualifiedAccessExpression.getSource();
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE(), receiverSymbol, (DiagnosticContext)context2, null, 16, null);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isInvokeOrInlineExtension(FirBasedSymbol<?> targetSymbol) {
            if (!(targetSymbol instanceof FirNamedFunctionSymbol)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)((FirNamedFunctionSymbol)targetSymbol).getName(), (Object)OperatorNameConventions.INVOKE)) return false;
            ConeSimpleKotlinType coneSimpleKotlinType = ((FirNamedFunctionSymbol)targetSymbol).getDispatchReceiverType();
            if (coneSimpleKotlinType == null) return false;
            if (!FunctionalTypeUtilsKt.isSomeFunctionType(coneSimpleKotlinType, this.session)) return false;
            return true;
        }

        public final void checkQualifiedAccess$checkers(@NotNull FirStatement qualifiedAccess, @Nullable FirBasedSymbol<?> targetSymbol, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)qualifiedAccess, (String)"qualifiedAccess");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            KtSourceElement ktSourceElement = qualifiedAccess.getSource();
            if (ktSourceElement == null) {
                return;
            }
            KtSourceElement source = ktSourceElement;
            if (!(targetSymbol instanceof FirCallableSymbol)) {
                return;
            }
            if (CollectionsKt.contains((Iterable)this.inlinableParameters, targetSymbol)) {
                boolean bl;
                block8: {
                    if (!this.partOfCall(qualifiedAccess, context2)) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE(), targetSymbol, (DiagnosticContext)context2, null, 16, null);
                    }
                    Iterable $this$any$iv = context2.getContainingDeclarations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FirDeclaration it = (FirDeclaration)element$iv;
                            boolean bl2 = false;
                            if (!CollectionsKt.contains((Iterable)this.inlinableParameters, it.getSymbol())) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNOT_SUPPORTED_INLINE_PARAMETER_IN_INLINE_PARAMETER_DEFAULT_VALUE(), (Object)((FirValueParameterSymbol)targetSymbol), (DiagnosticContext)context2, null, 16, null);
                }
            }
            this.checkVisibilityAndAccess(qualifiedAccess, (FirCallableSymbol)targetSymbol, source, context2, reporter);
            this.checkRecursion(targetSymbol, source, context2, reporter);
        }

        /*
         * WARNING - void declaration
         */
        private final boolean partOfCall(FirStatement $this$partOfCall, CheckerContext context2) {
            boolean bl;
            block7: {
                void $this$any$iv;
                if (!($this$partOfCall instanceof FirExpression)) {
                    return false;
                }
                FirStatement firStatement = (FirStatement)CollectionsKt.getOrNull(context2.getCallsOrAssignments(), (int)(context2.getCallsOrAssignments().size() - 2));
                if (firStatement == null) {
                    return false;
                }
                FirStatement containingQualifiedAccess = firStatement;
                FirQualifiedAccessExpression firQualifiedAccessExpression = containingQualifiedAccess instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)containingQualifiedAccess : null;
                if (Intrinsics.areEqual((Object)$this$partOfCall, (Object)(firQualifiedAccessExpression != null ? firQualifiedAccessExpression.getExplicitReceiver() : null))) {
                    return true;
                }
                FirCall firCall = containingQualifiedAccess instanceof FirCall ? (FirCall)containingQualifiedAccess : null;
                if (firCall == null) {
                    return false;
                }
                FirCall call2 = firCall;
                Object $this$arguments$iv = call2;
                boolean $i$f$getArguments = false;
                $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirExpression it = (FirExpression)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)FirExpressionUtilKt.unwrapArgument(it), (Object)$this$partOfCall)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final void checkVisibilityAndAccess(FirStatement accessExpression, FirCallableSymbol<?> calledDeclaration, KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter) {
            if (calledDeclaration == null || Intrinsics.areEqual((Object)calledDeclaration.getCallableId().getCallableName(), (Object)StandardNames.BACKING_FIELD)) {
                return;
            }
            FirCallableSymbol<?> $this$visibility$iv = calledDeclaration;
            boolean $i$f$getVisibility = false;
            AccessedDeclarationVisibilityData accessedDeclarationVisibilityData = this.checkAccessedDeclaration$checkers(source, (FirBasedSymbol)calledDeclaration, $this$visibility$iv.getResolvedStatus().getVisibility(), context2, reporter);
            boolean isInlineFunPublicOrPublishedApi = accessedDeclarationVisibilityData.component1();
            boolean isCalledFunPublicOrPublishedApi = accessedDeclarationVisibilityData.component2();
            EffectiveVisibility calledFunEffectiveVisibility = accessedDeclarationVisibilityData.component3();
            if (isInlineFunPublicOrPublishedApi && isCalledFunPublicOrPublishedApi) {
                this.checkSuperCalls(calledDeclaration, accessExpression, context2, reporter);
            }
            boolean isConstructorCall = calledDeclaration instanceof FirConstructorSymbol;
            if (isInlineFunPublicOrPublishedApi && this.inlineFunEffectiveVisibility.toVisibility() != Visibilities.Protected.INSTANCE && calledFunEffectiveVisibility.toVisibility() == Visibilities.Protected.INSTANCE) {
                KtDiagnosticFactory2<FirBasedSymbol<?>, FirBasedSymbol<?>> factory2 = isConstructorCall ? FirErrors.INSTANCE.getPROTECTED_CONSTRUCTOR_CALL_FROM_PUBLIC_INLINE() : (this.prohibitProtectedCallFromInline ? FirErrors.INSTANCE.getPROTECTED_CALL_FROM_PUBLIC_INLINE_ERROR() : FirErrors.INSTANCE.getPROTECTED_CALL_FROM_PUBLIC_INLINE());
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, factory2, this.inlineFunction.getSymbol(), calledDeclaration, (DiagnosticContext)context2, null, 32, null);
            }
        }

        private final void checkPrivateClassMemberAccess(FirBasedSymbol<?> calledDeclaration, KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter) {
            if (!this.isEffectivelyPrivateApiFunction && this.isInsidePrivateClass(calledDeclaration)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getPRIVATE_CLASS_MEMBER_FROM_INLINE(), calledDeclaration, this.inlineFunction.getSymbol(), (DiagnosticContext)context2, null, 32, null);
            }
        }

        private final void checkSuperCalls(FirCallableSymbol<?> calledDeclaration, FirStatement callExpression, CheckerContext context2, DiagnosticReporter reporter) {
            FirStatement firStatement = callExpression;
            FirExpression firExpression2 = firStatement instanceof FirQualifiedAccessExpression ? ((FirQualifiedAccessExpression)callExpression).getDispatchReceiver() : (firStatement instanceof FirVariableAssignment ? FirExpressionUtilKt.getDispatchReceiver((FirVariableAssignment)callExpression) : null);
            FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
            if (firQualifiedAccessExpression == null) {
                return;
            }
            FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
            if (receiver.getCalleeReference() instanceof FirSuperReference) {
                ConeKotlinType dispatchReceiverType = FirTypeUtilsKt.getResolvedType(receiver.getDispatchReceiver());
                FirClassifierSymbol<?> firClassifierSymbol = TypeUtilsKt.toSymbol(dispatchReceiverType, this.session);
                if (firClassifierSymbol == null) {
                    return;
                }
                FirClassifierSymbol<?> classSymbol = firClassifierSymbol;
                if (!this.isDefinedInInlineFunction(classSymbol)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)receiver.getSource(), FirErrors.INSTANCE.getSUPER_CALL_FROM_PUBLIC_INLINE(), calledDeclaration, (DiagnosticContext)context2, null, 16, null);
                }
            }
        }

        private final boolean isDefinedInInlineFunction(FirClassifierSymbol<?> $this$isDefinedInInlineFunction) {
            boolean bl;
            FirClassifierSymbol<?> symbol2 = $this$isDefinedInInlineFunction;
            if (symbol2 instanceof FirAnonymousObjectSymbol) {
                bl = true;
            } else if (symbol2 instanceof FirRegularClassSymbol) {
                bl = ((FirRegularClassSymbol)symbol2).getClassId().isLocal();
            } else {
                if (symbol2 instanceof FirTypeAliasSymbol ? true : symbol2 instanceof FirTypeParameterSymbol) {
                    throw new IllegalStateException(("Unexpected classifier declaration type: " + symbol2).toString());
                }
                throw new NoWhenBranchMatchedException();
            }
            return bl;
        }

        private final void checkRecursion(FirBasedSymbol<?> targetSymbol, KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter) {
            if (Intrinsics.areEqual(targetSymbol, this.inlineFunction.getSymbol())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getRECURSION_IN_INLINE(), targetSymbol, (DiagnosticContext)context2, null, 16, null);
            }
        }

        private final boolean isInsidePrivateClass(FirBasedSymbol<?> $this$isInsidePrivateClass) {
            Visibility visibility2;
            boolean $i$f$getVisibility;
            Object $this$visibility$iv;
            Object object = FirVisibilityCheckerKt.getOwnerLookupTag($this$isInsidePrivateClass);
            if (object == null || (object = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, this.session)) == null) {
                return false;
            }
            Object containingClassSymbol = object;
            Object object2 = containingClassSymbol;
            if (object2 instanceof FirAnonymousObjectSymbol) {
                return false;
            }
            if (object2 instanceof FirRegularClassSymbol) {
                $this$visibility$iv = containingClassSymbol;
                $i$f$getVisibility = false;
                visibility2 = ((FirClassLikeSymbol)$this$visibility$iv).getResolvedStatus().getVisibility();
            } else if (object2 instanceof FirTypeAliasSymbol) {
                $this$visibility$iv = containingClassSymbol;
                $i$f$getVisibility = false;
                visibility2 = ((FirClassLikeSymbol)$this$visibility$iv).getResolvedStatus().getVisibility();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Visibility containingClassVisibility = visibility2;
            if (Intrinsics.areEqual((Object)containingClassVisibility, (Object)Visibilities.Private.INSTANCE) || Intrinsics.areEqual((Object)containingClassVisibility, (Object)Visibilities.PrivateToThis.INSTANCE)) {
                return true;
            }
            if ($this$isInsidePrivateClass instanceof FirCallableSymbol && containingClassSymbol instanceof FirRegularClassSymbol) {
                Object $this$isCompanion$iv = containingClassSymbol;
                boolean $i$f$isCompanion = false;
                if (((FirClassLikeSymbol)$this$isCompanion$iv).getRawStatus().isCompanion()) {
                    return this.isInsidePrivateClass((FirBasedSymbol)containingClassSymbol);
                }
            }
            return false;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext$AccessedDeclarationVisibilityData;", "", "isInlineFunPublicOrPublishedApi", "", "isCalledFunPublicOrPublishedApi", "calledFunEffectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "(ZZLorg/jetbrains/kotlin/descriptors/EffectiveVisibility;)V", "getCalledFunEffectiveVisibility", "()Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "checkers"})
        public static final class AccessedDeclarationVisibilityData {
            private final boolean isInlineFunPublicOrPublishedApi;
            private final boolean isCalledFunPublicOrPublishedApi;
            @NotNull
            private final EffectiveVisibility calledFunEffectiveVisibility;

            public AccessedDeclarationVisibilityData(boolean isInlineFunPublicOrPublishedApi, boolean isCalledFunPublicOrPublishedApi, @NotNull EffectiveVisibility calledFunEffectiveVisibility) {
                Intrinsics.checkNotNullParameter((Object)calledFunEffectiveVisibility, (String)"calledFunEffectiveVisibility");
                this.isInlineFunPublicOrPublishedApi = isInlineFunPublicOrPublishedApi;
                this.isCalledFunPublicOrPublishedApi = isCalledFunPublicOrPublishedApi;
                this.calledFunEffectiveVisibility = calledFunEffectiveVisibility;
            }

            public final boolean isInlineFunPublicOrPublishedApi() {
                return this.isInlineFunPublicOrPublishedApi;
            }

            public final boolean isCalledFunPublicOrPublishedApi() {
                return this.isCalledFunPublicOrPublishedApi;
            }

            @NotNull
            public final EffectiveVisibility getCalledFunEffectiveVisibility() {
                return this.calledFunEffectiveVisibility;
            }

            public final boolean component1() {
                return this.isInlineFunPublicOrPublishedApi;
            }

            public final boolean component2() {
                return this.isCalledFunPublicOrPublishedApi;
            }

            @NotNull
            public final EffectiveVisibility component3() {
                return this.calledFunEffectiveVisibility;
            }

            @NotNull
            public final AccessedDeclarationVisibilityData copy(boolean isInlineFunPublicOrPublishedApi, boolean isCalledFunPublicOrPublishedApi, @NotNull EffectiveVisibility calledFunEffectiveVisibility) {
                Intrinsics.checkNotNullParameter((Object)calledFunEffectiveVisibility, (String)"calledFunEffectiveVisibility");
                return new AccessedDeclarationVisibilityData(isInlineFunPublicOrPublishedApi, isCalledFunPublicOrPublishedApi, calledFunEffectiveVisibility);
            }

            public static /* synthetic */ AccessedDeclarationVisibilityData copy$default(AccessedDeclarationVisibilityData accessedDeclarationVisibilityData, boolean bl, boolean bl2, EffectiveVisibility effectiveVisibility, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = accessedDeclarationVisibilityData.isInlineFunPublicOrPublishedApi;
                }
                if ((n & 2) != 0) {
                    bl2 = accessedDeclarationVisibilityData.isCalledFunPublicOrPublishedApi;
                }
                if ((n & 4) != 0) {
                    effectiveVisibility = accessedDeclarationVisibilityData.calledFunEffectiveVisibility;
                }
                return accessedDeclarationVisibilityData.copy(bl, bl2, effectiveVisibility);
            }

            @NotNull
            public String toString() {
                return "AccessedDeclarationVisibilityData(isInlineFunPublicOrPublishedApi=" + this.isInlineFunPublicOrPublishedApi + ", isCalledFunPublicOrPublishedApi=" + this.isCalledFunPublicOrPublishedApi + ", calledFunEffectiveVisibility=" + this.calledFunEffectiveVisibility + ')';
            }

            public int hashCode() {
                int result2 = Boolean.hashCode(this.isInlineFunPublicOrPublishedApi);
                result2 = result2 * 31 + Boolean.hashCode(this.isCalledFunPublicOrPublishedApi);
                result2 = result2 * 31 + this.calledFunEffectiveVisibility.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AccessedDeclarationVisibilityData)) {
                    return false;
                }
                AccessedDeclarationVisibilityData accessedDeclarationVisibilityData = (AccessedDeclarationVisibilityData)other;
                if (this.isInlineFunPublicOrPublishedApi != accessedDeclarationVisibilityData.isInlineFunPublicOrPublishedApi) {
                    return false;
                }
                if (this.isCalledFunPublicOrPublishedApi != accessedDeclarationVisibilityData.isCalledFunPublicOrPublishedApi) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.calledFunEffectiveVisibility, (Object)accessedDeclarationVisibilityData.calledFunEffectiveVisibility);
            }
        }
    }
}

