/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/DeprecationInheritanceChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class DeprecationInheritanceChecker
implements DeclarationChecker {
    @NotNull
    public static final DeprecationInheritanceChecker INSTANCE = new DeprecationInheritanceChecker();

    private DeprecationInheritanceChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(declaration instanceof KtNamedDeclaration)) {
            return;
        }
        if (declaration instanceof KtProperty && descriptor2 instanceof PropertyAccessorDescriptor && ((PropertyAccessorDescriptor)descriptor2).isDefault()) {
            return;
        }
        DeprecationResolver deprecationResolver = context2.getDeprecationResolver();
        if (!deprecationResolver.areDeprecationsInheritedFromOverriden(descriptor2)) {
            return;
        }
        Pair pair = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.StopPropagatingDeprecationThroughOverrides) ? TuplesKt.to(deprecationResolver.getHiddenDeprecationsFromOverriden(descriptor2), (Object)"") : TuplesKt.to(deprecationResolver.getDeprecations(descriptor2), (Object)"This deprecation won't be inherited in future releases. ");
        List deprecations2 = (List)pair.component1();
        String message = (String)pair.component2();
        context2.getTrace().report(Errors.OVERRIDE_DEPRECATION.on((KtNamedDeclaration)declaration, message, (CallableMemberDescriptor)descriptor2, deprecations2));
    }
}

