/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.jvm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractConeCallConflictResolver;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponents;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignature;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eH\u0002R\u001a\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/jvm/ConeEquivalentCallConflictResolver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractConeCallConflictResolver;", "specificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "inferenceComponents", "Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;", "transformerComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "(Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;)V", "mappedArgumentsOrderRepresentation", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "getMappedArgumentsOrderRepresentation", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;)[I", "areEquivalentTopLevelCallables", "", "first", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "firstCandidate", "second", "secondCandidate", "chooseMaximallySpecificCandidates", "", "candidates", "discriminateAbstracts", "createFlatSignature", "Lorg/jetbrains/kotlin/resolve/calls/results/FlatSignature;", "call", "declaration", "filterOutEquivalentCalls", "", "java"})
@SourceDebugExtension(value={"SMAP\nConeEquivalentCallConflictResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeEquivalentCallConflictResolver.kt\norg/jetbrains/kotlin/fir/resolve/calls/jvm/ConeEquivalentCallConflictResolver\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,114:1\n37#2:115\n1559#3:116\n1590#3,4:117\n81#4,7:121\n76#4,2:128\n57#4:130\n78#4:131\n*S KotlinDebug\n*F\n+ 1 ConeEquivalentCallConflictResolver.kt\norg/jetbrains/kotlin/fir/resolve/calls/jvm/ConeEquivalentCallConflictResolver\n*L\n66#1:115\n94#1:116\n94#1:117,4\n108#1:121,7\n108#1:128,2\n108#1:130\n108#1:131\n*E\n"})
public final class ConeEquivalentCallConflictResolver
extends AbstractConeCallConflictResolver {
    public ConeEquivalentCallConflictResolver(@NotNull TypeSpecificityComparator specificityComparator, @NotNull InferenceComponents inferenceComponents, @NotNull BodyResolveComponents transformerComponents) {
        Intrinsics.checkNotNullParameter((Object)specificityComparator, (String)"specificityComparator");
        Intrinsics.checkNotNullParameter((Object)inferenceComponents, (String)"inferenceComponents");
        Intrinsics.checkNotNullParameter((Object)transformerComponents, (String)"transformerComponents");
        super(specificityComparator, inferenceComponents, transformerComponents, true);
    }

    @Override
    @NotNull
    public Set<Candidate> chooseMaximallySpecificCandidates(@NotNull Set<Candidate> candidates2, boolean discriminateAbstracts) {
        Intrinsics.checkNotNullParameter(candidates2, (String)"candidates");
        return this.filterOutEquivalentCalls((Collection<Candidate>)candidates2);
    }

    private final Set<Candidate> filterOutEquivalentCalls(Collection<Candidate> candidates2) {
        Set result2 = new LinkedHashSet();
        block0: for (Candidate myCandidate : candidates2) {
            Object me = myCandidate.getSymbol().getFir();
            if (me instanceof FirCallableDeclaration && ClassMembersKt.containingClassLookupTag(((FirCallableDeclaration)me).getSymbol()) == null) {
                for (Candidate otherCandidate : result2) {
                    Object other = otherCandidate.getSymbol().getFir();
                    if (!(other instanceof FirCallableDeclaration) || ClassMembersKt.containingClassLookupTag(((FirCallableDeclaration)other).getSymbol()) != null || !this.areEquivalentTopLevelCallables((FirCallableDeclaration)me, myCandidate, (FirCallableDeclaration)other, otherCandidate)) continue;
                    continue block0;
                }
            }
            ((Collection)result2).add(myCandidate);
        }
        return result2;
    }

    private final boolean areEquivalentTopLevelCallables(FirCallableDeclaration first, Candidate firstCandidate, FirCallableDeclaration second, Candidate secondCandidate) {
        FlatSignature<Candidate> secondSignature;
        FirPureAbstractElement firPureAbstractElement;
        if (!Intrinsics.areEqual((Object)first.getSymbol().getCallableId(), (Object)second.getSymbol().getCallableId())) {
            return false;
        }
        FirMemberDeclaration $this$isExpect$iv = first;
        boolean $i$f$isExpect = false;
        boolean bl = $this$isExpect$iv.getStatus().isExpect();
        $this$isExpect$iv = second;
        $i$f$isExpect = false;
        if (bl != $this$isExpect$iv.getStatus().isExpect()) {
            return false;
        }
        FirPureAbstractElement firPureAbstractElement2 = first.getReceiverParameter();
        if (!Intrinsics.areEqual((Object)(firPureAbstractElement2 != null && (firPureAbstractElement2 = firPureAbstractElement2.getTypeRef()) != null ? FirTypeUtilsKt.getConeType((FirTypeRef)firPureAbstractElement2) : null), (firPureAbstractElement = second.getReceiverParameter()) != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null ? FirTypeUtilsKt.getConeType((FirTypeRef)firPureAbstractElement) : null)) {
            return false;
        }
        if (first instanceof FirVariable != second instanceof FirVariable) {
            return false;
        }
        if (!Arrays.equals(this.getMappedArgumentsOrderRepresentation(firstCandidate), this.getMappedArgumentsOrderRepresentation(secondCandidate))) {
            return false;
        }
        FlatSignature<Candidate> firstSignature = this.createFlatSignature(firstCandidate, first);
        return this.compareCallsByUsedArguments(firstSignature, secondSignature = this.createFlatSignature(secondCandidate, second), false, false) && this.compareCallsByUsedArguments(secondSignature, firstSignature, false, false);
    }

    /*
     * WARNING - void declaration
     */
    private final int[] getMappedArgumentsOrderRepresentation(Candidate $this$mappedArgumentsOrderRepresentation) {
        void $this$mapIndexedTo$iv$iv;
        Object obj = $this$mappedArgumentsOrderRepresentation.getSymbol().getFir();
        FirFunction firFunction = obj instanceof FirFunction ? (FirFunction)obj : null;
        if (firFunction == null) {
            return null;
        }
        FirFunction function2 = firFunction;
        Iterable $this$mapIndexed$iv = function2.getValueParameters();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo22 = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index2;
            void it;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)((int)index2)));
        }
        Map parametersToIndices = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = $this$mappedArgumentsOrderRepresentation.getArgumentMapping();
        if (linkedHashMap == null) {
            return null;
        }
        LinkedHashMap<FirExpression, FirValueParameter> mapping2 = linkedHashMap;
        int n = 0;
        int n3 = mapping2.size() + 1;
        int[] $i$f$mapIndexedTo22 = new int[n3];
        while (n < n3) {
            index$iv$iv = n++;
            $i$f$mapIndexedTo22[index$iv$iv] = function2.getValueParameters().size();
        }
        int[] result2 = $i$f$mapIndexedTo22;
        Iterator<FirValueParameter> iterator2 = mapping2.values().iterator();
        n3 = 0;
        while (iterator2.hasNext()) {
            int index3 = n3++;
            FirValueParameter parameter2 = iterator2.next();
            Integer n4 = (Integer)parametersToIndices.get(parameter2);
            if (n4 == null) {
                throw new IllegalStateException("Unmapped argument in arguments mapping".toString());
            }
            result2[index3 + 1] = n4;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final FlatSignature<Candidate> createFlatSignature(Candidate call2, FirCallableDeclaration declaration) {
        FlatSignature<Candidate> flatSignature;
        FirCallableDeclaration firCallableDeclaration = declaration;
        if (firCallableDeclaration instanceof FirSimpleFunction) {
            flatSignature = this.createFlatSignature(call2, (FirSimpleFunction)declaration);
        } else if (firCallableDeclaration instanceof FirConstructor) {
            flatSignature = this.createFlatSignature(call2, (FirConstructor)declaration);
        } else if (firCallableDeclaration instanceof FirVariable) {
            flatSignature = this.createFlatSignature(call2, (FirVariable)declaration);
        } else {
            void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            String message$iv = "Not supported: " + Reflection.getOrCreateKotlinClass(this.getClass());
            Throwable cause$iv = null;
            String attachmentName$iv = "info.txt";
            boolean $i$f$errorWithAttachment = false;
            boolean $i$f$buildErrorWithAttachment = false;
            KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
            KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string2 = attachmentName$iv;
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
            boolean bl = false;
            void $this$createFlatSignature_u24lambda_u241 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            boolean bl2 = false;
            FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$createFlatSignature_u24lambda_u241, "declaration", declaration);
            kotlinExceptionWithAttachments.withAttachment(string2, exceptionAttachmentBuilder.buildString());
            throw (Throwable)exception$iv$iv;
        }
        return flatSignature;
    }
}

