/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors.components;

import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.declarations.FirErrorImport;
import org.jetbrains.kotlin.fir.declarations.FirErrorProperty;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.diagnostics.ConeAmbiguousSuper;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSyntaxDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirErrorAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedErrorReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInstanceAccessBeforeSuperCall;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J.\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0018\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0018\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0018\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0018\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0018\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0018\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0018\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u0002012\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0018\u00102\u001a\u00020\b2\u0006\u00103\u001a\u0002042\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u000e\u00105\u001a\u000206*\u0004\u0018\u000107H\u0002\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/components/ErrorNodeDiagnosticCollectorComponent;", "Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "processErrorReference", "", "reference", "Lorg/jetbrains/kotlin/fir/references/FirNamedReference;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reportFirDiagnostic", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "callOrAssignmentSource", "visitErrorAnnotationCall", "errorAnnotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorAnnotationCall;", "data", "visitErrorExpression", "errorExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorExpression;", "visitErrorFunction", "errorFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorFunction;", "visitErrorImport", "errorImport", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorImport;", "visitErrorLoop", "errorLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorLoop;", "visitErrorNamedReference", "errorNamedReference", "Lorg/jetbrains/kotlin/fir/references/FirErrorNamedReference;", "visitErrorProperty", "errorProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorProperty;", "visitErrorResolvedQualifier", "errorResolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorResolvedQualifier;", "visitErrorTypeRef", "errorTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "visitResolvedErrorReference", "resolvedErrorReference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedErrorReference;", "visitResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "cannotBeResolved", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkers"})
@SourceDebugExtension(value={"SMAP\nErrorNodeDiagnosticCollectorComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorNodeDiagnosticCollectorComponent.kt\norg/jetbrains/kotlin/fir/analysis/collectors/components/ErrorNodeDiagnosticCollectorComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n533#2,6:163\n*S KotlinDebug\n*F\n+ 1 ErrorNodeDiagnosticCollectorComponent.kt\norg/jetbrains/kotlin/fir/analysis/collectors/components/ErrorNodeDiagnosticCollectorComponent\n*L\n80#1:163,6\n*E\n"})
public final class ErrorNodeDiagnosticCollectorComponent
extends AbstractDiagnosticCollectorComponent {
    public ErrorNodeDiagnosticCollectorComponent(@NotNull FirSession session, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        super(session, reporter);
    }

    @Override
    public void visitErrorLoop(@NotNull FirErrorLoop errorLoop, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter((Object)errorLoop, (String)"errorLoop");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        KtSourceElement source = errorLoop.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorLoop.getDiagnostic(), source, data2, null, 8, null);
    }

    @Override
    public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter((Object)errorTypeRef, (String)"errorTypeRef");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        KtSourceElement source = errorTypeRef.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorTypeRef.getDiagnostic(), source, data2, null, 8, null);
    }

    @Override
    public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @NotNull CheckerContext data2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        boolean bl2 = bl = !(resolvedTypeRef.getType() instanceof ConeErrorType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Instead use FirErrorTypeRef for " + ConeTypeUtilsKt.renderForDebugging(resolvedTypeRef.getType());
            throw new AssertionError((Object)string2);
        }
    }

    @Override
    public void visitErrorAnnotationCall(@NotNull FirErrorAnnotationCall errorAnnotationCall, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter((Object)errorAnnotationCall, (String)"errorAnnotationCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        KtSourceElement source = errorAnnotationCall.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorAnnotationCall.getDiagnostic(), source, data2, null, 8, null);
    }

    @Override
    public void visitErrorNamedReference(@NotNull FirErrorNamedReference errorNamedReference, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter((Object)errorNamedReference, (String)"errorNamedReference");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.processErrorReference(errorNamedReference, errorNamedReference.getDiagnostic(), data2);
    }

    @Override
    public void visitResolvedErrorReference(@NotNull FirResolvedErrorReference resolvedErrorReference, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter((Object)resolvedErrorReference, (String)"resolvedErrorReference");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.processErrorReference(resolvedErrorReference, resolvedErrorReference.getDiagnostic(), data2);
    }

    private final void processErrorReference(FirNamedReference reference2, ConeDiagnostic diagnostic, CheckerContext context2) {
        FirStatement firStatement;
        Object source = reference2.getSource();
        FirStatement firStatement2 = (FirStatement)CollectionsKt.lastOrNull(context2.getCallsOrAssignments());
        if (firStatement2 != null) {
            FirStatement firStatement3;
            FirStatement it = firStatement3 = firStatement2;
            boolean bl = false;
            firStatement = Intrinsics.areEqual((Object)FirExpressionUtilKt.getCalleeReference(it), (Object)reference2) ? firStatement3 : null;
        } else {
            firStatement = null;
        }
        FirStatement callOrAssignment = firStatement;
        KtSourceElement ktSourceElement = source;
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getElementType() : null), (Object)KtNodeTypes.ANNOTATION_ENTRY) && diagnostic instanceof ConeUnresolvedNameError) {
            return;
        }
        KtSourceElement ktSourceElement2 = source;
        if (Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE) && diagnostic instanceof ConeUnresolvedNameError) {
            return;
        }
        if (callOrAssignment instanceof FirQualifiedAccessExpression && (this.cannotBeResolved(((FirQualifiedAccessExpression)callOrAssignment).getDispatchReceiver()) || this.cannotBeResolved(((FirQualifiedAccessExpression)callOrAssignment).getExtensionReceiver()) || this.cannotBeResolved(((FirQualifiedAccessExpression)callOrAssignment).getExplicitReceiver()))) {
            return;
        }
        KtSourceElement ktSourceElement3 = source;
        if (Intrinsics.areEqual((Object)(ktSourceElement3 != null ? ktSourceElement3.getKind() : null), (Object)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
            FirDeclaration firDeclaration;
            block9: {
                List<FirDeclaration> $this$lastOrNull$iv = context2.getContainingDeclarations();
                boolean $i$f$lastOrNull = false;
                ListIterator<FirDeclaration> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    FirDeclaration element$iv;
                    FirDeclaration it = element$iv = iterator$iv.previous();
                    boolean bl = false;
                    if (!(it instanceof FirProperty)) continue;
                    firDeclaration = element$iv;
                    break block9;
                }
                firDeclaration = null;
            }
            FirDeclaration firDeclaration2 = firDeclaration;
            FirProperty firProperty = firDeclaration2 instanceof FirProperty ? (FirProperty)firDeclaration2 : null;
            if (firProperty == null) {
                return;
            }
            FirProperty property = firProperty;
            Object object = property.getDelegate();
            if (object == null || (object = ((FirExpression)object).getSource()) == null || (object = KtSourceElementKt.fakeElement$default((KtSourceElement)object, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE, 0, 0, 6, null)) == null) {
                return;
            }
            source = object;
        }
        FirStatement firStatement4 = callOrAssignment;
        this.reportFirDiagnostic(diagnostic, (KtSourceElement)source, context2, firStatement4 != null ? firStatement4.getSource() : null);
    }

    private final boolean cannotBeResolved(FirExpression $this$cannotBeResolved) {
        FirExpression firExpression2 = $this$cannotBeResolved;
        FirTypeRef firTypeRef = firExpression2 != null ? firExpression2.getTypeRef() : null;
        FirErrorTypeRef firErrorTypeRef = firTypeRef instanceof FirErrorTypeRef ? (FirErrorTypeRef)firTypeRef : null;
        ConeDiagnostic diagnostic = firErrorTypeRef != null ? firErrorTypeRef.getDiagnostic() : null;
        return ((diagnostic instanceof ConeUnresolvedNameError ? true : diagnostic instanceof ConeInstanceAccessBeforeSuperCall) ? true : diagnostic instanceof ConeAmbiguousSuper) ? true : (diagnostic instanceof ConeSimpleDiagnostic ? ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.NotASupertype || ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.SuperNotAvailable || ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.UnresolvedLabel : false);
    }

    @Override
    public void visitErrorExpression(@NotNull FirErrorExpression errorExpression, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter((Object)errorExpression, (String)"errorExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        KtSourceElement source = errorExpression.getSource();
        ConeDiagnostic diagnostic = errorExpression.getDiagnostic();
        if (source == null) {
            if (diagnostic instanceof ConeSyntaxDiagnostic) {
                return;
            }
            if (diagnostic instanceof ConeSimpleDiagnostic && ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.ExpressionExpected) {
                return;
            }
        }
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, diagnostic, source, data2, null, 8, null);
    }

    @Override
    public void visitErrorFunction(@NotNull FirErrorFunction errorFunction, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter((Object)errorFunction, (String)"errorFunction");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        KtSourceElement source = errorFunction.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorFunction.getDiagnostic(), source, data2, null, 8, null);
    }

    @Override
    public void visitErrorProperty(@NotNull FirErrorProperty errorProperty, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter((Object)errorProperty, (String)"errorProperty");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        KtSourceElement source = errorProperty.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorProperty.getDiagnostic(), source, data2, null, 8, null);
    }

    @Override
    public void visitErrorResolvedQualifier(@NotNull FirErrorResolvedQualifier errorResolvedQualifier, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter((Object)errorResolvedQualifier, (String)"errorResolvedQualifier");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        KtSourceElement source = errorResolvedQualifier.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorResolvedQualifier.getDiagnostic(), source, data2, null, 8, null);
    }

    @Override
    public void visitErrorImport(@NotNull FirErrorImport errorImport, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter((Object)errorImport, (String)"errorImport");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        KtSourceElement source = errorImport.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorImport.getDiagnostic(), source, data2, null, 8, null);
    }

    private final void reportFirDiagnostic(ConeDiagnostic diagnostic, KtSourceElement source, CheckerContext context2, KtSourceElement callOrAssignmentSource) {
        block8: {
            block7: {
                KtSourceElement ktSourceElement = source;
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getElementType() : null), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY)) {
                    return;
                }
                KtSourceElement ktSourceElement2 = source;
                if (Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE) && (diagnostic instanceof ConeUnresolvedNameError || diagnostic instanceof ConeAmbiguityError || diagnostic instanceof ConeInapplicableWrongReceiver || diagnostic instanceof ConeInapplicableCandidateError)) {
                    return;
                }
                KtSourceElement ktSourceElement3 = source;
                if (Intrinsics.areEqual((Object)(ktSourceElement3 != null ? ktSourceElement3.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitConstructor.INSTANCE)) break block7;
                KtSourceElement ktSourceElement4 = source;
                if (!Intrinsics.areEqual((Object)(ktSourceElement4 != null ? ktSourceElement4.getKind() : null), (Object)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) break block8;
            }
            return;
        }
        KtSourceElement ktSourceElement = source;
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DesugaredPrefixSecondGetReference.INSTANCE)) {
            return;
        }
        for (KtDiagnostic coneDiagnostic : ConeDiagnosticToFirDiagnosticKt.toFirDiagnostics(diagnostic, this.getSession(), source, callOrAssignmentSource)) {
            this.getReporter().report(coneDiagnostic, context2);
        }
    }

    static /* synthetic */ void reportFirDiagnostic$default(ErrorNodeDiagnosticCollectorComponent errorNodeDiagnosticCollectorComponent, ConeDiagnostic coneDiagnostic, KtSourceElement ktSourceElement, CheckerContext checkerContext, KtSourceElement ktSourceElement2, int n, Object object) {
        if ((n & 8) != 0) {
            ktSourceElement2 = null;
        }
        errorNodeDiagnosticCollectorComponent.reportFirDiagnostic(coneDiagnostic, ktSourceElement, checkerContext, ktSourceElement2);
    }
}

