/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.native;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.native.interop.FirObjCInteropKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.scopes.FirOverrideChecker;
import org.jetbrains.kotlin.fir.scopes.impl.FirStandardOverrideChecker;
import org.jetbrains.kotlin.native.interop.ObjCMethodInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0002J#\u0010\u0012\u001a\u0004\u0018\u00010\b*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0014\u001a\u0004\u0018\u00010\b*\u00020\r2\u0006\u0010\u000b\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/backend/native/FirNativeOverrideChecker;", "Lorg/jetbrains/kotlin/fir/scopes/FirOverrideChecker;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "standardOverrideChecker", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirStandardOverrideChecker;", "isOverriddenFunction", "", "overrideCandidate", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "baseDeclaration", "isOverriddenProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "parameterNamesMatch", "first", "second", "isPlatformOverriddenFunction", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)Ljava/lang/Boolean;", "isPlatformOverriddenProperty", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)Ljava/lang/Boolean;", "native"})
@SourceDebugExtension(value={"SMAP\nFirNativeOverrideChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeOverrideChecker.kt\norg/jetbrains/kotlin/fir/backend/native/FirNativeOverrideChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1864#2,3:77\n*S KotlinDebug\n*F\n+ 1 FirNativeOverrideChecker.kt\norg/jetbrains/kotlin/fir/backend/native/FirNativeOverrideChecker\n*L\n68#1:77,3\n*E\n"})
public final class FirNativeOverrideChecker
implements FirOverrideChecker {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirStandardOverrideChecker standardOverrideChecker;

    public FirNativeOverrideChecker(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.standardOverrideChecker = new FirStandardOverrideChecker(this.session);
    }

    @Override
    public boolean isOverriddenFunction(@NotNull FirSimpleFunction overrideCandidate, @NotNull FirSimpleFunction baseDeclaration) {
        Intrinsics.checkNotNullParameter((Object)overrideCandidate, (String)"overrideCandidate");
        Intrinsics.checkNotNullParameter((Object)baseDeclaration, (String)"baseDeclaration");
        Boolean bl = this.isPlatformOverriddenFunction(overrideCandidate, this.session, baseDeclaration);
        return bl != null ? bl.booleanValue() : this.standardOverrideChecker.isOverriddenFunction(overrideCandidate, baseDeclaration);
    }

    @Override
    public boolean isOverriddenProperty(@NotNull FirCallableDeclaration overrideCandidate, @NotNull FirProperty baseDeclaration) {
        Intrinsics.checkNotNullParameter((Object)overrideCandidate, (String)"overrideCandidate");
        Intrinsics.checkNotNullParameter((Object)baseDeclaration, (String)"baseDeclaration");
        Boolean bl = this.isPlatformOverriddenProperty(overrideCandidate, baseDeclaration);
        return bl != null ? bl.booleanValue() : this.standardOverrideChecker.isOverriddenProperty(overrideCandidate, baseDeclaration);
    }

    private final Boolean isPlatformOverriddenProperty(FirCallableDeclaration $this$isPlatformOverriddenProperty, FirProperty baseDeclaration) {
        if (!($this$isPlatformOverriddenProperty instanceof FirProperty) || !Intrinsics.areEqual((Object)((FirProperty)$this$isPlatformOverriddenProperty).getName(), (Object)baseDeclaration.getName())) {
            return null;
        }
        if (FirObjCInteropKt.isExternalObjCClassProperty((FirProperty)$this$isPlatformOverriddenProperty, this.session) && FirObjCInteropKt.isExternalObjCClassProperty(baseDeclaration, this.session)) {
            return true;
        }
        return null;
    }

    private final Boolean isPlatformOverriddenFunction(FirSimpleFunction $this$isPlatformOverriddenFunction, FirSession session, FirSimpleFunction baseDeclaration) {
        if (!Intrinsics.areEqual((Object)$this$isPlatformOverriddenFunction.getName(), (Object)baseDeclaration.getName())) {
            return null;
        }
        ObjCMethodInfo objCMethodInfo = FirObjCInteropKt.decodeObjCMethodAnnotation(baseDeclaration, session);
        if (objCMethodInfo == null) {
            return null;
        }
        ObjCMethodInfo superInfo = objCMethodInfo;
        ObjCMethodInfo subInfo = FirObjCInteropKt.decodeObjCMethodAnnotation($this$isPlatformOverriddenFunction, session);
        return subInfo != null ? Boolean.valueOf(Intrinsics.areEqual((Object)superInfo.getSelector(), (Object)subInfo.getSelector())) : (!this.parameterNamesMatch($this$isPlatformOverriddenFunction, baseDeclaration) ? Boolean.valueOf(false) : null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean parameterNamesMatch(FirSimpleFunction first, FirSimpleFunction second) {
        if (first.getValueParameters().size() != second.getValueParameters().size()) {
            return false;
        }
        Iterable $this$forEachIndexed$iv = first.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void parameter2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirValueParameter firValueParameter = (FirValueParameter)item$iv;
            int index2 = n;
            boolean bl = false;
            if (index2 <= 0 || Intrinsics.areEqual((Object)parameter2.getName(), (Object)second.getValueParameters().get(index2).getName())) continue;
            return false;
        }
        return true;
    }
}

