/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.native;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.mangle.MangleMode;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.FirMangleComputer;
import org.jetbrains.kotlin.fir.backend.native.FirNativeKotlinManglerKt;
import org.jetbrains.kotlin.fir.backend.native.interop.FirObjCInteropKt;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.native.interop.ObjCMethodInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u000e\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\fH\u0014J\u0014\u0010\r\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/backend/native/FirNativeKotlinMangleComputer;", "Lorg/jetbrains/kotlin/fir/backend/FirMangleComputer;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "mode", "Lorg/jetbrains/kotlin/backend/common/serialization/mangle/MangleMode;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/backend/common/serialization/mangle/MangleMode;)V", "copy", "newMode", "platformSpecificFunctionName", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "specialValueParamPrefix", "param", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "native"})
public final class FirNativeKotlinMangleComputer
extends FirMangleComputer {
    public FirNativeKotlinMangleComputer(@NotNull StringBuilder builder2, @NotNull MangleMode mode) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        super(builder2, mode);
    }

    @Override
    @NotNull
    public FirNativeKotlinMangleComputer copy(@NotNull MangleMode newMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)newMode), (String)"newMode");
        return new FirNativeKotlinMangleComputer(this.getBuilder(), newMode);
    }

    @Override
    @Nullable
    protected String platformSpecificFunctionName(@NotNull FirFunction $this$platformSpecificFunctionName) {
        ObjCMethodInfo objCMethodInfo;
        Intrinsics.checkNotNullParameter((Object)$this$platformSpecificFunctionName, (String)"<this>");
        FirSession session = $this$platformSpecificFunctionName.getModuleData().getSession();
        ScopeSession scopeSession = new ScopeSession();
        FirFunction firFunction = FirObjCInteropKt.getInitMethodIfObjCConstructor($this$platformSpecificFunctionName, session, scopeSession);
        if (firFunction != null && (objCMethodInfo = FirObjCInteropKt.getObjCMethodInfoFromOverriddenFunctions(firFunction, session, scopeSession)) != null) {
            StringBuilder stringBuilder2;
            ObjCMethodInfo it = objCMethodInfo;
            boolean bl = false;
            StringBuilder $this$platformSpecificFunctionName_u24lambda_u242_u24lambda_u241 = stringBuilder2 = new StringBuilder();
            boolean bl2 = false;
            FirReceiverParameter firReceiverParameter = $this$platformSpecificFunctionName.getReceiverParameter();
            if (firReceiverParameter != null) {
                FirReceiverParameter it2 = firReceiverParameter;
                boolean bl3 = false;
                $this$platformSpecificFunctionName_u24lambda_u242_u24lambda_u241.append(FirNativeKotlinManglerKt.access$getTypeName(it2, session));
                $this$platformSpecificFunctionName_u24lambda_u242_u24lambda_u241.append(".");
            }
            $this$platformSpecificFunctionName_u24lambda_u242_u24lambda_u241.append("objc:");
            $this$platformSpecificFunctionName_u24lambda_u242_u24lambda_u241.append(it.getSelector());
            if ($this$platformSpecificFunctionName instanceof FirConstructor && FirObjCInteropKt.isObjCConstructor((FirConstructor)$this$platformSpecificFunctionName, session)) {
                $this$platformSpecificFunctionName_u24lambda_u242_u24lambda_u241.append("#Constructor");
            }
            if ($this$platformSpecificFunctionName instanceof FirPropertyAccessor) {
                $this$platformSpecificFunctionName_u24lambda_u242_u24lambda_u241.append("#Accessor");
            }
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }
        return null;
    }

    @Override
    @NotNull
    protected String specialValueParamPrefix(@NotNull FirFunction $this$specialValueParamPrefix, @NotNull FirValueParameter param) {
        Intrinsics.checkNotNullParameter((Object)$this$specialValueParamPrefix, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        FirSession session = $this$specialValueParamPrefix.getModuleData().getSession();
        return FirObjCInteropKt.hasObjCMethodAnnotation($this$specialValueParamPrefix, session) || FirObjCInteropKt.hasObjCFactoryAnnotation($this$specialValueParamPrefix, session) || FirObjCInteropKt.isObjCClassMethod($this$specialValueParamPrefix, session) ? "" + param.getName() + ':' : "";
    }
}

