/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtDiagnosticReporterWithImplicitIrBasedContext;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtPsiSourceFileLinesMapping;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtSourceFileLinesMapping;
import org.jetbrains.kotlin.KtSourceFileLinesMappingFromLineStartOffsets;
import org.jetbrains.kotlin.backend.common.CommonBackendErrors;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.backend.CodeFragmentConversionData;
import org.jetbrains.kotlin.fir.backend.CodeFragmentUtilsKt;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrAnnotationsFromPluginRegistrar;
import org.jetbrains.kotlin.fir.backend.Fir2IrBuiltIns;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrCommonMemberStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponentsStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrConfiguration;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import org.jetbrains.kotlin.fir.backend.Fir2IrResult;
import org.jetbrains.kotlin.fir.backend.Fir2IrSpecialSymbolProvider;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverterKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisitor;
import org.jetbrains.kotlin.fir.backend.FirIrProvider;
import org.jetbrains.kotlin.fir.backend.InjectedValue;
import org.jetbrains.kotlin.fir.backend.IrBuiltInsOverFir;
import org.jetbrains.kotlin.fir.backend.generators.AnnotationGenerator;
import org.jetbrains.kotlin.fir.backend.generators.CallAndReferenceGenerator;
import org.jetbrains.kotlin.fir.backend.generators.DataClassMembersGenerator;
import org.jetbrains.kotlin.fir.backend.generators.DelegatedMemberGenerator;
import org.jetbrains.kotlin.fir.backend.generators.FakeOverrideGenerator;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.descriptors.FirModuleDescriptor;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtension;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtensionKt;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.GeneratedDeclarationsUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.signaturer.FirBasedSignatureComposer;
import org.jetbrains.kotlin.fir.symbols.Fir2IrConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.Fir2IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.IrLock;
import org.jetbrains.kotlin.ir.PsiIrFileEntry;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrFileImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterConfiguration;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import org.jetbrains.kotlin.ir.interpreter.transformer.IrConstTransformerKt;
import org.jetbrains.kotlin.ir.linkage.IrProvider;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.NaiveSourceBasedFileEntryImpl;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u0000 \u008f\u00012\u00020\u0001:\u0002\u008f\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020dJ\u0010\u0010e\u001a\u00020b2\u0006\u0010f\u001a\u00020gH\u0002J\u0014\u0010h\u001a\u00020b2\f\u0010i\u001a\b\u0012\u0004\u0012\u00020F02J\u0016\u0010j\u001a\b\u0012\u0004\u0012\u00020k022\u0006\u0010l\u001a\u00020dH\u0002J\u0016\u0010m\u001a\u00020b2\u0006\u0010n\u001a\u00020o2\u0006\u0010l\u001a\u00020dJ\u0010\u0010p\u001a\u00020b2\u0006\u0010c\u001a\u00020qH\u0002J\u0010\u0010r\u001a\u00020b2\u0006\u0010f\u001a\u00020gH\u0002J\u001d\u0010s\u001a\u00020d2\u0006\u0010c\u001a\u00020q2\u0006\u0010l\u001a\u00020dH\u0000\u00a2\u0006\u0002\btJ\u001a\u0010u\u001a\u00020d2\u0006\u0010v\u001a\u00020w2\b\b\u0002\u0010l\u001a\u00020dH\u0002J\u0010\u0010x\u001a\u00020b2\u0006\u0010f\u001a\u00020gH\u0002J\u0016\u0010y\u001a\u00020d2\u0006\u0010c\u001a\u00020q2\u0006\u0010z\u001a\u00020{J\u0016\u0010|\u001a\u00020d2\u0006\u0010c\u001a\u00020q2\u0006\u0010z\u001a\u00020{J$\u0010}\u001a\u0004\u0018\u00010F2\u0006\u0010~\u001a\u00020k2\b\u0010\u007f\u001a\u0004\u0018\u00010q2\u0006\u0010z\u001a\u00020{H\u0002J\u0011\u0010\u0080\u0001\u001a\u00020b2\u0006\u0010c\u001a\u00020qH\u0002J\u0019\u0010\u0081\u0001\u001a\u00020d2\u0006\u0010c\u001a\u00020q2\u0006\u0010z\u001a\u00020{H\u0002J\u001b\u0010\u0082\u0001\u001a\u00020b2\u0006\u0010f\u001a\u00020g2\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0002J\u0019\u0010\u0085\u0001\u001a\u00020b2\u0006\u0010c\u001a\u00020q2\u0006\u0010l\u001a\u00020dH\u0002J5\u0010\u0086\u0001\u001a\u00020b2\r\u0010\u0087\u0001\u001a\b\u0012\u0004\u0012\u00020g022\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\b\u0010\u008a\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u008c\u0001\u001a\u00020`H\u0002J\u001f\u0010\u008d\u0001\u001a\t\u0012\u0004\u0012\u00020k0\u008e\u00012\r\u0010i\u001a\t\u0012\u0004\u0012\u00020k0\u008e\u0001H\u0002R\u0012\u0010\u0006\u001a\u00020\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00020\u001bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u00020\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0012\u0010!\u001a\u00020\"X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0012\u0010%\u001a\u00020&X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0012\u0010)\u001a\u00020*X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0012\u0010-\u001a\u00020.X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020302X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00104\u001a\u000205X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0012\u00108\u001a\u000209X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0018\u0010<\u001a\b\u0012\u0004\u0012\u00020=02X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0012\u0010@\u001a\u00020AX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010D\u001a\b\u0012\u0004\u0012\u00020F0EX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010G\u001a\u00020HX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0012\u0010K\u001a\u00020LX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bM\u0010NR\u0012\u0010O\u001a\u00020PX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bQ\u0010RR\u0012\u0010S\u001a\u00020TX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bU\u0010VR\u0012\u0010W\u001a\u00020XX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bY\u0010ZR\u0012\u0010[\u001a\u00020\\X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b]\u0010^R\u000e\u0010_\u001a\u00020`X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0090\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "moduleDescriptor", "Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor;", "components", "(Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor;Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "annotationGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "getAnnotationGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "annotationsFromPluginRegistrar", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrAnnotationsFromPluginRegistrar;", "getAnnotationsFromPluginRegistrar", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrAnnotationsFromPluginRegistrar;", "builtIns", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "callGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "getCallGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "getClassifierStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "configuration", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "getConfiguration", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "converter", "getConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "getDeclarationStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "delegatedMemberGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/DelegatedMemberGenerator;", "getDelegatedMemberGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/DelegatedMemberGenerator;", "extensions", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "getExtensions", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "fakeOverrideGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "getFakeOverrideGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "generatorExtensions", "", "Lorg/jetbrains/kotlin/fir/extensions/FirDeclarationGenerationExtension;", "irBuiltIns", "Lorg/jetbrains/kotlin/fir/backend/IrBuiltInsOverFir;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/fir/backend/IrBuiltInsOverFir;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "irProviders", "Lorg/jetbrains/kotlin/ir/linkage/IrProvider;", "getIrProviders", "()Ljava/util/List;", "lock", "Lorg/jetbrains/kotlin/ir/IrLock;", "getLock", "()Lorg/jetbrains/kotlin/ir/IrLock;", "postponedDeclarationsForFakeOverridesBinding", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "signatureComposer", "Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;", "getSignatureComposer", "()Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "typeConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "getTypeConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "getVisibilityConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "wereSourcesFakeOverridesBound", "", "bindFakeOverridesInClass", "", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "bindFakeOverridesInFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "bindFakeOverridesOrPostpone", "declarations", "delegatedMembers", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "irClass", "processAnonymousObjectHeaders", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "processClassAndNestedClassHeaders", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "processClassHeaders", "processClassMembers", "processClassMembers$fir2ir", "processCodeFragmentMembers", "codeFragment", "Lorg/jetbrains/kotlin/fir/declarations/FirCodeFragment;", "processFileAndClassMembers", "processLocalClassAndNestedClasses", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "processLocalClassAndNestedClassesOnTheFly", "processMemberDeclaration", "declaration", "containingClass", "processNestedClassHeaders", "registerClassAndNestedClasses", "registerFileAndClasses", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "registerNestedClasses", "runSourcesConversion", "allFirFiles", "irModuleFragment", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrModuleFragmentImpl;", "fir2irVisitor", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisitor;", "runPreCacheBuiltinClasses", "syntheticPropertiesLast", "", "Companion", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFir2IrConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 6 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n1#1,594:1\n151#2,4:595\n1#3:599\n1#3:616\n1855#4,2:600\n766#4:603\n857#4,2:604\n1603#4,9:606\n1855#4:615\n1856#4:617\n1612#4:618\n1045#4:619\n1855#4,2:620\n1855#4,2:622\n1855#4,2:624\n1855#4,2:626\n54#5:602\n54#5:628\n38#6:629\n*S KotlinDebug\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter\n*L\n102#1:595,4\n349#1:616\n168#1:600,2\n347#1:603\n347#1:604,2\n349#1:606,9\n349#1:615\n349#1:617\n349#1:618\n358#1:619\n382#1:620,2\n388#1:622,2\n402#1:624,2\n408#1:626,2\n203#1:602\n422#1:628\n470#1:629\n*E\n"})
public final class Fir2IrConverter
implements Fir2IrComponents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirModuleDescriptor moduleDescriptor;
    @NotNull
    private final Fir2IrComponents components;
    @NotNull
    private final List<FirDeclarationGenerationExtension> generatorExtensions;
    private boolean wereSourcesFakeOverridesBound;
    @NotNull
    private final List<IrDeclaration> postponedDeclarationsForFakeOverridesBinding;

    public Fir2IrConverter(@NotNull FirModuleDescriptor moduleDescriptor, @NotNull Fir2IrComponents components2) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        this.moduleDescriptor = moduleDescriptor;
        this.components = components2;
        this.generatorExtensions = FirDeclarationGenerationExtensionKt.getDeclarationGenerators(FirExtensionServiceKt.getExtensionService(this.getSession()));
        this.postponedDeclarationsForFakeOverridesBinding = new ArrayList();
    }

    @Override
    @NotNull
    public AnnotationGenerator getAnnotationGenerator() {
        return this.components.getAnnotationGenerator();
    }

    @Override
    @NotNull
    public Fir2IrAnnotationsFromPluginRegistrar getAnnotationsFromPluginRegistrar() {
        return this.components.getAnnotationsFromPluginRegistrar();
    }

    @Override
    @NotNull
    public Fir2IrBuiltIns getBuiltIns() {
        return this.components.getBuiltIns();
    }

    @Override
    @NotNull
    public CallAndReferenceGenerator getCallGenerator() {
        return this.components.getCallGenerator();
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.components.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrConfiguration getConfiguration() {
        return this.components.getConfiguration();
    }

    @Override
    @NotNull
    public Fir2IrConverter getConverter() {
        return this.components.getConverter();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.components.getDeclarationStorage();
    }

    @Override
    @NotNull
    public DelegatedMemberGenerator getDelegatedMemberGenerator() {
        return this.components.getDelegatedMemberGenerator();
    }

    @Override
    @NotNull
    public Fir2IrExtensions getExtensions() {
        return this.components.getExtensions();
    }

    @Override
    @NotNull
    public FakeOverrideGenerator getFakeOverrideGenerator() {
        return this.components.getFakeOverrideGenerator();
    }

    @Override
    @NotNull
    public IrBuiltInsOverFir getIrBuiltIns() {
        return this.components.getIrBuiltIns();
    }

    @Override
    @NotNull
    public IrFactory getIrFactory() {
        return this.components.getIrFactory();
    }

    @Override
    @NotNull
    public List<IrProvider> getIrProviders() {
        return this.components.getIrProviders();
    }

    @Override
    @NotNull
    public IrLock getLock() {
        return this.components.getLock();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.components.getScopeSession();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.components.getSession();
    }

    @Override
    @NotNull
    public FirBasedSignatureComposer getSignatureComposer() {
        return this.components.getSignatureComposer();
    }

    @Override
    @NotNull
    public SymbolTable getSymbolTable() {
        return this.components.getSymbolTable();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.components.getTypeConverter();
    }

    @Override
    @NotNull
    public Fir2IrVisibilityConverter getVisibilityConverter() {
        return this.components.getVisibilityConverter();
    }

    private final void runSourcesConversion(List<? extends FirFile> allFirFiles, IrModuleFragmentImpl irModuleFragment, Fir2IrVisitor fir2irVisitor, boolean runPreCacheBuiltinClasses) {
        for (FirFile firFile : allFirFiles) {
            this.registerFileAndClasses(firFile, irModuleFragment);
        }
        if (runPreCacheBuiltinClasses) {
            this.getClassifierStorage().preCacheBuiltinClasses();
        }
        for (FirFile firFile : allFirFiles) {
            this.processClassHeaders(firFile);
        }
        for (FirFile firFile : allFirFiles) {
            this.processFileAndClassMembers(firFile);
        }
        for (FirFile firFile : allFirFiles) {
            this.bindFakeOverridesInFile(firFile);
        }
        this.wereSourcesFakeOverridesBound = true;
        this.getFakeOverrideGenerator().bindOverriddenSymbols(this.postponedDeclarationsForFakeOverridesBinding);
        this.postponedDeclarationsForFakeOverridesBinding.clear();
        this.getClassifierStorage().processMembersOfClassesCreatedOnTheFly();
        this.getDelegatedMemberGenerator().generateBodies();
        for (FirFile firFile : allFirFiles) {
            boolean $i$f$withFileAnalysisExceptionWrapping = false;
            try {
                boolean bl = false;
                IrElement irElement = (IrElement)firFile.accept(fir2irVisitor, null);
            }
            catch (Throwable throwable$iv) {
                UtilsKt.getExceptionHandler(firFile.getModuleData().getSession()).handleExceptionOnFileAnalysis(firFile, throwable$iv);
                throw null;
            }
        }
        Fir2IrConverter.Companion.evaluateConstants(irModuleFragment, this.getConfiguration());
    }

    public final void bindFakeOverridesOrPostpone(@NotNull List<? extends IrDeclaration> declarations2) {
        Intrinsics.checkNotNullParameter(declarations2, (String)"declarations");
        if (this.wereSourcesFakeOverridesBound) {
            this.getFakeOverrideGenerator().bindOverriddenSymbols(declarations2);
        } else {
            CollectionsKt.addAll((Collection)this.postponedDeclarationsForFakeOverridesBinding, (Iterable)declarations2);
        }
    }

    @NotNull
    public final IrClass processLocalClassAndNestedClassesOnTheFly(@NotNull FirClass klass, @NotNull IrDeclarationParent parent2) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        IrClass irClass2 = this.registerClassAndNestedClasses(klass, parent2);
        this.processClassAndNestedClassHeaders(klass);
        return irClass2;
    }

    @NotNull
    public final IrClass processLocalClassAndNestedClasses(@NotNull FirClass klass, @NotNull IrDeclarationParent parent2) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        IrClass irClass2 = this.registerClassAndNestedClasses(klass, parent2);
        this.processClassAndNestedClassHeaders(klass);
        this.processClassMembers$fir2ir(klass, irClass2);
        this.bindFakeOverridesInClass(irClass2);
        return irClass2;
    }

    private final void registerFileAndClasses(FirFile file2, IrModuleFragment moduleFragment) {
        IrFileEntry irFileEntry;
        FirDeclarationOrigin firDeclarationOrigin = file2.getOrigin();
        if (Intrinsics.areEqual((Object)firDeclarationOrigin, (Object)FirDeclarationOrigin.Source.INSTANCE)) {
            PsiElement psiElement = UtilsKt.getPsi(file2);
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                irFileEntry = new PsiIrFileEntry((PsiFile)((KtFile)it));
            } else {
                KtSourceFileLinesMapping linesMapping = file2.getSourceFileLinesMapping();
                if (linesMapping instanceof KtSourceFileLinesMappingFromLineStartOffsets) {
                    Object object = file2.getSourceFile();
                    if (object == null || (object = object.getPath()) == null) {
                        KtSourceFile ktSourceFile = file2.getSourceFile();
                        object = ktSourceFile != null ? ktSourceFile.getName() : file2.getName();
                    }
                    irFileEntry = new NaiveSourceBasedFileEntryImpl((String)object, ((KtSourceFileLinesMappingFromLineStartOffsets)linesMapping).getLineStartOffsets(), ((KtSourceFileLinesMappingFromLineStartOffsets)linesMapping).getLastOffset());
                } else if (linesMapping instanceof KtPsiSourceFileLinesMapping) {
                    irFileEntry = new PsiIrFileEntry(((KtPsiSourceFileLinesMapping)linesMapping).getPsiFile());
                } else {
                    Object object = file2.getSourceFile();
                    if (object == null || (object = object.getPath()) == null) {
                        KtSourceFile ktSourceFile = file2.getSourceFile();
                        object = ktSourceFile != null ? ktSourceFile.getName() : file2.getName();
                    }
                    irFileEntry = new NaiveSourceBasedFileEntryImpl((String)object, null, 0, 6, null);
                }
            }
        } else if (firDeclarationOrigin instanceof FirDeclarationOrigin.Synthetic) {
            irFileEntry = new NaiveSourceBasedFileEntryImpl(file2.getName(), null, 0, 6, null);
        } else {
            throw new IllegalStateException(("Unsupported file origin: " + file2.getOrigin()).toString());
        }
        IrFileEntry fileEntry = irFileEntry;
        IrFileImpl irFile = new IrFileImpl(fileEntry, (PackageFragmentDescriptor)CollectionsKt.first(this.moduleDescriptor.getPackage(UtilsKt.getPackageFqName(file2)).getFragments()), moduleFragment);
        this.getDeclarationStorage().registerFile(file2, irFile);
        for (FirDeclaration declaration : file2.getDeclarations()) {
            FirDeclaration firDeclaration = declaration;
            if (firDeclaration instanceof FirRegularClass) {
                this.registerClassAndNestedClasses((FirClass)declaration, irFile);
                continue;
            }
            if (!(firDeclaration instanceof FirCodeFragment)) continue;
            this.getClassifierStorage().registerCodeFragmentClass((FirCodeFragment)declaration, irFile);
        }
        ((Collection)moduleFragment.getFiles()).add(irFile);
    }

    private final void processClassHeaders(FirFile file2) {
        Iterable $this$forEach$iv = file2.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl = false;
            FirDeclaration firDeclaration = it;
            if (firDeclaration instanceof FirRegularClass) {
                this.processClassAndNestedClassHeaders((FirClass)it);
                continue;
            }
            if (!(firDeclaration instanceof FirTypeAlias)) continue;
            this.getClassifierStorage().registerTypeAlias((FirTypeAlias)it, this.getDeclarationStorage().getIrFile(file2));
        }
    }

    private final void processFileAndClassMembers(FirFile file2) {
        IrFile irFile = this.getDeclarationStorage().getIrFile(file2);
        for (FirDeclaration declaration : file2.getDeclarations()) {
            IrDeclaration irDeclaration2;
            if (this.processMemberDeclaration(declaration, null, irFile) == null) continue;
            ((Collection)irFile.getDeclarations()).add(irDeclaration2);
        }
    }

    public final void processAnonymousObjectHeaders(@NotNull FirAnonymousObject anonymousObject, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        this.registerNestedClasses(anonymousObject, irClass2);
        this.processNestedClassHeaders(anonymousObject);
    }

    @NotNull
    public final IrClass processClassMembers$fir2ir(@NotNull FirClass klass, @NotNull IrClass irClass2) {
        IrConstructor irConstructor2;
        IrConstructor irConstructor3;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        List list2 = new ArrayList();
        List $this$processClassMembers_u24lambda_u243 = list2;
        boolean bl = false;
        $this$processClassMembers_u24lambda_u243.addAll((Collection)klass.getDeclarations());
        if (klass instanceof FirRegularClass && !((Collection)this.generatorExtensions).isEmpty()) {
            $this$processClassMembers_u24lambda_u243.addAll((Collection)GeneratedDeclarationsUtilsKt.generatedMembers((FirRegularClass)klass, this.getSession()));
            $this$processClassMembers_u24lambda_u243.addAll((Collection)GeneratedDeclarationsUtilsKt.generatedNestedClassifiers((FirRegularClass)klass, this.getSession()));
        }
        List allDeclarations2 = list2;
        FirConstructorSymbol firConstructorSymbol2 = DeclarationUtilsKt.primaryConstructorIfAny(klass, this.getSession());
        if (firConstructorSymbol2 != null) {
            FirConstructorSymbol it = firConstructorSymbol2;
            boolean bl2 = false;
            FirClassLikeDeclaration $this$isLocal$iv = klass;
            boolean $i$f$isLocal = false;
            irConstructor3 = Fir2IrDeclarationStorage.getOrCreateIrConstructor$default(this.getDeclarationStorage(), (FirConstructor)it.getFir(), irClass2, null, $this$isLocal$iv.getSymbol().getClassId().isLocal(), 4, null);
        } else {
            irConstructor3 = irConstructor2 = null;
        }
        if (irConstructor2 != null) {
            ((Collection)irClass2.getDeclarations()).add(irConstructor2);
        }
        for (FirDeclaration declaration : this.syntheticPropertiesLast(allDeclarations2)) {
            IrDeclaration irDeclaration2;
            if (this.processMemberDeclaration(declaration, klass, irClass2) == null) continue;
            ((Collection)irClass2.getDeclarations()).add(irDeclaration2);
        }
        CollectionsKt.addAll((Collection)allDeclarations2, (Iterable)this.delegatedMembers(irClass2));
        if (klass instanceof FirRegularClass && irConstructor2 != null && (irClass2.isValue() || irClass2.isData())) {
            this.getDeclarationStorage().enterScope(irConstructor2);
            DataClassMembersGenerator dataClassMembersGenerator = new DataClassMembersGenerator(this.components);
            if (IrDeclarationsKt.isSingleFieldValueClass(irClass2)) {
                CollectionsKt.addAll((Collection)allDeclarations2, (Iterable)dataClassMembersGenerator.generateSingleFieldValueClassMembers((FirRegularClass)klass, irClass2));
            }
            if (IrDeclarationsKt.isMultiFieldValueClass(irClass2)) {
                CollectionsKt.addAll((Collection)allDeclarations2, (Iterable)dataClassMembersGenerator.generateMultiFieldValueClassMembers((FirRegularClass)klass, irClass2));
            }
            if (irClass2.isData()) {
                CollectionsKt.addAll((Collection)allDeclarations2, (Iterable)dataClassMembersGenerator.generateDataClassMembers((FirRegularClass)klass, irClass2));
            }
            this.getDeclarationStorage().leaveScope(irConstructor2);
        }
        FakeOverrideGenerator $this$processClassMembers_u24lambda_u245 = this.getFakeOverrideGenerator();
        boolean bl3 = false;
        $this$processClassMembers_u24lambda_u245.addFakeOverrides(irClass2, klass, allDeclarations2);
        return irClass2;
    }

    private final IrClass processCodeFragmentMembers(FirCodeFragment codeFragment, IrClass irClass2) {
        CodeFragmentConversionData conversionData = CodeFragmentUtilsKt.getConversionData(codeFragment);
        this.getDeclarationStorage().enterScope(irClass2);
        IdSignature idSignature = irClass2.getSymbol().getSignature();
        Intrinsics.checkNotNull((Object)idSignature);
        IdSignature signature2 = idSignature;
        IrConstructor irPrimaryConstructor2 = this.getSymbolTable().declareConstructor(signature2, (Function0<? extends IrConstructorSymbol>)((Function0)new Function0<IrConstructorSymbol>(signature2){
            final /* synthetic */ IdSignature $signature;
            {
                this.$signature = $signature;
                super(0);
            }

            @NotNull
            public final IrConstructorSymbol invoke() {
                return new Fir2IrConstructorSymbol(this.$signature);
            }
        }), (Function1<? super IrConstructorSymbol, ? extends IrConstructor>)((Function1)new Function1<IrConstructorSymbol, IrConstructor>(this, irClass2){
            final /* synthetic */ Fir2IrConverter this$0;
            final /* synthetic */ IrClass $irClass;
            {
                this.this$0 = $receiver;
                this.$irClass = $irClass;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final IrConstructor invoke(@NotNull IrConstructorSymbol irSymbol2) {
                T element$iv2;
                IrDelegatingConstructorCallImpl.Companion companion;
                int n;
                int n2;
                IrType irType;
                Collection collection;
                Object object;
                IrBlockBody irBlockBody;
                Object object2;
                block1: {
                    void $this$firstIsInstance$iv;
                    void $this$invoke_u24lambda_u241_u24lambda_u240;
                    Intrinsics.checkNotNullParameter((Object)irSymbol2, (String)"irSymbol");
                    object2 = this.this$0.getIrFactory();
                    Object object3 = IrDeclarationOrigin.DEFINED.INSTANCE;
                    Object object4 = Name.special("<init>");
                    DescriptorVisibility descriptorVisibility = this.$irClass.getVisibility();
                    IrSimpleType irSimpleType = IrUtilsKt.getDefaultType(this.$irClass);
                    IrDeclarationOrigin irDeclarationOrigin = (IrDeclarationOrigin)object3;
                    Intrinsics.checkNotNull((Object)object4);
                    object2 = IrFactory.DefaultImpls.createConstructor$default((IrFactory)object2, -1, -1, irDeclarationOrigin, (Name)object4, descriptorVisibility, false, false, irSimpleType, irSymbol2, true, false, null, 2048, null);
                    object3 = this.$irClass;
                    object4 = this.this$0;
                    Object $this$invoke_u24lambda_u241 = object2;
                    boolean bl = false;
                    $this$invoke_u24lambda_u241.setParent((IrDeclarationParent)object3);
                    IrBlockBody irBlockBody2 = irBlockBody = ((Fir2IrConverter)object4).getIrFactory().createBlockBody(-1, -1);
                    object = $this$invoke_u24lambda_u241;
                    boolean bl2 = false;
                    collection = $this$invoke_u24lambda_u241_u24lambda_u240.getStatements();
                    Iterable iterable = ((IrClass)((Fir2IrConverter)object4).getIrBuiltIns().getAnyClass().getOwner()).getDeclarations();
                    irType = ((Fir2IrConverter)object4).getIrBuiltIns().getUnitType();
                    n2 = -1;
                    n = -1;
                    companion = IrDelegatingConstructorCallImpl.Companion;
                    boolean $i$f$firstIsInstance = false;
                    for (T element$iv2 : $this$firstIsInstance$iv) {
                        if (!(element$iv2 instanceof IrConstructor)) continue;
                        break block1;
                    }
                    throw new NoSuchElementException("No element of given type found");
                }
                T t = element$iv2;
                collection.add(IrDelegatingConstructorCallImpl.Companion.fromSymbolOwner$default(companion, n, n2, irType, ((IrConstructor)t).getSymbol(), 0, 0, 48, null));
                ((IrFunction)object).setBody(irBlockBody);
                return object2;
            }
        }));
        IrSimpleFunction irFragmentFunction2 = this.getSymbolTable().declareSimpleFunction(signature2, (Function0<? extends IrSimpleFunctionSymbol>)((Function0)new Function0<IrSimpleFunctionSymbol>(signature2){
            final /* synthetic */ IdSignature $signature;
            {
                this.$signature = $signature;
                super(0);
            }

            @NotNull
            public final IrSimpleFunctionSymbol invoke() {
                return new Fir2IrSimpleFunctionSymbol(this.$signature);
            }
        }), (Function1<? super IrSimpleFunctionSymbol, ? extends IrSimpleFunction>)((Function1)new Function1<IrSimpleFunctionSymbol, IrSimpleFunction>(codeFragment, this, conversionData, irClass2){
            final /* synthetic */ FirCodeFragment $codeFragment;
            final /* synthetic */ Fir2IrConverter this$0;
            final /* synthetic */ CodeFragmentConversionData $conversionData;
            final /* synthetic */ IrClass $irClass;
            {
                this.$codeFragment = $codeFragment;
                this.this$0 = $receiver;
                this.$conversionData = $conversionData;
                this.$irClass = $irClass;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final IrSimpleFunction invoke(@NotNull IrSimpleFunctionSymbol irSymbol2) {
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                Intrinsics.checkNotNullParameter((Object)irSymbol2, (String)"irSymbol");
                FirStatement lastStatement = (FirStatement)CollectionsKt.lastOrNull(this.$codeFragment.getBlock().getStatements());
                Object object = lastStatement instanceof FirExpression ? (FirExpression)lastStatement : null;
                if (object == null || (object = ((FirExpression)object).getTypeRef()) == null || (object = Fir2IrTypeConverterKt.toIrType$default((FirTypeRef)object, this.this$0.getTypeConverter(), null, 2, null)) == null) {
                    object = this.this$0.getIrBuiltIns().getUnitType();
                }
                Object returnType2 = object;
                IrFactory irFactory = this.this$0.getIrFactory();
                IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
                Name name2 = this.$conversionData.getMethodName();
                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PUBLIC");
                IrSimpleFunction irSimpleFunction = irFactory.createSimpleFunction(-1, -1, irDeclarationOrigin, name2, descriptorVisibility, false, false, (IrType)returnType2, Modality.FINAL, irSymbol2, false, false, false, false, false, null, false);
                IrClass irClass2 = this.$irClass;
                CodeFragmentConversionData codeFragmentConversionData = this.$conversionData;
                Fir2IrConverter fir2IrConverter = this.this$0;
                IrSimpleFunction $this$invoke_u24lambda_u242 = irSimpleFunction;
                boolean bl = false;
                $this$invoke_u24lambda_u242.setParent(irClass2);
                Iterable iterable = codeFragmentConversionData.getInjectedValues();
                IrSimpleFunction irSimpleFunction2 = $this$invoke_u24lambda_u242;
                boolean $i$f$mapIndexed = false;
                void var13_13 = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    IrValueParameter irValueParameter;
                    void index2;
                    void injectedValue;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    InjectedValue injectedValue2 = (InjectedValue)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    boolean isMutated = injectedValue.isMutated();
                    IrFactory irFactory2 = fir2IrConverter.getIrFactory();
                    IrDeclarationOrigin irDeclarationOrigin2 = isMutated ? (IrDeclarationOriginImpl)IrDeclarationOrigin.SHARED_VARIABLE_IN_EVALUATOR_FRAGMENT.INSTANCE : (IrDeclarationOriginImpl)IrDeclarationOrigin.DEFINED.INSTANCE;
                    Name name3 = Name.identifier("" + 'p' + (int)index2);
                    Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
                    IrValueParameter $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240 = irValueParameter = irFactory2.createValueParameter(-1, -1, irDeclarationOrigin2, name3, Fir2IrTypeConverterKt.toIrType$default(injectedValue.getTypeRef(), fir2IrConverter.getTypeConverter(), null, 2, null), isMutated, injectedValue.getIrParameterSymbol(), (int)index2, null, false, false, false);
                    boolean bl3 = false;
                    $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240.setParent($this$invoke_u24lambda_u242);
                    collection.add(irValueParameter);
                }
                irSimpleFunction2.setValueParameters((List)destination$iv$iv);
                return irSimpleFunction;
            }
        }));
        irClass2.getDeclarations().add(irPrimaryConstructor2);
        irClass2.getDeclarations().add(irFragmentFunction2);
        this.getDeclarationStorage().leaveScope(irClass2);
        return irClass2;
    }

    static /* synthetic */ IrClass processCodeFragmentMembers$default(Fir2IrConverter fir2IrConverter, FirCodeFragment firCodeFragment, IrClass irClass2, int n, Object object) {
        if ((n & 2) != 0) {
            IrClass irClass3 = fir2IrConverter.getClassifierStorage().getCachedIrCodeFragment(firCodeFragment);
            Intrinsics.checkNotNull((Object)irClass3);
            irClass2 = irClass3;
        }
        return fir2IrConverter.processCodeFragmentMembers(firCodeFragment, irClass2);
    }

    private final void bindFakeOverridesInFile(FirFile file2) {
        IrFile irFile = this.getDeclarationStorage().getIrFile(file2);
        for (IrDeclaration irDeclaration2 : irFile.getDeclarations()) {
            if (!(irDeclaration2 instanceof IrClass)) continue;
            this.bindFakeOverridesInClass((IrClass)irDeclaration2);
        }
    }

    public final void bindFakeOverridesInClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        this.getFakeOverrideGenerator().bindOverriddenSymbols(klass.getDeclarations());
        this.getDelegatedMemberGenerator().bindDelegatedMembersOverriddenSymbols(klass);
        for (IrDeclaration irDeclaration2 : klass.getDeclarations()) {
            if (!(irDeclaration2 instanceof IrClass)) continue;
            this.bindFakeOverridesInClass((IrClass)irDeclaration2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirDeclaration> delegatedMembers(IrClass irClass2) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = irClass2.getDeclarations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrDeclaration it = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrDeclarationOrigin.DELEGATED_MEMBER.INSTANCE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrDeclaration it = (IrDeclaration)element$iv$iv;
            boolean bl2 = false;
            if (this.components.getDeclarationStorage().originalDeclarationForDelegated(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Iterable<FirDeclaration> syntheticPropertiesLast(Iterable<? extends FirDeclaration> declarations2) {
        Iterable<? extends FirDeclaration> $this$sortedBy$iv = declarations2;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith($this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl;
                boolean bl2;
                FirDeclaration it = (FirDeclaration)a;
                boolean bl3 = false;
                FirDeclaration $this$isSynthetic$iv = it;
                boolean $i$f$isSynthetic = false;
                if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) {
                    bl2 = false;
                } else {
                    KtSourceElement ktSourceElement = it.getSource();
                    bl2 = !((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.ClassDelegationField);
                }
                it = (FirDeclaration)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl3 = false;
                $this$isSynthetic$iv = it;
                $i$f$isSynthetic = false;
                if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) {
                    bl = false;
                } else {
                    KtSourceElement ktSourceElement = it.getSource();
                    bl = !((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.ClassDelegationField);
                }
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Boolean.valueOf(bl));
            }
        });
    }

    private final IrClass registerClassAndNestedClasses(FirClass klass, IrDeclarationParent parent2) {
        Object object;
        Object object2;
        IrClass irClass2 = this.getClassifierStorage().getCachedIrClass(klass);
        if (irClass2 != null) {
            object2 = irClass2;
            IrClass $this$registerClassAndNestedClasses_u24lambda_u249 = object2;
            boolean bl = false;
            $this$registerClassAndNestedClasses_u24lambda_u249.setParent(parent2);
            object = object2;
        } else {
            object2 = klass;
            if (object2 instanceof FirRegularClass) {
                object = Fir2IrClassifierStorage.registerIrClass$default(this.getClassifierStorage(), (FirRegularClass)klass, parent2, null, 4, null);
            } else if (object2 instanceof FirAnonymousObject) {
                object = Fir2IrClassifierStorage.registerIrAnonymousObject$default(this.getClassifierStorage(), (FirAnonymousObject)klass, null, null, parent2, 6, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object irClass3 = object;
        this.registerNestedClasses(klass, (IrClass)irClass3);
        return irClass3;
    }

    private final void registerNestedClasses(FirClass klass, IrClass irClass2) {
        FirDeclaration it;
        Iterable $this$forEach$iv = klass.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof FirRegularClass)) continue;
            this.registerClassAndNestedClasses((FirClass)it, irClass2);
        }
        if (klass instanceof FirRegularClass && !((Collection)this.generatorExtensions).isEmpty()) {
            $this$forEach$iv = GeneratedDeclarationsUtilsKt.generatedNestedClassifiers((FirRegularClass)klass, this.getSession());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirClassLikeDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirRegularClass)) continue;
                this.registerClassAndNestedClasses((FirClass)it, irClass2);
            }
        }
    }

    private final void processClassAndNestedClassHeaders(FirClass klass) {
        Fir2IrClassifierStorage.processClassHeader$default(this.getClassifierStorage(), klass, null, 2, null);
        this.processNestedClassHeaders(klass);
    }

    private final void processNestedClassHeaders(FirClass klass) {
        FirDeclaration it;
        Iterable $this$forEach$iv = klass.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof FirRegularClass)) continue;
            this.processClassAndNestedClassHeaders((FirClass)it);
        }
        if (klass instanceof FirRegularClass && !((Collection)this.generatorExtensions).isEmpty()) {
            $this$forEach$iv = GeneratedDeclarationsUtilsKt.generatedNestedClassifiers((FirRegularClass)klass, this.getSession());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirClassLikeDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirRegularClass)) continue;
                this.processClassAndNestedClassHeaders((FirClass)it);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final IrDeclaration processMemberDeclaration(FirDeclaration declaration, FirClass containingClass, IrDeclarationParent parent) {
        if (containingClass == null) ** GOTO lbl-1000
        if (!(containingClass instanceof FirRegularClass)) ** GOTO lbl-1000
        $this$isLocal$iv = containingClass;
        $i$f$isLocal = false;
        if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        isLocal = v0;
        var5_4 = declaration;
        if (var5_4 instanceof FirRegularClass) {
            v1 = (FirClass)declaration;
            v2 = this.getClassifierStorage().getCachedIrClass((FirClass)declaration);
            Intrinsics.checkNotNull((Object)v2);
            v3 = this.processClassMembers$fir2ir(v1, v2);
        } else if (var5_4 instanceof FirScript) {
            Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFile");
            (IrFile)parent;
            irScript = $i$f$isLocal = this.getDeclarationStorage().getOrCreateIrScript((FirScript)declaration);
            $i$a$-also-Fir2IrConverter$processMemberDeclaration$1 = false;
            this.getDeclarationStorage().enterScope(irScript);
            irScript.setParent(parent);
            for (FirStatement scriptStatement : ((FirScript)declaration).getStatements()) {
                var11_14 = scriptStatement;
                if (var11_14 instanceof FirRegularClass) {
                    this.registerClassAndNestedClasses((FirClass)scriptStatement, irScript);
                    this.processClassAndNestedClassHeaders((FirClass)scriptStatement);
                    continue;
                }
                if (!(var11_14 instanceof FirTypeAlias)) continue;
                this.getClassifierStorage().registerTypeAlias((FirTypeAlias)scriptStatement, irScript);
            }
            for (FirStatement scriptStatement : ((FirScript)declaration).getStatements()) {
                if (!(scriptStatement instanceof FirDeclaration)) continue;
                this.processMemberDeclaration((FirDeclaration)scriptStatement, null, irScript);
            }
            this.getDeclarationStorage().leaveScope(irScript);
            v3 = $i$f$isLocal;
        } else if (var5_4 instanceof FirSimpleFunction) {
            v3 = this.getDeclarationStorage().getOrCreateIrFunction((FirSimpleFunction)declaration, parent, isLocal);
        } else if (var5_4 instanceof FirProperty) {
            v3 = (IrDeclaration)(containingClass != null && UtilsKt.isEnumEntries((FirVariable)declaration, containingClass) != false && FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getSession()).supportsFeature(LanguageFeature.EnumEntries) == false ? null : this.getDeclarationStorage().getOrCreateIrProperty((FirProperty)declaration, parent, isLocal));
        } else if (var5_4 instanceof FirField) {
            $this$isSynthetic$iv = declaration;
            $i$f$isSynthetic = false;
            if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) {
                throw new AssertionError((Object)("Unexpected non-synthetic field: " + Reflection.getOrCreateKotlinClass(declaration.getClass())));
            }
            v4 = this.getDeclarationStorage();
            v5 = (FirField)declaration;
            v6 = containingClass;
            Intrinsics.checkNotNull((Object)v6);
            Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            v3 = v4.createIrFieldAndDelegatedMembers(v5, v6, (IrClass)parent);
        } else if (var5_4 instanceof FirConstructor) {
            if (!((FirConstructor)declaration).isPrimary()) {
                v7 = this.getDeclarationStorage();
                v8 = (FirConstructor)declaration;
                Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                v9 = Fir2IrDeclarationStorage.getOrCreateIrConstructor$default(v7, v8, (IrClass)parent, null, isLocal, 4, null);
            } else {
                v9 = null;
            }
            v3 = v9;
        } else if (var5_4 instanceof FirEnumEntry) {
            v10 = this.getClassifierStorage();
            v11 = (FirEnumEntry)declaration;
            Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            v3 = Fir2IrClassifierStorage.getIrEnumEntry$default(v10, v11, (IrClass)parent, null, 4, null);
        } else if (var5_4 instanceof FirAnonymousInitializer) {
            v12 = this.getDeclarationStorage();
            v13 = (FirAnonymousInitializer)declaration;
            Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            v3 = v12.createIrAnonymousInitializer(v13, (IrClass)parent);
        } else if (var5_4 instanceof FirTypeAlias) {
            v3 = null;
        } else if (var5_4 instanceof FirCodeFragment) {
            v3 = Fir2IrConverter.processCodeFragmentMembers$default(this, (FirCodeFragment)declaration, null, 2, null);
        } else {
            throw new IllegalStateException(("Unexpected member: " + Reflection.getOrCreateKotlinClass(declaration.getClass())).toString());
        }
        return v3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jn\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter$Companion;", "", "()V", "createModuleFragmentWithSignaturesIfNeeded", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrResult;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "firFiles", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "fir2IrExtensions", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "fir2IrConfiguration", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "irMangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "specialSymbolProvider", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSpecialSymbolProvider;", "kotlinBuiltIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "commonMemberStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrCommonMemberStorage;", "initializedIrBuiltIns", "Lorg/jetbrains/kotlin/fir/backend/IrBuiltInsOverFir;", "evaluateConstants", "", "irModuleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "fir2ir"})
    @SourceDebugExtension(value={"SMAP\nFir2IrConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,594:1\n1855#2,2:595\n*S KotlinDebug\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter$Companion\n*L\n516#1:595,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void evaluateConstants(IrModuleFragment irModuleFragment, Fir2IrConfiguration fir2IrConfiguration) {
            FirModuleDescriptor firModuleDescriptor;
            ModuleDescriptor moduleDescriptor = irModuleFragment.getDescriptor();
            FirModuleDescriptor firModuleDescriptor2 = firModuleDescriptor = moduleDescriptor instanceof FirModuleDescriptor ? (FirModuleDescriptor)moduleDescriptor : null;
            TargetPlatform targetPlatform = firModuleDescriptor2 != null ? firModuleDescriptor2.getPlatform() : null;
            Object object = firModuleDescriptor;
            if (object == null || (object = ((FirModuleDescriptor)object).getSession()) == null || (object = FirLanguageSettingsComponentKt.getLanguageVersionSettings((FirSession)object)) == null) {
                return;
            }
            Object languageVersionSettings2 = object;
            boolean intrinsicConstEvaluation = languageVersionSettings2.supportsFeature(LanguageFeature.IntrinsicConstEvaluation);
            IrInterpreterConfiguration configuration2 = new IrInterpreterConfiguration(targetPlatform, 0, 0, false, true, false, false, 110, null);
            IrInterpreter interpreter2 = new IrInterpreter(new IrInterpreterEnvironment(irModuleFragment.getIrBuiltins(), configuration2), null, 2, null);
            EvaluationMode mode = intrinsicConstEvaluation ? EvaluationMode.ONLY_INTRINSIC_CONST : EvaluationMode.ONLY_BUILTINS;
            KtDiagnosticReporterWithImplicitIrBasedContext ktDiagnosticReporter = new KtDiagnosticReporterWithImplicitIrBasedContext(fir2IrConfiguration.getDiagnosticReporter(), (LanguageVersionSettings)languageVersionSettings2);
            Iterable $this$forEach$iv = irModuleFragment.getFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrFile it = (IrFile)element$iv;
                boolean bl = false;
                IrConstTransformerKt.transformConst$default(it, interpreter2, mode, fir2IrConfiguration.getEvaluatedConstTracker(), fir2IrConfiguration.getInlineConstTracker(), null, (Function3)new Function3<IrFile, IrElement, IrErrorExpression, Unit>(ktDiagnosticReporter){
                    final /* synthetic */ KtDiagnosticReporterWithImplicitIrBasedContext $ktDiagnosticReporter;
                    {
                        this.$ktDiagnosticReporter = $ktDiagnosticReporter;
                        super(3);
                    }

                    public final void invoke(@NotNull IrFile irFile, @NotNull IrElement element, @NotNull IrErrorExpression error) {
                        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                        this.$ktDiagnosticReporter.at(org.jetbrains.kotlin.backend.common.UtilsKt.sourceElement(element), element, irFile).report(CommonBackendErrors.INSTANCE.getEVALUATION_ERROR(), error.getDescription());
                    }
                }, false, 80, null);
            }
        }

        @NotNull
        public final Fir2IrResult createModuleFragmentWithSignaturesIfNeeded(@NotNull FirSession session, @NotNull ScopeSession scopeSession, @NotNull List<? extends FirFile> firFiles, @NotNull Fir2IrExtensions fir2IrExtensions, @NotNull Fir2IrConfiguration fir2IrConfiguration, @NotNull KotlinMangler.IrMangler irMangler, @NotNull IrFactory irFactory, @NotNull Fir2IrVisibilityConverter visibilityConverter, @NotNull Fir2IrSpecialSymbolProvider specialSymbolProvider, @NotNull KotlinBuiltIns kotlinBuiltIns, @NotNull Fir2IrCommonMemberStorage commonMemberStorage, @Nullable IrBuiltInsOverFir initializedIrBuiltIns) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
            Intrinsics.checkNotNullParameter(firFiles, (String)"firFiles");
            Intrinsics.checkNotNullParameter((Object)fir2IrExtensions, (String)"fir2IrExtensions");
            Intrinsics.checkNotNullParameter((Object)fir2IrConfiguration, (String)"fir2IrConfiguration");
            Intrinsics.checkNotNullParameter((Object)irMangler, (String)"irMangler");
            Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
            Intrinsics.checkNotNullParameter((Object)visibilityConverter, (String)"visibilityConverter");
            Intrinsics.checkNotNullParameter((Object)specialSymbolProvider, (String)"specialSymbolProvider");
            Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"kotlinBuiltIns");
            Intrinsics.checkNotNullParameter((Object)commonMemberStorage, (String)"commonMemberStorage");
            FirLazyDeclarationResolverKt.getLazyDeclarationResolver(session).disableLazyResolveContractChecks();
            FirModuleDescriptor moduleDescriptor = new FirModuleDescriptor(session, kotlinBuiltIns);
            Fir2IrComponentsStorage components2 = new Fir2IrComponentsStorage(session, scopeSession, commonMemberStorage.getSymbolTable(), irFactory, commonMemberStorage.getFirSignatureComposer(), fir2IrExtensions, fir2IrConfiguration);
            Fir2IrConverter converter = new Fir2IrConverter(moduleDescriptor, components2);
            components2.setConverter(converter);
            components2.setClassifierStorage(new Fir2IrClassifierStorage(components2, commonMemberStorage));
            components2.setDelegatedMemberGenerator(new DelegatedMemberGenerator(components2));
            components2.setDeclarationStorage(new Fir2IrDeclarationStorage(components2, moduleDescriptor, commonMemberStorage));
            components2.setVisibilityConverter(visibilityConverter);
            components2.setTypeConverter(new Fir2IrTypeConverter(components2));
            IrBuiltInsOverFir irBuiltInsOverFir = initializedIrBuiltIns;
            if (irBuiltInsOverFir == null) {
                irBuiltInsOverFir = new IrBuiltInsOverFir(components2, fir2IrConfiguration.getLanguageVersionSettings(), moduleDescriptor, irMangler);
            }
            IrBuiltInsOverFir irBuiltIns = irBuiltInsOverFir;
            components2.setIrBuiltIns(irBuiltIns);
            Fir2IrConversionScope conversionScope = new Fir2IrConversionScope();
            Fir2IrVisitor fir2irVisitor = new Fir2IrVisitor(components2, conversionScope);
            components2.setBuiltIns(new Fir2IrBuiltIns(components2, specialSymbolProvider));
            components2.setAnnotationGenerator(new AnnotationGenerator(components2));
            components2.setFakeOverrideGenerator(new FakeOverrideGenerator(components2, conversionScope));
            components2.setCallGenerator(new CallAndReferenceGenerator(components2, fir2irVisitor, conversionScope));
            components2.setIrProviders(CollectionsKt.listOf((Object)new FirIrProvider(components2)));
            components2.setAnnotationsFromPluginRegistrar(new Fir2IrAnnotationsFromPluginRegistrar(components2));
            fir2IrExtensions.registerDeclarations(commonMemberStorage.getSymbolTable());
            IrModuleFragmentImpl irModuleFragment = new IrModuleFragmentImpl(moduleDescriptor, irBuiltIns, null, 4, null);
            List $this$createModuleFragmentWithSignaturesIfNeeded_u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$createModuleFragmentWithSignaturesIfNeeded_u24lambda_u241.addAll((Collection)firFiles);
            $this$createModuleFragmentWithSignaturesIfNeeded_u24lambda_u241.addAll((Collection)ConversionUtilsKt.createFilesWithGeneratedDeclarations(session));
            List allFirFiles = CollectionsKt.build((List)list2);
            converter.runSourcesConversion(allFirFiles, irModuleFragment, fir2irVisitor, initializedIrBuiltIns == null);
            return new Fir2IrResult(irModuleFragment, components2, moduleDescriptor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

