/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtDiagnosticReporterWithImplicitIrBasedContext;
import org.jetbrains.kotlin.backend.common.actualizer.ClassActualizationInfo;
import org.jetbrains.kotlin.backend.common.actualizer.ExpectActualCollectorKt;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizerUtilsKt;
import org.jetbrains.kotlin.backend.common.actualizer.IrExpectActualMatchingContext;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.mpp.DeclarationSymbolMarker;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualCompatibilityChecker;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCompatibility;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002J&\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitor;", "", "Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector$MatchingContext;", "()V", "matchExpectCallable", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "context", "matchExpectDeclaration", "expectSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "actualSymbols", "", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "data", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "MatchingContext", "ir.backend.common"})
final class ExpectActualLinkCollector
implements IrElementVisitor<Unit, MatchingContext> {
    @Override
    public void visitFile(@NotNull IrFile declaration, @NotNull MatchingContext data2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        IrElementVisitor.DefaultImpls.visitFile(this, declaration, data2.withNewCurrentFile(declaration));
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration, @NotNull MatchingContext data2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (declaration.isExpect()) {
            this.matchExpectCallable(declaration, AdditionalIrUtilsKt.getCallableId(declaration), data2);
        }
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration, @NotNull MatchingContext data2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (declaration.isExpect()) {
            this.matchExpectCallable(declaration, AdditionalIrUtilsKt.getCallableId(declaration), data2);
        }
    }

    private final void matchExpectCallable(IrDeclarationWithName declaration, CallableId callableId, MatchingContext context2) {
        IrSymbol irSymbol2 = declaration.getSymbol();
        List list2 = context2.getClassActualizationInfo$ir_backend_common().getActualTopLevels().get(callableId);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        this.matchExpectDeclaration(irSymbol2, list2, context2);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration, @NotNull MatchingContext data2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (!declaration.isExpect()) {
            return;
        }
        ClassId classId = AdditionalIrUtilsKt.getClassIdOrFail(declaration);
        IrClassSymbol expectClassSymbol = declaration.getSymbol();
        IrSymbol actualClassLikeSymbol = data2.getClassActualizationInfo$ir_backend_common().getActualWithoutExpansion(classId);
        this.matchExpectDeclaration(expectClassSymbol, CollectionsKt.listOfNotNull((Object)actualClassLikeSymbol), data2);
    }

    private final void matchExpectDeclaration(IrSymbol expectSymbol, List<? extends IrSymbol> actualSymbols, MatchingContext context2) {
        AbstractExpectActualCompatibilityChecker.INSTANCE.matchSingleExpectTopLevelDeclarationAgainstPotentialActuals(expectSymbol, actualSymbols, context2);
    }

    @Override
    public void visitElement(@NotNull IrElement element, @NotNull MatchingContext data2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        element.acceptChildren(this, data2);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitBlock(this, expression2, data2);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitBlockBody(this, body2, data2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitBody(this, body2, data2);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitBranch(this, branch, data2);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitBreak(this, jump, data2);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitBreakContinue(this, jump, data2);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitCall(this, expression2, data2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitCallableReference(this, expression2, data2);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitCatch(this, aCatch, data2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitClassReference(this, expression2, data2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitComposite(this, expression2, data2);
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitConst(this, expression2, data2);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitConstantArray(this, expression2, data2);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitConstantObject(this, expression2, data2);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitConstantValue(this, expression2, data2);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitConstructor(this, declaration, data2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitContainerExpression(this, expression2, data2);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitContinue(this, jump, data2);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitDeclaration(this, declaration, data2);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitDeclarationReference(this, expression2, data2);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitDynamicExpression(this, expression2, data2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitElseBranch(this, branch, data2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitEnumEntry(this, declaration, data2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitErrorExpression(this, expression2, data2);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitExpression(this, expression2, data2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitExpressionBody(this, body2, data2);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
    }

    @Override
    public void visitField(@NotNull IrField declaration, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitField(this, declaration, data2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitFieldAccess(this, expression2, data2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitFunctionAccess(this, expression2, data2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitFunctionExpression(this, expression2, data2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitFunctionReference(this, expression2, data2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitGetClass(this, expression2, data2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitGetEnumValue(this, expression2, data2);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitGetField(this, expression2, data2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitGetObjectValue(this, expression2, data2);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitGetValue(this, expression2, data2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitLoop(this, loop2, data2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitMemberAccess(this, expression2, data2);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitModuleFragment(this, declaration, data2);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitPackageFragment(this, declaration, data2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitPropertyReference(this, expression2, data2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitReturn(this, expression2, data2);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitScript(this, declaration, data2);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitSetField(this, expression2, data2);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitSetValue(this, expression2, data2);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitSimpleFunction(this, declaration, data2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitSingletonReference(this, expression2, data2);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitSpreadElement(this, spread, data2);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitStringConcatenation(this, expression2, data2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitSyntheticBody(this, body2, data2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitThrow(this, expression2, data2);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitTry(this, aTry, data2);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitTypeAlias(this, declaration, data2);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitTypeOperator(this, expression2, data2);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitTypeParameter(this, declaration, data2);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitValueAccess(this, expression2, data2);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitValueParameter(this, declaration, data2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitVararg(this, expression2, data2);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitVariable(this, declaration, data2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitWhen(this, expression2, data2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull MatchingContext data2) {
        IrElementVisitor.DefaultImpls.visitWhileLoop(this, loop2, data2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J.\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020!2\u001c\u0010\"\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030$\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0%0#H\u0016J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u000eJ\u0014\u0010(\u001a\u00020\u0019*\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0006H\u0002R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0012\u001a\u0004\u0018\u00010\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector$MatchingContext;", "Lorg/jetbrains/kotlin/backend/common/actualizer/IrExpectActualMatchingContext;", "typeSystemContext", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "destination", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "diagnosticsReporter", "Lorg/jetbrains/kotlin/KtDiagnosticReporterWithImplicitIrBasedContext;", "expectActualTracker", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "classActualizationInfo", "Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "currentExpectFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;Ljava/util/Map;Lorg/jetbrains/kotlin/KtDiagnosticReporterWithImplicitIrBasedContext;Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "getClassActualizationInfo$ir_backend_common", "()Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "currentExpectIoFile", "Ljava/io/File;", "getCurrentExpectIoFile", "()Ljava/io/File;", "currentExpectIoFile$delegate", "Lkotlin/Lazy;", "onMatchedCallables", "", "expectSymbol", "actualSymbol", "onMatchedClasses", "expectClassSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "actualClassSymbol", "onMismatchedMembersFromClassScope", "Lorg/jetbrains/kotlin/mpp/DeclarationSymbolMarker;", "actualSymbolsByIncompatibility", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualCompatibility$Incompatible;", "", "withNewCurrentFile", "newCurrentFile", "reportWithCurrentFile", "ir.backend.common"})
    public static final class MatchingContext
    extends IrExpectActualMatchingContext {
        @NotNull
        private final Map<IrSymbol, IrSymbol> destination;
        @NotNull
        private final KtDiagnosticReporterWithImplicitIrBasedContext diagnosticsReporter;
        @Nullable
        private final ExpectActualTracker expectActualTracker;
        @NotNull
        private final ClassActualizationInfo classActualizationInfo;
        @Nullable
        private final IrFile currentExpectFile;
        @NotNull
        private final Lazy currentExpectIoFile$delegate;

        public MatchingContext(@NotNull IrTypeSystemContext typeSystemContext2, @NotNull Map<IrSymbol, IrSymbol> destination, @NotNull KtDiagnosticReporterWithImplicitIrBasedContext diagnosticsReporter, @Nullable ExpectActualTracker expectActualTracker, @NotNull ClassActualizationInfo classActualizationInfo, @Nullable IrFile currentExpectFile) {
            Intrinsics.checkNotNullParameter((Object)typeSystemContext2, (String)"typeSystemContext");
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)diagnosticsReporter, (String)"diagnosticsReporter");
            Intrinsics.checkNotNullParameter((Object)classActualizationInfo, (String)"classActualizationInfo");
            super(typeSystemContext2, classActualizationInfo.getActualClasses());
            this.destination = destination;
            this.diagnosticsReporter = diagnosticsReporter;
            this.expectActualTracker = expectActualTracker;
            this.classActualizationInfo = classActualizationInfo;
            this.currentExpectFile = currentExpectFile;
            this.currentExpectIoFile$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<File>(this){
                final /* synthetic */ MatchingContext this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final File invoke() {
                    IrFile irFile = MatchingContext.access$getCurrentExpectFile$p(this.this$0);
                    return irFile != null ? ExpectActualCollectorKt.access$toIoFile(irFile) : null;
                }
            }));
        }

        @NotNull
        public final ClassActualizationInfo getClassActualizationInfo$ir_backend_common() {
            return this.classActualizationInfo;
        }

        private final File getCurrentExpectIoFile() {
            Lazy lazy = this.currentExpectIoFile$delegate;
            return (File)lazy.getValue();
        }

        @NotNull
        public final MatchingContext withNewCurrentFile(@NotNull IrFile newCurrentFile) {
            Intrinsics.checkNotNullParameter((Object)newCurrentFile, (String)"newCurrentFile");
            return new MatchingContext(this.getTypeContext(), this.destination, this.diagnosticsReporter, this.expectActualTracker, this.classActualizationInfo, newCurrentFile);
        }

        @Override
        public void onMatchedClasses(@NotNull IrClassSymbol expectClassSymbol, @NotNull IrClassSymbol actualClassSymbol) {
            Intrinsics.checkNotNullParameter((Object)expectClassSymbol, (String)"expectClassSymbol");
            Intrinsics.checkNotNullParameter((Object)actualClassSymbol, (String)"actualClassSymbol");
            this.destination.put(expectClassSymbol, actualClassSymbol);
            ExpectActualTracker expectActualTracker = this.expectActualTracker;
            if (expectActualTracker != null) {
                this.reportWithCurrentFile(expectActualTracker, actualClassSymbol);
            }
            IrActualizerUtilsKt.recordActualForExpectDeclaration(expectClassSymbol, actualClassSymbol, this.destination);
        }

        @Override
        public void onMatchedCallables(@NotNull IrSymbol expectSymbol, @NotNull IrSymbol actualSymbol) {
            Intrinsics.checkNotNullParameter((Object)expectSymbol, (String)"expectSymbol");
            Intrinsics.checkNotNullParameter((Object)actualSymbol, (String)"actualSymbol");
            ExpectActualTracker expectActualTracker = this.expectActualTracker;
            if (expectActualTracker != null) {
                this.reportWithCurrentFile(expectActualTracker, actualSymbol);
            }
            IrActualizerUtilsKt.recordActualForExpectDeclaration(expectSymbol, actualSymbol, this.destination);
        }

        @Override
        public void onMismatchedMembersFromClassScope(@NotNull DeclarationSymbolMarker expectSymbol, @NotNull Map<ExpectActualCompatibility.Incompatible<?>, ? extends List<? extends DeclarationSymbolMarker>> actualSymbolsByIncompatibility) {
            Intrinsics.checkNotNullParameter((Object)expectSymbol, (String)"expectSymbol");
            Intrinsics.checkNotNullParameter(actualSymbolsByIncompatibility, (String)"actualSymbolsByIncompatibility");
            if (!(expectSymbol instanceof IrSymbol)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            if (actualSymbolsByIncompatibility.isEmpty() && !IrActualizerUtilsKt.containsOptionalExpectation(((IrSymbol)expectSymbol).getOwner())) {
                IrActualizerUtilsKt.reportMissingActual(this.diagnosticsReporter, (IrSymbol)expectSymbol);
            }
            for (Map.Entry<ExpectActualCompatibility.Incompatible<?>, List<DeclarationSymbolMarker>> entry : actualSymbolsByIncompatibility.entrySet()) {
                ExpectActualCompatibility.Incompatible<?> incompatibility = entry.getKey();
                List<DeclarationSymbolMarker> actualMemberSymbols = entry.getValue();
                for (DeclarationSymbolMarker declarationSymbolMarker : actualMemberSymbols) {
                    if (!(declarationSymbolMarker instanceof IrSymbol)) {
                        String string3 = "Failed requirement.";
                        throw new IllegalArgumentException(string3.toString());
                    }
                    IrActualizerUtilsKt.reportIncompatibleExpectActual(this.diagnosticsReporter, (IrSymbol)expectSymbol, (IrSymbol)declarationSymbolMarker, incompatibility);
                }
            }
        }

        private final void reportWithCurrentFile(ExpectActualTracker $this$reportWithCurrentFile, IrSymbol actualSymbol) {
            if (this.currentExpectFile != null) {
                File actualIoFile;
                IrFile irFile = this.classActualizationInfo.getActualSymbolsToFile().get(actualSymbol);
                File file2 = actualIoFile = irFile != null ? ExpectActualCollectorKt.access$toIoFile(irFile) : null;
                if (actualIoFile != null) {
                    File file3 = this.getCurrentExpectIoFile();
                    Intrinsics.checkNotNull((Object)file3);
                    $this$reportWithCurrentFile.report(file3, actualIoFile);
                }
            }
        }

        public static final /* synthetic */ IrFile access$getCurrentExpectFile$p(MatchingContext $this) {
            return $this.currentExpectFile;
        }
    }
}

