/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.renderer;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.fir.renderer.ConeAttributeRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeIdRenderer;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerConstantOperatorType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeStubTypeForChainInference;
import org.jetbrains.kotlin.fir.types.ConeStubTypeForSyntheticFixation;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001cJA\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001c2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f2\u0019\b\u0002\u0010!\u001a\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00170\u001f\u00a2\u0006\u0002\b#H\u0016J\f\u0010\u0016\u001a\u00020\u0017*\u00020$H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\"H\u0002J\f\u0010%\u001a\u00020\u0017*\u00020\u001cH\u0002J\f\u0010&\u001a\u00020'*\u00020\u0019H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/fir/renderer/ConeTypeRenderer;", "", "()V", "attributeRenderer", "Lorg/jetbrains/kotlin/fir/renderer/ConeAttributeRenderer;", "getAttributeRenderer", "()Lorg/jetbrains/kotlin/fir/renderer/ConeAttributeRenderer;", "setAttributeRenderer", "(Lorg/jetbrains/kotlin/fir/renderer/ConeAttributeRenderer;)V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getBuilder", "()Ljava/lang/StringBuilder;", "setBuilder", "(Ljava/lang/StringBuilder;)V", "idRenderer", "Lorg/jetbrains/kotlin/fir/renderer/ConeIdRenderer;", "getIdRenderer", "()Lorg/jetbrains/kotlin/fir/renderer/ConeIdRenderer;", "setIdRenderer", "(Lorg/jetbrains/kotlin/fir/renderer/ConeIdRenderer;)V", "render", "", "flexibleType", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralType;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "renderAsPossibleFunctionType", "functionClassKindExtractor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "renderType", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "renderAttributes", "renderForSameLookupTags", "", "cones"})
public class ConeTypeRenderer {
    public StringBuilder builder;
    public ConeIdRenderer idRenderer;
    @NotNull
    private ConeAttributeRenderer attributeRenderer = ConeAttributeRenderer.ToString.INSTANCE;

    @NotNull
    public final StringBuilder getBuilder() {
        StringBuilder stringBuilder2 = this.builder;
        if (stringBuilder2 != null) {
            return stringBuilder2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
        return null;
    }

    public final void setBuilder(@NotNull StringBuilder stringBuilder2) {
        Intrinsics.checkNotNullParameter((Object)stringBuilder2, (String)"<set-?>");
        this.builder = stringBuilder2;
    }

    @NotNull
    public final ConeIdRenderer getIdRenderer() {
        ConeIdRenderer coneIdRenderer = this.idRenderer;
        if (coneIdRenderer != null) {
            return coneIdRenderer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"idRenderer");
        return null;
    }

    public final void setIdRenderer(@NotNull ConeIdRenderer coneIdRenderer) {
        Intrinsics.checkNotNullParameter((Object)coneIdRenderer, (String)"<set-?>");
        this.idRenderer = coneIdRenderer;
    }

    @NotNull
    public final ConeAttributeRenderer getAttributeRenderer() {
        return this.attributeRenderer;
    }

    public final void setAttributeRenderer(@NotNull ConeAttributeRenderer coneAttributeRenderer) {
        Intrinsics.checkNotNullParameter((Object)coneAttributeRenderer, (String)"<set-?>");
        this.attributeRenderer = coneAttributeRenderer;
    }

    public void renderAsPossibleFunctionType(@NotNull ConeKotlinType type2, @NotNull Function1<? super ConeKotlinType, ? extends FunctionTypeKind> functionClassKindExtractor, @NotNull Function1<? super ConeTypeProjection, Unit> renderType) {
        FunctionTypeKind kind;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(functionClassKindExtractor, (String)"functionClassKindExtractor");
        Intrinsics.checkNotNullParameter(renderType, (String)"renderType");
        FunctionTypeKind functionTypeKind = kind = (FunctionTypeKind)functionClassKindExtractor.invoke((Object)type2);
        if (!(functionTypeKind != null ? !functionTypeKind.isReflectType() : false)) {
            renderType.invoke((Object)type2);
            return;
        }
        if (ConeTypeUtilsKt.isMarkedNullable(type2)) {
            this.getBuilder().append("(");
        }
        String string2 = kind.getPrefixForTypeRender();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            this.getBuilder().append(it);
            this.getBuilder().append(" ");
        }
        Object[] typeArguments = type2.getTypeArguments();
        boolean isExtension = CompilerConeAttributesKt.isExtensionFunctionType(type2);
        Pair pair = isExtension && !Intrinsics.areEqual((Object)ArraysKt.first((Object[])typeArguments), (Object)ConeStarProjection.INSTANCE) ? TuplesKt.to((Object)ArraysKt.first((Object[])typeArguments), (Object)ArraysKt.drop((Object[])typeArguments, (int)1)) : TuplesKt.to(null, (Object)ArraysKt.toList((Object[])typeArguments));
        ConeTypeProjection receiver = (ConeTypeProjection)pair.component1();
        List otherTypeArguments = (List)pair.component2();
        List arguments2 = otherTypeArguments.subList(0, otherTypeArguments.size() - 1);
        ConeTypeProjection returnType2 = (ConeTypeProjection)CollectionsKt.last((List)otherTypeArguments);
        if (receiver != null) {
            this.render(receiver);
            this.getBuilder().append(".");
        }
        this.getBuilder().append("(");
        Iterator iterator2 = arguments2.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            ConeTypeProjection argument2 = (ConeTypeProjection)iterator2.next();
            if (index2 != 0) {
                this.getBuilder().append(", ");
            }
            this.render(argument2);
        }
        this.getBuilder().append(") -> ");
        this.render(returnType2);
        if (ConeTypeUtilsKt.isMarkedNullable(type2)) {
            this.getBuilder().append(")?");
        }
    }

    public static /* synthetic */ void renderAsPossibleFunctionType$default(ConeTypeRenderer coneTypeRenderer, ConeKotlinType coneKotlinType, Function1 function1, Function1 function12, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: renderAsPossibleFunctionType");
        }
        if ((n & 4) != 0) {
            function12 = (Function1)new Function1<ConeTypeProjection, Unit>(coneTypeRenderer){
                final /* synthetic */ ConeTypeRenderer this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ConeTypeProjection $this$null) {
                    Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                    ConeTypeRenderer.access$render(this.this$0, $this$null);
                }
            };
        }
        coneTypeRenderer.renderAsPossibleFunctionType(coneKotlinType, (Function1<? super ConeKotlinType, ? extends FunctionTypeKind>)function1, (Function1<? super ConeTypeProjection, Unit>)function12);
    }

    public final void render(@NotNull ConeKotlinType type2) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!(type2 instanceof ConeFlexibleType) && !(type2 instanceof ConeDefinitelyNotNullType)) {
            this.renderAttributes(type2);
        }
        if ((coneKotlinType = type2) instanceof ConeTypeVariableType) {
            this.getBuilder().append("TypeVariable(");
            this.getBuilder().append(((ConeTypeVariableType)type2).getLookupTag().getName());
            this.getBuilder().append(")");
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            this.render(((ConeDefinitelyNotNullType)type2).getOriginal());
            this.getBuilder().append(" & Any");
        } else if (coneKotlinType instanceof ConeErrorType) {
            this.getBuilder().append("ERROR CLASS: " + ((ConeErrorType)type2).getDiagnostic().getReason());
        } else if (coneKotlinType instanceof ConeCapturedType) {
            this.getBuilder().append("CapturedType(");
            this.render(((ConeCapturedType)type2).getConstructor().getProjection());
            this.getBuilder().append(")");
        } else if (coneKotlinType instanceof ConeClassLikeType) {
            this.render((ConeClassLikeType)type2);
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            this.getBuilder().append(((ConeLookupTagBasedType)type2).getLookupTag().getName().asString());
        } else if (coneKotlinType instanceof ConeDynamicType) {
            this.getBuilder().append("dynamic");
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            this.render((ConeFlexibleType)type2);
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            this.getBuilder().append("it(");
            Iterator<ConeKotlinType> iterator2 = ((ConeIntersectionType)type2).getIntersectedTypes().iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int index2 = n++;
                ConeKotlinType intersected = iterator2.next();
                if (index2 > 0) {
                    this.getBuilder().append(" & ");
                }
                this.render(intersected);
            }
            this.getBuilder().append(")");
        } else if (coneKotlinType instanceof ConeStubTypeForSyntheticFixation) {
            this.getBuilder().append("Stub (fixation): " + ((ConeStubTypeForSyntheticFixation)type2).getConstructor().getVariable());
        } else if (coneKotlinType instanceof ConeStubTypeForChainInference) {
            this.getBuilder().append("Stub (chain inference): " + ((ConeStubTypeForChainInference)type2).getConstructor().getVariable());
        } else if (coneKotlinType instanceof ConeStubType) {
            this.getBuilder().append("Stub (subtyping): " + ((ConeStubType)type2).getConstructor().getVariable());
        } else if (coneKotlinType instanceof ConeIntegerLiteralType) {
            this.render((ConeIntegerLiteralType)type2);
        }
        if (!(type2 instanceof ConeFlexibleType) && !(type2 instanceof ConeErrorType)) {
            this.getBuilder().append(type2.getNullability().getSuffix());
        }
    }

    private final void render(ConeClassLikeType $this$render) {
        this.getIdRenderer().renderClassId($this$render.getLookupTag().getClassId());
        if ($this$render.getTypeArguments().length == 0) {
            return;
        }
        this.getBuilder().append("<");
        ConeTypeProjection[] coneTypeProjectionArray = $this$render.getTypeArguments();
        int n = coneTypeProjectionArray.length;
        for (int i = 0; i < n; ++i) {
            int index2 = i;
            ConeTypeProjection typeArgument = coneTypeProjectionArray[i];
            if (index2 > 0) {
                this.getBuilder().append(", ");
            }
            this.render(typeArgument);
        }
        this.getBuilder().append(">");
    }

    private final boolean renderForSameLookupTags(ConeFlexibleType $this$renderForSameLookupTags) {
        if ($this$renderForSameLookupTags.getLowerBound() instanceof ConeLookupTagBasedType && $this$renderForSameLookupTags.getUpperBound() instanceof ConeLookupTagBasedType && Intrinsics.areEqual((Object)((ConeLookupTagBasedType)$this$renderForSameLookupTags.getLowerBound()).getLookupTag(), (Object)((ConeLookupTagBasedType)$this$renderForSameLookupTags.getUpperBound()).getLookupTag()) && $this$renderForSameLookupTags.getLowerBound().getNullability() == ConeNullability.NOT_NULL && $this$renderForSameLookupTags.getUpperBound().getNullability() == ConeNullability.NULLABLE && (!($this$renderForSameLookupTags.getLowerBound() instanceof ConeClassLikeType) || $this$renderForSameLookupTags.getLowerBound().getTypeArguments().length == 0) && (!($this$renderForSameLookupTags.getUpperBound() instanceof ConeClassLikeType) || $this$renderForSameLookupTags.getUpperBound().getTypeArguments().length == 0)) {
            this.render($this$renderForSameLookupTags.getLowerBound());
            this.getBuilder().append("!");
            return true;
        }
        return false;
    }

    protected void render(@NotNull ConeFlexibleType flexibleType) {
        Intrinsics.checkNotNullParameter((Object)flexibleType, (String)"flexibleType");
        if (this.renderForSameLookupTags(flexibleType)) {
            return;
        }
        this.getBuilder().append("ft<");
        this.render(flexibleType.getLowerBound());
        this.getBuilder().append(", ");
        this.render(flexibleType.getUpperBound());
        this.getBuilder().append(">");
    }

    private final void renderAttributes(ConeKotlinType $this$renderAttributes) {
        if (!CollectionsKt.any((Iterable)$this$renderAttributes.getAttributes())) {
            return;
        }
        this.getBuilder().append(this.attributeRenderer.render($this$renderAttributes.getAttributes()));
    }

    private final void render(ConeTypeProjection $this$render) {
        ConeTypeProjection coneTypeProjection = $this$render;
        if (Intrinsics.areEqual((Object)coneTypeProjection, (Object)ConeStarProjection.INSTANCE)) {
            this.getBuilder().append("*");
        } else if (coneTypeProjection instanceof ConeKotlinTypeConflictingProjection) {
            this.getBuilder().append("CONFLICTING-PROJECTION ");
            this.render(((ConeKotlinTypeConflictingProjection)$this$render).getType());
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionIn) {
            this.getBuilder().append("in ");
            this.render(((ConeKotlinTypeProjectionIn)$this$render).getType());
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionOut) {
            this.getBuilder().append("out ");
            this.render(((ConeKotlinTypeProjectionOut)$this$render).getType());
        } else if (coneTypeProjection instanceof ConeKotlinType) {
            this.render((ConeKotlinType)$this$render);
        }
    }

    protected void render(@NotNull ConeIntegerLiteralType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeIntegerLiteralType coneIntegerLiteralType = type2;
        if (coneIntegerLiteralType instanceof ConeIntegerLiteralConstantType) {
            this.getBuilder().append("ILT: " + ((ConeIntegerLiteralConstantType)type2).getValue());
        } else if (coneIntegerLiteralType instanceof ConeIntegerConstantOperatorType) {
            this.getBuilder().append("IOT");
        }
    }

    public static final /* synthetic */ void access$render(ConeTypeRenderer $this, ConeTypeProjection $receiver) {
        $this.render($receiver);
    }
}

