/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization.constant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.constant.AnnotationValue;
import org.jetbrains.kotlin.constant.ArrayValue;
import org.jetbrains.kotlin.constant.BooleanValue;
import org.jetbrains.kotlin.constant.ByteValue;
import org.jetbrains.kotlin.constant.CharValue;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.DoubleValue;
import org.jetbrains.kotlin.constant.EnumValue;
import org.jetbrains.kotlin.constant.FloatValue;
import org.jetbrains.kotlin.constant.IntValue;
import org.jetbrains.kotlin.constant.LongValue;
import org.jetbrains.kotlin.constant.NullValue;
import org.jetbrains.kotlin.constant.ShortValue;
import org.jetbrains.kotlin.constant.StringValue;
import org.jetbrains.kotlin.constant.UByteValue;
import org.jetbrains.kotlin.constant.UIntValue;
import org.jetbrains.kotlin.constant.ULongValue;
import org.jetbrains.kotlin.constant.UShortValue;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirArrayOfCallTransformer;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;
import org.jetbrains.kotlin.fir.serialization.constant.ConstantValueUtilsKt;
import org.jetbrains.kotlin.fir.serialization.constant.FirToConstantValueTransformer;
import org.jetbrains.kotlin.fir.serialization.constant.FirToConstantValueTransformerData;
import org.jetbrains.kotlin.fir.serialization.constant.FirToConstantValueTransformerKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001c\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001c\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J*\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00122\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001c\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010&\u001a\u00020'2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010)\u001a\u00020*2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001a\u0010+\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002*\u00020,2\u0006\u0010\b\u001a\u00020\u0003H\u0002\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "Lorg/jetbrains/kotlin/constant/ConstantValue;", "Lorg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformerData;", "()V", "visitAnnotation", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "data", "visitAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "visitArrayOfCall", "arrayOfCall", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayOfCall;", "visitConstExpression", "T", "constExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitGetClassCall", "getClassCall", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "visitQualifiedAccessExpression", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "visitStringConcatenationCall", "stringConcatenationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;", "visitVarargArgumentsExpression", "varargArgumentsExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;", "visitWrappedArgumentExpression", "wrappedArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWrappedArgumentExpression;", "toConstantValue", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "fir-serialization"})
@SourceDebugExtension(value={"SMAP\nFirToConstantValueTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirToConstantValueTransformer.kt\norg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 5 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 6 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,304:1\n1549#2:305\n1620#2,3:306\n1747#2,3:309\n1603#2,9:312\n1855#2:321\n1856#2:323\n1612#2:324\n1603#2,9:334\n1855#2:343\n1856#2:345\n1612#2:346\n1#3:322\n1#3:344\n20#4:325\n44#5:326\n17#5,2:327\n61#6,4:329\n47#6:333\n*S KotlinDebug\n*F\n+ 1 FirToConstantValueTransformer.kt\norg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformer\n*L\n90#1:305\n90#1:306,3\n91#1:309,3\n99#1:312,9\n99#1:321\n99#1:323\n99#1:324\n215#1:334,9\n215#1:343\n215#1:345\n215#1:346\n99#1:322\n215#1:344\n118#1:325\n135#1:326\n139#1:327,2\n151#1:329,4\n212#1:333\n*E\n"})
public final class FirToConstantValueTransformer
extends FirDefaultVisitor<ConstantValue<?>, FirToConstantValueTransformerData> {
    @NotNull
    public static final FirToConstantValueTransformer INSTANCE = new FirToConstantValueTransformer();

    private FirToConstantValueTransformer() {
    }

    private final ConstantValue<?> toConstantValue(FirExpression $this$toConstantValue, FirToConstantValueTransformerData data2) {
        Object object = data2.getConstValueProvider();
        if (object == null || (object = ((ConstValueProvider)object).findConstantValueFor($this$toConstantValue)) == null) {
            object = (ConstantValue)$this$toConstantValue.accept(this, data2);
        }
        return object;
    }

    @Override
    @Nullable
    public ConstantValue<?> visitElement(@NotNull FirElement element, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        throw new IllegalStateException(("Illegal element as annotation argument: " + Reflection.getOrCreateKotlinClass(element.getClass()).getQualifiedName() + " -> " + UtilsKt.render(element)).toString());
    }

    @Override
    @Nullable
    public <T> ConstantValue<?> visitConstExpression(@NotNull FirConstExpression<T> constExpression, @NotNull FirToConstantValueTransformerData data2) {
        ConstantValue constantValue;
        Intrinsics.checkNotNullParameter(constExpression, (String)"constExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        T value2 = constExpression.getValue();
        ConstantValueKind<T> constantValueKind = constExpression.getKind();
        if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Boolean");
            constantValue = new BooleanValue((Boolean)value2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Char.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Char");
            constantValue = new CharValue(((Character)value2).charValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new ByteValue(((Number)value2).byteValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedByte.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new UByteValue(((Number)value2).byteValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Short.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new ShortValue(((Number)value2).shortValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedShort.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new UShortValue(((Number)value2).shortValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Int.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new IntValue(((Number)value2).intValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedInt.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new UIntValue(((Number)value2).intValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Long.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new LongValue(((Number)value2).longValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedLong.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new ULongValue(((Number)value2).longValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.String.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.String");
            constantValue = new StringValue((String)value2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Float.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new FloatValue(((Number)value2).floatValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Double.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new DoubleValue(((Number)value2).doubleValue());
        } else {
            constantValue = Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Null.INSTANCE) ? (ConstantValue)NullValue.INSTANCE : null;
        }
        return constantValue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ConstantValue<?> visitStringConcatenationCall(@NotNull FirStringConcatenationCall stringConcatenationCall, @NotNull FirToConstantValueTransformerData data2) {
        boolean bl;
        List strings2;
        block5: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)stringConcatenationCall, (String)"stringConcatenationCall");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Iterable $this$map$iv = stringConcatenationCall.getArgumentList().getArguments();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirExpression firExpression2 = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(INSTANCE.toConstantValue((FirExpression)it, data2));
            }
            strings2 = (List)destination$iv$iv;
            Iterable $this$any$iv = strings2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConstantValue it = (ConstantValue)element$iv;
                    boolean bl3 = false;
                    if (!(it == null || !(it instanceof StringValue))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        return new StringValue(CollectionsKt.joinToString$default((Iterable)strings2, (CharSequence)"", null, null, (int)0, null, (Function1)visitStringConcatenationCall.2.INSTANCE, (int)30, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ConstantValue<?> visitArrayOfCall(@NotNull FirArrayOfCall arrayOfCall, @NotNull FirToConstantValueTransformerData data2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)arrayOfCall, (String)"arrayOfCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Iterable $this$mapNotNull$iv = arrayOfCall.getArgumentList().getArguments();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConstantValue<?> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirExpression it = (FirExpression)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.toConstantValue(it, data2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return new ArrayValue(list2);
    }

    @Override
    @NotNull
    public ConstantValue<?> visitAnnotation(@NotNull FirAnnotation annotation2, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Map<Name, ConstantValue<?>> mapping2 = ConstantValueUtilsKt.convertToConstantValues(annotation2.getArgumentMapping().getMapping(), data2.getSession(), data2.getConstValueProvider());
        return AnnotationValue.Companion.create(FirTypeUtilsKt.getConeType(annotation2.getAnnotationTypeRef()), mapping2);
    }

    @Override
    @NotNull
    public ConstantValue<?> visitAnnotationCall(@NotNull FirAnnotationCall annotationCall, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.visitAnnotation((FirAnnotation)annotationCall, data2);
    }

    @Override
    @Nullable
    public ConstantValue<?> visitGetClassCall(@NotNull FirGetClassCall getClassCall, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)getClassCall, (String)"getClassCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        FirTypeRef $this$coneTypeUnsafe$iv = getClassCall.getArgument().getTypeRef();
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        return ConstantValueUtilsKt.create(coneKotlinType);
    }

    @Override
    @Nullable
    public ConstantValue<?> visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @NotNull FirToConstantValueTransformerData data2) {
        ConstantValue<Object> constantValue;
        block43: {
            block46: {
                FirCallableSymbol<?> symbol2;
                block45: {
                    Modality modality$iv;
                    FirCallableDeclaration fir;
                    block44: {
                        block42: {
                            Intrinsics.checkNotNullParameter((Object)qualifiedAccessExpression, (String)"qualifiedAccessExpression");
                            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                            FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(qualifiedAccessExpression);
                            if (firCallableSymbol == null) {
                                return null;
                            }
                            symbol2 = firCallableSymbol;
                            fir = (FirCallableDeclaration)symbol2.getFir();
                            if (!(symbol2.getFir() instanceof FirEnumEntry)) break block42;
                            ClassId classId = symbol2.getCallableId().getClassId();
                            if (classId == null) {
                                return null;
                            }
                            ClassId classId2 = classId;
                            Object e = symbol2.getFir();
                            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirEnumEntry");
                            constantValue = new EnumValue(classId2, ((FirEnumEntry)e).getName());
                            break block43;
                        }
                        if (!(symbol2 instanceof FirPropertySymbol)) break block44;
                        FirMemberDeclaration $this$isConst$iv = (FirMemberDeclaration)((FirPropertySymbol)symbol2).getFir();
                        boolean $i$f$isConst = false;
                        if ($this$isConst$iv.getStatus().isConst()) {
                            FirExpression firExpression2 = ((FirProperty)((FirPropertySymbol)symbol2).getFir()).getInitializer();
                            constantValue = firExpression2 != null ? this.toConstantValue(firExpression2, data2) : null;
                        } else {
                            constantValue = null;
                        }
                        break block43;
                    }
                    if (!(fir instanceof FirField)) break block45;
                    FirMemberDeclaration $this$isFinal$iv = fir;
                    boolean $i$f$isFinal = false;
                    Modality modality = $this$isFinal$iv.getStatus().getModality();
                    if (modality == null ? true : (modality$iv = modality) == Modality.FINAL) {
                        FirExpression firExpression3 = ((FirField)fir).getInitializer();
                        constantValue = firExpression3 != null ? this.toConstantValue(firExpression3, data2) : null;
                    } else {
                        constantValue = null;
                    }
                    break block43;
                }
                if (symbol2 instanceof FirConstructorSymbol) {
                    Map<Name, ConstantValue<?>> map;
                    FirFunctionCall constructorCall = (FirFunctionCall)qualifiedAccessExpression;
                    Object object = ClassMembersKt.containingClassLookupTag(symbol2);
                    if (object == null || (object = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)object, data2.getSession())) == null) {
                        return null;
                    }
                    Object constructedClassSymbol = object;
                    if (((FirClassSymbol)constructedClassSymbol).getClassKind() != ClassKind.ANNOTATION_CLASS) {
                        return null;
                    }
                    FirCall $this$resolvedArgumentMapping$iv = constructorCall;
                    boolean $i$f$getResolvedArgumentMapping = false;
                    FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
                    LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
                    if (linkedHashMap == null || (map = ConstantValueUtilsKt.convertToConstantValues(linkedHashMap, data2.getSession(), data2.getConstValueProvider())) == null) {
                        return null;
                    }
                    Map<Name, ConstantValue<?>> mapping2 = map;
                    return AnnotationValue.Companion.create(FirTypeUtilsKt.getConeType(qualifiedAccessExpression.getTypeRef()), mapping2);
                }
                if (!Intrinsics.areEqual((Object)symbol2.getCallableId().getPackageName().asString(), (Object)"kotlin")) break block46;
                String string2 = symbol2.getCallableId().getCallableName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                String callableName = string2;
                if (!FirToConstantValueTransformerKt.access$getConstantIntrinsicCalls$p().contains(callableName)) {
                    return null;
                }
                FirExpression dispatchReceiver = qualifiedAccessExpression.getDispatchReceiver();
                ConstantValue<?> constantValue2 = this.toConstantValue(dispatchReceiver, data2);
                if (constantValue2 == null) {
                    return null;
                }
                ConstantValue<?> dispatchReceiverValue2 = constantValue2;
                switch (callableName) {
                    case "toByte": {
                        Object obj = dispatchReceiverValue2.getValue();
                        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
                        constantValue = new ByteValue(((Number)obj).byteValue());
                        break;
                    }
                    case "toLong": {
                        Object obj = dispatchReceiverValue2.getValue();
                        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
                        constantValue = new LongValue(((Number)obj).longValue());
                        break;
                    }
                    case "toShort": {
                        Object obj = dispatchReceiverValue2.getValue();
                        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
                        constantValue = new ShortValue(((Number)obj).shortValue());
                        break;
                    }
                    case "toFloat": {
                        Object obj = dispatchReceiverValue2.getValue();
                        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
                        constantValue = new FloatValue(((Number)obj).floatValue());
                        break;
                    }
                    case "toDouble": {
                        Object obj = dispatchReceiverValue2.getValue();
                        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
                        constantValue = new DoubleValue(((Number)obj).doubleValue());
                        break;
                    }
                    case "toChar": {
                        Object obj = dispatchReceiverValue2.getValue();
                        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
                        constantValue = new CharValue((char)((Number)obj).intValue());
                        break;
                    }
                    case "unaryMinus": {
                        ConstantValue<?> constantValue3 = dispatchReceiverValue2;
                        if (constantValue3 instanceof ByteValue) {
                            constantValue = new ByteValue(-((Number)((ByteValue)dispatchReceiverValue2).getValue()).byteValue());
                            break;
                        }
                        if (constantValue3 instanceof LongValue) {
                            constantValue = new LongValue(-((Number)((LongValue)dispatchReceiverValue2).getValue()).longValue());
                            break;
                        }
                        if (constantValue3 instanceof ShortValue) {
                            constantValue = new ShortValue(-((Number)((ShortValue)dispatchReceiverValue2).getValue()).shortValue());
                            break;
                        }
                        if (constantValue3 instanceof FloatValue) {
                            constantValue = new FloatValue(-((Number)((FloatValue)dispatchReceiverValue2).getValue()).floatValue());
                            break;
                        }
                        if (constantValue3 instanceof DoubleValue) {
                            constantValue = new DoubleValue(-((Number)((DoubleValue)dispatchReceiverValue2).getValue()).doubleValue());
                            break;
                        }
                        constantValue = null;
                        break;
                    }
                    default: {
                        constantValue = null;
                        break;
                    }
                }
                break block43;
            }
            constantValue = null;
        }
        return constantValue;
    }

    @Override
    @Nullable
    public ConstantValue<?> visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)propertyAccessExpression, data2);
    }

    @Override
    @Nullable
    public ConstantValue<?> visitFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (FirArrayOfCallTransformer.Companion.isArrayOfCall(functionCall)) {
            return (ConstantValue)new FirArrayOfCallTransformer().transformFunctionCall(functionCall, null).accept(this, data2);
        }
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)functionCall, data2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ConstantValue<?> visitVarargArgumentsExpression(@NotNull FirVarargArgumentsExpression varargArgumentsExpression, @NotNull FirToConstantValueTransformerData data2) {
        void $this$mapNotNullTo$iv$iv;
        List<FirExpression> list2;
        block4: {
            List<FirExpression> it;
            block3: {
                Intrinsics.checkNotNullParameter((Object)varargArgumentsExpression, (String)"varargArgumentsExpression");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                it = varargArgumentsExpression.getArguments();
                boolean bl = false;
                FirExpression firExpression2 = (FirExpression)CollectionsKt.singleOrNull(it);
                FirExpression firExpression3 = firExpression2 != null ? FirExpressionUtilKt.unwrapArgument(firExpression2) : null;
                list2 = firExpression3 instanceof FirArrayOfCall ? (FirArrayOfCall)firExpression3 : null;
                if (list2 == null) break block3;
                FirCall $this$arguments$iv = (FirCall)((Object)list2);
                boolean $i$f$getArguments = false;
                list2 = $this$arguments$iv.getArgumentList().getArguments();
                if (list2 != null) break block4;
            }
            list2 = it;
        }
        List<FirExpression> arguments2 = list2;
        Iterable $this$mapNotNull$iv = arguments2;
        boolean $i$f$mapNotNull = false;
        Iterable bl = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConstantValue<?> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            FirExpression it = (FirExpression)element$iv$iv;
            boolean bl3 = false;
            if (INSTANCE.toConstantValue(it, data2) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        return new ArrayValue(list3);
    }

    @Override
    @Nullable
    public ConstantValue<?> visitWrappedArgumentExpression(@NotNull FirWrappedArgumentExpression wrappedArgumentExpression, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)wrappedArgumentExpression, (String)"wrappedArgumentExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.toConstantValue(wrappedArgumentExpression.getExpression(), data2);
    }
}

