/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.CopyUtilsKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataContext;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.builder.FirContextReceiverBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.FirRegularTowerDataContexts;
import org.jetbrains.kotlin.fir.resolve.FirTowerDataMode;
import org.jetbrains.kotlin.fir.resolve.ResolutionMode;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.CallableReferenceResolutionKt;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.FirNamedReferenceWithCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.inference.CompletionModeCalculatorKt;
import org.jetbrains.kotlin.fir.resolve.inference.ConeTypeVariableForLambdaReturnType;
import org.jetbrains.kotlin.fir.resolve.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.fir.resolve.inference.FirBuilderInferenceSession;
import org.jetbrains.kotlin.fir.resolve.inference.FirCallCompleterKt;
import org.jetbrains.kotlin.fir.resolve.inference.FirDelegatedPropertyInferenceSession;
import org.jetbrains.kotlin.fir.resolve.inference.FirInferenceSession;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponentsKt;
import org.jetbrains.kotlin.fir.resolve.inference.LambdaAnalyzer;
import org.jetbrains.kotlin.fir.resolve.inference.PostponedArgumentsAnalyzer;
import org.jetbrains.kotlin.fir.resolve.inference.PostponedResolvedAtom;
import org.jetbrains.kotlin.fir.resolve.inference.ResolvedLambdaAtom;
import org.jetbrains.kotlin.fir.resolve.inference.ReturnArgumentsAnalysisResult;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeArgumentConstraintPosition;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeExpectedTypeConstraintPosition;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.transformers.FirCallCompletionResultsWriterTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.InvocationKindTransformerKt;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.BodyResolveContext;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirAbstractBodyResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirAbstractBodyResolveTransformerDispatcher;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemCompletionMode;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintSystemImpl;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.MarkerExtensionsKt;
import org.jetbrains.kotlin.types.model.StubTypeMarker;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J)\u0010\u0019\u001a\u0002H\u001a\"\f\b\u0000\u0010\u001a*\u00020\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u0002H\u001a2\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0013\u001a\u00020\u0014JE\u0010,\u001a\u00020\u0012\"\f\b\u0000\u0010\u001a*\u00020\u001b*\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001d\u001a\u0002H\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010/\u001a\u0004\u0018\u00010&\u00a2\u0006\u0002\u00100J\f\u00101\u001a\u00020\u0016*\u00020\u0016H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter;", "", "transformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformerDispatcher;", "components", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformer$BodyResolveTransformerComponents;", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformerDispatcher;Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformer$BodyResolveTransformerComponents;)V", "completer", "Lorg/jetbrains/kotlin/fir/resolve/inference/ConstraintSystemCompleter;", "getCompleter", "()Lorg/jetbrains/kotlin/fir/resolve/inference/ConstraintSystemCompleter;", "inferenceSession", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceSession;", "getInferenceSession", "()Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "addConstraintFromExpectedType", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "initialType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "resolutionMode", "Lorg/jetbrains/kotlin/fir/resolve/ResolutionMode;", "completeCall", "T", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "call", "(Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;Lorg/jetbrains/kotlin/fir/resolve/ResolutionMode;)Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "createCompletionResultsWriter", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirCallCompletionResultsWriterTransformer;", "substitutor", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "mode", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirCallCompletionResultsWriterTransformer$Mode;", "createPostponedArgumentsAnalyzer", "Lorg/jetbrains/kotlin/fir/resolve/inference/PostponedArgumentsAnalyzer;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "prepareLambdaAtomForFactoryPattern", "atom", "Lorg/jetbrains/kotlin/fir/resolve/inference/ResolvedLambdaAtom;", "runCompletionForCall", "completionMode", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionMode;", "analyzer", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionMode;Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/resolve/inference/PostponedArgumentsAnalyzer;)V", "approximateLambdaInputType", "LambdaAnalyzerImpl", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirCallCompleter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCallCompleter.kt\norg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter\n+ 2 BodyResolveUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/BodyResolveUtilsKt\n+ 3 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n1#1,380:1\n27#2,2:381\n24#3,4:383\n*S KotlinDebug\n*F\n+ 1 FirCallCompleter.kt\norg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter\n*L\n67#1:381,2\n133#1:383,4\n*E\n"})
public final class FirCallCompleter {
    @NotNull
    private final FirAbstractBodyResolveTransformerDispatcher transformer;
    @NotNull
    private final FirAbstractBodyResolveTransformer.BodyResolveTransformerComponents components;
    @NotNull
    private final FirSession session;
    @NotNull
    private final ConstraintSystemCompleter completer;

    public FirCallCompleter(@NotNull FirAbstractBodyResolveTransformerDispatcher transformer2, @NotNull FirAbstractBodyResolveTransformer.BodyResolveTransformerComponents components2) {
        Intrinsics.checkNotNullParameter((Object)transformer2, (String)"transformer");
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        this.transformer = transformer2;
        this.components = components2;
        this.session = this.components.getSession();
        this.completer = new ConstraintSystemCompleter(this.components, this.transformer.getContext());
    }

    private final FirInferenceSession getInferenceSession() {
        return this.transformer.getContext().getInferenceSession();
    }

    @NotNull
    public final ConstraintSystemCompleter getCompleter() {
        return this.completer;
    }

    @NotNull
    public final <T extends FirResolvable & FirStatement> T completeCall(@NotNull T call2, @NotNull ResolutionMode resolutionMode) {
        Object object;
        Intrinsics.checkNotNullParameter(call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)resolutionMode, (String)"resolutionMode");
        FirResolvedTypeRef typeRef = ResolveUtilsKt.typeFromCallee(this.components, call2);
        FirReference firReference = call2.getCalleeReference();
        FirNamedReferenceWithCandidate firNamedReferenceWithCandidate = firReference instanceof FirNamedReferenceWithCandidate ? (FirNamedReferenceWithCandidate)firReference : null;
        if (firNamedReferenceWithCandidate == null) {
            return call2;
        }
        FirNamedReferenceWithCandidate reference = firNamedReferenceWithCandidate;
        Candidate candidate2 = reference.getCandidate();
        ConeKotlinType initialType = ResolveUtilsKt.initialTypeOfCandidate(typeRef, candidate2);
        if (call2 instanceof FirExpression) {
            FirResolvedTypeRef resolvedTypeRef = CopyUtilsKt.resolvedTypeFromPrototype(typeRef, initialType);
            FirExpression $this$resultType$iv = (FirExpression)call2;
            boolean $i$f$setResultType = false;
            $this$resultType$iv.replaceTypeRef(resolvedTypeRef);
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.session);
            if (firLookupTrackerComponent != null) {
                FirLookupTrackerComponentKt.recordTypeResolveAsLookup(firLookupTrackerComponent, resolvedTypeRef, call2.getSource(), this.components.getContext().getFile().getSource());
            }
        }
        this.addConstraintFromExpectedType(candidate2, initialType, resolutionMode);
        ConstraintSystemCompletionMode completionMode = CompletionModeCalculatorKt.computeCompletionMode(candidate2, InferenceComponentsKt.getInferenceComponents(this.session), resolutionMode, initialType);
        PostponedArgumentsAnalyzer analyzer2 = this.createPostponedArgumentsAnalyzer(this.transformer.getResolutionContext());
        if (call2 instanceof FirFunctionCall) {
            InvocationKindTransformerKt.replaceLambdaArgumentInvocationKinds((FirFunctionCall)call2, this.session);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[completionMode.ordinal()]) {
            case 1: {
                if (this.getInferenceSession().shouldRunCompletion(call2)) {
                    this.runCompletionForCall(candidate2, completionMode, call2, initialType, analyzer2);
                    TypeSubstitutorMarker typeSubstitutorMarker = InferenceUtilsKt.buildAbstractResultingSubstitutor$default(candidate2.getSystem().asReadOnlyStorage(), TypeComponentsKt.getTypeContext(this.session), false, 2, null);
                    Intrinsics.checkNotNull((Object)typeSubstitutorMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor");
                    ConeSubstitutor finalSubstitutor = (ConeSubstitutor)typeSubstitutorMarker;
                    FirResolvable completedCall = (FirResolvable)FirTransformerUtilKt.transformSingle(call2, new FirCallCompletionResultsWriterTransformer(this.session, finalSubstitutor, this.components.getReturnTypeCalculator(), TypeComponentsKt.getTypeApproximator(this.session), this.components.getDataFlowAnalyzer(), this.components.getIntegerLiteralAndOperatorApproximationTransformer(), this.components.getContext(), null, 128, null), null);
                    this.getInferenceSession().addCompletedCall(completedCall, candidate2);
                    object = completedCall;
                    break;
                }
                this.getInferenceSession().addPartiallyResolvedCall(call2);
                object = call2;
                break;
            }
            case 2: {
                this.runCompletionForCall(candidate2, completionMode, call2, initialType, analyzer2);
                if (resolutionMode instanceof ResolutionMode.ContextDependentDelegate) {
                    if (!(this.getInferenceSession() instanceof FirDelegatedPropertyInferenceSession)) {
                        String string2 = "Failed requirement.";
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.getInferenceSession().addPartiallyResolvedCall(call2);
                }
                object = call2;
                break;
            }
            case 3: {
                throw new IllegalStateException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    private final void addConstraintFromExpectedType(Candidate candidate2, ConeKotlinType initialType, ResolutionMode resolutionMode) {
        if (!(resolutionMode instanceof ResolutionMode.WithExpectedType)) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = ((ResolutionMode.WithExpectedType)resolutionMode).getExpectedTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType expectedType = coneKotlinType;
        NewConstraintSystemImpl system2 = candidate2.getSystem();
        if (!((ResolutionMode.WithExpectedType)resolutionMode).getShouldBeStrictlyEnforced() || ((ResolutionMode.WithExpectedType)resolutionMode).getExpectedTypeMismatchIsReportedInChecker()) {
            ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(system2, initialType, expectedType, ConeExpectedTypeConstraintPosition.INSTANCE);
        } else if (((ResolutionMode.WithExpectedType)resolutionMode).getFromCast()) {
            if (FirCallCompleterKt.access$isFunctionForExpectTypeFromCastFeature(candidate2)) {
                system2.addSubtypeConstraint(initialType, expectedType, ConeExpectedTypeConstraintPosition.INSTANCE);
            }
        } else if (!CallableReferenceResolutionKt.isUnitOrFlexibleUnit(expectedType) || !((ResolutionMode.WithExpectedType)resolutionMode).getMayBeCoercionToUnitApplied()) {
            system2.addSubtypeConstraint(initialType, expectedType, ConeExpectedTypeConstraintPosition.INSTANCE);
        } else {
            if (system2.getNotFixedTypeVariables().isEmpty()) {
                return;
            }
            if (ConeBuiltinTypeUtilsKt.isUnit(expectedType)) {
                ConstraintSystemBuilderKt.addEqualityConstraintIfCompatible(system2, initialType, expectedType, ConeExpectedTypeConstraintPosition.INSTANCE);
            } else {
                ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(system2, initialType, expectedType, ConeExpectedTypeConstraintPosition.INSTANCE);
            }
        }
    }

    public final <T extends FirResolvable & FirStatement> void runCompletionForCall(@NotNull Candidate candidate2, @NotNull ConstraintSystemCompletionMode completionMode, @NotNull T call2, @NotNull ConeKotlinType initialType, @Nullable PostponedArgumentsAnalyzer analyzer2) {
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)((Object)completionMode), (String)"completionMode");
        Intrinsics.checkNotNullParameter(call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)initialType, (String)"initialType");
        PostponedArgumentsAnalyzer postponedArgumentsAnalyzer = analyzer2;
        if (postponedArgumentsAnalyzer == null) {
            postponedArgumentsAnalyzer = this.createPostponedArgumentsAnalyzer(this.transformer.getResolutionContext());
        }
        PostponedArgumentsAnalyzer analyzer3 = postponedArgumentsAnalyzer;
        ConstraintSystemCompleter.complete$default(this.completer, candidate2.getSystem().asConstraintSystemCompleterContext(), completionMode, CollectionsKt.listOf(call2), initialType, this.transformer.getResolutionContext(), false, (Function1)new Function1<PostponedResolvedAtom, Unit>(analyzer3, candidate2, completionMode){
            final /* synthetic */ PostponedArgumentsAnalyzer $analyzer;
            final /* synthetic */ Candidate $candidate;
            final /* synthetic */ ConstraintSystemCompletionMode $completionMode;
            {
                this.$analyzer = $analyzer;
                this.$candidate = $candidate;
                this.$completionMode = $completionMode;
                super(1);
            }

            public final void invoke(@NotNull PostponedResolvedAtom it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$analyzer.analyze(this.$candidate.getSystem(), it, this.$candidate, this.$completionMode);
            }
        }, 32, null);
    }

    public static /* synthetic */ void runCompletionForCall$default(FirCallCompleter firCallCompleter, Candidate candidate2, ConstraintSystemCompletionMode constraintSystemCompletionMode, FirResolvable firResolvable, ConeKotlinType coneKotlinType, PostponedArgumentsAnalyzer postponedArgumentsAnalyzer, int n, Object object) {
        if ((n & 0x10) != 0) {
            postponedArgumentsAnalyzer = null;
        }
        firCallCompleter.runCompletionForCall(candidate2, constraintSystemCompletionMode, firResolvable, coneKotlinType, postponedArgumentsAnalyzer);
    }

    public final void prepareLambdaAtomForFactoryPattern(@NotNull ResolvedLambdaAtom atom, @NotNull Candidate candidate2) {
        Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        ConeTypeVariableForLambdaReturnType returnVariable = new ConeTypeVariableForLambdaReturnType(atom.getAtom(), "_R");
        NewConstraintSystemImpl csBuilder = candidate2.getSystem().getBuilder();
        csBuilder.registerVariable(returnVariable);
        TypeSubstitutorMarker typeSubstitutorMarker = csBuilder.buildCurrentSubstitutor();
        TypeSystemInferenceExtensionContext typeSystemInferenceExtensionContext = csBuilder;
        ConeKotlinType coneKotlinType = atom.getExpectedType();
        Intrinsics.checkNotNull((Object)coneKotlinType);
        KotlinTypeMarker kotlinTypeMarker = MarkerExtensionsKt.safeSubstitute(typeSubstitutorMarker, typeSystemInferenceExtensionContext, coneKotlinType);
        Intrinsics.checkNotNull((Object)kotlinTypeMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeClassLikeType");
        ConeClassLikeType functionalType = (ConeClassLikeType)kotlinTypeMarker;
        int size = functionalType.getTypeArguments().length;
        ConeTypeProjection[] coneTypeProjectionArray = new ConeTypeProjection[size];
        ConeClassLikeLookupTag coneClassLikeLookupTag = functionalType.getLookupTag();
        for (int i = 0; i < size; ++i) {
            int n = i;
            coneTypeProjectionArray[n] = n != size - 1 ? functionalType.getTypeArguments()[n] : (ConeTypeProjection)returnVariable.getDefaultType();
        }
        ConeAttributes coneAttributes = functionalType.getAttributes();
        boolean bl = ConeTypeUtilsKt.isNullable(functionalType);
        ConeTypeProjection[] coneTypeProjectionArray2 = coneTypeProjectionArray;
        ConeClassLikeLookupTag coneClassLikeLookupTag2 = coneClassLikeLookupTag;
        ConeClassLikeTypeImpl expectedType = new ConeClassLikeTypeImpl(coneClassLikeLookupTag2, coneTypeProjectionArray2, bl, coneAttributes);
        csBuilder.addSubtypeConstraint(expectedType, functionalType, new ConeArgumentConstraintPosition(atom.getAtom()));
        atom.replaceExpectedType(expectedType, returnVariable.getDefaultType());
        atom.replaceTypeVariableForLambdaReturnType(returnVariable);
    }

    @NotNull
    public final FirCallCompletionResultsWriterTransformer createCompletionResultsWriter(@NotNull ConeSubstitutor substitutor2, @NotNull FirCallCompletionResultsWriterTransformer.Mode mode) {
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return new FirCallCompletionResultsWriterTransformer(this.session, substitutor2, this.components.getReturnTypeCalculator(), TypeComponentsKt.getTypeApproximator(this.session), this.components.getDataFlowAnalyzer(), this.components.getIntegerLiteralAndOperatorApproximationTransformer(), this.components.getContext(), mode);
    }

    public static /* synthetic */ FirCallCompletionResultsWriterTransformer createCompletionResultsWriter$default(FirCallCompleter firCallCompleter, ConeSubstitutor coneSubstitutor, FirCallCompletionResultsWriterTransformer.Mode mode, int n, Object object) {
        if ((n & 2) != 0) {
            mode = FirCallCompletionResultsWriterTransformer.Mode.Normal;
        }
        return firCallCompleter.createCompletionResultsWriter(coneSubstitutor, mode);
    }

    @NotNull
    public final PostponedArgumentsAnalyzer createPostponedArgumentsAnalyzer(@NotNull ResolutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        LambdaAnalyzerImpl lambdaAnalyzer = new LambdaAnalyzerImpl();
        return new PostponedArgumentsAnalyzer(context2, lambdaAnalyzer, InferenceComponentsKt.getInferenceComponents(this.session), this.transformer.getComponents().getCallResolver());
    }

    private final ConeKotlinType approximateLambdaInputType(ConeKotlinType $this$approximateLambdaInputType) {
        ConeKotlinType coneKotlinType = TypeComponentsKt.getTypeApproximator(this.session).approximateToSuperType($this$approximateLambdaInputType, (TypeApproximatorConfiguration)TypeApproximatorConfiguration.FinalApproximationAfterResolutionAndInference.INSTANCE);
        if (coneKotlinType == null) {
            coneKotlinType = $this$approximateLambdaInputType;
        }
        return coneKotlinType;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\\\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter$LambdaAnalyzerImpl;", "Lorg/jetbrains/kotlin/fir/resolve/inference/LambdaAnalyzer;", "(Lorg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter;)V", "analyzeAndGetLambdaReturnArguments", "Lorg/jetbrains/kotlin/fir/resolve/inference/ReturnArgumentsAnalysisResult;", "lambdaAtom", "Lorg/jetbrains/kotlin/fir/resolve/inference/ResolvedLambdaAtom;", "receiverType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "contextReceivers", "", "parameters", "expectedReturnType", "stubsForPostponedVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "Lorg/jetbrains/kotlin/types/model/StubTypeMarker;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirCallCompleter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCallCompleter.kt\norg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter$LambdaAnalyzerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirValueParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirValueParameterBuilderKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FirContextReceiverBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirContextReceiverBuilderKt\n+ 6 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 7 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 8 BodyResolveContext.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/BodyResolveContext\n*L\n1#1,380:1\n1#2:381\n100#3,4:382\n1549#4:386\n1620#4,2:387\n1622#4:397\n1864#4,3:398\n44#5,4:389\n51#6,4:393\n218#7:401\n314#8,11:402\n303#8,7:413\n325#8:420\n165#8,3:421\n326#8:424\n95#8,4:425\n303#8,7:429\n100#8,2:436\n169#8,2:438\n*S KotlinDebug\n*F\n+ 1 FirCallCompleter.kt\norg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter$LambdaAnalyzerImpl\n*L\n261#1:382,4\n291#1:386\n291#1:387,2\n291#1:397\n303#1:398,3\n292#1:389,4\n293#1:393,4\n319#1:401\n328#1:402,11\n330#1:413,7\n328#1:420\n328#1:421,3\n328#1:424\n328#1:425,4\n330#1:429,7\n328#1:436,2\n328#1:438,2\n*E\n"})
    private final class LambdaAnalyzerImpl
    implements LambdaAnalyzer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ReturnArgumentsAnalysisResult analyzeAndGetLambdaReturnArguments(@NotNull ResolvedLambdaAtom lambdaAtom, @Nullable ConeKotlinType receiverType, @NotNull List<? extends ConeKotlinType> contextReceivers, @NotNull List<? extends ConeKotlinType> parameters2, @Nullable ConeKotlinType expectedReturnType, @NotNull Map<TypeVariableMarker, ? extends StubTypeMarker> stubsForPostponedVariables, @NotNull Candidate candidate2) {
            void symbol$iv;
            void this_$iv;
            FirBuilderInferenceSession firBuilderInferenceSession;
            void condition$iv232;
            FirTypeRef firTypeRef;
            Object item$iv22;
            void $this$forEachIndexed$iv;
            Object object;
            int n;
            Object destination$iv$iv232;
            FirAnonymousFunction firAnonymousFunction;
            FirResolvedTypeRef expectedReturnTypeRef;
            FirResolvedTypeRef firResolvedTypeRef;
            FirValueParameter firValueParameter;
            Object itType;
            FirValueParameter matchedParameter;
            FirPureAbstractElement firPureAbstractElement;
            FirValueParameter firValueParameter2;
            Object currentArgument;
            boolean bl;
            boolean needItParam;
            FirAnonymousFunction lambdaArgument;
            block39: {
                Intrinsics.checkNotNullParameter((Object)lambdaAtom, (String)"lambdaAtom");
                Intrinsics.checkNotNullParameter(contextReceivers, (String)"contextReceivers");
                Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
                Intrinsics.checkNotNullParameter(stubsForPostponedVariables, (String)"stubsForPostponedVariables");
                Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
                lambdaArgument = lambdaAtom.getAtom();
                needItParam = lambdaArgument.getValueParameters().isEmpty() && parameters2.size() == 1;
                LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = candidate2.getArgumentMapping();
                if (linkedHashMap != null) {
                    for (Map.Entry entry : ((Map)linkedHashMap).entrySet()) {
                        FirAnonymousFunction currentLambdaArgument;
                        bl = false;
                        currentArgument = (FirExpression)entry.getKey();
                        FirValueParameter currentValueParameter = (FirValueParameter)entry.getValue();
                        FirLambdaArgumentExpression firLambdaArgumentExpression = currentArgument instanceof FirLambdaArgumentExpression ? (FirLambdaArgumentExpression)currentArgument : null;
                        FirExpression firExpression2 = firLambdaArgumentExpression != null ? firLambdaArgumentExpression.getExpression() : null;
                        FirAnonymousFunctionExpression firAnonymousFunctionExpression = firExpression2 instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)firExpression2 : null;
                        FirAnonymousFunction firAnonymousFunction2 = currentLambdaArgument = firAnonymousFunctionExpression != null ? firAnonymousFunctionExpression.getAnonymousFunction() : null;
                        FirValueParameter object3 = currentLambdaArgument == lambdaArgument ? currentValueParameter : null;
                        if (object3 == null) continue;
                        firValueParameter2 = object3;
                        break block39;
                    }
                    firValueParameter2 = null;
                } else {
                    firValueParameter2 = null;
                }
            }
            ClassMembersKt.setMatchingParameterFunctionType(lambdaArgument, (firPureAbstractElement = (matchedParameter = firValueParameter2)) != null && (firPureAbstractElement = firPureAbstractElement.getReturnTypeRef()) != null ? FirTypeUtilsKt.getConeType((FirTypeRef)firPureAbstractElement) : null);
            if (needItParam) {
                Name name2 = StandardNames.IMPLICIT_LAMBDA_PARAMETER_NAME;
                itType = (ConeKotlinType)CollectionsKt.single(parameters2);
                FirCallCompleter firCallCompleter = FirCallCompleter.this;
                boolean $i$f$buildValueParameter = false;
                Object $this$analyzeAndGetLambdaReturnArguments_u24lambda_u241 = currentArgument = new FirValueParameterBuilder();
                boolean bl2 = false;
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setResolvePhase(FirResolvePhase.BODY_RESOLVE);
                KtSourceElement ktSourceElement = lambdaAtom.getAtom().getSource();
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.ItLambdaParameter.INSTANCE, 0, 0, 6, null) : null);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setContainingFunctionSymbol(lambdaArgument.getSymbol());
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setModuleData(FirModuleDataKt.getModuleData(firCallCompleter.session));
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setReturnTypeRef(TypeUtilsKt.toFirResolvedTypeRef$default(firCallCompleter.approximateLambdaInputType((ConeKotlinType)itType), null, null, 3, null));
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setName(name2);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setSymbol(new FirValueParameterSymbol(name2));
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setDefaultValue(null);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setCrossinline(false);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setNoinline(false);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setVararg(false);
                firValueParameter = ((FirValueParameterBuilder)currentArgument).build();
            } else {
                firValueParameter = null;
            }
            FirValueParameter itParam = firValueParameter;
            ConeKotlinType coneKotlinType = expectedReturnType;
            if (coneKotlinType != null) {
                ConeKotlinType coneKotlinType2 = coneKotlinType;
                bl = false;
                firResolvedTypeRef = CopyUtilsKt.resolvedTypeFromPrototype(lambdaArgument.getReturnTypeRef(), coneKotlinType2);
            } else {
                firResolvedTypeRef = expectedReturnTypeRef = null;
            }
            if (receiverType == null) {
                lambdaArgument.replaceReceiverParameter(null);
            } else {
                FirReceiverParameter firReceiverParameter = lambdaArgument.getReceiverParameter();
                if (firReceiverParameter != null) {
                    FirReceiverParameter firReceiverParameter2 = firReceiverParameter;
                    FirCallCompleter bl3 = FirCallCompleter.this;
                    FirReceiverParameter $this$analyzeAndGetLambdaReturnArguments_u24lambda_u243 = firReceiverParameter2;
                    boolean bl2 = false;
                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u243.replaceTypeRef(CopyUtilsKt.resolvedTypeFromPrototype($this$analyzeAndGetLambdaReturnArguments_u24lambda_u243.getTypeRef(), bl3.approximateLambdaInputType(receiverType)));
                }
            }
            if (!((Collection)contextReceivers).isEmpty()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                itType = contextReceivers;
                firAnonymousFunction = lambdaArgument;
                boolean bl4 = false;
                void bl3 = $this$map$iv;
                destination$iv$iv232 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Iterator item$iv$iv : $this$mapTo$iv$iv) {
                    void contextReceiverType;
                    void $this$analyzeAndGetLambdaReturnArguments_u24lambda_u246_u24lambda_u245_u24lambda_u244;
                    FirContextReceiverBuilder firContextReceiverBuilder;
                    ConeKotlinType coneKotlinType3 = (ConeKotlinType)((Object)item$iv$iv);
                    Object object2 = destination$iv$iv232;
                    n = 0;
                    boolean $i$f$buildContextReceiver = false;
                    FirContextReceiverBuilder $this$analyzeAndGetLambdaReturnArguments_u24lambda_u246_u24lambda_u245 = firContextReceiverBuilder = new FirContextReceiverBuilder();
                    boolean bl32 = false;
                    boolean $i$f$buildResolvedTypeRef = false;
                    FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
                    object = firResolvedTypeRefBuilder;
                    FirContextReceiverBuilder firContextReceiverBuilder2 = $this$analyzeAndGetLambdaReturnArguments_u24lambda_u246_u24lambda_u245;
                    boolean bl42 = false;
                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u246_u24lambda_u245_u24lambda_u244.setType((ConeKotlinType)contextReceiverType);
                    firContextReceiverBuilder2.setTypeRef(firResolvedTypeRefBuilder.build());
                    object2.add(firContextReceiverBuilder.build());
                }
                firAnonymousFunction.replaceContextReceivers((List)destination$iv$iv232);
            }
            FirLookupTrackerComponent lookupTracker = FirLookupTrackerComponentKt.getLookupTracker(FirCallCompleter.this.session);
            KtSourceElement ktSourceElement = FirCallCompleter.this.components.getFile().getSource();
            Iterable $this$mapTo$iv$iv = lambdaArgument.getValueParameters();
            destination$iv$iv232 = FirCallCompleter.this;
            boolean $i$f$forEachIndexed22 = false;
            int index$iv = 0;
            for (Object item$iv22 : $this$forEachIndexed$iv) {
                FirResolvedTypeRef firResolvedTypeRef2;
                void parameter2;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                FirValueParameter $i$f$buildContextReceiver = (FirValueParameter)item$iv22;
                int index2 = n;
                boolean bl5 = false;
                ConeKotlinType newReturnType = ((FirCallCompleter)destination$iv$iv232).approximateLambdaInputType(parameters2.get(index2));
                if (parameter2.getReturnTypeRef() instanceof FirImplicitTypeRef) {
                    KtSourceElement ktSourceElement2 = parameter2.getSource();
                    firResolvedTypeRef2 = TypeUtilsKt.toFirResolvedTypeRef$default(newReturnType, ktSourceElement2 != null ? KtSourceElementKt.fakeElement$default(ktSourceElement2, KtFakeSourceElementKind.ImplicitReturnTypeOfLambdaValueParameter.INSTANCE, 0, 0, 6, null) : null, null, 2, null);
                } else {
                    firResolvedTypeRef2 = CopyUtilsKt.resolvedTypeFromPrototype(parameter2.getReturnTypeRef(), newReturnType);
                }
                FirResolvedTypeRef newReturnTypeRef = firResolvedTypeRef2;
                parameter2.replaceReturnTypeRef(newReturnTypeRef);
                FirLookupTrackerComponent firLookupTrackerComponent = lookupTracker;
                if (firLookupTrackerComponent == null) continue;
                FirLookupTrackerComponentKt.recordTypeResolveAsLookup(firLookupTrackerComponent, newReturnTypeRef, parameter2.getSource(), ktSourceElement);
            }
            lambdaArgument.replaceValueParameters(CollectionsKt.plus((Collection)lambdaArgument.getValueParameters(), (Iterable)CollectionsKt.listOfNotNull(itParam)));
            FirAnonymousFunction firAnonymousFunction3 = lambdaArgument;
            FirResolvedTypeRef firResolvedTypeRef3 = expectedReturnTypeRef;
            if (firResolvedTypeRef3 != null) {
                Object $i$f$forEachIndexed22 = destination$iv$iv232 = firResolvedTypeRef3;
                firAnonymousFunction = firAnonymousFunction3;
                boolean bl6 = false;
                FirLookupTrackerComponent firLookupTrackerComponent = lookupTracker;
                if (firLookupTrackerComponent != null) {
                    void it2;
                    FirLookupTrackerComponentKt.recordTypeResolveAsLookup(firLookupTrackerComponent, (FirTypeRef)it2, lambdaArgument.getSource(), ktSourceElement);
                }
                firAnonymousFunction3 = firAnonymousFunction;
                firTypeRef = (FirTypeRef)destination$iv$iv232;
            } else {
                firTypeRef = FirCallCompleter.this.components.getNoExpectedType();
            }
            firAnonymousFunction3.replaceReturnTypeRef(firTypeRef);
            boolean destination$iv$iv232 = !stubsForPostponedVariables.isEmpty();
            Object it2 = FirCallCompleter.this;
            boolean $i$f$runIf = false;
            if (condition$iv232 != false) {
                boolean bl7 = false;
                firBuilderInferenceSession = new FirBuilderInferenceSession(lambdaArgument, ((FirCallCompleter)it2).transformer.getResolutionContext(), stubsForPostponedVariables);
            } else {
                firBuilderInferenceSession = null;
            }
            FirBuilderInferenceSession builderInferenceSession = firBuilderInferenceSession;
            BodyResolveContext condition$iv232 = FirCallCompleter.this.transformer.getContext();
            it2 = lambdaArgument.getSymbol();
            FirCallCompleter firCallCompleter = FirCallCompleter.this;
            boolean $i$f$withAnonymousFunctionTowerDataContext = false;
            item$iv22 = this_$iv;
            FirTowerDataContext newContext$iv$iv = this_$iv.getSpecialTowerDataContexts().getAnonymousFunctionContext((FirAnonymousFunctionSymbol)symbol$iv);
            boolean $i$f$withTemporaryRegularContext = false;
            if (newContext$iv$iv == null) {
                boolean bl8 = false;
                if (builderInferenceSession != null) {
                    BodyResolveContext this_$iv2 = firCallCompleter.transformer.getContext();
                    boolean $i$f$withInferenceSession = false;
                    FirInferenceSession oldSession$iv = this_$iv2.getInferenceSession();
                    this_$iv2.setInferenceSession(builderInferenceSession);
                    try {
                        boolean bl5 = false;
                        object = (FirAnonymousFunction)FirTransformerUtilKt.transformSingle((FirElement)lambdaArgument, firCallCompleter.transformer, new ResolutionMode.LambdaResolution(expectedReturnTypeRef));
                    }
                    finally {
                        this_$iv2.setInferenceSession(oldSession$iv);
                    }
                } else {
                    FirAnonymousFunction cfr_ignored_0 = (FirAnonymousFunction)FirTransformerUtilKt.transformSingle((FirElement)lambdaArgument, firCallCompleter.transformer, new ResolutionMode.LambdaResolution(expectedReturnTypeRef));
                }
            } else {
                void this_$iv$iv;
                void this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$withTowerDataModeCleanup = false;
                FirTowerDataMode initialMode$iv$iv$iv = this_$iv$iv$iv.getTowerDataMode();
                try {
                    FirAnonymousFunction firAnonymousFunction4;
                    void this_$iv$iv$iv2;
                    boolean bl9 = false;
                    void var34_82 = this_$iv$iv;
                    FirRegularTowerDataContexts newContexts$iv$iv$iv = this_$iv$iv.getRegularTowerDataContexts().replaceAndSetActiveRegularContext(newContext$iv$iv);
                    boolean $i$f$withTowerDataContexts = false;
                    FirRegularTowerDataContexts old$iv$iv$iv = this_$iv$iv$iv2.getRegularTowerDataContexts();
                    this_$iv$iv$iv2.setRegularTowerDataContexts(newContexts$iv$iv$iv);
                    try {
                        Object object3;
                        boolean bl6 = false;
                        if (builderInferenceSession != null) {
                            BodyResolveContext this_$iv3 = firCallCompleter.transformer.getContext();
                            boolean $i$f$withInferenceSession = false;
                            FirInferenceSession oldSession$iv = this_$iv3.getInferenceSession();
                            this_$iv3.setInferenceSession(builderInferenceSession);
                            try {
                                boolean bl7 = false;
                                object = (FirAnonymousFunction)FirTransformerUtilKt.transformSingle((FirElement)lambdaArgument, firCallCompleter.transformer, new ResolutionMode.LambdaResolution(expectedReturnTypeRef));
                            }
                            finally {
                                this_$iv3.setInferenceSession(oldSession$iv);
                            }
                            object3 = object;
                        } else {
                            object3 = (FirAnonymousFunction)FirTransformerUtilKt.transformSingle((FirElement)lambdaArgument, firCallCompleter.transformer, new ResolutionMode.LambdaResolution(expectedReturnTypeRef));
                        }
                        firAnonymousFunction4 = object3;
                    }
                    finally {
                        this_$iv$iv$iv2.setRegularTowerDataContexts(old$iv$iv$iv);
                    }
                    FirAnonymousFunction firAnonymousFunction5 = firAnonymousFunction4;
                }
                finally {
                    this_$iv$iv$iv.setTowerDataMode(initialMode$iv$iv$iv);
                }
            }
            FirCallCompleter.this.transformer.getContext().dropContextForAnonymousFunction(lambdaArgument);
            Collection<FirExpression> returnArguments = FirCallCompleter.this.components.getDataFlowAnalyzer().returnExpressionsOfAnonymousFunction(lambdaArgument);
            return new ReturnArgumentsAnalysisResult(returnArguments, builderInferenceSession);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstraintSystemCompletionMode.values().length];
            try {
                nArray[ConstraintSystemCompletionMode.FULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintSystemCompletionMode.PARTIAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintSystemCompletionMode.UNTIL_FIRST_LAMBDA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

