/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLookupTagWithFixedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousInitializerSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUninitializedEnumChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "lazyDelegation", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getLazyDelegation", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isEnumEntryInitializer", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUninitializedEnumChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUninitializedEnumChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUninitializedEnumChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,251:1\n86#2:252\n37#3:253\n1747#4,3:254\n800#4,11:257\n800#4,11:268\n800#4,11:279\n800#4,11:293\n533#4,6:308\n533#4,6:314\n300#5,3:290\n303#5,4:304\n*S KotlinDebug\n*F\n+ 1 FirUninitializedEnumChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUninitializedEnumChecker\n*L\n80#1:252\n80#1:253\n95#1:254,3\n101#1:257,11\n102#1:268,11\n103#1:279,11\n105#1:293,11\n108#1:308,6\n125#1:314,6\n104#1:290,3\n104#1:304,4\n*E\n"})
public final class FirUninitializedEnumChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirUninitializedEnumChecker INSTANCE = new FirUninitializedEnumChecker();

    private FirUninitializedEnumChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirAnonymousFunction lazyDelegation;
        FirDeclaration firDeclaration;
        List<FirDeclaration> accessedContext;
        Map enumEntriesInitBlocks;
        List enumEntries2;
        List enumInitBlocks;
        List enumMemberProperties;
        FirBasedSymbol calleeSymbol;
        KtSourceElement source;
        block33: {
            FirDeclaration firDeclaration2;
            FirDeclaration it;
            FirDeclaration element$iv;
            ListIterator<FirDeclaration> iterator$iv;
            boolean $i$f$lastOrNull;
            List<FirDeclaration> $this$lastOrNull$iv;
            block32: {
                void $this$filterIsInstanceTo$iv$iv;
                void $this$filterIsInstanceTo$iv$iv2;
                void $this$filterIsInstanceTo$iv$iv3;
                boolean isInsideCorrespondingEnum;
                Object it2;
                FirRegularClassSymbol enumClassSymbol;
                block31: {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                    KtSourceElement ktSourceElement = expression2.getSource();
                    if (ktSourceElement == null) {
                        return;
                    }
                    source = ktSourceElement;
                    if (source.getKind() instanceof KtFakeSourceElementKind) {
                        return;
                    }
                    FirBasedSymbol firBasedSymbol = FirReferenceUtilsKt.toResolvedBaseSymbol$default(expression2.getCalleeReference(), false, 1, null);
                    if (firBasedSymbol == null) {
                        return;
                    }
                    calleeSymbol = firBasedSymbol;
                    FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(calleeSymbol, context2.getSession());
                    FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
                    if (firRegularClassSymbol == null) {
                        return;
                    }
                    enumClassSymbol = firRegularClassSymbol;
                    FirClassSymbol $this$isEnumClass$iv = enumClassSymbol;
                    boolean $i$f$isEnumClass = false;
                    ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
                    boolean $i$f$isEnumClass2 = false;
                    if (!($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS)) {
                        return;
                    }
                    Iterable $this$any$iv = context2.getContainingDeclarations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            it2 = (FirDeclaration)element$iv2;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(FirHelpersKt.getContainingClassSymbol((FirDeclaration)it2, context2.getSession()), (Object)enumClassSymbol)) continue;
                            bl = true;
                            break block31;
                        }
                        bl = isInsideCorrespondingEnum = false;
                    }
                }
                if (!isInsideCorrespondingEnum) {
                    return;
                }
                List<FirBasedSymbol<?>> declarationSymbols = enumClassSymbol.getDeclarationSymbols();
                Iterable $this$filterIsInstance$iv = declarationSymbols;
                boolean $i$f$filterIsInstance = false;
                it2 = $this$filterIsInstance$iv;
                Iterable destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
                    if (!(element$iv$iv instanceof FirPropertySymbol)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                enumMemberProperties = (List)destination$iv$iv;
                Iterable $this$filterIsInstance$iv2 = declarationSymbols;
                boolean $i$f$filterIsInstance2 = false;
                destination$iv$iv = $this$filterIsInstance$iv2;
                Iterable destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo2 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                    if (!(element$iv$iv instanceof FirAnonymousInitializerSymbol)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                enumInitBlocks = (List)destination$iv$iv2;
                Iterable $this$filterIsInstance$iv3 = declarationSymbols;
                boolean $i$f$filterIsInstance3 = false;
                destination$iv$iv2 = $this$filterIsInstance$iv3;
                Object destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterIsInstanceTo3 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof FirEnumEntrySymbol)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                List $this$flatAssociateBy$iv = enumEntries2 = (List)destination$iv$iv3;
                boolean $i$f$flatAssociateBy = false;
                Object $this$flatAssociateBy_u24lambda_u246$iv = destination$iv$iv3 = MapsKt.createMapBuilder();
                boolean bl = false;
                for (Object value$iv : $this$flatAssociateBy$iv) {
                    List list2;
                    List list3;
                    FirEnumEntrySymbol it3 = (FirEnumEntrySymbol)value$iv;
                    boolean bl3 = false;
                    Object object = it3.getInitializerObjectSymbol();
                    if (object != null && (object = ((FirClassSymbol)object).getDeclarationSymbols()) != null) {
                        void $this$filterIsInstanceTo$iv$iv4;
                        Iterable $this$filterIsInstance$iv4 = (Iterable)object;
                        boolean $i$f$filterIsInstance4 = false;
                        Iterable iterable = $this$filterIsInstance$iv4;
                        Collection destination$iv$iv4 = new ArrayList();
                        boolean $i$f$filterIsInstanceTo4 = false;
                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv4) {
                            if (!(element$iv$iv instanceof FirAnonymousInitializerSymbol)) continue;
                            destination$iv$iv4.add(element$iv$iv);
                        }
                        list3 = (List)destination$iv$iv4;
                    } else {
                        list3 = list2 = null;
                    }
                    if (list3 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    for (Object key$iv : (Collection)list2) {
                        $this$flatAssociateBy_u24lambda_u246$iv.put(key$iv, value$iv);
                    }
                }
                enumEntriesInitBlocks = MapsKt.build((Map)destination$iv$iv3);
                $this$lastOrNull$iv = context2.getContainingDeclarations();
                $i$f$lastOrNull = false;
                iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    it = element$iv = iterator$iv.previous();
                    boolean bl4 = false;
                    boolean bl5 = Intrinsics.areEqual(FirHelpersKt.getContainingClassSymbol(it, context2.getSession()), (Object)enumClassSymbol) || enumEntriesInitBlocks.containsKey(it.getSymbol());
                    if (!bl5) continue;
                    firDeclaration2 = element$iv;
                    break block32;
                }
                firDeclaration2 = null;
            }
            FirDeclaration $i$f$flatAssociateBy = firDeclaration2;
            if ($i$f$flatAssociateBy == null || ($this$lastOrNull$iv = $i$f$flatAssociateBy.getSymbol()) == null) {
                return;
            }
            accessedContext = $this$lastOrNull$iv;
            $this$lastOrNull$iv = context2.getContainingDeclarations();
            $i$f$lastOrNull = false;
            iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!(!(it instanceof FirAnonymousFunction) || ((FirAnonymousFunction)it).getInvocationKind() == null)) continue;
                firDeclaration = element$iv;
                break block33;
            }
            firDeclaration = null;
        }
        FirDeclaration containingDeclarationForAccess = firDeclaration;
        if (CollectionsKt.contains((Iterable)enumMemberProperties, accessedContext) && (lazyDelegation = this.getLazyDelegation((FirPropertySymbol)((Object)accessedContext))) != null && Intrinsics.areEqual((Object)lazyDelegation, (Object)containingDeclarationForAccess)) {
            return;
        }
        if (CollectionsKt.contains((Iterable)enumEntries2, accessedContext)) {
            FirDeclaration firDeclaration3 = containingDeclarationForAccess;
            if (!(firDeclaration3 != null ? this.isEnumEntryInitializer(firDeclaration3, context2.getSession()) : false)) {
                return;
            }
        }
        if (CollectionsKt.contains((Iterable)enumEntries2, (Object)calleeSymbol)) {
            FirEnumEntrySymbol calleeEnumEntry = (FirEnumEntrySymbol)calleeSymbol;
            List<FirDeclaration> list4 = accessedContext;
            if (CollectionsKt.contains((Iterable)enumMemberProperties, list4) ? true : CollectionsKt.contains((Iterable)enumInitBlocks, list4)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNINITIALIZED_ENUM_ENTRY(), (Object)calleeEnumEntry, (DiagnosticContext)context2, null, 16, null);
            } else if (CollectionsKt.contains((Iterable)enumEntries2, list4)) {
                FirUninitializedEnumChecker.check$reportIllegalAccessInEnumEntry(enumEntries2, calleeEnumEntry, reporter, source, context2, (FirEnumEntrySymbol)((Object)accessedContext));
            } else if (enumEntriesInitBlocks.containsKey(list4)) {
                FirEnumEntrySymbol entrySymbol = (FirEnumEntrySymbol)MapsKt.getValue((Map)enumEntriesInitBlocks, (Object)((FirAnonymousInitializerSymbol)((Object)accessedContext)));
                if (Intrinsics.areEqual((Object)entrySymbol, (Object)calleeSymbol)) {
                    return;
                }
                FirUninitializedEnumChecker.check$reportIllegalAccessInEnumEntry(enumEntries2, calleeEnumEntry, reporter, source, context2, entrySymbol);
            }
        }
    }

    private final FirAnonymousFunction getLazyDelegation(FirPropertySymbol $this$lazyDelegation) {
        FirLazyDeclarationResolverKt.lazyResolveToPhase($this$lazyDelegation, FirResolvePhase.BODY_RESOLVE);
        FirProperty property = (FirProperty)$this$lazyDelegation.getFir();
        if (property.getDelegate() == null || !(property.getDelegate() instanceof FirFunctionCall)) {
            return null;
        }
        FirExpression firExpression2 = property.getDelegate();
        Intrinsics.checkNotNull((Object)firExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirFunctionCall");
        FirFunctionCall delegateCall = (FirFunctionCall)firExpression2;
        FirNamedFunctionSymbol firNamedFunctionSymbol = FirReferenceUtilsKt.toResolvedFunctionSymbol$default(delegateCall.getCalleeReference(), false, 1, null);
        if (firNamedFunctionSymbol == null) {
            return null;
        }
        FirNamedFunctionSymbol calleeSymbol = firNamedFunctionSymbol;
        if (!Intrinsics.areEqual((Object)calleeSymbol.getCallableId().asSingleFqName().asString(), (Object)"kotlin.lazy")) {
            return null;
        }
        Object object = CollectionsKt.singleOrNull(delegateCall.getArgumentList().getArguments());
        FirLambdaArgumentExpression firLambdaArgumentExpression = object instanceof FirLambdaArgumentExpression ? (FirLambdaArgumentExpression)object : null;
        if (firLambdaArgumentExpression == null) {
            return null;
        }
        FirLambdaArgumentExpression lazyCallArgument = firLambdaArgumentExpression;
        object = lazyCallArgument.getExpression();
        FirAnonymousFunctionExpression firAnonymousFunctionExpression = object instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)object : null;
        return firAnonymousFunctionExpression != null ? firAnonymousFunctionExpression.getAnonymousFunction() : null;
    }

    private final boolean isEnumEntryInitializer(FirDeclaration $this$isEnumEntryInitializer, FirSession session) {
        FirClassLikeSymbol firClassLikeSymbol;
        FirDeclaration firDeclaration = $this$isEnumEntryInitializer;
        if (firDeclaration instanceof FirConstructor) {
            if (!((FirConstructor)$this$isEnumEntryInitializer).isPrimary()) {
                return false;
            }
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.getContainingClassForStaticMemberAttr((FirCallableDeclaration)$this$isEnumEntryInitializer);
            ConeClassLookupTagWithFixedSymbol coneClassLookupTagWithFixedSymbol = coneClassLikeLookupTag instanceof ConeClassLookupTagWithFixedSymbol ? (ConeClassLookupTagWithFixedSymbol)coneClassLikeLookupTag : null;
            firClassLikeSymbol = coneClassLookupTagWithFixedSymbol != null ? coneClassLookupTagWithFixedSymbol.getSymbol() : null;
        } else if (firDeclaration instanceof FirAnonymousInitializer) {
            ConeClassLikeType coneClassLikeType = ((FirAnonymousInitializer)$this$isEnumEntryInitializer).getDispatchReceiverType();
            firClassLikeSymbol = coneClassLikeType != null ? TypeUtilsKt.toSymbol(coneClassLikeType, session) : null;
        } else {
            firClassLikeSymbol = null;
        }
        if (firClassLikeSymbol == null) {
            return false;
        }
        FirClassLikeSymbol containingClassSymbol = firClassLikeSymbol;
        return FirHelpersKt.getClassKind(containingClassSymbol) == ClassKind.ENUM_ENTRY;
    }

    private static final void check$reportIllegalAccessInEnumEntry(List<FirEnumEntrySymbol> enumEntries2, FirEnumEntrySymbol calleeEnumEntry, DiagnosticReporter $reporter, KtSourceElement source, CheckerContext $context, FirEnumEntrySymbol correspondingEnumEntry) {
        FirEnumEntrySymbol precedingEntry = null;
        for (FirEnumEntrySymbol it : enumEntries2) {
            if (!Intrinsics.areEqual((Object)it, (Object)calleeEnumEntry) && !Intrinsics.areEqual((Object)it, (Object)correspondingEnumEntry)) continue;
            precedingEntry = it;
            break;
        }
        if (Intrinsics.areEqual(precedingEntry, (Object)correspondingEnumEntry)) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNINITIALIZED_ENUM_ENTRY(), (Object)calleeEnumEntry, (DiagnosticContext)$context, null, 16, null);
        }
    }
}

