/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeLocalVariableNoTypeOrInitializer;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aF\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u0005H\u0000\u001a:\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a \u0010\u001f\u001a\u0004\u0018\u00010 *\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010!\u001a\u00020\"H\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001a\u0010\t\u001a\u00020\u0005*\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0018\u0010\r\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\u00a8\u0006#"}, d2={"deprecationWarning", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "getDeprecationWarning", "(Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;)Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "hasAnyAccessorImplementation", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getHasAnyAccessorImplementation", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)Z", "hasImplementation", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "getHasImplementation", "(Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;)Z", "hasSetterAccessorImplementation", "getHasSetterAccessorImplementation", "checkPropertyInitializer", "", "containingClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "property", "modifierList", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "isDefinitelyAssignedInConstructor", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reachable", "reportMustBeInitialized", "propertySource", "Lorg/jetbrains/kotlin/KtSourceElement;", "getEffectiveModality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirTopLevelPropertiesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTopLevelPropertiesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTopLevelPropertiesCheckerKt\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n54#2:219\n12#2:221\n45#2:222\n45#2:223\n12#2:224\n69#2:226\n34#3:220\n1#4:225\n*S KotlinDebug\n*F\n+ 1 FirTopLevelPropertiesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTopLevelPropertiesCheckerKt\n*L\n62#1:219\n64#1:221\n127#1:222\n139#1:223\n162#1:224\n206#1:226\n62#1:220\n*E\n"})
public final class FirTopLevelPropertiesCheckerKt {
    public static final void checkPropertyInitializer(@Nullable FirClass containingClass, @NotNull FirProperty property, @Nullable FirModifierList modifierList2, boolean isDefinitelyAssignedInConstructor, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2, boolean reachable) {
        boolean isAbstract;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirClass firClass = containingClass;
        if (firClass != null) {
            FirClass $this$isInterface$iv = firClass;
            boolean $i$f$isInterface = false;
            ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
            boolean $i$f$isInterface2 = false;
            bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
        } else {
            bl = false;
        }
        boolean inInterface = bl;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"ABSTRACT_KEYWORD");
        boolean hasAbstractModifier = FirKeywordUtilsKt.contains(modifierList2, ktModifierKeywordToken);
        FirMemberDeclaration $this$isAbstract$iv = property;
        boolean $i$f$isAbstract = false;
        boolean bl2 = isAbstract = $this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT || hasAbstractModifier;
        if (isAbstract) {
            FirTypeRef returnTypeRef = property.getReturnTypeRef();
            if (property.getInitializer() == null && property.getDelegate() == null && returnTypeRef instanceof FirErrorTypeRef && ((FirErrorTypeRef)returnTypeRef).getDiagnostic() instanceof ConeLocalVariableNoTypeOrInitializer) {
                KtSourceElement ktSourceElement = property.getSource();
                if (ktSourceElement != null) {
                    KtSourceElement it = ktSourceElement;
                    boolean bl3 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getPROPERTY_WITH_NO_TYPE_NO_INITIALIZER(), (DiagnosticContext)context2, null, 8, null);
                }
            }
            return;
        }
        boolean backingFieldRequired = DeclarationAttributesKt.getHasBackingField(property);
        if (inInterface && backingFieldRequired && FirTopLevelPropertiesCheckerKt.getHasAnyAccessorImplementation(property)) {
            KtSourceElement ktSourceElement = property.getSource();
            if (ktSourceElement != null) {
                KtSourceElement it = ktSourceElement;
                boolean bl4 = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getBACKING_FIELD_IN_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        boolean isExpect = DeclarationUtilsKt.isEffectivelyExpect(property, containingClass, context2);
        if (property.getInitializer() != null) {
            Object object = property.getInitializer();
            if (object != null && (object = ((FirExpression)object).getSource()) != null) {
                Object it = object;
                boolean bl5 = false;
                if (inInterface) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getPROPERTY_INITIALIZER_IN_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
                } else if (isExpect) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getEXPECTED_PROPERTY_INITIALIZER(), (DiagnosticContext)context2, null, 8, null);
                } else if (!backingFieldRequired) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getPROPERTY_INITIALIZER_NO_BACKING_FIELD(), (DiagnosticContext)context2, null, 8, null);
                } else if (property.getReceiverParameter() != null) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getEXTENSION_PROPERTY_WITH_BACKING_FIELD(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        } else if (property.getDelegate() != null) {
            Object object = property.getDelegate();
            if (object != null && (object = ((FirExpression)object).getSource()) != null) {
                Object it = object;
                boolean bl6 = false;
                if (inInterface) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getDELEGATED_PROPERTY_IN_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
                } else if (isExpect) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getEXPECTED_DELEGATED_PROPERTY(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        } else {
            boolean $i$f$isLateInit;
            FirMemberDeclaration $this$isLateInit$iv;
            boolean isCorrectlyInitialized;
            KtSourceElement ktSourceElement = property.getSource();
            if (ktSourceElement == null) {
                return;
            }
            KtSourceElement propertySource = ktSourceElement;
            boolean isExternal = DeclarationUtilsKt.isEffectivelyExternal(property, containingClass, context2);
            boolean bl7 = isCorrectlyInitialized = property.getInitializer() != null || isDefinitelyAssignedInConstructor && !FirTopLevelPropertiesCheckerKt.getHasSetterAccessorImplementation(property) && FirTopLevelPropertiesCheckerKt.getEffectiveModality(property, containingClass, context2.getLanguageVersionSettings()) != Modality.OPEN;
            if (backingFieldRequired && !inInterface) {
                $this$isLateInit$iv = property;
                $i$f$isLateInit = false;
                if (!($this$isLateInit$iv.getStatus().isLateInit() || isExpect || isCorrectlyInitialized || isExternal || DeclarationAttributesKt.getHasExplicitBackingField(property))) {
                    if (property.getReceiverParameter() != null && !FirTopLevelPropertiesCheckerKt.getHasAnyAccessorImplementation(property)) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)propertySource, FirErrors.INSTANCE.getEXTENSION_PROPERTY_MUST_HAVE_ACCESSORS_OR_BE_ABSTRACT(), (DiagnosticContext)context2, null, 8, null);
                    } else if (reachable) {
                        FirTopLevelPropertiesCheckerKt.reportMustBeInitialized(property, isDefinitelyAssignedInConstructor, containingClass, propertySource, reporter, context2);
                    }
                }
            }
            $this$isLateInit$iv = property;
            $i$f$isLateInit = false;
            if ($this$isLateInit$iv.getStatus().isLateInit()) {
                if (isExpect) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)propertySource, FirErrors.INSTANCE.getEXPECTED_LATEINIT_PROPERTY(), (DiagnosticContext)context2, null, 8, null);
                }
                if (backingFieldRequired && !inInterface && isCorrectlyInitialized && context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.EnableDfaWarningsInK2)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)propertySource, FirErrors.INSTANCE.getUNNECESSARY_LATEINIT(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        }
    }

    public static /* synthetic */ void checkPropertyInitializer$default(FirClass firClass, FirProperty firProperty, FirModifierList firModifierList, boolean bl, DiagnosticReporter diagnosticReporter, CheckerContext checkerContext, boolean bl2, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        FirTopLevelPropertiesCheckerKt.checkPropertyInitializer(firClass, firProperty, firModifierList, bl, diagnosticReporter, checkerContext, bl2);
    }

    private static final void reportMustBeInitialized(FirProperty property, boolean isDefinitelyAssignedInConstructor, FirClass containingClass, KtSourceElement propertySource, DiagnosticReporter reporter, CheckerContext context2) {
        KtDiagnosticFactory0 ktDiagnosticFactory0;
        boolean bl;
        boolean isOpenValDeferredInitDeprecationWarning;
        FirMemberDeclaration $this$isAbstract$iv = property;
        boolean $i$f$isAbstract = false;
        if (!(!($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT))) {
            boolean $i$a$-check-FirTopLevelPropertiesCheckerKt$reportMustBeInitialized$22 = false;
            String $i$a$-check-FirTopLevelPropertiesCheckerKt$reportMustBeInitialized$22 = "reportMustBeInitialized isn't called for abstract properties";
            throw new IllegalStateException($i$a$-check-FirTopLevelPropertiesCheckerKt$reportMustBeInitialized$22.toString());
        }
        boolean suggestMakingItFinal = containingClass != null && !FirTopLevelPropertiesCheckerKt.getHasSetterAccessorImplementation(property) && FirTopLevelPropertiesCheckerKt.getEffectiveModality(property, containingClass, context2.getLanguageVersionSettings()) != Modality.FINAL && isDefinitelyAssignedInConstructor;
        boolean suggestMakingItAbstract = containingClass != null && !FirTopLevelPropertiesCheckerKt.getHasAnyAccessorImplementation(property);
        boolean bl2 = isOpenValDeferredInitDeprecationWarning = !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitOpenValDeferredInitialization) && FirTopLevelPropertiesCheckerKt.getEffectiveModality(property, containingClass, context2.getLanguageVersionSettings()) == Modality.OPEN && property.isVal() && isDefinitelyAssignedInConstructor;
        if (isOpenValDeferredInitDeprecationWarning && !suggestMakingItFinal && suggestMakingItAbstract) {
            throw new IllegalStateException("Not reachable case. Every \"open val + deferred init\" case that could be made `abstract`, also could be made `final`".toString());
        }
        boolean isMissedMustBeInitializedDeprecationWarning = !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor) && containingClass != null && org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.primaryConstructorIfAny(containingClass, context2.getSession()) == null && isDefinitelyAssignedInConstructor;
        KtDiagnosticFactory0 factory2 = suggestMakingItFinal && suggestMakingItAbstract ? FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_FINAL_OR_ABSTRACT() : (suggestMakingItFinal ? FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_FINAL() : (suggestMakingItAbstract ? FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_ABSTRACT() : FirErrors.INSTANCE.getMUST_BE_INITIALIZED()));
        AbstractKtSourceElement abstractKtSourceElement = propertySource;
        boolean bl3 = bl = isMissedMustBeInitializedDeprecationWarning || isOpenValDeferredInitDeprecationWarning;
        if (bl) {
            ktDiagnosticFactory0 = FirTopLevelPropertiesCheckerKt.getDeprecationWarning(factory2);
        } else if (!bl) {
            ktDiagnosticFactory0 = factory2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory0, (DiagnosticContext)context2, null, 8, null);
    }

    private static final KtDiagnosticFactory0 getDeprecationWarning(KtDiagnosticFactory0 $this$deprecationWarning) {
        KtDiagnosticFactory0 ktDiagnosticFactory0;
        KtDiagnosticFactory0 ktDiagnosticFactory02 = $this$deprecationWarning;
        if (Intrinsics.areEqual((Object)ktDiagnosticFactory02, (Object)FirErrors.INSTANCE.getMUST_BE_INITIALIZED())) {
            ktDiagnosticFactory0 = FirErrors.INSTANCE.getMUST_BE_INITIALIZED_WARNING();
        } else if (Intrinsics.areEqual((Object)ktDiagnosticFactory02, (Object)FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_ABSTRACT())) {
            ktDiagnosticFactory0 = FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_ABSTRACT_WARNING();
        } else if (Intrinsics.areEqual((Object)ktDiagnosticFactory02, (Object)FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_FINAL())) {
            ktDiagnosticFactory0 = FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_FINAL_WARNING();
        } else if (Intrinsics.areEqual((Object)ktDiagnosticFactory02, (Object)FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_FINAL_OR_ABSTRACT())) {
            ktDiagnosticFactory0 = FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_FINAL_OR_ABSTRACT_WARNING();
        } else {
            throw new IllegalStateException("Only MUST_BE_INITIALIZED is supported".toString());
        }
        return ktDiagnosticFactory0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getHasImplementation(FirPropertyAccessor $this$hasImplementation) {
        if ($this$hasImplementation instanceof FirDefaultPropertyAccessor) return false;
        FirPropertyAccessor firPropertyAccessor = $this$hasImplementation;
        if (firPropertyAccessor == null) return false;
        FirPropertyAccessor $this$hasBody$iv = firPropertyAccessor;
        boolean $i$f$getHasBody = false;
        if ($this$hasBody$iv.getBody() == null) return false;
        return true;
    }

    private static final boolean getHasSetterAccessorImplementation(FirProperty $this$hasSetterAccessorImplementation) {
        return FirTopLevelPropertiesCheckerKt.getHasImplementation($this$hasSetterAccessorImplementation.getSetter());
    }

    private static final boolean getHasAnyAccessorImplementation(FirProperty $this$hasAnyAccessorImplementation) {
        return FirTopLevelPropertiesCheckerKt.getHasImplementation($this$hasAnyAccessorImplementation.getGetter()) || FirTopLevelPropertiesCheckerKt.getHasImplementation($this$hasAnyAccessorImplementation.getSetter());
    }

    private static final Modality getEffectiveModality(FirProperty $this$getEffectiveModality, FirClass containingClass, LanguageVersionSettings languageVersionSettings2) {
        Modality modality;
        boolean bl;
        FirElement firElement;
        boolean bl2 = languageVersionSettings2.supportsFeature(LanguageFeature.TakeIntoAccountEffectivelyFinalInMustBeInitializedCheck) && $this$getEffectiveModality.getStatus().getModality() == Modality.OPEN && ((firElement = containingClass) != null && (firElement = ((FirClass)firElement).getStatus()) != null ? firElement.getModality() : null) == Modality.FINAL ? true : (bl = false);
        if (bl) {
            modality = Modality.FINAL;
        } else if (!bl) {
            modality = $this$getEffectiveModality.getStatus().getModality();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return modality;
    }
}

