/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectConsistencyChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExpectConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpectConsistencyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectConsistencyChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,46:1\n34#2:47\n21#2:48\n67#2:49\n*S KotlinDebug\n*F\n+ 1 FirExpectConsistencyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectConsistencyChecker\n*L\n28#1:47\n37#1:48\n41#1:49\n*E\n"})
public final class FirExpectConsistencyChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExpectConsistencyChecker INSTANCE = new FirExpectConsistencyChecker();

    private FirExpectConsistencyChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                boolean isTopLevel = context2.getContainingDeclarations().size() == 1;
                boolean isInsideClass = CollectionsKt.lastOrNull(context2.getContainingDeclarations()) instanceof FirClass;
                if (!(declaration instanceof FirMemberDeclaration) || !isTopLevel && !isInsideClass) break block8;
                FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)declaration;
                boolean $i$f$isExpect = false;
                if ($this$isExpect$iv.getStatus().isExpect() && !(declaration instanceof FirConstructor)) break block9;
            }
            return;
        }
        KtSourceElement ktSourceElement = declaration.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (source.getKind() instanceof KtFakeSourceElementKind) {
            return;
        }
        FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$getVisibility = false;
        if (Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECTED_PRIVATE_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
        }
        if (declaration instanceof FirSimpleFunction) {
            FirFunction $this$hasBody$iv = (FirFunction)declaration;
            boolean $i$f$getHasBody = false;
            if ($this$hasBody$iv.getBody() != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECTED_DECLARATION_WITH_BODY(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }
}

