/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitUnitTypeRef;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0018\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a-\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010\u0018H\u0082\b\u001a\u001e\u0010\u0019\u001a\u00020\u0001*\u00020\u001a2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u001e\u0010\u001b\u001a\u00020\u0001*\u00020\u001a2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0014\u0010\u001c\u001a\u00020\u0001*\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 \u001a\u0010\u0010!\u001a\u0004\u0018\u00010\"*\u0006\u0012\u0002\b\u00030#\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0019\u0010\u0005\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\u0001*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\"\u001c\u0010\t\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\b\"\u0015\u0010\f\u001a\u00020\u0001*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\"\u001c\u0010\f\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0010\u00a8\u0006$"}, d2={"canHaveOpenMembers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getCanHaveOpenMembers", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Z", "hasExplicitReturnType", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getHasExplicitReturnType", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "isExtensionMember", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)Z", "isLocalMember", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "isInsideExpectClass", "containingClass", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "isInsideExternalClass", "isInsideSpecificClass", "predicate", "Lkotlin/Function1;", "isEffectivelyExpect", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "isEffectivelyExternal", "isEffectivelyFinal", "needsMultiFieldValueClassFlattening", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "primaryConstructorSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\ndeclarationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 declarationUtils.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationUtilsKt\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,117:1\n34#1:118\n35#1:120\n34#1:124\n35#1:126\n34#2:119\n42#2:125\n17#2,2:133\n57#2:135\n17#2,2:137\n34#2:139\n42#2:140\n42#2:141\n1747#3,3:121\n1747#3,3:127\n1747#3,3:130\n37#4:136\n80#5:142\n100#5:143\n*S KotlinDebug\n*F\n+ 1 declarationUtils.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationUtilsKt\n*L\n21#1:118\n21#1:120\n25#1:124\n25#1:126\n21#1:119\n25#1:125\n39#1:133,2\n41#1:135\n45#1:137,2\n52#1:139\n61#1:140\n71#1:141\n21#1:121,3\n25#1:127,3\n35#1:130,3\n41#1:136\n88#1:142\n89#1:143\n*E\n"})
public final class DeclarationUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInsideExpectClass(@NotNull FirClass containingClass, @NotNull CheckerContext context2) {
        boolean bl;
        boolean $i$f$isExpect;
        FirMemberDeclaration $this$isExpect$iv;
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        boolean $i$f$isInsideSpecificClass = false;
        FirClass klass = containingClass;
        boolean bl2 = false;
        if (klass instanceof FirRegularClass) {
            $this$isExpect$iv = klass;
            $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return true;
            }
        }
        boolean bl3 = false;
        if (bl3) return true;
        Iterable $this$any$iv$iv = CollectionsKt.asReversed(context2.getContainingDeclarations());
        boolean $i$f$any = false;
        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv$iv = iterator2.next();
            FirDeclaration it$iv = (FirDeclaration)element$iv$iv;
            boolean bl4 = false;
            if (it$iv instanceof FirRegularClass) {
                klass = (FirClass)it$iv;
                bl2 = false;
                if (klass instanceof FirRegularClass) {
                    $this$isExpect$iv = klass;
                    $i$f$isExpect = false;
                    if ($this$isExpect$iv.getStatus().isExpect()) {
                        return true;
                    }
                }
                boolean bl5 = false;
                if (bl5) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInsideExternalClass(@NotNull FirClass containingClass, @NotNull CheckerContext context2) {
        boolean bl;
        boolean $i$f$isExternal;
        FirMemberDeclaration $this$isExternal$iv;
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        boolean $i$f$isInsideSpecificClass = false;
        FirClass klass = containingClass;
        boolean bl2 = false;
        if (klass instanceof FirRegularClass) {
            $this$isExternal$iv = klass;
            $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal()) {
                return true;
            }
        }
        boolean bl3 = false;
        if (bl3) return true;
        Iterable $this$any$iv$iv = CollectionsKt.asReversed(context2.getContainingDeclarations());
        boolean $i$f$any = false;
        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv$iv = iterator2.next();
            FirDeclaration it$iv = (FirDeclaration)element$iv$iv;
            boolean bl4 = false;
            if (it$iv instanceof FirRegularClass) {
                klass = (FirClass)it$iv;
                bl2 = false;
                if (klass instanceof FirRegularClass) {
                    $this$isExternal$iv = klass;
                    $i$f$isExternal = false;
                    if ($this$isExternal$iv.getStatus().isExternal()) {
                        return true;
                    }
                }
                boolean bl5 = false;
                if (bl5) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInsideSpecificClass(FirClass containingClass, CheckerContext context2, Function1<? super FirClass, Boolean> predicate) {
        boolean bl;
        boolean $i$f$isInsideSpecificClass = false;
        if ((Boolean)predicate.invoke((Object)containingClass) != false) return true;
        Iterable $this$any$iv = CollectionsKt.asReversed(context2.getContainingDeclarations());
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl2 = false;
            if (it instanceof FirRegularClass && ((Boolean)predicate.invoke((Object)it)).booleanValue()) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static final boolean isEffectivelyFinal(@NotNull FirMemberDeclaration $this$isEffectivelyFinal, @NotNull CheckerContext context2) {
        Modality modality$iv;
        Object modality$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyFinal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirMemberDeclaration $this$isFinal$iv = $this$isEffectivelyFinal;
        boolean $i$f$isFinal = false;
        Modality modality = $this$isFinal$iv.getStatus().getModality();
        if (modality == null ? true : (modality$iv2 = modality) == Modality.FINAL) {
            return true;
        }
        modality$iv2 = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        FirRegularClass firRegularClass = modality$iv2 instanceof FirRegularClass ? (FirRegularClass)modality$iv2 : null;
        if (firRegularClass == null) {
            return true;
        }
        FirRegularClass containingClass = firRegularClass;
        FirClass $this$isEnumClass$iv = containingClass;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        boolean bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
        if (bl) {
            return false;
        }
        FirMemberDeclaration $this$isFinal$iv2 = containingClass;
        boolean $i$f$isFinal2 = false;
        Modality modality2 = $this$isFinal$iv2.getStatus().getModality();
        return modality2 == null ? true : (modality$iv = modality2) == Modality.FINAL;
    }

    public static final boolean isEffectivelyExpect(@NotNull FirMemberDeclaration $this$isEffectivelyExpect, @Nullable FirClass containingClass, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyExpect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirMemberDeclaration $this$isExpect$iv = $this$isEffectivelyExpect;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            return true;
        }
        return containingClass != null && DeclarationUtilsKt.isInsideExpectClass(containingClass, context2);
    }

    public static final boolean isEffectivelyExternal(@NotNull FirMemberDeclaration $this$isEffectivelyExternal, @Nullable FirClass containingClass, @NotNull CheckerContext context2) {
        block9: {
            block10: {
                boolean bl;
                boolean bl2;
                boolean $i$f$isExternal;
                Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyExternal, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                FirMemberDeclaration $this$isExternal$iv = $this$isEffectivelyExternal;
                boolean $i$f$isExternal2 = false;
                if ($this$isExternal$iv.getStatus().isExternal()) {
                    return true;
                }
                if ($this$isEffectivelyExternal instanceof FirPropertyAccessor) {
                    Object object = CollectionsKt.last(context2.getContainingDeclarations());
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirProperty");
                    FirProperty property = (FirProperty)object;
                    return DeclarationUtilsKt.isEffectivelyExternal(property, containingClass, context2);
                }
                if (!($this$isEffectivelyExternal instanceof FirProperty)) break block9;
                FirPropertyAccessor firPropertyAccessor = ((FirProperty)$this$isEffectivelyExternal).getGetter();
                if (firPropertyAccessor != null) {
                    FirMemberDeclaration $this$isExternal$iv2 = firPropertyAccessor;
                    $i$f$isExternal = false;
                    bl2 = $this$isExternal$iv2.getStatus().isExternal();
                } else {
                    bl2 = false;
                }
                if (!bl2) break block9;
                if (!((FirProperty)$this$isEffectivelyExternal).isVar()) break block10;
                FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)$this$isEffectivelyExternal).getSetter();
                if (firPropertyAccessor2 != null) {
                    FirMemberDeclaration $this$isExternal$iv3 = firPropertyAccessor2;
                    $i$f$isExternal = false;
                    bl = $this$isExternal$iv3.getStatus().isExternal();
                } else {
                    bl = false;
                }
                if (!bl) break block9;
            }
            return true;
        }
        return containingClass != null && DeclarationUtilsKt.isInsideExternalClass(containingClass, context2);
    }

    public static final boolean getCanHaveOpenMembers(@NotNull FirClass $this$canHaveOpenMembers) {
        Intrinsics.checkNotNullParameter((Object)$this$canHaveOpenMembers, (String)"<this>");
        return FirHelpersKt.modality($this$canHaveOpenMembers) != Modality.FINAL || $this$canHaveOpenMembers.getClassKind() == ClassKind.ENUM_CLASS;
    }

    public static final boolean isLocalMember(@NotNull FirDeclaration $this$isLocalMember) {
        Intrinsics.checkNotNullParameter((Object)$this$isLocalMember, (String)"<this>");
        return DeclarationUtilsKt.isLocalMember($this$isLocalMember.getSymbol());
    }

    public static final boolean isLocalMember(@NotNull FirBasedSymbol<?> $this$isLocalMember) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isLocalMember, (String)"<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$isLocalMember;
        if (firBasedSymbol instanceof FirPropertySymbol) {
            bl = ((FirPropertySymbol)$this$isLocalMember).isLocal();
        } else if (firBasedSymbol instanceof FirRegularClassSymbol) {
            FirClassLikeSymbol $this$isLocal$iv = (FirClassLikeSymbol)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            bl = $this$isLocal$iv.getClassId().isLocal();
        } else if (firBasedSymbol instanceof FirNamedFunctionSymbol) {
            FirNamedFunctionSymbol $this$isLocal$iv = (FirNamedFunctionSymbol)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            bl = Intrinsics.areEqual((Object)$this$isLocal$iv.getRawStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isExtensionMember(@NotNull FirCallableDeclaration $this$isExtensionMember) {
        Intrinsics.checkNotNullParameter((Object)$this$isExtensionMember, (String)"<this>");
        return DeclarationUtilsKt.isExtensionMember($this$isExtensionMember.getSymbol());
    }

    public static final boolean isExtensionMember(@NotNull FirCallableSymbol<?> $this$isExtensionMember) {
        Intrinsics.checkNotNullParameter($this$isExtensionMember, (String)"<this>");
        return $this$isExtensionMember.getResolvedReceiverTypeRef() != null && $this$isExtensionMember.getDispatchReceiverType() != null;
    }

    @Nullable
    public static final FirConstructorSymbol primaryConstructorSymbol(@NotNull FirClassSymbol<?> $this$primaryConstructorSymbol) {
        Intrinsics.checkNotNullParameter($this$primaryConstructorSymbol, (String)"<this>");
        for (FirBasedSymbol<?> declarationSymbol : $this$primaryConstructorSymbol.getDeclarationSymbols()) {
            if (!(declarationSymbol instanceof FirConstructorSymbol) || !((FirConstructorSymbol)declarationSymbol).isPrimary()) continue;
            return (FirConstructorSymbol)declarationSymbol;
        }
        return null;
    }

    public static final boolean needsMultiFieldValueClassFlattening(@NotNull FirTypeRef $this$needsMultiFieldValueClassFlattening, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$needsMultiFieldValueClassFlattening, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ConeInferenceContext $this$needsMultiFieldValueClassFlattening_u24lambda_u243 = TypeComponentsKt.getTypeContext(session);
        boolean bl = false;
        return $this$needsMultiFieldValueClassFlattening_u24lambda_u243.isMultiFieldValueClass($this$needsMultiFieldValueClassFlattening_u24lambda_u243.typeConstructor(FirTypeUtilsKt.getConeType($this$needsMultiFieldValueClassFlattening))) && !ConeTypeUtilsKt.isNullable(FirTypeUtilsKt.getConeType($this$needsMultiFieldValueClassFlattening));
    }

    public static final boolean getHasExplicitReturnType(@NotNull FirCallableSymbol<?> $this$hasExplicitReturnType) {
        Intrinsics.checkNotNullParameter($this$hasExplicitReturnType, (String)"<this>");
        FirResolvedTypeRef returnTypeRef = $this$hasExplicitReturnType.getResolvedReturnTypeRef();
        return returnTypeRef.getDelegatedTypeRef() != null || returnTypeRef instanceof FirImplicitUnitTypeRef;
    }
}

