/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeObjCNameOverridesChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001 B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u0018*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u0018*\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u001f*\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "exactName", "Lorg/jetbrains/kotlin/name/Name;", "objCNameClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "swiftNameName", "validChars", "", "", "validFirstChars", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkDeclaration", "checkObjCName", "objCName", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameChecker$ObjCName;", "getObjCName", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "getObjCNames", "", "ObjCName", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeObjCNameChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeObjCNameChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n37#2:137\n1855#3,2:138\n1855#3,2:141\n1#4:140\n*S KotlinDebug\n*F\n+ 1 FirNativeObjCNameChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameChecker\n*L\n57#1:137\n62#1:138,2\n130#1:141,2\n*E\n"})
public final class FirNativeObjCNameChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirNativeObjCNameChecker INSTANCE = new FirNativeObjCNameChecker();
    @NotNull
    private static final ClassId objCNameClassId;
    @NotNull
    private static final Name swiftNameName;
    @NotNull
    private static final Name exactName;
    @NotNull
    private static final Set<Character> validFirstChars;
    @NotNull
    private static final Set<Character> validChars;

    private FirNativeObjCNameChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkDeclaration(declaration, context2, reporter);
        if (declaration instanceof FirCallableDeclaration && (declaration instanceof FirSimpleFunction || declaration instanceof FirProperty)) {
            FirClass containingClass;
            Object object = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
            FirClass firClass = containingClass = object instanceof FirClass ? (FirClass)object : null;
            if (containingClass != null) {
                FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(containingClass, context2);
                FirNativeObjCNameOverridesChecker.INSTANCE.check(firTypeScope, ((FirCallableDeclaration)declaration).getSymbol(), declaration, context2, reporter);
            }
        }
    }

    private final void checkDeclaration(FirDeclaration declaration, CheckerContext context2, DiagnosticReporter reporter) {
        if (declaration instanceof FirValueParameter) {
            return;
        }
        List objCNames = CollectionsKt.filterNotNull((Iterable)this.getObjCNames(declaration.getSymbol(), context2.getSession()));
        if (objCNames.isEmpty()) {
            return;
        }
        if (declaration instanceof FirCallableDeclaration) {
            FirMemberDeclaration $this$isOverride$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isOverride = false;
            if ($this$isOverride$iv.getStatus().isOverride()) {
                for (ObjCName objCName : objCNames) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)objCName.getAnnotation().getSource(), FirNativeErrors.INSTANCE.getINAPPLICABLE_OBJC_NAME(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        }
        Iterable $this$forEach$iv = objCNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObjCName it = (ObjCName)element$iv;
            boolean bl = false;
            INSTANCE.checkObjCName(it, declaration, context2, reporter);
        }
    }

    private final void checkObjCName(ObjCName objCName, FirDeclaration declaration, CheckerContext context2, DiagnosticReporter reporter) {
        Object invalidSwiftNameChars;
        Set invalidChars;
        Object object;
        Object invalidNameChars;
        Object object2;
        Set invalidFirstChars;
        KtSourceElement annotationSource;
        block16: {
            block15: {
                Object object3;
                Object object4;
                Object[] invalidNameFirstChar;
                Object object5;
                Object object6;
                Object[] objectArray;
                Object[] objectArray2;
                annotationSource = objCName.getAnnotation().getSource();
                Iterator<Map.Entry<Name, FirExpression>> iterator2 = objCName.getAnnotation().getArgumentMapping().getMapping().entrySet().iterator();
                while (iterator2.hasNext()) {
                    FirExpression argument2 = iterator2.next().getValue();
                    if (argument2 instanceof FirConstExpression) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)argument2.getSource(), FirNativeErrors.INSTANCE.getNON_LITERAL_OBJC_NAME_ARG(), (DiagnosticContext)context2, null, 8, null);
                }
                if (objCName.getName() == null && objCName.getSwiftName() == null) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getINVALID_OBJC_NAME(), (DiagnosticContext)context2, null, 8, null);
                }
                if ((objectArray2 = objCName.getName()) != null && (objectArray2 = StringsKt.firstOrNull((CharSequence)((CharSequence)objectArray2))) != null) {
                    objectArray = objectArray2;
                    object6 = validFirstChars;
                    char p0 = objectArray.charValue();
                    boolean bl = false;
                    object5 = !object6.contains(Character.valueOf(p0)) ? objectArray : null;
                } else {
                    object5 = invalidNameFirstChar = null;
                }
                if ((object4 = objCName.getSwiftName()) != null && (object4 = StringsKt.firstOrNull((CharSequence)((CharSequence)object4))) != null) {
                    object6 = object4;
                    Set<Character> p0 = validFirstChars;
                    char p02 = ((Character)object6).charValue();
                    boolean bl = false;
                    object3 = !p0.contains(Character.valueOf(p02)) ? object6 : null;
                } else {
                    object3 = null;
                }
                Object invalidSwiftNameFirstChar = object3;
                objectArray = new Character[]{invalidNameFirstChar, invalidSwiftNameFirstChar};
                invalidFirstChars = SetsKt.setOfNotNull((Object[])objectArray);
                if (!((Collection)invalidFirstChars).isEmpty()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getINVALID_OBJC_NAME_FIRST_CHAR(), (Object)CollectionsKt.joinToString$default((Iterable)invalidFirstChars, (CharSequence)"", null, null, (int)0, null, null, (int)62, null), (DiagnosticContext)context2, null, 16, null);
                }
                String string2 = objCName.getName();
                if (string2 != null ? ((CharSequence)string2).length() == 0 : false) break block15;
                String string3 = objCName.getSwiftName();
                boolean bl = string3 != null ? ((CharSequence)string3).length() == 0 : false;
                if (!bl) break block16;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getEMPTY_OBJC_NAME(), (DiagnosticContext)context2, null, 8, null);
        }
        if ((object2 = objCName.getName()) == null || (object2 = StringsKt.toSet((CharSequence)((CharSequence)object2))) == null || (object2 = CollectionsKt.subtract((Iterable)((Iterable)object2), (Iterable)validChars)) == null) {
            object2 = invalidNameChars = SetsKt.emptySet();
        }
        if ((object = objCName.getSwiftName()) == null || (object = StringsKt.toSet((CharSequence)((CharSequence)object))) == null || (object = CollectionsKt.subtract((Iterable)((Iterable)object), (Iterable)validChars)) == null) {
            object = SetsKt.emptySet();
        }
        if (!((Collection)(invalidChars = SetsKt.plus((Set)invalidNameChars, (Iterable)((Iterable)(invalidSwiftNameChars = object))))).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getINVALID_OBJC_NAME_CHARS(), (Object)CollectionsKt.joinToString$default((Iterable)invalidFirstChars, (CharSequence)"", null, null, (int)0, null, null, (int)62, null), (DiagnosticContext)context2, null, 16, null);
        }
        if (objCName.getExact() && (!(declaration instanceof FirClass) || ((FirClass)declaration).getClassKind() == ClassKind.ENUM_ENTRY)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getINAPPLICABLE_EXACT_OBJC_NAME(), (DiagnosticContext)context2, null, 8, null);
        }
        if (objCName.getExact() && objCName.getName() == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getMISSING_EXACT_OBJC_NAME(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final ObjCName getObjCName(FirAnnotationContainer $this$getObjCName, FirSession session) {
        ObjCName objCName;
        FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId($this$getObjCName, objCNameClassId, session);
        if (firAnnotation != null) {
            FirAnnotation p0 = firAnnotation;
            boolean bl = false;
            objCName = new ObjCName(p0);
        } else {
            objCName = null;
        }
        return objCName;
    }

    private final ObjCName getObjCName(FirBasedSymbol<?> $this$getObjCName, FirSession session) {
        ObjCName objCName;
        FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId($this$getObjCName, objCNameClassId, session);
        if (firAnnotation != null) {
            FirAnnotation p0 = firAnnotation;
            boolean bl = false;
            objCName = new ObjCName(p0);
        } else {
            objCName = null;
        }
        return objCName;
    }

    @NotNull
    public final List<ObjCName> getObjCNames(@NotNull FirBasedSymbol<?> $this$getObjCNames, @NotNull FirSession session) {
        List list2;
        Intrinsics.checkNotNullParameter($this$getObjCNames, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if ($this$getObjCNames instanceof FirFunctionSymbol) {
            List list3;
            List $this$getObjCNames_u24lambda_u245 = list3 = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$getObjCNames_u24lambda_u245.add(INSTANCE.getObjCName($this$getObjCNames, session));
            FirResolvedTypeRef firResolvedTypeRef = ((FirFunctionSymbol)$this$getObjCNames).getResolvedReceiverTypeRef();
            $this$getObjCNames_u24lambda_u245.add(firResolvedTypeRef != null ? INSTANCE.getObjCName(firResolvedTypeRef, session) : null);
            FirReceiverParameter firReceiverParameter = ((FirFunctionSymbol)$this$getObjCNames).getReceiverParameter();
            $this$getObjCNames_u24lambda_u245.add(firReceiverParameter != null ? INSTANCE.getObjCName(firReceiverParameter, session) : null);
            Iterable $this$forEach$iv = ((FirFunctionSymbol)$this$getObjCNames).getValueParameterSymbols();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                boolean bl2 = false;
                $this$getObjCNames_u24lambda_u245.add(INSTANCE.getObjCName(it, session));
            }
            list2 = CollectionsKt.build((List)list3);
        } else {
            list2 = CollectionsKt.listOf((Object)this.getObjCName($this$getObjCNames, session));
        }
        return list2;
    }

    static {
        ClassId classId = ClassId.topLevel(new FqName("kotlin.native.ObjCName"));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(...)");
        objCNameClassId = classId;
        Name name2 = Name.identifier("swiftName");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        swiftNameName = name2;
        Name name3 = Name.identifier("exact");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        exactName = name3;
        validFirstChars = SetsKt.plus((Set)SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)CollectionsKt.toSet((Iterable)((Iterable)new CharRange('a', 'z')))), (Object)Character.valueOf('_'));
        validChars = SetsKt.plus(validFirstChars, (Iterable)CollectionsKt.toSet((Iterable)((Iterable)new CharRange('0', '9'))));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameChecker$ObjCName;", "", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;)V", "getAnnotation", "()Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "exact", "", "getExact", "()Z", "name", "", "getName", "()Ljava/lang/String;", "swiftName", "getSwiftName", "equals", "other", "hashCode", "", "checkers.native"})
    public static final class ObjCName {
        @NotNull
        private final FirAnnotation annotation;
        @Nullable
        private final String name;
        @Nullable
        private final String swiftName;
        private final boolean exact;

        public ObjCName(@NotNull FirAnnotation annotation2) {
            Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
            this.annotation = annotation2;
            this.name = FirAnnotationUtilsKt.getStringArgument(this.annotation, StandardNames.NAME);
            this.swiftName = FirAnnotationUtilsKt.getStringArgument(this.annotation, swiftNameName);
            Boolean bl = FirAnnotationUtilsKt.getBooleanArgument(this.annotation, exactName);
            this.exact = bl != null ? bl : false;
        }

        @NotNull
        public final FirAnnotation getAnnotation() {
            return this.annotation;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getSwiftName() {
            return this.swiftName;
        }

        public final boolean getExact() {
            return this.exact;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof ObjCName && Intrinsics.areEqual((Object)this.name, (Object)((ObjCName)other).name) && Intrinsics.areEqual((Object)this.swiftName, (Object)((ObjCName)other).swiftName) && this.exact == ((ObjCName)other).exact;
        }

        public int hashCode() {
            String string2 = this.name;
            int result2 = string2 != null ? string2.hashCode() : 0;
            String string3 = this.swiftName;
            result2 = 31 * result2 + (string3 != null ? string3.hashCode() : 0);
            result2 = 31 * result2 + Boolean.hashCode(this.exact);
            return result2;
        }
    }
}

