/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.ModulePath;
import org.jetbrains.kotlin.resolve.ModuleStructureOracle;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCompatibility;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolver;
import org.jetbrains.kotlin.resolve.multiplatform.ModuleFilterUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 K2\u00020\u0001:\u0002JKB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J@\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00190\u001dj\u0002`\u001fH\u0002J@\u0010 \u001a\u00020\r2\u001e\u0010!\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170$0\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J(\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020)H\u0002J\\\u0010*\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u00172\"\u0010,\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170$0\"j\u0002`-2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010/\u001a\u000200H\u0002JR\u00101\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u00172\"\u0010,\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170$0\"j\u0002`-2\f\u00102\u001a\b\u0012\u0004\u0012\u0002030$2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J0\u00104\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010/\u001a\u000200H\u0002J \u00105\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u00172\u0006\u00106\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J&\u00107\u001a\b\u0012\u0002\b\u0003\u0018\u0001082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J\"\u0010@\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u00172\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010A\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J\u0012\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J,\u0010D\u001a\u00020\u0019*\u00020\u00172\u001e\u0010!\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170$0\"H\u0002J\f\u0010E\u001a\u00020\u0019*\u00020\u0017H\u0002J\f\u0010F\u001a\u00020\u0019*\u00020\u0017H\u0002J\"\u0010G\u001a\u00020\r*\u0002002\u0006\u0010&\u001a\u00020\u00172\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00170IH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "moduleStructureOracle", "Lorg/jetbrains/kotlin/resolve/ModuleStructureOracle;", "argumentExtractors", "", "Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker$ActualAnnotationArgumentExtractor;", "(Lorg/jetbrains/kotlin/resolve/ModuleStructureOracle;Ljava/lang/Iterable;)V", "getArgumentExtractors", "()Ljava/lang/Iterable;", "getModuleStructureOracle", "()Lorg/jetbrains/kotlin/resolve/ModuleStructureOracle;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkActualDeclarationHasExpected", "reportOn", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "checkActualModifier", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "moduleVisibilityFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlin/resolve/multiplatform/ModuleFilter;", "checkAmbiguousExpects", "compatibility", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualCompatibility;", "", "checkAnnotationConstructors", "expected", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "actual", "Lcom/intellij/psi/PsiElement;", "checkExpectedDeclarationHasAtLeastOneActual", "expectDescriptor", "actuals", "Lorg/jetbrains/kotlin/resolve/checkers/ActualsMap;", "module", "expectActualTracker", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "checkExpectedDeclarationHasAtMostOneActual", "modulePaths", "Lorg/jetbrains/kotlin/resolve/ModulePath;", "checkExpectedDeclarationHasProperActuals", "checkIfExpectHasDefaultArgumentsAndActualizedWithTypealias", "actualDeclaration", "getActualAnnotationParameterValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "actualParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isUnderlyingPropertyOfInlineClass", "reportMissingActualModifier", "requireActualModifier", "sourceFile", "Ljava/io/File;", "hasNoActualWithDiagnostic", "isActualOrSomeContainerIsActual", "isExplicitActualDeclaration", "reportExpectActual", "actualMembers", "Lkotlin/sequences/Sequence;", "ActualAnnotationArgumentExtractor", "Companion", "frontend"})
@SourceDebugExtension(value={"SMAP\nExpectedActualDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectedActualDeclarationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,440:1\n1360#2:441\n1446#2,5:442\n1549#2:447\n1620#2,3:448\n1855#2,2:451\n1271#2,2:460\n1285#2,2:462\n766#2:464\n857#2,2:465\n1288#2:467\n1549#2:469\n1620#2,3:470\n1045#2:473\n1726#2,3:475\n800#2,11:480\n766#2:491\n857#2:492\n1747#2,3:493\n858#2:496\n1446#2,5:497\n1726#2,3:502\n819#2:508\n847#2,2:509\n1726#2,3:511\n223#2,2:515\n478#3,7:453\n215#4:468\n216#4:474\n187#4,3:505\n1313#5,2:478\n603#5:514\n1#6:517\n*S KotlinDebug\n*F\n+ 1 ExpectedActualDeclarationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker\n*L\n69#1:441\n69#1:442,5\n96#1:447\n96#1:448,3\n98#1:451,2\n142#1:460,2\n142#1:462,2\n143#1:464\n143#1:465,2\n142#1:467\n152#1:469\n152#1:470,3\n153#1:473\n178#1:475,3\n219#1:480,11\n222#1:491\n222#1:492\n222#1:493,3\n222#1:496\n238#1:497,5\n238#1:502,3\n310#1:508\n310#1:509,2\n323#1:511,3\n394#1:515,2\n119#1:453,7\n146#1:468\n146#1:474\n274#1:505,3\n191#1:478,2\n358#1:514\n*E\n"})
public final class ExpectedActualDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModuleStructureOracle moduleStructureOracle;
    @NotNull
    private final Iterable<ActualAnnotationArgumentExtractor> argumentExtractors;

    public ExpectedActualDeclarationChecker(@NotNull ModuleStructureOracle moduleStructureOracle, @NotNull Iterable<? extends ActualAnnotationArgumentExtractor> argumentExtractors) {
        Intrinsics.checkNotNullParameter((Object)moduleStructureOracle, (String)"moduleStructureOracle");
        Intrinsics.checkNotNullParameter(argumentExtractors, (String)"argumentExtractors");
        this.moduleStructureOracle = moduleStructureOracle;
        this.argumentExtractors = argumentExtractors;
    }

    @NotNull
    public final ModuleStructureOracle getModuleStructureOracle() {
        return this.moduleStructureOracle;
    }

    @NotNull
    public final Iterable<ActualAnnotationArgumentExtractor> getArgumentExtractors() {
        return this.argumentExtractors;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        boolean checkActualModifier;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiPlatformProjects)) {
            return;
        }
        if (context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getExpectActualLinker()).booleanValue()) {
            return;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return;
        }
        if (!(declaration instanceof KtNamedDeclaration)) {
            return;
        }
        if (!(descriptor2 instanceof MemberDescriptor) || DescriptorUtils.isEnumEntry(descriptor2)) {
            return;
        }
        boolean bl = checkActualModifier = context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getMultiPlatformDoNotCheckActual()) == false;
        if (((MemberDescriptor)descriptor2).isExpect()) {
            this.checkExpectedDeclarationHasProperActuals((KtNamedDeclaration)declaration, (MemberDescriptor)descriptor2, context2.getTrace(), checkActualModifier, context2.getExpectActualTracker());
        }
        if (this.isActualOrSomeContainerIsActual((MemberDescriptor)descriptor2)) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.moduleStructureOracle.findAllDependsOnPaths(DescriptorUtilsKt.getModule(descriptor2));
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ModulePath it = (ModulePath)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = it.getNodes();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            HashSet allDependsOnModules = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            this.checkActualDeclarationHasExpected((KtNamedDeclaration)declaration, (MemberDescriptor)descriptor2, checkActualModifier, context2.getTrace(), (Function1<? super ModuleDescriptor, Boolean>)((Function1)new Function1<ModuleDescriptor, Boolean>((HashSet<ModuleDescriptor>)allDependsOnModules){
                final /* synthetic */ HashSet<ModuleDescriptor> $allDependsOnModules;
                {
                    this.$allDependsOnModules = $allDependsOnModules;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ModuleDescriptor it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$allDependsOnModules.contains(it);
                }
            }));
        }
    }

    private final boolean isActualOrSomeContainerIsActual(MemberDescriptor $this$isActualOrSomeContainerIsActual) {
        MemberDescriptor declaration = $this$isActualOrSomeContainerIsActual;
        while (!declaration.isActual()) {
            DeclarationDescriptor declarationDescriptor = declaration.getContainingDeclaration();
            if ((declarationDescriptor instanceof MemberDescriptor ? (MemberDescriptor)declarationDescriptor : null) == null) {
                return false;
            }
            declaration = declaration;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExpectedDeclarationHasProperActuals(KtNamedDeclaration reportOn, MemberDescriptor descriptor2, BindingTrace trace, boolean checkActualModifier, ExpectActualTracker expectActualTracker) {
        void $this$mapTo$iv$iv;
        List<ModulePath> allActualizationPaths = this.moduleStructureOracle.findAllReversedDependsOnPaths(DescriptorUtilsKt.getModule(descriptor2));
        Iterable $this$map$iv = allActualizationPaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ModulePath modulePath = (ModulePath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((ModuleDescriptor)CollectionsKt.last(it.getNodes()));
        }
        Set allLeafModules = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = allLeafModules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map actuals;
            ModuleDescriptor leafModule = (ModuleDescriptor)element$iv;
            boolean bl = false;
            if (ExpectedActualResolver.findActualForExpected$default(ExpectedActualResolver.INSTANCE, descriptor2, leafModule, null, 4, null) == null) continue;
            this.checkExpectedDeclarationHasAtLeastOneActual(reportOn, descriptor2, actuals, trace, leafModule, checkActualModifier, expectActualTracker);
            this.checkExpectedDeclarationHasAtMostOneActual(reportOn, descriptor2, actuals, allActualizationPaths, trace);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExpectedDeclarationHasAtMostOneActual(KtNamedDeclaration reportOn, MemberDescriptor expectDescriptor, Map<ExpectActualCompatibility<MemberDescriptor>, ? extends List<? extends MemberDescriptor>> actuals, List<ModulePath> modulePaths, BindingTrace trace) {
        Map actualsByModulePath;
        Iterable path;
        Object object;
        void $this$filterKeys$iv;
        Map<ExpectActualCompatibility<MemberDescriptor>, ? extends List<? extends MemberDescriptor>> map = actuals;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            ExpectActualCompatibility compatibility = (ExpectActualCompatibility)entry$iv.getKey();
            boolean bl = false;
            if (!Companion.isCompatibleOrWeakCompatible$frontend(compatibility)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        List atLeastWeaklyCompatibleActuals = CollectionsKt.flatten((Iterable)((Map)result$iv).values());
        if (atLeastWeaklyCompatibleActuals.size() <= 1) {
            return;
        }
        Iterable $this$associateWith$iv = modulePaths;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv;
            ModulePath modulePath = (ModulePath)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv2;
            boolean bl = false;
            Iterable $this$filter$iv = atLeastWeaklyCompatibleActuals;
            boolean $i$f$filter = false;
            object = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                MemberDescriptor it = (MemberDescriptor)element$iv$iv2;
                boolean bl2 = false;
                if (!((ModulePath)((Object)path)).getNodes().contains(DescriptorUtilsKt.getModule(it))) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List list2 = (List)destination$iv$iv;
            map2.put(t, list2);
        }
        Map $this$forEach$iv = actualsByModulePath = (Map)result$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$sortedBy$iv;
            Collection<ModuleDescriptor> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            List actualsInPath = (List)entry.getValue();
            if (actualsInPath.size() <= 1) continue;
            path = actualsInPath;
            MemberDescriptor memberDescriptor = expectDescriptor;
            PsiElement psiElement = reportOn;
            DiagnosticFactory2<KtNamedDeclaration, DeclarationDescriptor, Collection<ModuleDescriptor>> diagnosticFactory2 = Errors.AMBIGUOUS_ACTUALS;
            object = trace;
            boolean $i$f$map = false;
            void $i$f$filterTo = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MemberDescriptor memberDescriptor2 = (MemberDescriptor)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(DescriptorUtilsKt.getModule((DeclarationDescriptor)it));
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            boolean $i$f$sortedBy = false;
            object.report(diagnosticFactory2.on((KtNamedDeclaration)psiElement, memberDescriptor, CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ModuleDescriptor it = (ModuleDescriptor)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName().asString());
                    it = (ModuleDescriptor)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName().asString())));
                }
            })));
        }
    }

    private final void checkExpectedDeclarationHasAtLeastOneActual(KtNamedDeclaration reportOn, MemberDescriptor expectDescriptor, Map<ExpectActualCompatibility<MemberDescriptor>, ? extends List<? extends MemberDescriptor>> actuals, BindingTrace trace, ModuleDescriptor module2, boolean checkActualModifier, ExpectActualTracker expectActualTracker) {
        if (!(expectDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor)) {
            return;
        }
        if (Companion.allStrongIncompatibilities(actuals) && OptionalAnnotationUtil.isOptionalAnnotationClass(expectDescriptor)) {
            return;
        }
        if (Companion.allStrongIncompatibilities(actuals) || !actuals.containsKey(ExpectActualCompatibility.Compatible.INSTANCE) && this.hasNoActualWithDiagnostic(expectDescriptor, actuals)) {
            boolean $this$all$iv2;
            block9: {
                boolean bl;
                Iterable $this$all$iv2 = actuals.keySet();
                boolean $i$f$all = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv2) {
                        ExpectActualCompatibility it = (ExpectActualCompatibility)element$iv;
                        boolean bl2 = false;
                        if (it instanceof ExpectActualCompatibility.Incompatible) continue;
                        bl = false;
                        break block9;
                    }
                    bl = $this$all$iv2 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv2) {
                String $i$f$all = "Assertion failed";
                throw new AssertionError((Object)$i$f$all);
            }
            Intrinsics.checkNotNull(actuals, (String)"null cannot be cast to non-null type kotlin.collections.Map<org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCompatibility.Incompatible<org.jetbrains.kotlin.descriptors.MemberDescriptor>, kotlin.collections.Collection<org.jetbrains.kotlin.descriptors.MemberDescriptor>>");
            Map<ExpectActualCompatibility<MemberDescriptor>, ? extends List<? extends MemberDescriptor>> incompatibility = actuals;
            trace.report(Errors.NO_ACTUAL_FOR_EXPECT.on((KtNamedDeclaration)((PsiElement)reportOn), expectDescriptor, module2, incompatibility));
            return;
        }
        Sequence actualMembers2 = SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence(actuals), (Function1)checkExpectedDeclarationHasAtLeastOneActual.actualMembers.1.INSTANCE), (Function1)checkExpectedDeclarationHasAtLeastOneActual.actualMembers.2.INSTANCE);
        if (checkActualModifier) {
            Sequence $this$forEach$iv = actualMembers2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MemberDescriptor it = (MemberDescriptor)element$iv;
                boolean bl = false;
                this.reportMissingActualModifier(it, null, trace);
            }
        }
        this.reportExpectActual(expectActualTracker, expectDescriptor, (Sequence<? extends MemberDescriptor>)actualMembers2);
    }

    private final void reportMissingActualModifier(MemberDescriptor actual, KtNamedDeclaration reportOn, BindingTrace trace) {
        if (actual.isActual()) {
            return;
        }
        KtNamedDeclaration ktNamedDeclaration = reportOn;
        if (ktNamedDeclaration == null) {
            SourceElement sourceElement = actual.getSource();
            KotlinSourceElement kotlinSourceElement = sourceElement instanceof KotlinSourceElement ? (KotlinSourceElement)sourceElement : null;
            KtElement ktElement = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
            ktNamedDeclaration = ktElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)ktElement : null;
            if (ktNamedDeclaration == null) {
                return;
            }
        }
        KtNamedDeclaration reportOn2 = ktNamedDeclaration;
        if (this.requireActualModifier(actual)) {
            trace.report(Errors.ACTUAL_MISSING.on((KtNamedDeclaration)((PsiElement)reportOn2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkIfExpectHasDefaultArgumentsAndActualizedWithTypealias(MemberDescriptor expectDescriptor, KtNamedDeclaration actualDeclaration, BindingTrace trace) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        if (!(expectDescriptor instanceof ClassDescriptor) || !(actualDeclaration instanceof KtTypeAlias) || ((ClassDescriptor)expectDescriptor).getKind() == ClassKind.ANNOTATION_CLASS) {
            return;
        }
        Collection<ClassConstructorDescriptor> collection = ((ClassDescriptor)expectDescriptor).getConstructors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getConstructors(...)");
        MemberScope memberScope2 = ((ClassDescriptor)expectDescriptor).getUnsubstitutedMemberScope();
        Intrinsics.checkNotNullExpressionValue((Object)memberScope2, (String)"getUnsubstitutedMemberScope(...)");
        Iterable iterable = ResolutionScope.DefaultImpls.getContributedDescriptors$default(memberScope2, DescriptorKindFilter.FUNCTIONS, null, 2, null);
        Collection<ClassConstructorDescriptor> collection2 = collection;
        boolean $i$f$filterIsInstance22 = false;
        void var7_8 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FunctionDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List members = CollectionsKt.plus(collection2, (Iterable)((List)destination$iv$iv));
        Iterable $i$f$filterIsInstance22 = members;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block7: {
                FunctionDescriptor it = (FunctionDescriptor)element$iv$iv;
                boolean bl2 = false;
                List<ValueParameterDescriptor> list2 = it.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameters(...)");
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ValueParameterDescriptor p = (ValueParameterDescriptor)element$iv;
                        boolean bl3 = false;
                        if (!p.declaresDefaultValue()) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List membersWithDefaultValueParameters = (List)destination$iv$iv2;
        if (membersWithDefaultValueParameters.isEmpty()) {
            return;
        }
        trace.report(Errors.DEFAULT_ARGUMENTS_IN_EXPECT_WITH_ACTUAL_TYPEALIAS.on((KtNamedDeclaration)((PsiElement)actualDeclaration), (ClassDescriptor)expectDescriptor, membersWithDefaultValueParameters));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasNoActualWithDiagnostic(MemberDescriptor $this$hasNoActualWithDiagnostic, Map<ExpectActualCompatibility<MemberDescriptor>, ? extends List<? extends MemberDescriptor>> compatibility) {
        boolean bl;
        block4: {
            void destination$iv;
            void $this$flatMapTo$iv;
            Iterable iterable = compatibility.values();
            Collection collection = new HashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                List it = (List)element$iv;
                boolean bl2 = false;
                Iterable list$iv = it;
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            Iterable $this$all$iv = (Iterable)destination$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    MemberDescriptor actual = (MemberDescriptor)element$iv;
                    boolean bl3 = false;
                    Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> expectedOnes = ExpectedActualResolver.INSTANCE.findExpectedForActual(actual, ModuleFilterUtilsKt.onlyFromThisModule(DescriptorUtilsKt.getModule($this$hasNoActualWithDiagnostic)));
                    if (expectedOnes != null && expectedOnes.keySet().contains(ExpectActualCompatibility.Compatible.INSTANCE)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void reportExpectActual(ExpectActualTracker $this$reportExpectActual, MemberDescriptor expected, Sequence<? extends MemberDescriptor> actualMembers2) {
        if ($this$reportExpectActual instanceof ExpectActualTracker.DoNothing) {
            return;
        }
        File file2 = this.sourceFile(expected);
        if (file2 == null) {
            return;
        }
        File expectedFile = file2;
        for (MemberDescriptor actual : actualMembers2) {
            File actualFile;
            if (this.sourceFile(actual) == null) continue;
            $this$reportExpectActual.report(expectedFile, actualFile);
        }
    }

    private final File sourceFile(MemberDescriptor descriptor2) {
        SourceFile sourceFile = descriptor2.getSource().getContainingFile();
        PsiSourceFile psiSourceFile = sourceFile instanceof PsiSourceFile ? (PsiSourceFile)sourceFile : null;
        if (psiSourceFile == null) {
            return null;
        }
        PsiSourceFile containingFile = psiSourceFile;
        return VfsUtilCore.virtualToIoFile((VirtualFile)containingFile.getPsiFile().getVirtualFile());
    }

    private final void checkActualDeclarationHasExpected(KtNamedDeclaration reportOn, MemberDescriptor descriptor2, boolean checkActualModifier, BindingTrace trace, Function1<? super ModuleDescriptor, Boolean> moduleVisibilityFilter) {
        MemberDescriptor expectSingleCandidate;
        Object it;
        boolean $i$f$any;
        Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> map = ExpectedActualResolver.INSTANCE.findExpectedForActual(descriptor2, moduleVisibilityFilter);
        if (map == null) {
            return;
        }
        Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> compatibility = map;
        this.checkAmbiguousExpects(compatibility, trace, reportOn, descriptor2);
        if (checkActualModifier && !(descriptor2.getContainingDeclaration() instanceof PackageFragmentDescriptor)) {
            boolean bl;
            block23: {
                Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> $this$any$iv = compatibility;
                $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    for (Map.Entry<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> element$iv : $this$any$iv.entrySet()) {
                        it = element$iv;
                        boolean bl2 = false;
                        if (!Companion.isCompatibleOrWeakCompatible$frontend(it.getKey())) continue;
                        bl = true;
                        break block23;
                    }
                    bl = false;
                }
            }
            if (bl) {
                this.reportMissingActualModifier(descriptor2, reportOn, trace);
            }
        }
        if (!PsiUtilsKt.hasActualModifier(reportOn) && Companion.allStrongIncompatibilities(compatibility)) {
            return;
        }
        ExpectActualCompatibility singleIncompatibility = (ExpectActualCompatibility)CollectionsKt.firstOrNull((Iterable)compatibility.keySet());
        if (singleIncompatibility instanceof ExpectActualCompatibility.Incompatible.ClassScopes) {
            ClassifierDescriptor $this$filterNotTo$iv$iv;
            boolean bl = $i$f$any = descriptor2 instanceof ClassDescriptor || descriptor2 instanceof TypeAliasDescriptor;
            if (_Assertions.ENABLED && !$i$f$any) {
                boolean $i$a$-assert-ExpectedActualDeclarationChecker$checkActualDeclarationHasExpected$32 = false;
                String $i$a$-assert-ExpectedActualDeclarationChecker$checkActualDeclarationHasExpected$32 = "Incompatible.ClassScopes is only possible for a class or a typealias: " + descriptor2;
                throw new AssertionError((Object)$i$a$-assert-ExpectedActualDeclarationChecker$checkActualDeclarationHasExpected$32);
            }
            Iterable $this$filterNot$iv = ((ExpectActualCompatibility.Incompatible.ClassScopes)singleIncompatibility).getUnfulfilled();
            boolean $i$f$filterNot = false;
            it = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            Iterator iterator2 = $this$filterNotTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                Pair p0 = (Pair)element$iv$iv;
                boolean bl3 = false;
                if (ExpectedActualDeclarationChecker.checkActualDeclarationHasExpected$hasSingleActualSuspect(this, (Pair<? extends MemberDescriptor, ? extends Map<ExpectActualCompatibility.Incompatible<MemberDescriptor>, ? extends Collection<? extends MemberDescriptor>>>)p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonTrivialUnfulfilled = (List)destination$iv$iv;
            if (!((Collection)nonTrivialUnfulfilled).isEmpty()) {
                Object object = descriptor2 instanceof TypeAliasDescriptor ? (TypeAliasDescriptor)descriptor2 : null;
                ClassifierDescriptor classifierDescriptor = $this$filterNotTo$iv$iv = object != null && (object = object.getExpandedType()) != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : null;
                ClassDescriptor classDescriptor2 = $this$filterNotTo$iv$iv instanceof ClassDescriptor ? (ClassDescriptor)$this$filterNotTo$iv$iv : null;
                if (classDescriptor2 == null) {
                    Intrinsics.checkNotNull((Object)descriptor2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    classDescriptor2 = (ClassDescriptor)descriptor2;
                }
                ClassDescriptor classDescriptor3 = classDescriptor2;
                trace.report(Errors.NO_ACTUAL_CLASS_MEMBER_FOR_EXPECTED_CLASS.on((KtNamedDeclaration)((PsiElement)reportOn), classDescriptor3, nonTrivialUnfulfilled));
            }
        } else if (!compatibility.containsKey(ExpectActualCompatibility.Compatible.INSTANCE)) {
            boolean $this$all$iv2;
            block24: {
                boolean bl;
                Iterable $this$all$iv2 = compatibility.keySet();
                boolean $i$f$all = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv2) {
                        ExpectActualCompatibility it2 = (ExpectActualCompatibility)element$iv;
                        boolean bl4 = false;
                        if (it2 instanceof ExpectActualCompatibility.Incompatible) continue;
                        bl = false;
                        break block24;
                    }
                    bl = $this$all$iv2 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv2) {
                String $i$f$all = "Assertion failed";
                throw new AssertionError((Object)$i$f$all);
            }
            Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> incompatibility = compatibility;
            trace.report(Errors.ACTUAL_WITHOUT_EXPECT.on((KtNamedDeclaration)((PsiElement)reportOn), descriptor2, incompatibility));
        } else {
            List<MemberDescriptor> list2 = compatibility.get(ExpectActualCompatibility.Compatible.INSTANCE);
            Intrinsics.checkNotNull(list2);
            MemberDescriptor expected = (MemberDescriptor)CollectionsKt.first(list2);
            if (expected instanceof ClassDescriptor && ((ClassDescriptor)expected).getKind() == ClassKind.ANNOTATION_CLASS) {
                Object object = descriptor2 instanceof ClassDescriptor ? (ClassDescriptor)descriptor2 : null;
                if (object == null || (object = object.getConstructors()) == null || (object = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)((Iterable)object))) == null) {
                    Object object2 = descriptor2 instanceof TypeAliasDescriptor ? (TypeAliasDescriptor)descriptor2 : null;
                    object = object2 != null && (object2 = object2.getConstructors()) != null && (object2 = (TypeAliasConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)((Iterable)object2))) != null ? object2.getUnderlyingConstructorDescriptor() : null;
                }
                Object actualConstructor = object;
                Collection<ClassConstructorDescriptor> collection = ((ClassDescriptor)expected).getConstructors();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getConstructors(...)");
                ClassConstructorDescriptor expectedConstructor = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
                if (expectedConstructor != null && actualConstructor != null) {
                    this.checkAnnotationConstructors(expectedConstructor, (ConstructorDescriptor)actualConstructor, trace, reportOn);
                }
            }
        }
        List list3 = (List)CollectionsKt.singleOrNull((Iterable)compatibility.values());
        MemberDescriptor memberDescriptor = expectSingleCandidate = list3 != null ? (MemberDescriptor)CollectionsKt.singleOrNull((List)list3) : null;
        if (expectSingleCandidate != null) {
            this.checkIfExpectHasDefaultArgumentsAndActualizedWithTypealias(expectSingleCandidate, reportOn, trace);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAmbiguousExpects(Map<ExpectActualCompatibility<MemberDescriptor>, ? extends List<? extends MemberDescriptor>> compatibility, BindingTrace trace, KtNamedDeclaration reportOn, MemberDescriptor descriptor2) {
        void $this$sortedBy$iv;
        Sequence sequence2 = SequencesKt.map((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence(compatibility), (Function1)checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.1.INSTANCE), (Function1)checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.2.INSTANCE)), (Function1)checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.3.INSTANCE);
        boolean $i$f$sortedBy = false;
        List filesWithAtLeastWeaklyCompatibleExpects2 = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ModuleDescriptor it = (ModuleDescriptor)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName().asString());
                it = (ModuleDescriptor)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName().asString())));
            }
        }));
        if (filesWithAtLeastWeaklyCompatibleExpects2.size() > 1) {
            trace.report(Errors.AMBIGUOUS_EXPECTS.on((KtNamedDeclaration)((PsiElement)reportOn), descriptor2, filesWithAtLeastWeaklyCompatibleExpects2));
        }
    }

    private final boolean requireActualModifier(MemberDescriptor descriptor2) {
        return !DescriptorUtilsKt.isAnnotationConstructor(descriptor2) && !DescriptorUtilsKt.isPrimaryConstructorOfInlineClass(descriptor2) && !this.isUnderlyingPropertyOfInlineClass(descriptor2);
    }

    private final boolean isUnderlyingPropertyOfInlineClass(MemberDescriptor descriptor2) {
        return descriptor2 instanceof PropertyDescriptor && InlineClassesUtilsKt.isUnderlyingPropertyOfInlineClass((VariableDescriptor)((Object)descriptor2));
    }

    private final boolean isExplicitActualDeclaration(MemberDescriptor $this$isExplicitActualDeclaration) {
        MemberDescriptor memberDescriptor = $this$isExplicitActualDeclaration;
        return memberDescriptor instanceof ConstructorDescriptor ? DescriptorToSourceUtils.getSourceFromDescriptor($this$isExplicitActualDeclaration) instanceof KtConstructor : (memberDescriptor instanceof CallableMemberDescriptor ? ((CallableMemberDescriptor)$this$isExplicitActualDeclaration).getKind() == CallableMemberDescriptor.Kind.DECLARATION : true);
    }

    private final void checkAnnotationConstructors(ConstructorDescriptor expected, ConstructorDescriptor actual, BindingTrace trace, PsiElement reportOn) {
        for (ValueParameterDescriptor expectedParameterDescriptor : expected.getValueParameters()) {
            Object object;
            ConstantValue constantValue;
            KtParameter expectedParameter;
            Object element$iv2;
            block7: {
                List<ValueParameterDescriptor> list2 = actual.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameters(...)");
                Iterable $this$first$iv = list2;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)expectedParameterDescriptor.getName())) continue;
                    break block7;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            ValueParameterDescriptor actualParameterDescriptor = (ValueParameterDescriptor)element$iv2;
            if (!expectedParameterDescriptor.declaresDefaultValue() || !actualParameterDescriptor.declaresDefaultValue()) continue;
            Intrinsics.checkNotNull((Object)expectedParameterDescriptor);
            Object object2 = DescriptorToSourceUtils.descriptorToDeclaration(expectedParameterDescriptor);
            if ((object2 instanceof KtParameter ? (KtParameter)object2 : null) == null) continue;
            expectedParameter = expectedParameter;
            object2 = (CompileTimeConstant)trace.getBindingContext().get(BindingContext.COMPILE_TIME_VALUE, expectedParameter.getDefaultValue());
            if (object2 != null) {
                KotlinType kotlinType = expectedParameterDescriptor.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                constantValue = object2.toConstantValue(kotlinType);
            } else {
                constantValue = null;
            }
            ConstantValue expectedValue = constantValue;
            Intrinsics.checkNotNull((Object)actualParameterDescriptor);
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            KotlinType kotlinType = expectedParameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            ConstantValue<?> actualValue = this.getActualAnnotationParameterValue(actualParameterDescriptor, bindingContext, kotlinType);
            if (Intrinsics.areEqual(expectedValue, actualValue)) continue;
            PsiElement ktParameter = DescriptorToSourceUtils.descriptorToDeclaration(actualParameterDescriptor);
            KtExpression ktExpression = ktParameter instanceof KtParameter ? (KtParameter)ktParameter : null;
            if (ktExpression != null && (ktExpression = ktExpression.getDefaultValue()) != null) {
                object = ktExpression;
            } else {
                KtTypeAlias ktTypeAlias = reportOn instanceof KtTypeAlias ? (KtTypeAlias)reportOn : null;
                object = ktTypeAlias != null ? ktTypeAlias.getNameIdentifier() : null;
                if (object == null) {
                    object = reportOn;
                }
            }
            PsiElement psiElement = object;
            Intrinsics.checkNotNull((Object)psiElement);
            PsiElement target = psiElement;
            trace.report(Errors.ACTUAL_ANNOTATION_CONFLICTING_DEFAULT_ARGUMENT_VALUE.on(target, actualParameterDescriptor));
        }
    }

    private final ConstantValue<?> getActualAnnotationParameterValue(ValueParameterDescriptor actualParameter, BindingContext bindingContext, KotlinType expectedType) {
        PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(actualParameter);
        if (declaration instanceof KtParameter) {
            CompileTimeConstant compileTimeConstant = (CompileTimeConstant)bindingContext.get(BindingContext.COMPILE_TIME_VALUE, ((KtParameter)declaration).getDefaultValue());
            return compileTimeConstant != null ? compileTimeConstant.toConstantValue(expectedType) : null;
        }
        for (ActualAnnotationArgumentExtractor extractor2 : this.argumentExtractors) {
            ConstantValue<?> constantValue = extractor2.extractDefaultValue(actualParameter, expectedType);
            if (constantValue == null) continue;
            ConstantValue<?> it = constantValue;
            boolean bl = false;
            return it;
        }
        return null;
    }

    private static final boolean checkActualDeclarationHasExpected$hasSingleActualSuspect(ExpectedActualDeclarationChecker this$0, Pair<? extends MemberDescriptor, ? extends Map<ExpectActualCompatibility.Incompatible<MemberDescriptor>, ? extends Collection<? extends MemberDescriptor>>> expectedWithIncompatibility) {
        List list2;
        Collection<List<MemberDescriptor>> collection;
        Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> map;
        MemberDescriptor actualMember;
        MemberDescriptor expectedMember = (MemberDescriptor)expectedWithIncompatibility.component1();
        Map incompatibility = (Map)expectedWithIncompatibility.component2();
        Collection collection2 = (Collection)CollectionsKt.singleOrNull((Iterable)incompatibility.values());
        MemberDescriptor memberDescriptor = actualMember = collection2 != null ? (MemberDescriptor)CollectionsKt.singleOrNull((Iterable)collection2) : null;
        return actualMember != null && this$0.isExplicitActualDeclaration(actualMember) && !Companion.allStrongIncompatibilities(incompatibility) && Intrinsics.areEqual((map = ExpectedActualResolver.INSTANCE.findExpectedForActual(actualMember, ModuleFilterUtilsKt.onlyFromThisModule(DescriptorUtilsKt.getModule(expectedMember)))) != null && (collection = map.values()) != null && (list2 = (List)CollectionsKt.singleOrNull((Iterable)collection)) != null ? (MemberDescriptor)CollectionsKt.singleOrNull((List)list2) : null, (Object)expectedMember);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker$ActualAnnotationArgumentExtractor;", "", "extractDefaultValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "frontend"})
    public static interface ActualAnnotationArgumentExtractor {
        @Nullable
        public ConstantValue<?> extractDefaultValue(@NotNull ValueParameterDescriptor var1, @NotNull KotlinType var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u0004*\u001c\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0005J\u0017\u0010\t\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker$Companion;", "", "()V", "allStrongIncompatibilities", "", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualCompatibility;", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "", "isCompatibleOrWeakCompatible", "isCompatibleOrWeakCompatible$frontend", "frontend"})
    @SourceDebugExtension(value={"SMAP\nExpectedActualDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectedActualDeclarationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,440:1\n1726#2,3:441\n*S KotlinDebug\n*F\n+ 1 ExpectedActualDeclarationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker$Companion\n*L\n431#1:441,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean allStrongIncompatibilities(@NotNull Map<? extends ExpectActualCompatibility<? extends MemberDescriptor>, ? extends Collection<? extends MemberDescriptor>> $this$allStrongIncompatibilities) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter($this$allStrongIncompatibilities, (String)"<this>");
                Iterable $this$all$iv = $this$allStrongIncompatibilities.keySet();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ExpectActualCompatibility it = (ExpectActualCompatibility)element$iv;
                        boolean bl2 = false;
                        if (it instanceof ExpectActualCompatibility.Incompatible && ((ExpectActualCompatibility.Incompatible)it).getKind() == ExpectActualCompatibility.IncompatibilityKind.STRONG) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public final boolean isCompatibleOrWeakCompatible$frontend(@NotNull ExpectActualCompatibility<? extends MemberDescriptor> $this$isCompatibleOrWeakCompatible) {
            Intrinsics.checkNotNullParameter($this$isCompatibleOrWeakCompatible, (String)"<this>");
            return $this$isCompatibleOrWeakCompatible instanceof ExpectActualCompatibility.Compatible || $this$isCompatibleOrWeakCompatible instanceof ExpectActualCompatibility.Incompatible && ((ExpectActualCompatibility.Incompatible)$this$isCompatibleOrWeakCompatible).getKind() == ExpectActualCompatibility.IncompatibilityKind.WEAK;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

