/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.classes;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.light.LightReferenceListBuilder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class KotlinLightReferenceListBuilder
extends LightReferenceListBuilder
implements PsiReferenceList {
    private final List<PsiJavaCodeReferenceElement> myRefs = new ArrayList<PsiJavaCodeReferenceElement>();
    private volatile PsiJavaCodeReferenceElement[] myCachedRefs;
    private volatile PsiClassType[] myCachedTypes;
    private final PsiReferenceList.Role myRole;
    private final PsiElementFactory myFactory;

    public KotlinLightReferenceListBuilder(PsiManager manager, PsiReferenceList.Role role) {
        this(manager, (Language)JavaLanguage.INSTANCE, role);
    }

    public KotlinLightReferenceListBuilder(PsiManager manager, Language language2, PsiReferenceList.Role role) {
        super(manager, language2, role);
        this.myRole = role;
        this.myFactory = JavaPsiFacade.getElementFactory((Project)this.getProject());
    }

    public void addReference(PsiClass aClass) {
        this.addReference(aClass.getQualifiedName());
    }

    public void addReference(String qualifiedName) {
        PsiJavaCodeReferenceElement ref = this.myFactory.createReferenceElementByFQClassName(qualifiedName, this.getResolveScope());
        this.myRefs.add(ref);
    }

    public void addReference(PsiClassType type2) {
        PsiJavaCodeReferenceElement ref = this.myFactory.createReferenceElementByType(type2);
        this.myRefs.add(ref);
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getReferenceElements() {
        PsiJavaCodeReferenceElement[] refs = this.myCachedRefs;
        if (refs == null) {
            this.myCachedRefs = refs = this.myRefs.toArray(PsiJavaCodeReferenceElement.EMPTY_ARRAY);
        }
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = refs;
        if (refs == null) {
            KotlinLightReferenceListBuilder.$$$reportNull$$$0(0);
        }
        if (psiJavaCodeReferenceElementArray == null) {
            KotlinLightReferenceListBuilder.$$$reportNull$$$1(0);
        }
        return psiJavaCodeReferenceElementArray;
    }

    @NotNull
    public PsiClassType[] getReferencedTypes() {
        PsiClassType[] types2 = this.myCachedTypes;
        if (types2 == null) {
            int size = this.myRefs.size();
            types2 = size == 0 ? PsiClassType.EMPTY_ARRAY : new PsiClassType[size];
            for (int i = 0; i < size; ++i) {
                types2[i] = this.myFactory.createType(this.myRefs.get(i));
            }
            this.myCachedTypes = types2;
        }
        PsiClassType[] psiClassTypeArray = types2;
        if (types2 == null) {
            KotlinLightReferenceListBuilder.$$$reportNull$$$0(1);
        }
        if (psiClassTypeArray == null) {
            KotlinLightReferenceListBuilder.$$$reportNull$$$1(1);
        }
        return psiClassTypeArray;
    }

    public PsiReferenceList.Role getRole() {
        return this.myRole;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/kotlin/asJava/classes/KotlinLightReferenceListBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedTypes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/kotlin/asJava/classes/KotlinLightReferenceListBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedTypes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

