/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ.\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\r2\u001c\u0010%\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020#0&H\u0016J$\u0010(\u001a\u00020#2\u0006\u0010$\u001a\u00020\r2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020#0)H\u0016J(\u0010*\u001a\u00020#2\u0006\u0010$\u001a\u00020\r2\u0016\u0010%\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030+\u0012\u0004\u0012\u00020#0)H\u0016R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00180\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirPackageMemberScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "excludedImportNames", "", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;Ljava/util/Collection;)V", "classifierCache", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "excludedNames", "", "getExcludedNames", "()Ljava/util/Set;", "excludedNames$delegate", "Lkotlin/Lazy;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "functionCache", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "propertyCache", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "scopeOwnerLookupNames", "", "getScopeOwnerLookupNames", "()Ljava/util/List;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "processClassifiersByNameWithSubstitution", "", "name", "processor", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "processFunctionsByName", "Lkotlin/Function1;", "processPropertiesByName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "providers"})
@SourceDebugExtension(value={"SMAP\nFirPackageMemberScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPackageMemberScope.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirPackageMemberScope\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,80:1\n372#2,7:81\n372#2,7:88\n372#2,7:95\n*S KotlinDebug\n*F\n+ 1 FirPackageMemberScope.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirPackageMemberScope\n*L\n44#1:81,7\n57#1:88,7\n68#1:95,7\n*E\n"})
public final class FirPackageMemberScope
extends FirScope {
    @NotNull
    private final FqName fqName;
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirSymbolProvider symbolProvider;
    @NotNull
    private final Map<Name, FirClassifierSymbol<?>> classifierCache;
    @NotNull
    private final Map<Name, List<FirNamedFunctionSymbol>> functionCache;
    @NotNull
    private final Map<Name, List<FirPropertySymbol>> propertyCache;
    @NotNull
    private final Lazy excludedNames$delegate;
    @NotNull
    private final List<String> scopeOwnerLookupNames;

    public FirPackageMemberScope(@NotNull FqName fqName2, @NotNull FirSession session, @NotNull FirSymbolProvider symbolProvider, @Nullable Collection<FqName> excludedImportNames) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)symbolProvider, (String)"symbolProvider");
        this.fqName = fqName2;
        this.session = session;
        this.symbolProvider = symbolProvider;
        this.classifierCache = new LinkedHashMap();
        this.functionCache = new LinkedHashMap();
        this.propertyCache = new LinkedHashMap();
        this.excludedNames$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends Name>>(excludedImportNames, this){
            final /* synthetic */ Collection<FqName> $excludedImportNames;
            final /* synthetic */ FirPackageMemberScope this$0;
            {
                this.$excludedImportNames = $excludedImportNames;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Set<Name> invoke() {
                Set set;
                Set set2;
                Collection<FqName> collection = this.$excludedImportNames;
                if (collection != null) {
                    void $this$mapNotNullTo$iv;
                    Iterable iterable = collection;
                    Collection collection2 = new LinkedHashSet<E>();
                    FirPackageMemberScope firPackageMemberScope = this.this$0;
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        void destination$iv;
                        Name it$iv;
                        T element$iv$iv;
                        T element$iv = element$iv$iv = iterator2.next();
                        boolean bl = false;
                        FqName it = (FqName)element$iv;
                        boolean bl2 = false;
                        if ((Intrinsics.areEqual((Object)it.parent(), (Object)firPackageMemberScope.getFqName()) ? it.shortName() : null) == null) continue;
                        it$iv = it$iv;
                        boolean bl3 = false;
                        destination$iv.add(it$iv);
                    }
                    set2 = (Set)collection2;
                } else {
                    set2 = set = null;
                }
                if (set2 == null) {
                    set = SetsKt.emptySet();
                }
                return set;
            }
        }));
        this.scopeOwnerLookupNames = new SmartList<String>(this.fqName.asString());
    }

    public /* synthetic */ FirPackageMemberScope(FqName fqName2, FirSession firSession, FirSymbolProvider firSymbolProvider, Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            firSymbolProvider = FirSymbolProviderKt.getSymbolProvider(firSession);
        }
        if ((n & 8) != 0) {
            collection = null;
        }
        this(fqName2, firSession, firSymbolProvider, collection);
    }

    @NotNull
    public final FqName getFqName() {
        return this.fqName;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    private final Set<Name> getExcludedNames() {
        Lazy lazy = this.excludedNames$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name2, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor2) {
        FirClassifierSymbol symbol2;
        FirClassifierSymbol firClassifierSymbol;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        String string2 = name2.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        if (((CharSequence)string2).length() == 0) {
            return;
        }
        if (this.getExcludedNames().contains(name2)) {
            return;
        }
        Map<Name, FirClassifierSymbol<?>> $this$getOrPut$iv = this.classifierCache;
        boolean $i$f$getOrPut = false;
        FirClassifierSymbol value$iv = $this$getOrPut$iv.get(name2);
        if (value$iv == null) {
            boolean bl = false;
            ClassId unambiguousFqName = new ClassId(this.fqName, name2);
            FirClassifierSymbol answer$iv = this.symbolProvider.getClassLikeSymbolByClassId(unambiguousFqName);
            $this$getOrPut$iv.put(name2, answer$iv);
            firClassifierSymbol = answer$iv;
        } else {
            firClassifierSymbol = value$iv;
        }
        if ((symbol2 = firClassifierSymbol) != null) {
            processor2.invoke(symbol2, (Object)ConeSubstitutor.Empty.INSTANCE);
        }
    }

    @Override
    public void processFunctionsByName(@NotNull Name name2, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor2) {
        List<FirNamedFunctionSymbol> list2;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        if (this.getExcludedNames().contains(name2)) {
            return;
        }
        Map<Name, List<FirNamedFunctionSymbol>> $this$getOrPut$iv = this.functionCache;
        boolean $i$f$getOrPut = false;
        List<FirNamedFunctionSymbol> value$iv = $this$getOrPut$iv.get(name2);
        if (value$iv == null) {
            boolean bl = false;
            List<FirNamedFunctionSymbol> answer$iv = this.symbolProvider.getTopLevelFunctionSymbols(this.fqName, name2);
            $this$getOrPut$iv.put(name2, answer$iv);
            list2 = answer$iv;
        } else {
            list2 = value$iv;
        }
        List<FirNamedFunctionSymbol> symbols = list2;
        for (FirNamedFunctionSymbol symbol2 : symbols) {
            processor2.invoke((Object)symbol2);
        }
    }

    @Override
    public void processPropertiesByName(@NotNull Name name2, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor2) {
        List<FirPropertySymbol> list2;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        if (this.getExcludedNames().contains(name2)) {
            return;
        }
        Map<Name, List<FirPropertySymbol>> $this$getOrPut$iv = this.propertyCache;
        boolean $i$f$getOrPut = false;
        List<FirPropertySymbol> value$iv = $this$getOrPut$iv.get(name2);
        if (value$iv == null) {
            boolean bl = false;
            List<FirPropertySymbol> answer$iv = this.symbolProvider.getTopLevelPropertySymbols(this.fqName, name2);
            $this$getOrPut$iv.put(name2, answer$iv);
            list2 = answer$iv;
        } else {
            list2 = value$iv;
        }
        List<FirPropertySymbol> symbols = list2;
        for (FirPropertySymbol symbol2 : symbols) {
            processor2.invoke((Object)symbol2);
        }
    }

    @Override
    @NotNull
    public List<String> getScopeOwnerLookupNames() {
        return this.scopeOwnerLookupNames;
    }
}

