/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.impl.FirOuterClassTypeParameterRef;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.util.ListMultimap;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"NO_NAME_PROVIDED", "Lorg/jetbrains/kotlin/name/Name;", "checkConflictingElements", "", "elements", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isCollectable", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "checkers"})
public final class FirConflictsHelpersKt {
    @NotNull
    private static final Name NO_NAME_PROVIDED;

    private static final boolean isCollectable(FirDeclaration $this$isCollectable) {
        boolean bl;
        FirDeclaration firDeclaration = $this$isCollectable;
        if (firDeclaration instanceof FirSimpleFunction) {
            KtSourceElement ktSourceElement = $this$isCollectable.getSource();
            bl = !((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) && !Intrinsics.areEqual((Object)((FirSimpleFunction)$this$isCollectable).getName(), (Object)NO_NAME_PROVIDED);
        } else if (firDeclaration instanceof FirProperty) {
            KtSourceElement ktSourceElement = $this$isCollectable.getSource();
            bl = !((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.EnumGeneratedDeclaration);
        } else {
            bl = firDeclaration instanceof FirRegularClass ? !Intrinsics.areEqual((Object)((FirRegularClass)$this$isCollectable).getName(), (Object)NO_NAME_PROVIDED) : true;
        }
        return bl;
    }

    public static final void checkConflictingElements(@NotNull List<? extends FirElement> elements, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (elements.size() <= 1) {
            return;
        }
        ListMultimap<Name, FirBasedSymbol> multimap = new ListMultimap<Name, FirBasedSymbol>();
        for (FirElement firElement : elements) {
            Name name2 = null;
            FirBasedSymbol symbol2 = null;
            FirElement firElement2 = firElement;
            if (firElement2 instanceof FirVariable) {
                symbol2 = ((FirVariable)firElement).getSymbol();
                name2 = ((FirVariable)firElement).getName();
            } else {
                if (firElement2 instanceof FirOuterClassTypeParameterRef) continue;
                if (firElement2 instanceof FirTypeParameterRef) {
                    symbol2 = ((FirTypeParameterRef)firElement).getSymbol();
                    name2 = ((FirTypeParameterSymbol)symbol2).getName();
                } else {
                    symbol2 = null;
                    name2 = null;
                }
            }
            Name name3 = name2;
            boolean bl = name3 != null ? !name3.isSpecial() : false;
            if (!bl) continue;
            FirBasedSymbol firBasedSymbol = symbol2;
            Intrinsics.checkNotNull((Object)firBasedSymbol);
            multimap.put(name2, firBasedSymbol);
        }
        for (Name name4 : multimap.getKeys()) {
            List conflictingElements = (List)multimap.get(name4);
            if (conflictingElements.size() <= 1) continue;
            for (FirBasedSymbol conflictingElement : conflictingElements) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)conflictingElement.getSource(), FirErrors.INSTANCE.getREDECLARATION(), (Object)conflictingElements, (DiagnosticContext)context2, null, 16, null);
            }
        }
    }

    public static final /* synthetic */ boolean access$isCollectable(FirDeclaration $receiver) {
        return FirConflictsHelpersKt.isCollectable($receiver);
    }

    static {
        Name name2 = Name.special("<no name provided>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(...)");
        NO_NAME_PROVIDED = name2;
    }
}

