/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInconsistentTypeParameterHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001bH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterChecker;", "()V", "classKinds", "", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkBoundUniqueness", "checkConflictingBounds", "checkDynamicBounds", "checkExtensionFunctionTypeBound", "checkFinalUpperBounds", "containingDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "checkInconsistentTypeParameterBounds", "checkOnlyOneTypeParameterBound", "checkTypeAliasBound", "isRelated", "", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "Lorg/jetbrains/kotlin/types/model/TypeCheckerProviderContext;", "type", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirTypeParameterBoundsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n37#2:185\n37#2:186\n1855#3,2:187\n1855#3,2:189\n766#3:191\n857#3,2:192\n1855#3,2:194\n1655#3,8:196\n3190#3,10:204\n766#3:214\n857#3,2:215\n766#3:217\n857#3,2:218\n1655#3,8:220\n1855#3,2:228\n1855#3,2:230\n1549#3:232\n1620#3,3:233\n1855#3,2:236\n1855#3:238\n1855#3,2:239\n1856#3:241\n*S KotlinDebug\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker\n*L\n54#1:185\n55#1:186\n57#1:187,2\n65#1:189,2\n79#1:191\n79#1:192,2\n79#1:194,2\n86#1:196,8\n87#1:204,10\n94#1:214\n94#1:215,2\n110#1:217\n110#1:218,2\n111#1:220,8\n113#1:228,2\n121#1:230,2\n142#1:232\n142#1:233,3\n148#1:236,2\n130#1:238\n132#1:239,2\n130#1:241\n*E\n"})
public final class FirTypeParameterBoundsChecker
extends FirDeclarationChecker<FirTypeParameter> {
    @NotNull
    public static final FirTypeParameterBoundsChecker INSTANCE = new FirTypeParameterBoundsChecker();
    @NotNull
    private static final Set<ClassKind> classKinds;

    private FirTypeParameterBoundsChecker() {
    }

    @Override
    public void check(@NotNull FirTypeParameter declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        if (firDeclaration == null) {
            return;
        }
        FirDeclaration containingDeclaration = firDeclaration;
        if (containingDeclaration instanceof FirConstructor) {
            return;
        }
        this.checkFinalUpperBounds(declaration, containingDeclaration, context2, reporter);
        this.checkExtensionFunctionTypeBound(declaration, context2, reporter);
        FirMemberDeclaration firMemberDeclaration = containingDeclaration instanceof FirMemberDeclaration ? (FirMemberDeclaration)containingDeclaration : null;
        if (!(firMemberDeclaration != null ? FirHelpersKt.isInlineOnly(firMemberDeclaration, context2.getSession()) : false)) {
            this.checkOnlyOneTypeParameterBound(declaration, context2, reporter);
        }
        this.checkBoundUniqueness(declaration, context2, reporter);
        this.checkConflictingBounds(declaration, context2, reporter);
        this.checkTypeAliasBound(declaration, containingDeclaration, context2, reporter);
        this.checkDynamicBounds(declaration, context2, reporter);
        this.checkInconsistentTypeParameterBounds(declaration, context2, reporter);
    }

    private final void checkFinalUpperBounds(FirTypeParameter declaration, FirDeclaration containingDeclaration, CheckerContext context2, DiagnosticReporter reporter) {
        boolean $i$f$isOverride;
        FirMemberDeclaration $this$isOverride$iv;
        if (containingDeclaration instanceof FirSimpleFunction) {
            $this$isOverride$iv = (FirMemberDeclaration)containingDeclaration;
            $i$f$isOverride = false;
            if ($this$isOverride$iv.getStatus().isOverride()) {
                return;
            }
        }
        if (containingDeclaration instanceof FirProperty) {
            $this$isOverride$iv = (FirMemberDeclaration)containingDeclaration;
            $i$f$isOverride = false;
            if ($this$isOverride$iv.getStatus().isOverride()) {
                return;
            }
        }
        Iterable $this$forEach$iv = declaration.getSymbol().getResolvedBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirResolvedTypeRef bound2 = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            if (TypeUtilsKt.canHaveSubtypes(FirTypeUtilsKt.getConeType(bound2), context2.getSession())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound2.getSource(), FirErrors.INSTANCE.getFINAL_UPPER_BOUND(), (Object)FirTypeUtilsKt.getConeType(bound2), (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkExtensionFunctionTypeBound(FirTypeParameter declaration, CheckerContext context2, DiagnosticReporter reporter) {
        Iterable $this$forEach$iv = declaration.getSymbol().getResolvedBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirResolvedTypeRef bound2 = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            if (!TypeUtilsKt.isExtensionFunctionType(bound2, context2.getSession())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound2.getSource(), FirErrors.INSTANCE.getUPPER_BOUND_IS_EXTENSION_FUNCTION_TYPE(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeAliasBound(FirTypeParameter declaration, FirDeclaration containingDeclaration, CheckerContext context2, DiagnosticReporter reporter) {
        if (containingDeclaration instanceof FirTypeAlias) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = declaration.getBounds();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirTypeRef it = (FirTypeRef)element$iv$iv;
                boolean bl = false;
                KtSourceElement ktSourceElement = it.getSource();
                if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirTypeRef bound2 = (FirTypeRef)element$iv;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound2.getSource(), FirErrors.INSTANCE.getBOUND_ON_TYPE_ALIAS_PARAMETER_NOT_ALLOWED(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOnlyOneTypeParameterBound(FirTypeParameter declaration, CheckerContext context2, DiagnosticReporter reporter) {
        Iterable $this$distinctBy$iv = declaration.getSymbol().getResolvedBounds();
        boolean $i$f$distinctBy = false;
        HashSet<ConeKotlinType> set$iv = new HashSet<ConeKotlinType>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            FirResolvedTypeRef it = (FirResolvedTypeRef)e$iv;
            boolean bl = false;
            ConeKotlinType key$iv = FirTypeUtilsKt.getConeType(it);
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List bounds = list$iv;
        Iterable $this$partition$iv = bounds;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            if (FirTypeUtilsKt.getConeType(it) instanceof ConeTypeParameterType) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List boundWithParam = (List)pair.component1();
        List otherBounds = (List)pair.component2();
        if (boundWithParam.size() > 1 || boundWithParam.size() == 1 && !((Collection)otherBounds).isEmpty()) {
            KtSourceElement ktSourceElement;
            void $this$filterTo$iv$iv;
            SourceNavigator $this$checkOnlyOneTypeParameterBound_u24lambda_u247 = SourceNavigator.Companion.forElement(declaration);
            boolean bl = false;
            Iterable $this$filter$iv = bounds;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv$iv;
                boolean bl2 = false;
                if (!$this$checkOnlyOneTypeParameterBound_u24lambda_u247.isInTypeConstraint(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set constraintBounds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (bounds.size() == 2) {
                FirResolvedTypeRef boundDecl;
                FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)CollectionsKt.firstOrNull((List)otherBounds);
                if (firResolvedTypeRef == null) {
                    firResolvedTypeRef = (FirResolvedTypeRef)CollectionsKt.last((List)boundWithParam);
                }
                ktSourceElement = constraintBounds.contains(boundDecl = firResolvedTypeRef) ? boundDecl.getSource() : declaration.getSource();
            } else {
                ktSourceElement = declaration.getSource();
            }
            KtSourceElement reportOn = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)reportOn, FirErrors.INSTANCE.getBOUNDS_NOT_ALLOWED_IF_BOUNDED_BY_TYPE_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkBoundUniqueness(FirTypeParameter declaration, CheckerContext context2, DiagnosticReporter reporter) {
        FirResolvedTypeRef bound2;
        FirResolvedTypeRef it;
        void $this$filterTo$iv$iv;
        Set seenClasses = new LinkedHashSet();
        Iterable $this$filter$iv = declaration.getSymbol().getResolvedBounds();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FirResolvedTypeRef)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof FirErrorTypeRef))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allNonErrorBounds = (List)destination$iv$iv;
        Iterable $this$distinctBy$iv = allNonErrorBounds;
        boolean $i$f$distinctBy = false;
        HashSet<ClassId> set$iv = new HashSet<ClassId>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            ClassId key$iv;
            it = (FirResolvedTypeRef)e$iv;
            boolean bl = false;
            Object object = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(it));
            if (object == null) {
                object = FirTypeUtilsKt.getConeType(it);
            }
            if (!set$iv.add(key$iv = object)) continue;
            list$iv.add(e$iv);
        }
        List uniqueBounds = list$iv;
        Iterable $this$forEach$iv = uniqueBounds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirRegularClassSymbol symbol2;
            bound2 = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            if (TypeUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getConeType(bound2), context2.getSession()) == null) continue;
            boolean bl2 = false;
            if (!classKinds.contains((Object)symbol2.getClassKind()) || !seenClasses.add(symbol2) || seenClasses.size() <= 1) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound2.getSource(), FirErrors.INSTANCE.getONLY_ONE_CLASS_BOUND_ALLOWED(), (DiagnosticContext)context2, null, 8, null);
        }
        $this$forEach$iv = CollectionsKt.minus((Iterable)allNonErrorBounds, (Iterable)uniqueBounds);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            bound2 = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound2.getSource(), FirErrors.INSTANCE.getREPEATED_BOUND(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConflictingBounds(FirTypeParameter declaration, CheckerContext context2, DiagnosticReporter reporter) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (declaration.getBounds().size() < 2) {
            return;
        }
        Iterable iterable = declaration.getSymbol().getResolvedBounds();
        CheckerContext checkerContext = context2;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FirTypeUtilsKt.getConeType((FirTypeRef)it));
        }
        if (FirTypeParameterBoundsChecker.checkConflictingBounds$anyConflictingTypes(checkerContext, (List)destination$iv$iv)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getCONFLICTING_UPPER_BOUNDS(), (Object)declaration.getSymbol(), (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkDynamicBounds(FirTypeParameter declaration, CheckerContext context2, DiagnosticReporter reporter) {
        Iterable $this$forEach$iv = declaration.getBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirTypeRef bound2 = (FirTypeRef)element$iv;
            boolean bl = false;
            if (!(FirTypeUtilsKt.getConeType(bound2) instanceof ConeDynamicType)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound2.getSource(), FirErrors.INSTANCE.getDYNAMIC_UPPER_BOUND(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean isRelated(KotlinTypeMarker $this$isRelated, TypeCheckerProviderContext context2, KotlinTypeMarker type2) {
        return TypeUtilsKt.isSubtypeOf($this$isRelated, context2, type2) || FirHelpersKt.isSupertypeOf($this$isRelated, context2, type2);
    }

    private final void checkInconsistentTypeParameterBounds(FirTypeParameter declaration, CheckerContext context2, DiagnosticReporter reporter) {
        if (declaration.getBounds().size() <= 1) {
            return;
        }
        List firTypeRefClasses = new ArrayList();
        Set firRegularClassesSet = new LinkedHashSet();
        for (FirResolvedTypeRef bound2 : declaration.getSymbol().getResolvedBounds()) {
            FirRegularClassSymbol classSymbol = FirHelpersKt.toRegularClassSymbol(bound2, context2.getSession());
            if (CollectionsKt.contains((Iterable)firRegularClassesSet, (Object)classSymbol)) {
                return;
            }
            if (classSymbol == null) continue;
            firRegularClassesSet.add(classSymbol);
            firTypeRefClasses.add(new Pair((Object)bound2, (Object)classSymbol));
        }
        FirInconsistentTypeParameterHelpersKt.checkInconsistentTypeParameters(firTypeRefClasses, context2, reporter, declaration.getSource(), false);
    }

    private static final boolean checkConflictingBounds$anyConflictingTypes(CheckerContext $context, List<? extends ConeKotlinType> types2) {
        Iterable $this$forEach$iv = types2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConeKotlinType type2 = (ConeKotlinType)element$iv;
            boolean bl = false;
            if (TypeUtilsKt.canHaveSubtypes(type2, $context.getSession())) continue;
            Iterable $this$forEach$iv2 = types2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ConeKotlinType otherType = (ConeKotlinType)element$iv2;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)type2, (Object)otherType) || INSTANCE.isRelated(type2, TypeComponentsKt.getTypeContext($context.getSession()), otherType)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        ClassKind[] classKindArray = new ClassKind[]{ClassKind.CLASS, ClassKind.ENUM_CLASS, ClassKind.OBJECT};
        classKinds = SetsKt.setOf((Object[])classKindArray);
    }
}

