/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.InstructionKt;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.builtins.IrBuiltInsMapGeneratedKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterAssertionError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterException;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicEvaluator;
import org.jetbrains.kotlin.ir.interpreter.proxy.ProxyKt;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.JsPlatformKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002?@B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u001e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J4\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%H\u0016J,\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%H\u0016J\u001e\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%H\u0016J\u001e\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%H\u0016J\u0010\u0010/\u001a\u00020\u00162\u0006\u0010-\u001a\u000200H\u0016J,\u00101\u001a\u0004\u0018\u0001022\u0006\u0010\u0017\u001a\u00020\u00182\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\n\u00104\u001a\u0006\u0012\u0002\b\u000305H\u0016J\u0012\u00106\u001a\u0004\u0018\u0001022\u0006\u00107\u001a\u000208H\u0002J\u0016\u00109\u001a\u00020\u001e*\u0004\u0018\u0001022\u0006\u0010:\u001a\u00020\u001eH\u0002J$\u0010;\u001a\u00020\u0016*\u0004\u0018\u00010<2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u000e\u0010=\u001a\u0004\u0018\u00010>*\u00020\u0018H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor;", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;)V", "bodyMap", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "callStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getEnvironment", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getInterpreter", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "calculateBuiltIns", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "args", "", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "calculateRangeTo", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "handleIntrinsicMethods", "", "interceptCall", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "defaultAction", "Lkotlin/Function0;", "interceptConstructor", "constructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "interceptEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "interceptGetObjectValue", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "interceptJavaStaticField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "interceptProxy", "", "valueArguments", "expectedResultClass", "Ljava/lang/Class;", "interpretBuiltinFunction", "signature", "Lorg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor$Signature;", "getType", "defaultType", "invokeMethod", "Ljava/lang/invoke/MethodHandle;", "trySubstituteFunctionBody", "Lorg/jetbrains/kotlin/ir/IrElement;", "Arg", "Signature", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nCallInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallInterceptor.kt\norg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor\n+ 2 ExceptionUtils.kt\norg/jetbrains/kotlin/ir/interpreter/exceptions/ExceptionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,225:1\n20#2,2:226\n20#2,2:253\n24#2,8:255\n24#2,2:269\n26#2,6:275\n618#3,12:228\n1855#3,2:263\n1549#3:265\n1620#3,3:266\n1549#3:271\n1620#3,3:272\n766#3:281\n857#3,2:282\n1855#3,2:284\n1549#3:286\n1620#3,3:287\n1549#3:290\n1620#3,3:291\n1864#3,3:294\n1#4:240\n346#5,12:241\n*S KotlinDebug\n*F\n+ 1 CallInterceptor.kt\norg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor\n*L\n89#1:226,2\n134#1:253,2\n136#1:255,8\n161#1:269,2\n161#1:275,6\n94#1:228,12\n144#1:263,2\n158#1:265\n158#1:266,3\n163#1:271\n163#1:272,3\n173#1:281\n173#1:282,2\n173#1:284,2\n192#1:286\n192#1:287,3\n194#1:290\n194#1:291,3\n195#1:294,3\n118#1:241,12\n*E\n"})
public final class DefaultCallInterceptor
implements CallInterceptor {
    @NotNull
    private final IrInterpreter interpreter;
    @NotNull
    private final IrInterpreterEnvironment environment;
    @NotNull
    private final CallStack callStack;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Map<IdSignature, IrBody> bodyMap;

    public DefaultCallInterceptor(@NotNull IrInterpreter interpreter2) {
        Intrinsics.checkNotNullParameter((Object)interpreter2, (String)"interpreter");
        this.interpreter = interpreter2;
        this.environment = this.getInterpreter().getEnvironment$ir_interpreter();
        this.callStack = this.getEnvironment().getCallStack$ir_interpreter();
        this.irBuiltIns = this.getEnvironment().getIrBuiltIns();
        this.bodyMap = this.getInterpreter().getBodyMap$ir_interpreter();
    }

    @Override
    @NotNull
    public IrInterpreter getInterpreter() {
        return this.interpreter;
    }

    @Override
    @NotNull
    public IrInterpreterEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    @NotNull
    public IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @Override
    @Nullable
    public Object interceptProxy(@NotNull IrFunction irFunction2, @NotNull List<? extends State> valueArguments, @NotNull Class<?> expectedResultClass) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter(valueArguments, (String)"valueArguments");
        Intrinsics.checkNotNullParameter(expectedResultClass, (String)"expectedResultClass");
        IrCall irCall = IrTreeBuildUtilsKt.createCall$default(irFunction2, null, 1, null);
        return ProxyKt.wrap(this.getInterpreter().withNewCallStack$ir_interpreter(irCall, (Function1<? super IrInterpreter, ? extends Object>)((Function1)new Function1<IrInterpreter, Unit>(irCall, valueArguments){
            final /* synthetic */ IrCall $irCall;
            final /* synthetic */ List<State> $valueArguments;
            {
                this.$irCall = $irCall;
                this.$valueArguments = $valueArguments;
                super(1);
            }

            public final void invoke(@NotNull IrInterpreter $this$withNewCallStack) {
                Intrinsics.checkNotNullParameter((Object)$this$withNewCallStack, (String)"$this$withNewCallStack");
                InstructionKt.pushSimpleInstruction($this$withNewCallStack.getEnvironment$ir_interpreter().getCallStack$ir_interpreter(), this.$irCall);
                Iterable $this$forEach$iv = this.$valueArguments;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    State it = (State)element$iv;
                    boolean bl = false;
                    $this$withNewCallStack.getEnvironment$ir_interpreter().getCallStack$ir_interpreter().pushState(it);
                }
            }
        })), (CallInterceptor)this, false, expectedResultClass);
    }

    @Override
    public void interceptCall(@NotNull IrCall call2, @NotNull IrFunction irFunction2, @NotNull List<? extends State> args, @NotNull Function0<Unit> defaultAction) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
        boolean isInlineOnly = IrUtilsKt.hasAnnotation((IrAnnotationContainer)irFunction2, new FqName("kotlin.internal.InlineOnly"));
        boolean isSyntheticDefault = Intrinsics.areEqual((Object)irFunction2.getOrigin(), (Object)IrDeclarationOrigin.FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE);
        State receiver = irFunction2.getDispatchReceiverParameter() != null ? args.get(0) : null;
        if (receiver instanceof Wrapper && !isInlineOnly && !isSyntheticDefault) {
            this.invokeMethod(((Wrapper)receiver).getMethod(irFunction2), irFunction2, args);
        } else if (Wrapper.Companion.mustBeHandledWithWrapper(irFunction2)) {
            this.invokeMethod(Wrapper.Companion.getStaticMethod(irFunction2), irFunction2, args);
        } else {
            if (this.handleIntrinsicMethods(irFunction2)) {
                return;
            }
            if (StateKt.mustBeHandledAsReflection(receiver, call2)) {
                this.invokeMethod(Wrapper.Companion.getReflectionMethod(irFunction2), irFunction2, args);
            } else if (receiver instanceof Primitive) {
                this.calculateBuiltIns(irFunction2, args);
            } else if (irFunction2.getBody() == null && UtilsKt.isAccessorOfPropertyWithBackingField(irFunction2)) {
                InstructionKt.pushCompoundInstruction(this.callStack, IrTreeBuildUtilsKt.createGetField(irFunction2));
            } else if (irFunction2.getBody() == null) {
                IrElement irElement = this.trySubstituteFunctionBody(irFunction2);
                if (irElement == null) {
                    this.calculateBuiltIns(irFunction2, args);
                    irElement = Unit.INSTANCE;
                }
            } else {
                defaultAction.invoke();
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void interceptConstructor(@NotNull IrFunctionAccessExpression constructorCall, @NotNull List<? extends State> args, @NotNull Function0<Unit> defaultAction) {
        block11: {
            block13: {
                block12: {
                    block10: {
                        Intrinsics.checkNotNullParameter((Object)constructorCall, (String)"constructorCall");
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
                        receiver = this.callStack.loadState(UtilsKt.getThisReceiver(constructorCall));
                        irConstructor = ((IrFunctionSymbol)constructorCall.getSymbol()).getOwner();
                        irClass = IrUtilsKt.getParentAsClass(irConstructor);
                        if (!Wrapper.Companion.mustBeHandledWithWrapper(irClass)) break block10;
                        this.invokeMethod(Wrapper.Companion.getConstructorMethod(irConstructor), irConstructor, args);
                        if (UtilsKt.isSubclassOfThrowable(irClass)) {
                            Intrinsics.checkNotNull((Object)receiver, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.ExceptionState");
                            v0 = (ExceptionState)receiver;
                            v1 = this.callStack.popState();
                            Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Wrapper");
                            v0.copyFieldsFrom((Wrapper)v1);
                        } else if (constructorCall instanceof IrConstructorCall) {
                            this.callStack.rewriteState(UtilsKt.getThisReceiver(constructorCall), this.callStack.popState());
                        } else {
                            Intrinsics.checkNotNull((Object)receiver, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Complex");
                            v2 = (Complex)receiver;
                            v3 = this.callStack.popState();
                            Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Wrapper");
                            v2.setSuperWrapperClass((Wrapper)v3);
                        }
                        break block11;
                    }
                    if (!IrTypePredicatesKt.isArray(IrUtilsKt.getDefaultType(irClass)) && !UtilsKt.isPrimitiveArray(IrUtilsKt.getDefaultType(irClass))) break block12;
                    value$iv = this.handleIntrinsicMethods(irConstructor);
                    $i$f$verify = false;
                    if (!value$iv) {
                        $i$a$-verify-DefaultCallInterceptor$interceptConstructor$1 = false;
                        var17_14 = ("Unsupported intrinsic constructor: " + RenderIrElementKt.render$default(irConstructor, null, 1, null)).toString();
                        throw new InterpreterAssertionError(var17_14);
                    }
                    break block11;
                }
                if (!IrTypePredicatesKt.isUnsignedType$default(IrUtilsKt.getDefaultType(irClass), false, 1, null)) break block13;
                $this$single$iv = irClass.getDeclarations();
                $i$f$single = false;
                single$iv = null;
                found$iv = false;
                for (T element$iv : $this$single$iv) {
                    it = (IrDeclaration)element$iv;
                    $i$a$-single-DefaultCallInterceptor$interceptConstructor$propertySymbol$1 = false;
                    if (!(it instanceof IrProperty)) ** GOTO lbl-1000
                    v4 /* !! */  = ((IrProperty)it).getGetter();
                    v5 = v4 /* !! */  != null && (v4 /* !! */  = v4 /* !! */ .getReturnType()) != null ? IrTypePredicatesKt.isPrimitiveType$default((IrType)v4 /* !! */ , false, 1, null) : false;
                    if (v5) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                    if (!v6) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                propertySymbol = ((IrDeclaration)single$iv).getSymbol();
                $i$f$single = var8_10 = receiver;
                var16_22 = this.callStack;
                $i$a$-apply-DefaultCallInterceptor$interceptConstructor$2 = false;
                $this$interceptConstructor_u24lambda_u242.setField(propertySymbol, (State)CollectionsKt.single(args));
                var16_22.pushState(var8_10);
                break block11;
            }
            defaultAction.invoke();
        }
    }

    @Override
    public void interceptGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull Function0<Unit> defaultAction) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
        IrClass objectClass = (IrClass)expression2.getSymbol().getOwner();
        if (Wrapper.Companion.mustBeHandledWithWrapper(objectClass)) {
            Wrapper result2 = Wrapper.Companion.getCompanionObject(objectClass, this.getEnvironment());
            this.getEnvironment().getMapOfObjects$ir_interpreter().put(expression2.getSymbol(), result2);
            this.callStack.pushState(result2);
        } else {
            defaultAction.invoke();
        }
    }

    @Override
    public void interceptEnumEntry(@NotNull IrEnumEntry enumEntry, @NotNull Function0<Unit> defaultAction) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
        IrClass enumClass2 = IrUtilsKt.getParentAsClass((IrDeclaration)enumEntry.getSymbol().getOwner());
        if (Wrapper.Companion.mustBeHandledWithWrapper(enumClass2)) {
            State enumEntryName = this.getEnvironment().convertToState$ir_interpreter(enumEntry.getName().asString(), this.getEnvironment().getIrBuiltIns().getStringType());
            Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(enumClass2);
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"valueOf")) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunction valueOfFun = single$iv;
            this.invokeMethod(Wrapper.Companion.getEnumEntry(enumClass2), valueOfFun, CollectionsKt.listOf((Object)enumEntryName));
            Map<IrSymbol, Complex> map = this.getEnvironment().getMapOfEnums$ir_interpreter();
            IrEnumEntrySymbol irEnumEntrySymbol = enumEntry.getSymbol();
            State state = this.callStack.popState();
            Intrinsics.checkNotNull((Object)state, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Complex");
            Complex complex = (Complex)state;
            map.put(irEnumEntrySymbol, complex);
        } else {
            defaultAction.invoke();
        }
    }

    @Override
    public void interceptJavaStaticField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrField field2 = (IrField)expression2.getSymbol().getOwner();
        ExceptionUtilsKt.verify(Intrinsics.areEqual((Object)field2.getOrigin(), (Object)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE) && field2.isStatic());
        IrExpressionBody irExpressionBody = field2.getInitializer();
        ExceptionUtilsKt.verify(!((irExpressionBody != null ? irExpressionBody.getExpression() : null) instanceof IrConst));
        this.callStack.pushState(this.getEnvironment().convertToState$ir_interpreter(Wrapper.Companion.getStaticGetter(field2).invokeWithArguments(new Object[0]), field2.getType()));
    }

    private final void invokeMethod(MethodHandle $this$invokeMethod, IrFunction irFunction2, List<? extends State> args) {
        if ($this$invokeMethod == null) {
            boolean value$iv = this.handleIntrinsicMethods(irFunction2);
            boolean $i$f$verify = false;
            if (!value$iv) {
                boolean bl = false;
                String string2 = ("Unsupported intrinsic function: " + RenderIrElementKt.render$default(irFunction2, null, 1, null)).toString();
                throw new InterpreterAssertionError(string2);
            }
            return;
        }
        CallInterceptor callInterceptor = this;
        MethodType methodType = $this$invokeMethod.type();
        Intrinsics.checkNotNullExpressionValue((Object)methodType, (String)"type(...)");
        List<Object> argsForMethodInvocation = UtilsKt.getArgsForMethodInvocation(irFunction2, callInterceptor, methodType, args);
        IrInterpreterEnvironment environment$iv = this.getEnvironment();
        boolean $i$f$withExceptionHandler = false;
        try {
            boolean bl = false;
            Object result2 = $this$invokeMethod.invokeWithArguments(argsForMethodInvocation);
            this.callStack.pushState(this.getEnvironment().convertToState$ir_interpreter(result2, this.getType(result2, irFunction2.getReturnType())));
        }
        catch (InterpreterException e$iv) {
            throw e$iv;
        }
        catch (Throwable e$iv) {
            ExceptionUtilsKt.handleUserException(e$iv, environment$iv);
        }
    }

    private final boolean handleIntrinsicMethods(IrFunction irFunction2) {
        List<Instruction> list2 = IntrinsicEvaluator.INSTANCE.unwindInstructions(irFunction2, this.getEnvironment());
        if (list2 == null) {
            return false;
        }
        List<Instruction> instructions = list2;
        Iterable $this$forEach$iv = instructions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Instruction it = (Instruction)element$iv;
            boolean bl = false;
            this.callStack.pushInstruction(it);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateBuiltIns(IrFunction irFunction2, List<? extends State> args) {
        IrType it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        IrProperty property = UtilsKt.getProperty(irFunction2);
        String string2 = property == null ? irFunction2.getName().asString() : property.getName().asString();
        Intrinsics.checkNotNull((Object)string2);
        String methodName = string2;
        IrAnnotationContainer irAnnotationContainer = irFunction2.getDispatchReceiverParameter();
        if (irAnnotationContainer == null || (irAnnotationContainer = irAnnotationContainer.getType()) == null) {
            IrValueParameter irValueParameter = irFunction2.getExtensionReceiverParameter();
            irAnnotationContainer = irValueParameter != null ? irValueParameter.getType() : null;
        }
        IrAnnotationContainer receiverType = irAnnotationContainer;
        Iterable iterable = irFunction2.getValueParameters();
        Collection collection = CollectionsKt.listOfNotNull((Object)receiverType);
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getType());
        }
        $this$map$iv = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UtilsKt.fqNameWithNullability(it));
        }
        List argsType = (List)destination$iv$iv;
        List argsValues = ProxyKt.wrap$default(args, (CallInterceptor)this, irFunction2, null, 4, null);
        IrInterpreterEnvironment environment$iv = this.getEnvironment();
        boolean $i$f$withExceptionHandler = false;
        try {
            Collection<Arg> collection3;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)methodName, (Object)"rangeTo")) {
                this.calculateRangeTo(irFunction2.getReturnType(), args);
                return;
            }
            Iterable $i$f$mapTo2 = CollectionsKt.zip((Iterable)argsType, (Iterable)argsValues);
            String string3 = methodName;
            DefaultCallInterceptor defaultCallInterceptor = this;
            boolean $i$f$map2 = false;
            void var16_23 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                Pair pair = (Pair)item$iv$iv;
                collection3 = destination$iv$iv2;
                boolean bl2 = false;
                collection3.add(new Arg((String)it2.getFirst(), it2.getSecond()));
            }
            collection3 = (List)destination$iv$iv2;
            List list2 = collection3;
            String string4 = string3;
            Object result2 = defaultCallInterceptor.interpretBuiltinFunction(new Signature(string4, list2));
            this.callStack.pushState(this.getEnvironment().convertToState$ir_interpreter(result2, this.getType(result2, irFunction2.getReturnType())));
        }
        catch (InterpreterException e$iv) {
            throw e$iv;
        }
        catch (Throwable e$iv) {
            ExceptionUtilsKt.handleUserException(e$iv, environment$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Object interpretBuiltinFunction(Signature signature2) {
        Object object;
        if (JsPlatformKt.isJs(this.getEnvironment().getConfiguration().getPlatform())) {
            void $this$filterTo$iv$iv;
            if (Intrinsics.areEqual((Object)signature2.getName(), (Object)"toString")) {
                return UtilsKt.specialToStringForJs(signature2.getArgs().get(0).getValue());
            }
            if (Intrinsics.areEqual((Object)signature2.getName(), (Object)"toFloat")) {
                signature2.setName("toDouble");
            }
            Iterable $this$filter$iv = signature2.getArgs();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Arg it = (Arg)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)"kotlin.Float")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Arg it = (Arg)element$iv;
                boolean bl = false;
                it.setType("kotlin.Double");
                it.setValue(Double.parseDouble(String.valueOf(it.getValue())));
            }
        }
        String name2 = signature2.getName();
        List<Arg> args = signature2.getArgs();
        switch (args.size()) {
            case 1: {
                object = IrBuiltInsMapGeneratedKt.interpretUnaryFunction(name2, args.get(0).getType(), args.get(0).getValue());
                break;
            }
            case 2: {
                object = IrBuiltInsMapGeneratedKt.interpretBinaryFunction(name2, args.get(0).getType(), args.get(1).getType(), args.get(0).getValue(), args.get(1).getValue());
                break;
            }
            case 3: {
                object = IrBuiltInsMapGeneratedKt.interpretTernaryFunction(name2, args.get(0).getType(), args.get(1).getType(), args.get(2).getType(), args.get(0).getValue(), args.get(1).getValue(), args.get(2).getValue());
                break;
            }
            default: {
                throw new InterpreterError("Unsupported number of arguments for invocation as builtin function: " + name2);
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateRangeTo(IrType type2, List<? extends State> args) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(type2);
        Intrinsics.checkNotNull((Object)irClassSymbol);
        IrConstructor constructor2 = (IrConstructor)SequencesKt.first(IrUtilsKt.getConstructors((IrClass)irClassSymbol.getOwner()));
        IrConstructorCall constructorCall = IrTreeBuildUtilsKt.createConstructorCall$default(constructor2, null, 1, null);
        Iterable $this$map$iv = constructor2.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        List constructorValueParameters = (List)destination$iv$iv;
        Iterable $this$map$iv2 = args;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            State bl = (State)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive<*>");
            collection.add((Primitive)it);
        }
        List primitiveValueParameters = (List)destination$iv$iv2;
        Iterable $this$forEachIndexed$iv = primitiveValueParameters;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void primitive;
            int n;
            Object item$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (Primitive)item$iv;
            int index2 = n;
            boolean bl = false;
            constructorCall.putValueArgument(index2, IrTreeBuildUtilsKt.toIrConst$default(primitive.getValue(), ((IrValueParameter)((IrValueParameterSymbol)constructorValueParameters.get(index2)).getOwner()).getType(), 0, 0, 6, null));
        }
        InstructionKt.pushCompoundInstruction(this.callStack, constructorCall);
    }

    private final IrType getType(Object $this$getType, IrType defaultType) {
        Object object = $this$getType;
        return object instanceof Boolean ? this.getIrBuiltIns().getBooleanType() : (object instanceof Character ? this.getIrBuiltIns().getCharType() : (object instanceof Byte ? this.getIrBuiltIns().getByteType() : (object instanceof Short ? this.getIrBuiltIns().getShortType() : (object instanceof Integer ? this.getIrBuiltIns().getIntType() : (object instanceof Long ? this.getIrBuiltIns().getLongType() : (object instanceof String ? this.getIrBuiltIns().getStringType() : (object instanceof Float ? this.getIrBuiltIns().getFloatType() : (object instanceof Double ? this.getIrBuiltIns().getDoubleType() : (object == null ? this.getIrBuiltIns().getNothingNType() : defaultType)))))))));
    }

    private final IrElement trySubstituteFunctionBody(IrFunction $this$trySubstituteFunctionBody) {
        IdSignature idSignature = $this$trySubstituteFunctionBody.getSymbol().getSignature();
        if (idSignature == null) {
            return null;
        }
        IdSignature signature2 = idSignature;
        IrBody irBody = this.bodyMap.get(signature2);
        if (irBody == null) {
            return null;
        }
        $this$trySubstituteFunctionBody.setBody(irBody);
        InstructionKt.pushCompoundInstruction(this.callStack, $this$trySubstituteFunctionBody);
        return $this$trySubstituteFunctionBody.getBody();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\u001f\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor$Arg;", "", "type", "", "value", "(Ljava/lang/String;Ljava/lang/Object;)V", "getType", "()Ljava/lang/String;", "setType", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "ir.interpreter"})
    private static final class Arg {
        @NotNull
        private String type;
        @Nullable
        private Object value;

        public Arg(@NotNull String type2, @Nullable Object value2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            this.type = type2;
            this.value = value2;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final void setType(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.type = string2;
        }

        @Nullable
        public final Object getValue() {
            return this.value;
        }

        public final void setValue(@Nullable Object object) {
            this.value = object;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @Nullable
        public final Object component2() {
            return this.value;
        }

        @NotNull
        public final Arg copy(@NotNull String type2, @Nullable Object value2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new Arg(type2, value2);
        }

        public static /* synthetic */ Arg copy$default(Arg arg, String string2, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                string2 = arg.type;
            }
            if ((n & 2) != 0) {
                object = arg.value;
            }
            return arg.copy(string2, object);
        }

        @NotNull
        public String toString() {
            return "Arg(type=" + this.type + ", value=" + this.value + ')';
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + (this.value == null ? 0 : this.value.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Arg)) {
                return false;
            }
            Arg arg = (Arg)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)arg.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)arg.value);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor$Signature;", "", "name", "", "args", "", "Lorg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor$Arg;", "(Ljava/lang/String;Ljava/util/List;)V", "getArgs", "()Ljava/util/List;", "setArgs", "(Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "ir.interpreter"})
    private static final class Signature {
        @NotNull
        private String name;
        @NotNull
        private List<Arg> args;

        public Signature(@NotNull String name2, @NotNull List<Arg> args) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            this.name = name2;
            this.args = args;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.name = string2;
        }

        @NotNull
        public final List<Arg> getArgs() {
            return this.args;
        }

        public final void setArgs(@NotNull List<Arg> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
            this.args = list2;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final List<Arg> component2() {
            return this.args;
        }

        @NotNull
        public final Signature copy(@NotNull String name2, @NotNull List<Arg> args) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            return new Signature(name2, args);
        }

        public static /* synthetic */ Signature copy$default(Signature signature2, String string2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = signature2.name;
            }
            if ((n & 2) != 0) {
                list2 = signature2.args;
            }
            return signature2.copy(string2, list2);
        }

        @NotNull
        public String toString() {
            return "Signature(name=" + this.name + ", args=" + this.args + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + ((Object)this.args).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Signature)) {
                return false;
            }
            Signature signature2 = (Signature)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)signature2.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.args, signature2.args);
        }
    }
}

