/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.body.resolve;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.CopyUtilsKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirVarargArgumentsExpressionBuilder;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralTypeImplKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001aX\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n`\u000b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\"\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n`\u000bH\u0000\u001a\u0016\u0010\u0010\u001a\u00020\u000e*\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013\"*\u0010\u0002\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\u00018\u00c0\u0002@\u00c0\u0002X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"type", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "resultType", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getResultType", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "setResultType", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)V", "remapArgumentsWithVararg", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lkotlin/collections/LinkedHashMap;", "varargParameter", "varargArrayType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "argumentMapping", "expectedConeType", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "writeResultType", "", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "resolve"})
@SourceDebugExtension(value={"SMAP\nBodyResolveUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BodyResolveUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/BodyResolveUtilsKt\n+ 2 FirVarargArgumentsExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirVarargArgumentsExpressionBuilderKt\n+ 3 FirErrorTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirErrorTypeRefBuilderKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,131:1\n25#1:136\n25#1:137\n27#1,2:142\n51#2,4:132\n60#3,4:138\n26#4:144\n*S KotlinDebug\n*F\n+ 1 BodyResolveUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/BodyResolveUtilsKt\n*L\n90#1:136\n92#1:137\n89#1:142,2\n43#1:132,4\n96#1:138,4\n107#1:144\n*E\n"})
public final class BodyResolveUtilsKt {
    @NotNull
    public static final FirTypeRef getResultType(@NotNull FirExpression $this$resultType) {
        Intrinsics.checkNotNullParameter((Object)$this$resultType, (String)"<this>");
        boolean $i$f$getResultType = false;
        return $this$resultType.getTypeRef();
    }

    public static final void setResultType(@NotNull FirExpression $this$resultType, @NotNull FirTypeRef type2) {
        Intrinsics.checkNotNullParameter((Object)$this$resultType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        boolean $i$f$setResultType = false;
        $this$resultType.replaceTypeRef(type2);
    }

    @NotNull
    public static final LinkedHashMap<FirExpression, FirValueParameter> remapArgumentsWithVararg(@NotNull FirValueParameter varargParameter, @NotNull ConeKotlinType varargArrayType, @NotNull LinkedHashMap<FirExpression, FirValueParameter> argumentMapping) {
        FirVarargArgumentsExpressionBuilder firVarargArgumentsExpressionBuilder;
        Intrinsics.checkNotNullParameter((Object)varargParameter, (String)"varargParameter");
        Intrinsics.checkNotNullParameter((Object)varargArrayType, (String)"varargArrayType");
        Intrinsics.checkNotNullParameter(argumentMapping, (String)"argumentMapping");
        FirTypeRef varargParameterTypeRef = varargParameter.getReturnTypeRef();
        ConeKotlinType coneKotlinType = ArrayUtilsKt.arrayElementType(varargArrayType);
        ConeKotlinType varargElementType2 = coneKotlinType != null ? ConeIntegerLiteralTypeImplKt.approximateIntegerLiteralType$default(coneKotlinType, null, 1, null) : null;
        Set<FirExpression> set = argumentMapping.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        List argumentList2 = CollectionsKt.toList((Iterable)set);
        int indexAfterVarargs = 0;
        indexAfterVarargs = argumentList2.size();
        LinkedHashMap<FirExpression, FirValueParameter> newArgumentMapping = new LinkedHashMap<FirExpression, FirValueParameter>();
        boolean $i$f$buildVarargArgumentsExpression = false;
        FirVarargArgumentsExpressionBuilder $this$remapArgumentsWithVararg_u24lambda_u240 = firVarargArgumentsExpressionBuilder = new FirVarargArgumentsExpressionBuilder();
        boolean bl = false;
        $this$remapArgumentsWithVararg_u24lambda_u240.setVarargElementType(TypeUtilsKt.withReplacedConeType(varargParameterTypeRef, varargElementType2, KtFakeSourceElementKind.VarargArgument.INSTANCE));
        $this$remapArgumentsWithVararg_u24lambda_u240.setTypeRef(TypeUtilsKt.withReplacedConeType(varargParameterTypeRef, varargArrayType, KtFakeSourceElementKind.VarargArgument.INSTANCE));
        int startOffset = Integer.MAX_VALUE;
        int endOffset = 0;
        KtSourceElement firstVarargElementSource = null;
        Iterator iterator2 = argumentList2.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            FirExpression arg = (FirExpression)iterator2.next();
            Map map = argumentMapping;
            Intrinsics.checkNotNull((Object)arg);
            FirValueParameter valueParameter2 = (FirValueParameter)MapsKt.getValue((Map)map, (Object)arg);
            if (Intrinsics.areEqual((Object)valueParameter2, (Object)varargParameter) || valueParameter2.isVararg() && !(arg instanceof FirNamedArgumentExpression)) {
                ((Collection)$this$remapArgumentsWithVararg_u24lambda_u240.getArguments()).add(arg);
                KtSourceElement ktSourceElement = arg.getSource();
                int n2 = ktSourceElement != null ? ktSourceElement.getStartOffset() : Integer.MAX_VALUE;
                startOffset = Math.min(startOffset, n2);
                KtSourceElement ktSourceElement2 = arg.getSource();
                n2 = ktSourceElement2 != null ? ktSourceElement2.getEndOffset() : 0;
                endOffset = Math.max(endOffset, n2);
                if (firstVarargElementSource != null) continue;
                firstVarargElementSource = arg.getSource();
                continue;
            }
            if ($this$remapArgumentsWithVararg_u24lambda_u240.getArguments().isEmpty()) {
                ((Map)newArgumentMapping).put(arg, valueParameter2);
                continue;
            }
            indexAfterVarargs = i;
            break;
        }
        KtSourceElement ktSourceElement = firstVarargElementSource;
        $this$remapArgumentsWithVararg_u24lambda_u240.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.VarargArgument.INSTANCE, startOffset, endOffset) : null);
        FirVarargArgumentsExpression varargArgument = firVarargArgumentsExpressionBuilder.build();
        ((Map)newArgumentMapping).put(varargArgument, varargParameter);
        int n3 = argumentList2.size();
        for (int i = indexAfterVarargs; i < n3; ++i) {
            Object e = argumentList2.get(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            FirExpression arg = (FirExpression)e;
            ((Map)newArgumentMapping).put(arg, MapsKt.getValue((Map)argumentMapping, (Object)arg));
        }
        return newArgumentMapping;
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeResultType(@NotNull FirBlock $this$writeResultType, @NotNull FirSession session) {
        void type$iv;
        void $this$resultType$iv;
        FirTypeRef theType;
        FirTypeRef firTypeRef;
        Intrinsics.checkNotNullParameter((Object)$this$writeResultType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        FirStatement statement2 = (FirStatement)CollectionsKt.lastOrNull($this$writeResultType.getStatements());
        FirExpression resultExpression2 = statement2 instanceof FirExpression ? (FirExpression)statement2 : null;
        statement2 = $this$writeResultType;
        if (resultExpression2 == null) {
            FirExpression $this$resultType$iv2 = $this$writeResultType;
            boolean $i$f$getResultType = false;
            firTypeRef = CopyUtilsKt.resolvedTypeFromPrototype($this$resultType$iv2.getTypeRef(), session.getBuiltinTypes().getUnitType().getType());
        } else {
            FirResolvedTypeRef firResolvedTypeRef;
            FirExpression $this$resultType$iv3 = resultExpression2;
            boolean $i$f$getResultType = false;
            theType = $this$resultType$iv3.getTypeRef();
            if (theType instanceof FirResolvedTypeRef) {
                firResolvedTypeRef = (FirResolvedTypeRef)UtilsKt.copyWithNewSourceKind(theType, KtFakeSourceElementKind.ImplicitTypeRef.INSTANCE);
            } else {
                FirErrorTypeRefBuilder firErrorTypeRefBuilder;
                boolean $i$f$buildErrorTypeRef = false;
                FirErrorTypeRefBuilder $this$writeResultType_u24lambda_u241 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
                boolean bl = false;
                $this$writeResultType_u24lambda_u241.setDiagnostic(new ConeSimpleDiagnostic("No type for block", DiagnosticKind.InferenceError));
                firResolvedTypeRef = firErrorTypeRefBuilder.build();
            }
            firTypeRef = firResolvedTypeRef;
        }
        theType = firTypeRef;
        boolean $i$f$setResultType = false;
        $this$resultType$iv.replaceTypeRef((FirTypeRef)type$iv);
    }

    @NotNull
    public static final ConeKotlinType expectedConeType(@NotNull ConstantValueKind<?> $this$expectedConeType, @NotNull FirSession session) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter($this$expectedConeType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ConstantValueKind<?> constantValueKind = $this$expectedConeType;
        if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Null.INSTANCE)) {
            coneKotlinType = session.getBuiltinTypes().getNullableNothingType().getType();
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE)) {
            coneKotlinType = session.getBuiltinTypes().getBooleanType().getType();
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Char.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getChar(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getByte(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Short.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getShort(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Int.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getInt(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Long.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getLong(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.String.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getString(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Float.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getFloat(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Double.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getDouble(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedByte.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getUByte(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedShort.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getUShort(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedInt.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getUInt(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedLong.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getULong(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.IntegerLiteral.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getInt(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedIntegerLiteral.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getUInt(), false, 4, null);
        } else {
            if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Error.INSTANCE)) {
                throw new IllegalStateException("Unexpected error ConstantValueKind".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType;
    }

    private static final ConeKotlinType expectedConeType$constructLiteralType(FirSession $session, ClassId classId, boolean isNullable) {
        FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider($session).getClassLikeSymbolByClassId(classId);
        if (firClassLikeSymbol == null) {
            return new ConeErrorType(new ConeSimpleDiagnostic("Missing stdlib class: " + classId, DiagnosticKind.MissingStdlibClass), false, null, null, 14, null);
        }
        FirClassLikeSymbol<?> symbol2 = firClassLikeSymbol;
        boolean $i$f$emptyArray = false;
        return TypeConstructionUtilsKt.constructClassType$default(symbol2.toLookupTag(), new ConeTypeProjection[0], isNullable, null, 4, null);
    }

    static /* synthetic */ ConeKotlinType expectedConeType$constructLiteralType$default(FirSession firSession, ClassId classId, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return BodyResolveUtilsKt.expectedConeType$constructLiteralType(firSession, classId, bl);
    }
}

