/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.CopyUtilsKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.builder.FirImplicitInvokeCallBuilder;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.FirTypeAttributeExtension;
import org.jetbrains.kotlin.fir.extensions.FirTypeAttributeExtensionKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeAttribute;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttribute;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a@\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0004\u001a\u00020\u00052\u0012\b\u0002\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00022\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u001a)\u0010\f\u001a\u00020\r*\u00020\u000e2\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\u0002\b\u0013H\u0086\b\u00f8\u0001\u0000\u001a\u0012\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001b\u001a\u0012\u0010\u001c\u001a\u00020\u001d*\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0016\u0010 \u001a\u0004\u0018\u00010!*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\""}, d2={"computeTypeAttributes", "Lorg/jetbrains/kotlin/fir/types/ConeAttributes;", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "predefined", "Lorg/jetbrains/kotlin/fir/types/ConeAttribute;", "containerDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "shouldExpandTypeAliases", "", "copyAsImplicitInvokeCall", "Lorg/jetbrains/kotlin/fir/expressions/FirImplicitInvokeCall;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "setupCopy", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirImplicitInvokeCallBuilder;", "", "Lkotlin/ExtensionFunctionType;", "errorTypeFromPrototype", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "extractContextReceiversCount", "", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;)Ljava/lang/Integer;", "resolvedTypeFromPrototype", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "tryExpandClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "providers"})
@SourceDebugExtension(value={"SMAP\nCopyUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopyUtils.kt\norg/jetbrains/kotlin/fir/CopyUtilsKt\n+ 2 FirImplicitInvokeCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirImplicitInvokeCallBuilderKt\n+ 3 FirErrorTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirErrorTypeRefBuilderKt\n+ 4 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 5 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,138:1\n82#2,4:139\n60#3,4:143\n60#3,4:151\n51#4,4:147\n34#5:155\n34#5:156\n*S KotlinDebug\n*F\n+ 1 CopyUtils.kt\norg/jetbrains/kotlin/fir/CopyUtilsKt\n*L\n30#1:139,4\n48#1:143,4\n70#1:151,4\n54#1:147,4\n130#1:155\n131#1:156\n*E\n"})
public final class CopyUtilsKt {
    @NotNull
    public static final FirImplicitInvokeCall copyAsImplicitInvokeCall(@NotNull FirFunctionCall $this$copyAsImplicitInvokeCall, @NotNull Function1<? super FirImplicitInvokeCallBuilder, Unit> setupCopy) {
        FirImplicitInvokeCallBuilder firImplicitInvokeCallBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$copyAsImplicitInvokeCall, (String)"<this>");
        Intrinsics.checkNotNullParameter(setupCopy, (String)"setupCopy");
        boolean $i$f$copyAsImplicitInvokeCall = false;
        FirFunctionCall original = $this$copyAsImplicitInvokeCall;
        boolean $i$f$buildImplicitInvokeCall = false;
        FirImplicitInvokeCallBuilder $this$copyAsImplicitInvokeCall_u24lambda_u240 = firImplicitInvokeCallBuilder = new FirImplicitInvokeCallBuilder();
        boolean bl = false;
        $this$copyAsImplicitInvokeCall_u24lambda_u240.setSource(original.getSource());
        $this$copyAsImplicitInvokeCall_u24lambda_u240.getAnnotations().addAll((Collection<FirAnnotation>)original.getAnnotations());
        $this$copyAsImplicitInvokeCall_u24lambda_u240.getTypeArguments().addAll((Collection<FirTypeProjection>)original.getTypeArguments());
        $this$copyAsImplicitInvokeCall_u24lambda_u240.setExplicitReceiver(original.getExplicitReceiver());
        $this$copyAsImplicitInvokeCall_u24lambda_u240.setDispatchReceiver(original.getDispatchReceiver());
        $this$copyAsImplicitInvokeCall_u24lambda_u240.setExtensionReceiver(original.getExtensionReceiver());
        $this$copyAsImplicitInvokeCall_u24lambda_u240.setArgumentList(original.getArgumentList());
        $this$copyAsImplicitInvokeCall_u24lambda_u240.setCalleeReference(original.getCalleeReference());
        setupCopy.invoke((Object)$this$copyAsImplicitInvokeCall_u24lambda_u240);
        return firImplicitInvokeCallBuilder.build();
    }

    @NotNull
    public static final FirResolvedTypeRef resolvedTypeFromPrototype(@NotNull FirTypeRef $this$resolvedTypeFromPrototype, @NotNull ConeKotlinType type2) {
        FirResolvedTypeRef firResolvedTypeRef;
        Intrinsics.checkNotNullParameter((Object)$this$resolvedTypeFromPrototype, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (type2 instanceof ConeErrorType) {
            FirErrorTypeRefBuilder firErrorTypeRefBuilder;
            boolean $i$f$buildErrorTypeRef = false;
            FirErrorTypeRefBuilder $this$resolvedTypeFromPrototype_u24lambda_u241 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
            boolean bl = false;
            $this$resolvedTypeFromPrototype_u24lambda_u241.setSource($this$resolvedTypeFromPrototype.getSource());
            $this$resolvedTypeFromPrototype_u24lambda_u241.setType(type2);
            $this$resolvedTypeFromPrototype_u24lambda_u241.setDiagnostic(((ConeErrorType)type2).getDiagnostic());
            firResolvedTypeRef = firErrorTypeRefBuilder.build();
        } else {
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
            boolean $i$f$buildResolvedTypeRef = false;
            FirResolvedTypeRefBuilder $this$resolvedTypeFromPrototype_u24lambda_u242 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            boolean bl = false;
            $this$resolvedTypeFromPrototype_u24lambda_u242.setSource($this$resolvedTypeFromPrototype.getSource());
            $this$resolvedTypeFromPrototype_u24lambda_u242.setType(type2);
            FirTypeRef original = $this$resolvedTypeFromPrototype;
            $this$resolvedTypeFromPrototype_u24lambda_u242.setDelegatedTypeRef(original instanceof FirResolvedTypeRef ? ((FirResolvedTypeRef)original).getDelegatedTypeRef() : (original instanceof FirUserTypeRef ? original : null));
            CollectionsKt.addAll((Collection)$this$resolvedTypeFromPrototype_u24lambda_u242.getAnnotations(), (Iterable)$this$resolvedTypeFromPrototype.getAnnotations());
            firResolvedTypeRef = firResolvedTypeRefBuilder.build();
        }
        return firResolvedTypeRef;
    }

    @NotNull
    public static final FirErrorTypeRef errorTypeFromPrototype(@NotNull FirTypeRef $this$errorTypeFromPrototype, @NotNull ConeDiagnostic diagnostic) {
        FirErrorTypeRefBuilder firErrorTypeRefBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$errorTypeFromPrototype, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        boolean $i$f$buildErrorTypeRef = false;
        FirErrorTypeRefBuilder $this$errorTypeFromPrototype_u24lambda_u243 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
        boolean bl = false;
        $this$errorTypeFromPrototype_u24lambda_u243.setSource($this$errorTypeFromPrototype.getSource());
        $this$errorTypeFromPrototype_u24lambda_u243.setDiagnostic(diagnostic);
        return firErrorTypeRefBuilder.build();
    }

    @NotNull
    public static final ConeAttributes computeTypeAttributes(@NotNull List<? extends FirAnnotation> $this$computeTypeAttributes, @NotNull FirSession session, @NotNull List<? extends ConeAttribute<?>> predefined, @Nullable FirDeclaration containerDeclaration, boolean shouldExpandTypeAliases) {
        Intrinsics.checkNotNullParameter($this$computeTypeAttributes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(predefined, (String)"predefined");
        if ($this$computeTypeAttributes.isEmpty()) {
            if (predefined.isEmpty()) {
                return ConeAttributes.Companion.getEmpty();
            }
            return ConeAttributes.Companion.create(predefined);
        }
        List attributes2 = new ArrayList();
        CollectionsKt.addAll((Collection)attributes2, (Iterable)predefined);
        List customAnnotations = new ArrayList();
        for (FirAnnotation firAnnotation : $this$computeTypeAttributes) {
            ConeAttribute<?> attributeFromPlugin;
            block15: {
                ConeAttribute<?> coneAttribute;
                ClassId classId;
                ClassId classId2;
                boolean bl = shouldExpandTypeAliases;
                if (bl) {
                    classId2 = CopyUtilsKt.tryExpandClassId(firAnnotation, session);
                } else if (!bl) {
                    classId2 = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(firAnnotation.getTypeRef()));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                ClassId classId3 = classId = classId2;
                if (Intrinsics.areEqual((Object)classId3, (Object)CompilerConeAttributes.Exact.INSTANCE.getANNOTATION_CLASS_ID())) {
                    ((Collection)attributes2).add(CompilerConeAttributes.Exact.INSTANCE);
                    continue;
                }
                if (Intrinsics.areEqual((Object)classId3, (Object)CompilerConeAttributes.NoInfer.INSTANCE.getANNOTATION_CLASS_ID())) {
                    ((Collection)attributes2).add(CompilerConeAttributes.NoInfer.INSTANCE);
                    continue;
                }
                if (Intrinsics.areEqual((Object)classId3, (Object)CompilerConeAttributes.ExtensionFunctionType.INSTANCE.getANNOTATION_CLASS_ID())) {
                    ((Collection)attributes2).add(CompilerConeAttributes.ExtensionFunctionType.INSTANCE);
                    continue;
                }
                if (Intrinsics.areEqual((Object)classId3, (Object)CompilerConeAttributes.ContextFunctionTypeParams.Companion.getANNOTATION_CLASS_ID())) {
                    Collection collection = attributes2;
                    Integer n = CopyUtilsKt.extractContextReceiversCount(firAnnotation);
                    CompilerConeAttributes.ContextFunctionTypeParams contextFunctionTypeParams = new CompilerConeAttributes.ContextFunctionTypeParams(n != null ? n : 0);
                    collection.add(contextFunctionTypeParams);
                    continue;
                }
                if (Intrinsics.areEqual((Object)classId3, (Object)CompilerConeAttributes.UnsafeVariance.INSTANCE.getANNOTATION_CLASS_ID())) {
                    ((Collection)attributes2).add(CompilerConeAttributes.UnsafeVariance.INSTANCE);
                    continue;
                }
                for (FirTypeAttributeExtension it : (Iterable)FirTypeAttributeExtensionKt.getTypeAttributeExtensions(FirExtensionServiceKt.getExtensionService(session))) {
                    boolean bl2 = false;
                    ConeAttribute<?> coneAttribute2 = it.extractAttributeFromAnnotation(firAnnotation);
                    if (coneAttribute2 == null) continue;
                    coneAttribute = coneAttribute2;
                    break block15;
                }
                coneAttribute = attributeFromPlugin = null;
            }
            if (attributeFromPlugin != null) {
                ((Collection)attributes2).add(attributeFromPlugin);
                continue;
            }
            ((Collection)customAnnotations).add(firAnnotation);
        }
        if (!((Collection)customAnnotations).isEmpty()) {
            FirDeclaration firDeclaration = containerDeclaration;
            ((Collection)attributes2).add(new CustomAnnotationTypeAttribute((List<? extends FirAnnotation>)customAnnotations, firDeclaration != null ? firDeclaration.getSymbol() : null));
        }
        return ConeAttributes.Companion.create(attributes2);
    }

    public static /* synthetic */ ConeAttributes computeTypeAttributes$default(List list2, FirSession firSession, List list3, FirDeclaration firDeclaration, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            firDeclaration = null;
        }
        return CopyUtilsKt.computeTypeAttributes(list2, firSession, list3, firDeclaration, bl);
    }

    private static final ClassId tryExpandClassId(FirAnnotation $this$tryExpandClassId, FirSession session) {
        ClassId classId;
        ConeClassLikeType directlyExpanded2;
        FirAnnotation $this$unexpandedConeClassLikeType$iv = $this$tryExpandClassId;
        boolean $i$f$getUnexpandedConeClassLikeType = false;
        FirTypeRef firTypeRef = $this$unexpandedConeClassLikeType$iv.getAnnotationTypeRef();
        FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        ConeClassLikeType coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        ConeClassLikeType coneClassLikeType2 = directlyExpanded2 = coneClassLikeType != null ? TypeExpansionUtilsKt.directExpansionType(coneClassLikeType, session, (Function1<? super FirTypeAlias, ? extends ConeClassLikeType>)((Function1)tryExpandClassId.directlyExpanded.1.INSTANCE)) : null;
        if (directlyExpanded2 == null) {
            $this$unexpandedConeClassLikeType$iv = $this$tryExpandClassId;
            $i$f$getUnexpandedConeClassLikeType = false;
            firTypeRef = $this$unexpandedConeClassLikeType$iv.getAnnotationTypeRef();
            FirResolvedTypeRef firResolvedTypeRef2 = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
            coneKotlinType = firResolvedTypeRef2 != null ? firResolvedTypeRef2.getType() : null;
            ConeClassLikeType coneClassLikeType3 = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
            classId = coneClassLikeType3 != null ? ConeTypeUtilsKt.getClassId(coneClassLikeType3) : null;
        } else {
            classId = ConeTypeUtilsKt.getClassId(TypeExpansionUtilsKt.fullyExpandedType$default(directlyExpanded2, session, null, 2, null));
        }
        return classId;
    }

    private static final Integer extractContextReceiversCount(FirAnnotation $this$extractContextReceiversCount) {
        FirExpression firExpression2 = $this$extractContextReceiversCount.getArgumentMapping().getMapping().get(StandardNames.CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME);
        FirConstExpression firConstExpression = firExpression2 instanceof FirConstExpression ? (FirConstExpression)firExpression2 : null;
        Object t = firConstExpression != null ? firConstExpression.getValue() : null;
        return t instanceof Integer ? (Integer)t : null;
    }
}

