/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.CfgContainingDeclarationUtilsKt;
import org.jetbrains.kotlin.cfg.ConstructorConsistencyChecker;
import org.jetbrains.kotlin.cfg.ControlFlowInformationProvider;
import org.jetbrains.kotlin.cfg.ControlFlowInformationProviderImpl;
import org.jetbrains.kotlin.cfg.ControlFlowProcessor;
import org.jetbrains.kotlin.cfg.ReadOnlyControlFlowInfo;
import org.jetbrains.kotlin.cfg.TailInstructionDetector;
import org.jetbrains.kotlin.cfg.TailRecursionKind;
import org.jetbrains.kotlin.cfg.UnreachableCode;
import org.jetbrains.kotlin.cfg.UnreachableCodeImpl;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtil;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtilsKt;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.KtElementInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.CallInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.InstructionWithValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.LoadUnitValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MergeInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.ReadValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.WriteValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ConditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.JumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.NondeterministicJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ReturnNoValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ReturnValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.UnconditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.LocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.MarkInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineExitInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.VariableDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.Edges;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.PseudocodeTraverserKt;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraversalOrder;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraverseInstructionResult;
import org.jetbrains.kotlin.cfg.variable.BlockScopeVariableInfo;
import org.jetbrains.kotlin.cfg.variable.PseudocodeVariablesData;
import org.jetbrains.kotlin.cfg.variable.VariableControlFlowState;
import org.jetbrains.kotlin.cfg.variable.VariableInitReadOnlyControlFlowInfo;
import org.jetbrains.kotlin.cfg.variable.VariableUseState;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorPsiUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilityUtils;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.incremental.components.EnumWhenTracker;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerKt;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.KtDescriptorUtilKt;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CapturingInClosureCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.calls.util.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.checkers.PlatformDiagnosticSuppressor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.IncrementalTrackerUtilKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u007f2\u00020\u0001:\f~\u007f\u0080\u0001\u0081\u0001\u0082\u0001\u0083\u0001\u0084\u0001B3\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fB9\b\u0002\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010 \u001a\u00020\u001c2\n\u0010!\u001a\u00060\"R\u00020\u00002\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020&H\u0016J\u0018\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J(\u0010-\u001a\u00020&2\b\u0010.\u001a\u0004\u0018\u00010*2\u0006\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0002J\b\u00104\u001a\u00020&H\u0016J\u0010\u00105\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u00106\u001a\u00020&2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\b\u00107\u001a\u00020&H\u0002J\u0010\u00108\u001a\u00020&2\u0006\u0010#\u001a\u00020$H\u0002J\u001c\u00109\u001a\u00020\u001c2\n\u0010!\u001a\u00060\"R\u00020\u00002\u0006\u0010#\u001a\u00020$H\u0002J*\u0010:\u001a\u00020&2\n\u0010!\u001a\u00060\"R\u00020\u00002\u0006\u0010/\u001a\u00020\u00032\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001d0<H\u0002J\b\u0010=\u001a\u00020&H\u0002J2\u0010>\u001a\u00020\u001c2\n\u0010!\u001a\u00060\"R\u00020\u00002\u0006\u0010#\u001a\u00020$2\u0006\u0010?\u001a\u00020@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001d0<H\u0002J\b\u0010B\u001a\u00020&H\u0002J\"\u0010C\u001a\u00020&2\b\u0010.\u001a\u0004\u0018\u00010*2\u0006\u0010/\u001a\u0002002\u0006\u0010D\u001a\u00020EH\u0002J\b\u0010F\u001a\u00020GH\u0002J\b\u0010H\u001a\u00020,H\u0002J\u0018\u0010I\u001a\u00020\u001c2\u0006\u0010J\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010K\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u0003H\u0002J\u0010\u0010L\u001a\u00020&2\u0006\u0010M\u001a\u00020NH\u0002J\b\u0010O\u001a\u00020&H\u0002J\b\u0010P\u001a\u00020&H\u0002J\u0010\u0010P\u001a\u00020&2\u0006\u0010Q\u001a\u00020RH\u0002J\u0010\u0010S\u001a\u00020&2\u0006\u0010T\u001a\u00020UH\u0002J\u0010\u0010V\u001a\u00020&2\u0006\u0010T\u001a\u00020UH\u0002J\u0010\u0010W\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010X\u001a\u00020&H\u0002J\b\u0010Y\u001a\u00020&H\u0002J\b\u0010Z\u001a\u00020&H\u0002J\b\u0010[\u001a\u00020&H\u0002J.\u0010\\\u001a\u00020&2\u0006\u0010/\u001a\u00020]2\u0006\u0010J\u001a\u00020\u001d2\n\u0010!\u001a\u00060^R\u00020\u00002\b\u0010_\u001a\u0004\u0018\u00010`H\u0002J$\u0010a\u001a\u00020&2\n\u0010!\u001a\u00060^R\u00020\u00002\u0006\u0010/\u001a\u00020b2\u0006\u0010J\u001a\u00020\u001dH\u0002J\b\u0010c\u001a\u00020&H\u0002J*\u0010c\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010d\u001a\u0014\u0012\u0004\u0012\u00020U\u0012\n\u0012\b\u0012\u0004\u0012\u00020g0f0eH\u0002J\u001c\u0010h\u001a\u00020&2\u0006\u0010i\u001a\u00020j2\n\u0010!\u001a\u00060kR\u00020\u0000H\u0002J\u0010\u0010l\u001a\u00020&2\u0006\u0010+\u001a\u00020,H\u0002J$\u0010m\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010J\u001a\u00020\u001d2\n\u0010!\u001a\u00060\"R\u00020\u0000H\u0002J,\u0010n\u001a\u00020&2\u0006\u0010o\u001a\u00020p2\u0006\u0010#\u001a\u00020$2\u0006\u0010J\u001a\u00020q2\n\u0010!\u001a\u00060\"R\u00020\u0000H\u0002JG\u0010r\u001a\u00020&2<\b\u0004\u0010s\u001a6\u0012\u0013\u0012\u00110u\u00a2\u0006\f\bv\u0012\b\bw\u0012\u0004\b\b(T\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030x\u00a2\u0006\f\bv\u0012\b\bw\u0012\u0004\b\b(y\u0012\u0004\u0012\u00020&0tH\u0082\bJ\f\u0010z\u001a\u00020\u001c*\u00020qH\u0002J\u0010\u0010{\u001a\u00020\u001c*\u00060\"R\u00020\u0000H\u0002J\u0016\u0010|\u001a\u00020\u001c*\u00020u2\b\b\u0002\u0010\r\u001a\u00020\u0003H\u0002J\f\u0010}\u001a\u00020&*\u00020$H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\u00020\u0018*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\u00020\u001c*\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001eR\u0018\u0010\u001f\u001a\u00020\u001c*\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001e\u00a8\u0006\u0085\u0001"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProvider;", "declaration", "Lorg/jetbrains/kotlin/psi/KtElement;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "diagnosticSuppressor", "Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;", "enumWhenTracker", "Lorg/jetbrains/kotlin/incremental/components/EnumWhenTracker;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;Lorg/jetbrains/kotlin/incremental/components/EnumWhenTracker;)V", "subroutine", "pseudocode", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;Lorg/jetbrains/kotlin/incremental/components/EnumWhenTracker;)V", "pseudocodeVariablesData", "Lorg/jetbrains/kotlin/cfg/variable/PseudocodeVariablesData;", "getPseudocodeVariablesData", "()Lorg/jetbrains/kotlin/cfg/variable/PseudocodeVariablesData;", "pseudocodeVariablesData$delegate", "Lkotlin/Lazy;", "deparenthesizedParent", "Lcom/intellij/psi/PsiElement;", "getDeparenthesizedParent", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "isLocalVariableWithDelegate", "", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;)Z", "isLocalVariableWithProvideDelegate", "checkAssignmentBeforeDeclaration", "ctxt", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableInitContext;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkConstructorConsistency", "", "checkDeclaration", "checkDefiniteReturn", "expectedReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "unreachableCode", "Lorg/jetbrains/kotlin/cfg/UnreachableCode;", "checkExhaustiveWhenStatement", "subjectType", "element", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "missingCases", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "checkForLocalClassOrObjectMode", "checkForSuspendLambdaAndMarkParameters", "checkFunction", "checkIfExpressions", "checkImplicitCastOnConditionalExpression", "checkInitializationForCustomSetter", "checkIsInitialized", "varWithUninitializedErrorGenerated", "", "checkLocalFunctions", "checkValReassignment", "writeValueInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/WriteValueInstruction;", "varWithValReassignErrorGenerated", "checkWhenExpressions", "checkWhenStatement", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "collectReturnExpressions", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$ReturnedExpressionsInfo;", "collectUnreachableCode", "isCapturedWrite", "variableDescriptor", "isInsideTry", "markAndCheckRecursiveTailCalls", "subroutineDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "markAndCheckTailCalls", "markAnnotationArguments", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "markImplicitReceiverOfSuspendLambda", "instruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "markReadOfSuspendLambdaParameter", "markReadOfSuspendLambdaParameters", "markStatements", "markUninitializedVariables", "markUnusedExpressions", "markUnusedVariables", "processUnusedDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableUseContext;", "variableUseState", "Lorg/jetbrains/kotlin/cfg/variable/VariableUseState;", "processUnusedParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "recordInitializedVariables", "initializersMap", "", "Lorg/jetbrains/kotlin/cfg/pseudocodeTraverser/Edges;", "Lorg/jetbrains/kotlin/cfg/variable/VariableInitReadOnlyControlFlowInfo;", "report", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableContext;", "reportUnreachableCode", "reportValReassigned", "reportVisibilityWarningForInternalFakeSetterOverride", "setterDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertySetterDescriptor;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "traverseCalls", "onCall", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/CallInstruction;", "Lkotlin/ParameterName;", "name", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "isDefinitelyInitialized", "isInitializationBeforeDeclaration", "isTailCall", "recordUsedAsExpression", "AlgebraicTypeKind", "Companion", "Factory", "ReturnedExpressionsInfo", "VariableContext", "VariableInitContext", "VariableUseContext", "cfg"})
@SourceDebugExtension(value={"SMAP\nControlFlowInformationProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlFlowInformationProviderImpl.kt\norg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,1481:1\n1300#1,5:1499\n1#2:1482\n13309#3:1483\n13310#3:1487\n228#4,2:1484\n240#4:1486\n221#4,9:1488\n240#4:1497\n222#4:1498\n*S KotlinDebug\n*F\n+ 1 ControlFlowInformationProviderImpl.kt\norg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl\n*L\n1228#1:1499,5\n1002#1:1483\n1002#1:1487\n1003#1:1484,2\n1003#1:1486\n1012#1:1488,9\n1012#1:1497\n1012#1:1498\n*E\n"})
public final class ControlFlowInformationProviderImpl
implements ControlFlowInformationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtElement subroutine;
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final Pseudocode pseudocode;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final PlatformDiagnosticSuppressor diagnosticSuppressor;
    @Nullable
    private final EnumWhenTracker enumWhenTracker;
    @NotNull
    private final Lazy pseudocodeVariablesData$delegate;

    private ControlFlowInformationProviderImpl(KtElement subroutine, BindingTrace trace, Pseudocode pseudocode, LanguageVersionSettings languageVersionSettings2, PlatformDiagnosticSuppressor diagnosticSuppressor, EnumWhenTracker enumWhenTracker) {
        this.subroutine = subroutine;
        this.trace = trace;
        this.pseudocode = pseudocode;
        this.languageVersionSettings = languageVersionSettings2;
        this.diagnosticSuppressor = diagnosticSuppressor;
        this.enumWhenTracker = enumWhenTracker;
        this.pseudocodeVariablesData$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PseudocodeVariablesData>(this){
            final /* synthetic */ ControlFlowInformationProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PseudocodeVariablesData invoke() {
                Pseudocode pseudocode = ControlFlowInformationProviderImpl.access$getPseudocode$p(this.this$0);
                BindingContext bindingContext = ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                return new PseudocodeVariablesData(pseudocode, bindingContext);
            }
        }));
    }

    private final PseudocodeVariablesData getPseudocodeVariablesData() {
        Lazy lazy = this.pseudocodeVariablesData$delegate;
        return (PseudocodeVariablesData)lazy.getValue();
    }

    public ControlFlowInformationProviderImpl(@NotNull KtElement declaration, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull PlatformDiagnosticSuppressor diagnosticSuppressor, @Nullable EnumWhenTracker enumWhenTracker) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)diagnosticSuppressor, (String)"diagnosticSuppressor");
        this(declaration, trace, new ControlFlowProcessor(trace, languageVersionSettings2).generatePseudocode(declaration), languageVersionSettings2, diagnosticSuppressor, enumWhenTracker);
    }

    public /* synthetic */ ControlFlowInformationProviderImpl(KtElement ktElement, BindingTrace bindingTrace, LanguageVersionSettings languageVersionSettings2, PlatformDiagnosticSuppressor platformDiagnosticSuppressor, EnumWhenTracker enumWhenTracker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            enumWhenTracker = null;
        }
        this(ktElement, bindingTrace, languageVersionSettings2, platformDiagnosticSuppressor, enumWhenTracker);
    }

    @Override
    public void checkForLocalClassOrObjectMode() {
        this.recordInitializedVariables();
    }

    @Override
    public void checkDeclaration() {
        this.recordInitializedVariables();
        this.checkLocalFunctions();
        this.markUninitializedVariables();
        if (this.trace.wantsDiagnostics()) {
            this.markUnusedVariables();
        }
        this.checkForSuspendLambdaAndMarkParameters(this.pseudocode);
        this.markStatements();
        this.markAnnotationArguments();
        this.markUnusedExpressions();
        if (this.trace.wantsDiagnostics()) {
            this.checkIfExpressions();
        }
        this.checkWhenExpressions();
        this.checkConstructorConsistency();
    }

    @Override
    public void checkFunction(@Nullable KotlinType expectedReturnType) {
        UnreachableCode unreachableCode = this.collectUnreachableCode();
        this.reportUnreachableCode(unreachableCode);
        if (this.subroutine instanceof KtFunctionLiteral) {
            return;
        }
        KotlinType kotlinType = expectedReturnType;
        if (kotlinType == null) {
            SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"NO_EXPECTED_TYPE");
            kotlinType = simpleType2;
        }
        this.checkDefiniteReturn(kotlinType, unreachableCode);
        this.markAndCheckTailCalls();
    }

    private final ReturnedExpressionsInfo collectReturnExpressions() {
        HashSet instructions = CollectionsKt.toHashSet((Iterable)this.pseudocode.getInstructions());
        SubroutineExitInstruction exitInstruction = this.pseudocode.getExitInstruction();
        ArrayList<KtElement> returnedExpressions = new ArrayList<KtElement>();
        Ref.BooleanRef hasReturnsInInlinedLambda = new Ref.BooleanRef();
        for (Instruction previousInstruction : exitInstruction.getPreviousInstructions()) {
            previousInstruction.accept(new InstructionVisitor(instructions, returnedExpressions, hasReturnsInInlinedLambda){
                final /* synthetic */ HashSet<Instruction> $instructions;
                final /* synthetic */ ArrayList<KtElement> $returnedExpressions;
                final /* synthetic */ Ref.BooleanRef $hasReturnsInInlinedLambda;
                {
                    this.$instructions = $instructions;
                    this.$returnedExpressions = $returnedExpressions;
                    this.$hasReturnsInInlinedLambda = $hasReturnsInInlinedLambda;
                }

                public void visitReturnValue(@NotNull ReturnValueInstruction instruction) {
                    Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                    if (this.$instructions.contains(instruction)) {
                        this.$returnedExpressions.add(instruction.getElement());
                    }
                    if (instruction.getOwner().isInlined()) {
                        this.$hasReturnsInInlinedLambda.element = true;
                    }
                }

                public void visitReturnNoValue(@NotNull ReturnNoValueInstruction instruction) {
                    Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                    if (this.$instructions.contains(instruction)) {
                        this.$returnedExpressions.add(instruction.getElement());
                    }
                    if (instruction.getOwner().isInlined()) {
                        this.$hasReturnsInInlinedLambda.element = true;
                    }
                }

                public void visitUnconditionalJump(@NotNull UnconditionalJumpInstruction instruction) {
                    Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                    this.redirectToPrevInstructions(instruction);
                }

                public void visitConditionalJump(@NotNull ConditionalJumpInstruction instruction) {
                    Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                    this.redirectToPrevInstructions(instruction);
                }

                private final void redirectToPrevInstructions(Instruction instruction) {
                    for (Instruction redirectInstruction : instruction.getPreviousInstructions()) {
                        redirectInstruction.accept(this);
                    }
                }

                public void visitNondeterministicJump(@NotNull NondeterministicJumpInstruction instruction) {
                    Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                    this.redirectToPrevInstructions(instruction);
                }

                public void visitMarkInstruction(@NotNull MarkInstruction instruction) {
                    Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                    this.redirectToPrevInstructions(instruction);
                }

                public void visitInstruction(@NotNull Instruction instruction) {
                    Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                    if (!(instruction instanceof KtElementInstruction)) {
                        throw new IllegalStateException(instruction + " precedes the exit point");
                    }
                    this.$returnedExpressions.add(((KtElementInstruction)instruction).getElement());
                }
            });
        }
        return new ReturnedExpressionsInfo((Collection<? extends KtElement>)returnedExpressions, hasReturnsInInlinedLambda.element);
    }

    private final void checkLocalFunctions() {
        for (LocalFunctionDeclarationInstruction localDeclarationInstruction : this.pseudocode.getLocalDeclarations()) {
            CallableDescriptor functionDescriptor;
            KtElement element = localDeclarationInstruction.getElement();
            if (!(element instanceof KtDeclarationWithBody)) continue;
            DeclarationDescriptor declarationDescriptor = this.trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
            CallableDescriptor callableDescriptor = functionDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
            KotlinType expectedType = callableDescriptor != null ? callableDescriptor.getReturnType() : null;
            ControlFlowInformationProviderImpl providerForLocalDeclaration = new ControlFlowInformationProviderImpl(element, this.trace, localDeclarationInstruction.getBody(), this.languageVersionSettings, this.diagnosticSuppressor, this.enumWhenTracker);
            providerForLocalDeclaration.checkFunction(expectedType);
        }
    }

    private final void checkDefiniteReturn(KotlinType expectedReturnType, UnreachableCode unreachableCode) {
        KtElement ktElement = this.subroutine;
        KtDeclarationWithBody ktDeclarationWithBody = ktElement instanceof KtDeclarationWithBody ? (KtDeclarationWithBody)ktElement : null;
        if (ktDeclarationWithBody == null) {
            throw new AssertionError((Object)("checkDefiniteReturn is called for " + this.subroutine.getText() + " which is not KtDeclarationWithBody"));
        }
        KtDeclarationWithBody function2 = ktDeclarationWithBody;
        if (!function2.hasBody()) {
            return;
        }
        ReturnedExpressionsInfo returnedExpressionsInfo = this.collectReturnExpressions();
        Collection<KtElement> returnedExpressions = returnedExpressionsInfo.component1();
        boolean hasReturnsInInlinedLambdas = returnedExpressionsInfo.component2();
        boolean blockBody = function2.hasBlockBody();
        Ref.BooleanRef noReturnError = new Ref.BooleanRef();
        for (KtElement returnedExpression : returnedExpressions) {
            returnedExpression.accept(new KtVisitorVoid(blockBody, this, expectedReturnType, unreachableCode, noReturnError){
                final /* synthetic */ boolean $blockBody;
                final /* synthetic */ ControlFlowInformationProviderImpl this$0;
                final /* synthetic */ KotlinType $expectedReturnType;
                final /* synthetic */ UnreachableCode $unreachableCode;
                final /* synthetic */ Ref.BooleanRef $noReturnError;
                {
                    this.$blockBody = $blockBody;
                    this.this$0 = $receiver;
                    this.$expectedReturnType = $expectedReturnType;
                    this.$unreachableCode = $unreachableCode;
                    this.$noReturnError = $noReturnError;
                }

                public void visitReturnExpression(@NotNull KtReturnExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    if (!this.$blockBody) {
                        ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).report(Errors.RETURN_IN_FUNCTION_WITH_EXPRESSION_BODY.on((KtReturnExpression)((PsiElement)expression2)));
                    }
                }

                public void visitKtElement(@NotNull KtElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (!(element instanceof KtExpression) && !(element instanceof KtWhenCondition)) {
                        return;
                    }
                    if (this.$blockBody && !TypeUtils.noExpectedType(this.$expectedReturnType) && !KotlinBuiltIns.isUnit(this.$expectedReturnType) && !this.$unreachableCode.getElements().contains(element)) {
                        this.$noReturnError.element = true;
                    }
                }
            });
        }
        if (noReturnError.element) {
            if (hasReturnsInInlinedLambdas) {
                this.trace.report(Errors.NO_RETURN_IN_FUNCTION_WITH_BLOCK_BODY_MIGRATION.on((KtDeclarationWithBody)((PsiElement)function2)));
            } else {
                this.trace.report(Errors.NO_RETURN_IN_FUNCTION_WITH_BLOCK_BODY.on((KtDeclarationWithBody)((PsiElement)function2)));
            }
        }
    }

    private final void reportUnreachableCode(UnreachableCode unreachableCode) {
        for (KtElement element : unreachableCode.getElements()) {
            this.trace.report(Errors.UNREACHABLE_CODE.on((KtElement)((PsiElement)element), unreachableCode.getReachableElements(), unreachableCode.getUnreachableElements()));
        }
    }

    private final UnreachableCode collectUnreachableCode() {
        HashSet<KtElement> reachableElements = new HashSet<KtElement>();
        HashSet<KtElement> unreachableElements = new HashSet<KtElement>();
        for (Instruction instruction : this.pseudocode.getInstructionsIncludingDeadCode()) {
            boolean isJumpElement;
            if (!(instruction instanceof KtElementInstruction) || instruction instanceof LoadUnitValueInstruction || instruction instanceof MergeInstruction || instruction instanceof MagicInstruction && ((MagicInstruction)instruction).getSynthetic()) continue;
            KtElement element = ((KtElementInstruction)instruction).getElement();
            if (instruction instanceof JumpInstruction && !(isJumpElement = element instanceof KtBreakExpression || element instanceof KtContinueExpression || element instanceof KtReturnExpression || element instanceof KtThrowExpression)) continue;
            if (instruction.getDead()) {
                unreachableElements.add(element);
                continue;
            }
            reachableElements.add(element);
        }
        return new UnreachableCodeImpl((Set<? extends KtElement>)reachableElements, (Set<? extends KtElement>)unreachableElements);
    }

    private final void markUninitializedVariables() {
        HashSet<VariableDescriptor> varWithUninitializedErrorGenerated = new HashSet<VariableDescriptor>();
        HashSet<VariableDescriptor> varWithValReassignErrorGenerated = new HashSet<VariableDescriptor>();
        boolean processClassOrObject = this.subroutine instanceof KtClassOrObject || this.subroutine instanceof KtSecondaryConstructor;
        Map<Instruction, Edges<VariableInitReadOnlyControlFlowInfo>> initializers = this.getPseudocodeVariablesData().getVariableInitializers();
        Set<VariableDescriptor> declaredVariables = this.getPseudocodeVariablesData().getDeclaredVariables(this.pseudocode, true);
        BlockScopeVariableInfo blockScopeVariableInfo = this.getPseudocodeVariablesData().getBlockScopeVariableInfo();
        HashMap reportedDiagnosticMap = new HashMap();
        PseudocodeTraverserKt.traverse(this.pseudocode, TraversalOrder.FORWARD, initializers, (Function3)new Function3<Instruction, VariableInitReadOnlyControlFlowInfo, VariableInitReadOnlyControlFlowInfo, Unit>(this, reportedDiagnosticMap, blockScopeVariableInfo, declaredVariables, varWithUninitializedErrorGenerated, varWithValReassignErrorGenerated, processClassOrObject){
            final /* synthetic */ ControlFlowInformationProviderImpl this$0;
            final /* synthetic */ HashMap<Instruction, DiagnosticFactory<?>> $reportedDiagnosticMap;
            final /* synthetic */ BlockScopeVariableInfo $blockScopeVariableInfo;
            final /* synthetic */ Set<VariableDescriptor> $declaredVariables;
            final /* synthetic */ HashSet<VariableDescriptor> $varWithUninitializedErrorGenerated;
            final /* synthetic */ HashSet<VariableDescriptor> $varWithValReassignErrorGenerated;
            final /* synthetic */ boolean $processClassOrObject;
            {
                this.this$0 = $receiver;
                this.$reportedDiagnosticMap = $reportedDiagnosticMap;
                this.$blockScopeVariableInfo = $blockScopeVariableInfo;
                this.$declaredVariables = $declaredVariables;
                this.$varWithUninitializedErrorGenerated = $varWithUninitializedErrorGenerated;
                this.$varWithValReassignErrorGenerated = $varWithValReassignErrorGenerated;
                this.$processClassOrObject = $processClassOrObject;
                super(3);
            }

            public final void invoke(@NotNull Instruction instruction, @NotNull VariableInitReadOnlyControlFlowInfo enterData, @NotNull VariableInitReadOnlyControlFlowInfo exitData) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                Intrinsics.checkNotNullParameter((Object)enterData, (String)"enterData");
                Intrinsics.checkNotNullParameter((Object)exitData, (String)"exitData");
                VariableInitContext ctxt = this.this$0.new VariableInitContext(instruction, (Map)this.$reportedDiagnosticMap, enterData, exitData, this.$blockScopeVariableInfo);
                if (ctxt.getVariableDescriptor$cfg() == null) {
                    return;
                }
                if (instruction instanceof ReadValueInstruction) {
                    KtElement element = ((ReadValueInstruction)instruction).getElement();
                    if (PseudocodeUtil.isThisOrNoDispatchReceiver((AccessValueInstruction)instruction, ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getBindingContext()) && this.$declaredVariables.contains(ctxt.getVariableDescriptor$cfg())) {
                        ControlFlowInformationProviderImpl.access$checkIsInitialized(this.this$0, ctxt, element, this.$varWithUninitializedErrorGenerated);
                    }
                    return;
                }
                if (!(instruction instanceof WriteValueInstruction)) {
                    return;
                }
                KtElement ktElement = ((WriteValueInstruction)instruction).getLValue();
                KtExpression ktExpression = ktElement instanceof KtExpression ? (KtExpression)ktElement : null;
                if (ktExpression == null) {
                    return;
                }
                KtExpression element = ktExpression;
                boolean error = ControlFlowInformationProviderImpl.access$checkValReassignment(this.this$0, ctxt, element, (WriteValueInstruction)instruction, this.$varWithValReassignErrorGenerated);
                if (!error && this.$processClassOrObject) {
                    error = ControlFlowInformationProviderImpl.access$checkAssignmentBeforeDeclaration(this.this$0, ctxt, element);
                }
                if (!error && this.$processClassOrObject) {
                    ControlFlowInformationProviderImpl.access$checkInitializationForCustomSetter(this.this$0, ctxt, element);
                }
            }
        });
    }

    private final void recordInitializedVariables() {
        Pseudocode pseudocode = this.getPseudocodeVariablesData().getPseudocode();
        Map<Instruction, Edges<VariableInitReadOnlyControlFlowInfo>> initializers = this.getPseudocodeVariablesData().getVariableInitializers();
        this.recordInitializedVariables(pseudocode, initializers);
        for (LocalFunctionDeclarationInstruction instruction : pseudocode.getLocalDeclarations()) {
            this.recordInitializedVariables(instruction.getBody(), initializers);
        }
    }

    private final boolean isDefinitelyInitialized(PropertyDescriptor $this$isDefinitelyInitialized) {
        if (Intrinsics.areEqual(this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, $this$isDefinitelyInitialized), (Object)true)) {
            return false;
        }
        PsiElement property = DescriptorToSourceUtils.descriptorToDeclaration($this$isDefinitelyInitialized);
        return !(property instanceof KtProperty) || !((KtProperty)property).hasDelegate();
    }

    private final void checkIsInitialized(VariableInitContext ctxt, KtElement element, Collection<VariableDescriptor> varWithUninitializedErrorGenerated) {
        block14: {
            VariableDescriptor variableDescriptor;
            VariableDescriptor variableDescriptor2;
            block16: {
                block15: {
                    if (!(element instanceof KtSimpleNameExpression)) {
                        return;
                    }
                    VariableControlFlowState variableControlFlowState = ctxt.getExitInitState$cfg();
                    boolean isDefinitelyInitialized = variableControlFlowState != null ? variableControlFlowState.definitelyInitialized() : false;
                    variableDescriptor2 = ctxt.getVariableDescriptor$cfg();
                    if (!isDefinitelyInitialized && variableDescriptor2 instanceof PropertyDescriptor) {
                        isDefinitelyInitialized = this.isDefinitelyInitialized((PropertyDescriptor)variableDescriptor2);
                    }
                    if (isDefinitelyInitialized || CollectionsKt.contains((Iterable)varWithUninitializedErrorGenerated, (Object)variableDescriptor2)) break block14;
                    if (!(variableDescriptor2 instanceof PropertyDescriptor)) {
                        VariableDescriptor variableDescriptor3 = variableDescriptor2;
                        if (variableDescriptor3 != null) {
                            VariableDescriptor it = variableDescriptor3;
                            boolean bl = false;
                            varWithUninitializedErrorGenerated.add(it);
                        }
                    } else if (((PropertyDescriptor)variableDescriptor2).isLateInit()) {
                        this.trace.record(BindingContext.MUST_BE_LATEINIT, variableDescriptor2);
                        return;
                    }
                    variableDescriptor = variableDescriptor2;
                    if (!(variableDescriptor instanceof ValueParameterDescriptor)) break block15;
                    ParametrizedDiagnostic<KtSimpleNameExpression> parametrizedDiagnostic = Errors.UNINITIALIZED_PARAMETER.on((KtSimpleNameExpression)((PsiElement)element), (ValueParameterDescriptor)variableDescriptor2);
                    Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                    this.report(parametrizedDiagnostic, ctxt);
                    break block14;
                }
                if (!(variableDescriptor instanceof FakeCallableDescriptorForObject)) break block16;
                ClassDescriptor classDescriptor2 = ((FakeCallableDescriptorForObject)variableDescriptor2).getClassDescriptor();
                switch (WhenMappings.$EnumSwitchMapping$0[classDescriptor2.getKind().ordinal()]) {
                    case 1: {
                        ParametrizedDiagnostic<KtSimpleNameExpression> parametrizedDiagnostic = Errors.UNINITIALIZED_ENUM_ENTRY.on((KtSimpleNameExpression)((PsiElement)element), classDescriptor2);
                        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                        this.report(parametrizedDiagnostic, ctxt);
                        break;
                    }
                    case 2: {
                        if (!classDescriptor2.isCompanionObject()) break block14;
                        DeclarationDescriptor declarationDescriptor = classDescriptor2.getContainingDeclaration();
                        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
                        DeclarationDescriptor container = declarationDescriptor;
                        if (!(container instanceof ClassDescriptor) || ((ClassDescriptor)container).getKind() != ClassKind.ENUM_CLASS || this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitAccessToEnumCompanionMembersInEnumConstructorCall)) break block14;
                        ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.UNINITIALIZED_ENUM_COMPANION.on((KtExpression)((PsiElement)element), (ClassDescriptor)container);
                        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                        this.report(parametrizedDiagnostic, ctxt);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block14;
            }
            if (!(variableDescriptor == null || variableDescriptor2.isLateInit() || variableDescriptor2 instanceof MemberDescriptor && DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)((Object)variableDescriptor2)))) {
                ParametrizedDiagnostic<KtSimpleNameExpression> parametrizedDiagnostic = Errors.UNINITIALIZED_VARIABLE.on((KtSimpleNameExpression)((PsiElement)element), variableDescriptor2);
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                this.report(parametrizedDiagnostic, ctxt);
            }
        }
    }

    private final boolean isCapturedWrite(VariableDescriptor variableDescriptor, WriteValueInstruction writeValueInstruction) {
        block5: {
            BindingContext context2;
            DeclarationDescriptor declarationDescriptor = variableDescriptor.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
            DeclarationDescriptor containingDeclarationDescriptor = declarationDescriptor;
            if (containingDeclarationDescriptor instanceof PackageFragmentDescriptor) {
                return false;
            }
            KtDeclaration parentDeclaration = CfgContainingDeclarationUtilsKt.getElementParentDeclaration(writeValueInstruction.getElement());
            while (true) {
                Intrinsics.checkNotNullExpressionValue((Object)this.trace.getBindingContext(), (String)"getBindingContext(...)");
                DeclarationDescriptor parentDescriptor = CfgContainingDeclarationUtilsKt.getDeclarationDescriptorIncludingConstructors(parentDeclaration, context2);
                if (Intrinsics.areEqual((Object)parentDescriptor, (Object)containingDeclarationDescriptor)) {
                    return false;
                }
                KtDeclaration ktDeclaration = parentDeclaration;
                if (ktDeclaration instanceof KtObjectDeclaration ? true : ktDeclaration instanceof KtClassInitializer) {
                    parentDeclaration = CfgContainingDeclarationUtilsKt.getElementParentDeclaration(parentDeclaration);
                    continue;
                }
                if (!(ktDeclaration instanceof KtDeclarationWithBody)) break block5;
                PsiElement maybeEnclosingLambdaExpr = ((KtDeclarationWithBody)parentDeclaration).getParent();
                if (!(maybeEnclosingLambdaExpr instanceof KtLambdaExpression) || this.trace.get(BindingContext.LAMBDA_INVOCATIONS, maybeEnclosingLambdaExpr) == null) break;
                parentDeclaration = CfgContainingDeclarationUtilsKt.getElementParentDeclaration(parentDeclaration);
            }
            if (parentDeclaration instanceof KtFunction && ((KtFunction)parentDeclaration).isLocal()) {
                return true;
            }
            return !Intrinsics.areEqual((Object)CfgContainingDeclarationUtilsKt.getDeclarationDescriptorIncludingConstructors(parentDeclaration = CfgContainingDeclarationUtilsKt.getElementParentDeclaration(parentDeclaration), context2), (Object)containingDeclarationDescriptor);
        }
        return true;
    }

    private final boolean checkValReassignment(VariableInitContext ctxt, KtExpression expression2, WriteValueInstruction writeValueInstruction, Collection<VariableDescriptor> varWithValReassignErrorGenerated) {
        boolean captured2;
        boolean bl;
        VariableDescriptor it;
        Object object;
        boolean mayBeInitializedNotHere;
        VariableDescriptor variableDescriptor;
        block30: {
            block29: {
                variableDescriptor = ctxt.getVariableDescriptor$cfg();
                VariableControlFlowState variableControlFlowState = ctxt.getEnterInitState$cfg();
                mayBeInitializedNotHere = variableControlFlowState != null ? variableControlFlowState.mayBeInitialized() : false;
                object = variableDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)variableDescriptor : null;
                if (object == null) break block29;
                it = object;
                boolean bl2 = false;
                Boolean bl3 = (Boolean)this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, it);
                if (bl3 == null) {
                    bl3 = false;
                }
                object = bl3;
                if (bl3 != null) break block30;
            }
            object = true;
        }
        boolean hasBackingField = (Boolean)object;
        if (variableDescriptor instanceof PropertyDescriptor && ((PropertyDescriptor)variableDescriptor).isVar()) {
            ReceiverValue receiverValue;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            DeclarationDescriptor descriptor2 = BindingContextUtilsKt.getEnclosingDescriptor(bindingContext, expression2);
            PropertySetterDescriptor setterDescriptor = ((PropertyDescriptor)variableDescriptor).getSetter();
            KtElement ktElement = expression2;
            BindingContext bindingContext2 = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"getBindingContext(...)");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext2);
            ReceiverValue receiverValue2 = receiverValue = resolvedCall2 != null ? ResolvedCallUtilKt.getDispatchReceiverWithSmartCast(resolvedCall2) : null;
            if (DescriptorVisibilityUtils.isVisible(receiverValue, variableDescriptor, descriptor2, this.languageVersionSettings) && setterDescriptor != null) {
                if (!DescriptorVisibilityUtils.isVisible(receiverValue, setterDescriptor, descriptor2, this.languageVersionSettings)) {
                    ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.INVISIBLE_SETTER.on((PsiElement)expression2, variableDescriptor, setterDescriptor.getVisibility(), setterDescriptor);
                    Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                    this.report(parametrizedDiagnostic, ctxt);
                    return true;
                }
                this.reportVisibilityWarningForInternalFakeSetterOverride(setterDescriptor, expression2, (PropertyDescriptor)variableDescriptor, ctxt);
            }
        }
        boolean isThisOrNoDispatchReceiver = PseudocodeUtil.isThisOrNoDispatchReceiver(writeValueInstruction, this.trace.getBindingContext());
        VariableDescriptor variableDescriptor2 = variableDescriptor;
        if (variableDescriptor2 != null) {
            it = variableDescriptor2;
            boolean bl4 = false;
            bl = this.isCapturedWrite(it, writeValueInstruction);
        } else {
            bl = captured2 = false;
        }
        if (!(!mayBeInitializedNotHere && hasBackingField && isThisOrNoDispatchReceiver && !captured2 || variableDescriptor == null || variableDescriptor.isVar())) {
            KtSimpleNameExpression operationReference;
            boolean hasReassignMethodReturningUnit = false;
            PsiElement parent2 = expression2.getParent();
            KtSimpleNameExpression ktSimpleNameExpression = parent2 instanceof KtBinaryExpression ? (KtSimpleNameExpression)((KtBinaryExpression)parent2).getOperationReference() : (operationReference = parent2 instanceof KtUnaryExpression ? ((KtUnaryExpression)parent2).getOperationReference() : null);
            if (operationReference != null) {
                DeclarationDescriptor descriptor3 = (DeclarationDescriptor)this.trace.get(BindingContext.REFERENCE_TARGET, operationReference);
                if (descriptor3 instanceof FunctionDescriptor) {
                    boolean bl5;
                    KotlinType kotlinType = ((FunctionDescriptor)descriptor3).getReturnType();
                    if (kotlinType != null) {
                        KotlinType it2 = kotlinType;
                        boolean bl6 = false;
                        bl5 = KotlinBuiltIns.isUnit(it2);
                    } else {
                        bl5 = false;
                    }
                    if (bl5) {
                        hasReassignMethodReturningUnit = true;
                    }
                }
                if (descriptor3 == null) {
                    Collection collection = (Collection)this.trace.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, operationReference);
                    if (collection == null) {
                        collection = CollectionsKt.emptyList();
                    }
                    Collection descriptors = collection;
                    for (DeclarationDescriptor referenceDescriptor : descriptors) {
                        boolean bl7;
                        Annotated annotated = referenceDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)referenceDescriptor : null;
                        if (annotated != null && (annotated = annotated.getReturnType()) != null) {
                            Annotated it3 = annotated;
                            boolean bl8 = false;
                            bl7 = KotlinBuiltIns.isUnit((KotlinType)it3);
                        } else {
                            bl7 = false;
                        }
                        if (!bl7) continue;
                        hasReassignMethodReturningUnit = true;
                    }
                }
            }
            if (!hasReassignMethodReturningUnit) {
                if (!isThisOrNoDispatchReceiver || !varWithValReassignErrorGenerated.contains(variableDescriptor)) {
                    if (captured2 && !mayBeInitializedNotHere && hasBackingField && isThisOrNoDispatchReceiver) {
                        if (variableDescriptor.getContainingDeclaration() instanceof ClassDescriptor) {
                            ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.CAPTURED_MEMBER_VAL_INITIALIZATION.on((KtExpression)((PsiElement)expression2), variableDescriptor);
                            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                            this.report(parametrizedDiagnostic, ctxt);
                        } else {
                            ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.CAPTURED_VAL_INITIALIZATION.on((KtExpression)((PsiElement)expression2), variableDescriptor);
                            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                            this.report(parametrizedDiagnostic, ctxt);
                        }
                    } else if (DescriptorPsiUtilsKt.isBackingFieldReference(variableDescriptor)) {
                        this.reportValReassigned(expression2, variableDescriptor, ctxt);
                    } else {
                        ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.VAL_REASSIGNMENT.on((KtExpression)((PsiElement)expression2), variableDescriptor);
                        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                        this.report(parametrizedDiagnostic, ctxt);
                    }
                }
                if (isThisOrNoDispatchReceiver) {
                    varWithValReassignErrorGenerated.add(variableDescriptor);
                }
                return true;
            }
        }
        return false;
    }

    private final void reportVisibilityWarningForInternalFakeSetterOverride(PropertySetterDescriptor setterDescriptor, KtExpression expression2, PropertyDescriptor variableDescriptor, VariableInitContext ctxt) {
        if (setterDescriptor.getKind().isReal()) {
            return;
        }
        if (setterDescriptor.getVisibility().isPublicAPI()) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = setterDescriptor.getContainingDeclaration();
        ClassDescriptor classDescriptor2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor2 == null) {
            return;
        }
        ClassDescriptor containingClass = classDescriptor2;
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtilsKt.firstOverridden$default(setterDescriptor, false, reportVisibilityWarningForInternalFakeSetterOverride.firstRealOverridden.1.INSTANCE, 1, null);
        if (callableMemberDescriptor == null) {
            return;
        }
        CallableMemberDescriptor firstRealOverridden2 = callableMemberDescriptor;
        Collection<CallableMemberDescriptor> collection = OverridingUtil.filterVisibleFakeOverrides(containingClass, CollectionsKt.listOf((Object)firstRealOverridden2));
        Intrinsics.checkNotNullExpressionValue(collection, (String)"filterVisibleFakeOverrides(...)");
        Collection<CallableMemberDescriptor> visibleOverrides = collection;
        if (visibleOverrides.isEmpty()) {
            DiagnosticFactory3<PsiElement, DeclarationDescriptor, DescriptorVisibility, DeclarationDescriptor> diagnostic = this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitAccessToInvisibleSetterFromDerivedClass) ? Errors.INVISIBLE_SETTER : Errors.INVISIBLE_SETTER_FROM_DERIVED;
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = diagnostic.on((PsiElement)expression2, variableDescriptor, setterDescriptor.getVisibility(), setterDescriptor);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
            this.report(parametrizedDiagnostic, ctxt);
        }
    }

    private final void reportValReassigned(KtExpression expression2, VariableDescriptor variableDescriptor, VariableInitContext ctxt) {
        this.report(Errors.VAL_REASSIGNMENT_VIA_BACKING_FIELD.on(this.languageVersionSettings, (KtExpression)((PsiElement)expression2), variableDescriptor), ctxt);
    }

    private final boolean checkAssignmentBeforeDeclaration(VariableInitContext ctxt, KtExpression expression2) {
        boolean bl;
        if (this.isInitializationBeforeDeclaration(ctxt)) {
            if (ctxt.getVariableDescriptor$cfg() != null) {
                ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.INITIALIZATION_BEFORE_DECLARATION.on((KtExpression)((PsiElement)expression2), ctxt.getVariableDescriptor$cfg());
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                this.report(parametrizedDiagnostic, ctxt);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInitializationBeforeDeclaration(VariableInitContext $this$isInitializationBeforeDeclaration) {
        boolean bl;
        boolean bl2;
        VariableControlFlowState variableControlFlowState = $this$isInitializationBeforeDeclaration.getEnterInitState$cfg();
        if (variableControlFlowState != null) {
            if (variableControlFlowState.isDeclared()) {
                return false;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return false;
        VariableControlFlowState variableControlFlowState2 = $this$isInitializationBeforeDeclaration.getExitInitState$cfg();
        if (variableControlFlowState2 != null) {
            if (variableControlFlowState2.isDeclared()) {
                return false;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return false;
        VariableControlFlowState variableControlFlowState3 = $this$isInitializationBeforeDeclaration.getEnterInitState$cfg();
        if (variableControlFlowState3 == null) return true;
        if (!variableControlFlowState3.mayBeInitialized()) return true;
        return false;
    }

    private final boolean checkInitializationForCustomSetter(VariableInitContext ctxt, KtExpression expression2) {
        KtExpression variable2;
        VariableDescriptor variableDescriptor;
        block7: {
            block6: {
                variableDescriptor = ctxt.getVariableDescriptor$cfg();
                if (!(variableDescriptor instanceof PropertyDescriptor)) break block6;
                VariableControlFlowState variableControlFlowState = ctxt.getEnterInitState$cfg();
                if (variableControlFlowState != null ? variableControlFlowState.mayBeInitialized() : false) break block6;
                VariableControlFlowState variableControlFlowState2 = ctxt.getExitInitState$cfg();
                if ((variableControlFlowState2 != null ? variableControlFlowState2.mayBeInitialized() : false) && Intrinsics.areEqual(this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, variableDescriptor), (Object)true)) break block7;
            }
            return false;
        }
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(variableDescriptor);
        KtProperty ktProperty = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
        if (ktProperty == null) {
            throw new AssertionError((Object)(variableDescriptor + " is not related to KtProperty"));
        }
        KtProperty property = ktProperty;
        KtPropertyAccessor setter2 = property.getSetter();
        if (!(DeclarationsCheckerKt.getEffectiveModality((PropertyDescriptor)variableDescriptor, this.languageVersionSettings) != Modality.FINAL || setter2 != null && setter2.hasBody())) {
            return false;
        }
        KtExpression ktExpression = variable2 = expression2 instanceof KtDotQualifiedExpression && ((KtDotQualifiedExpression)expression2).getReceiverExpression() instanceof KtThisExpression ? ((KtDotQualifiedExpression)expression2).getSelectorExpression() : expression2;
        if (variable2 instanceof KtSimpleNameExpression) {
            this.trace.record(BindingContext.IS_UNINITIALIZED, variableDescriptor);
            return true;
        }
        return false;
    }

    private final void recordInitializedVariables(Pseudocode pseudocode, Map<Instruction, ? extends Edges<? extends VariableInitReadOnlyControlFlowInfo>> initializersMap) {
        Edges<? extends VariableInitReadOnlyControlFlowInfo> edges = initializersMap.get(pseudocode.getExitInstruction());
        if (edges == null) {
            return;
        }
        Edges<? extends VariableInitReadOnlyControlFlowInfo> initializers = edges;
        Set<VariableDescriptor> declaredVariables = this.getPseudocodeVariablesData().getDeclaredVariables(pseudocode, false);
        for (VariableDescriptor variable2 : declaredVariables) {
            if (!(variable2 instanceof PropertyDescriptor)) continue;
            VariableControlFlowState variableControlFlowState = (VariableControlFlowState)initializers.getIncoming().getOrNull(variable2);
            if (variableControlFlowState != null ? variableControlFlowState.definitelyInitialized() : false) continue;
            this.trace.record(BindingContext.IS_DEFINITELY_NOT_ASSIGNED_IN_CONSTRUCTOR, variable2);
            this.trace.record(BindingContext.IS_UNINITIALIZED, variable2);
        }
    }

    private final void markUnusedVariables() {
        Map<Instruction, Edges<ReadOnlyControlFlowInfo<VariableDescriptor, VariableUseState>>> variableStatusData = this.getPseudocodeVariablesData().getVariableUseStatusData();
        HashMap reportedDiagnosticMap = new HashMap();
        HashMap<KtExpression, Pair<VariableDescriptor, VariableUseContext>> unusedValueExpressions = new HashMap<KtExpression, Pair<VariableDescriptor, VariableUseContext>>();
        HashSet<KtExpression> usedValueExpressions = new HashSet<KtExpression>();
        PseudocodeTraverserKt.traverse(this.pseudocode, TraversalOrder.BACKWARD, variableStatusData, (Function3)new Function3<Instruction, ReadOnlyControlFlowInfo<VariableDescriptor, VariableUseState>, ReadOnlyControlFlowInfo<VariableDescriptor, VariableUseState>, Unit>(this, reportedDiagnosticMap, unusedValueExpressions, usedValueExpressions){
            final /* synthetic */ ControlFlowInformationProviderImpl this$0;
            final /* synthetic */ HashMap<Instruction, DiagnosticFactory<?>> $reportedDiagnosticMap;
            final /* synthetic */ HashMap<KtExpression, Pair<VariableDescriptor, VariableUseContext>> $unusedValueExpressions;
            final /* synthetic */ HashSet<KtExpression> $usedValueExpressions;
            {
                this.this$0 = $receiver;
                this.$reportedDiagnosticMap = $reportedDiagnosticMap;
                this.$unusedValueExpressions = $unusedValueExpressions;
                this.$usedValueExpressions = $usedValueExpressions;
                super(3);
            }

            public final void invoke(@NotNull Instruction instruction, @NotNull ReadOnlyControlFlowInfo<VariableDescriptor, VariableUseState> enterData, @NotNull ReadOnlyControlFlowInfo<VariableDescriptor, VariableUseState> readOnlyControlFlowInfo) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                Intrinsics.checkNotNullParameter(enterData, (String)"enterData");
                Intrinsics.checkNotNullParameter(readOnlyControlFlowInfo, (String)"<anonymous parameter 2>");
                VariableUseContext ctxt = this.this$0.new VariableUseContext(instruction, (Map)this.$reportedDiagnosticMap);
                Set<VariableDescriptor> declaredVariables = ControlFlowInformationProviderImpl.access$getPseudocodeVariablesData(this.this$0).getDeclaredVariables(instruction.getOwner(), false);
                VariableDescriptor variableDescriptor = PseudocodeUtil.extractVariableDescriptorIfAny(instruction, ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getBindingContext());
                if (variableDescriptor == null || !declaredVariables.contains(variableDescriptor) || !ExpressionTypingUtils.isLocal(variableDescriptor.getContainingDeclaration(), variableDescriptor)) {
                    return;
                }
                VariableUseState variableUseState = enterData.getOrNull(variableDescriptor);
                Instruction instruction2 = instruction;
                if (instruction2 instanceof WriteValueInstruction) {
                    if (ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).get(BindingContext.CAPTURED_IN_CLOSURE, variableDescriptor) != null) {
                        return;
                    }
                    KtElement ktElement = ((WriteValueInstruction)instruction).getElement();
                    KtExpression ktExpression = ktElement instanceof KtExpression ? (KtExpression)ktElement : null;
                    if (ktExpression == null) {
                        return;
                    }
                    KtExpression expressionInQuestion = ktExpression;
                    if (variableUseState != VariableUseState.READ) {
                        ((Map)this.$unusedValueExpressions).put(expressionInQuestion, TuplesKt.to((Object)variableDescriptor, (Object)ctxt));
                    } else {
                        this.$usedValueExpressions.add(expressionInQuestion);
                    }
                } else if (instruction2 instanceof VariableDeclarationInstruction) {
                    KtDeclaration ktDeclaration = ((VariableDeclarationInstruction)instruction).getVariableDeclarationElement();
                    KtNamedDeclaration ktNamedDeclaration = ktDeclaration instanceof KtNamedDeclaration ? (KtNamedDeclaration)ktDeclaration : null;
                    if (ktNamedDeclaration == null) {
                        return;
                    }
                    KtNamedDeclaration element = ktNamedDeclaration;
                    ControlFlowInformationProviderImpl.access$processUnusedDeclaration(this.this$0, element, variableDescriptor, ctxt, variableUseState);
                }
            }
        });
        unusedValueExpressions.keySet().removeAll((Collection)usedValueExpressions);
        for (Map.Entry entry : ((Map)unusedValueExpressions).entrySet()) {
            IElementType operationToken;
            KtExpression expressionInQuestion = (KtExpression)entry.getKey();
            Pair variableInContext = (Pair)entry.getValue();
            VariableDescriptor variableDescriptor = (VariableDescriptor)variableInContext.component1();
            VariableUseContext ctxt = (VariableUseContext)variableInContext.component2();
            KtExpression ktExpression = expressionInQuestion;
            if (ktExpression instanceof KtBinaryExpression) {
                if (((KtBinaryExpression)expressionInQuestion).getOperationToken() != KtTokens.EQ) continue;
                if (((KtBinaryExpression)expressionInQuestion).getRight() != null) {
                    KtExpression it;
                    boolean bl = false;
                    if (this.isLocalVariableWithDelegate(variableDescriptor)) continue;
                    ParametrizedDiagnostic<KtBinaryExpression> parametrizedDiagnostic = Errors.UNUSED_VALUE.on((KtBinaryExpression)((PsiElement)expressionInQuestion), it, variableDescriptor);
                    Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                    this.report(parametrizedDiagnostic, ctxt);
                }
                continue;
            }
            if (!(ktExpression instanceof KtPostfixExpression) || (operationToken = ((KtPostfixExpression)expressionInQuestion).getOperationReference().getReferencedNameElementType()) != KtTokens.PLUSPLUS && operationToken != KtTokens.MINUSMINUS) continue;
            ParametrizedDiagnostic<KtElement> parametrizedDiagnostic = Errors.UNUSED_CHANGED_VALUE.on((KtElement)((PsiElement)expressionInQuestion), expressionInQuestion);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
            this.report(parametrizedDiagnostic, ctxt);
        }
    }

    private final boolean isLocalVariableWithDelegate(VariableDescriptor $this$isLocalVariableWithDelegate) {
        return $this$isLocalVariableWithDelegate instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)$this$isLocalVariableWithDelegate).isDelegated();
    }

    private final boolean isLocalVariableWithProvideDelegate(VariableDescriptor $this$isLocalVariableWithProvideDelegate) {
        if (!this.isLocalVariableWithDelegate($this$isLocalVariableWithProvideDelegate)) {
            return false;
        }
        if (!($this$isLocalVariableWithProvideDelegate instanceof VariableDescriptorWithAccessors)) {
            return false;
        }
        return this.trace.getBindingContext().get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, $this$isLocalVariableWithProvideDelegate) != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void processUnusedDeclaration(KtNamedDeclaration element, VariableDescriptor variableDescriptor, VariableUseContext ctxt, VariableUseState variableUseState) {
        if (element.getNameIdentifier() == null) {
            return;
        }
        if (!VariableUseState.Companion.isUsed(variableUseState)) {
            if (UnderscoreUtilKt.isSingleUnderscore(element)) {
                return;
            }
            if (element instanceof KtDestructuringDeclarationEntry) {
                PsiElement psiElement = ((KtDestructuringDeclarationEntry)element).getParent().getParent();
                if ((psiElement != null ? psiElement.getParent() : null) instanceof KtParameterList) {
                    ParametrizedDiagnostic<KtDestructuringDeclarationEntry> parametrizedDiagnostic = Errors.UNUSED_DESTRUCTURED_PARAMETER_ENTRY.on((KtDestructuringDeclarationEntry)element, variableDescriptor);
                    Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                    this.report(parametrizedDiagnostic, ctxt);
                    return;
                }
            }
            if (KtPsiUtil.isRemovableVariableDeclaration(element)) {
                if (this.isLocalVariableWithProvideDelegate(variableDescriptor)) return;
                ParametrizedDiagnostic<KtNamedDeclaration> parametrizedDiagnostic = Errors.UNUSED_VARIABLE.on((KtNamedDeclaration)((PsiElement)element), variableDescriptor);
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                this.report(parametrizedDiagnostic, ctxt);
                return;
            }
            if (!(element instanceof KtParameter)) return;
            this.processUnusedParameter(ctxt, (KtParameter)element, variableDescriptor);
            return;
        }
        if (variableUseState == VariableUseState.ONLY_WRITTEN_NEVER_READ && KtPsiUtil.isRemovableVariableDeclaration(element)) {
            if (this.isLocalVariableWithDelegate(variableDescriptor)) return;
            ParametrizedDiagnostic<KtNamedDeclaration> parametrizedDiagnostic = Errors.ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE.on((KtNamedDeclaration)((PsiElement)element), variableDescriptor);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
            this.report(parametrizedDiagnostic, ctxt);
            return;
        }
        if (variableUseState != VariableUseState.WRITTEN_AFTER_READ) return;
        if (!(element instanceof KtVariableDeclaration)) return;
        KtNamedDeclaration ktNamedDeclaration = element;
        if (ktNamedDeclaration instanceof KtProperty) {
            KtExpression ktExpression = ((KtProperty)element).getInitializer();
            if (ktExpression == null) return;
            KtExpression it = ktExpression;
            boolean bl = false;
            ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.VARIABLE_WITH_REDUNDANT_INITIALIZER.on((KtExpression)((PsiElement)it), variableDescriptor);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
            this.report(parametrizedDiagnostic, ctxt);
            return;
        }
        if (!(ktNamedDeclaration instanceof KtDestructuringDeclarationEntry)) return;
        ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.VARIABLE_WITH_REDUNDANT_INITIALIZER.on((KtExpression)((PsiElement)element), variableDescriptor);
        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
        this.report(parametrizedDiagnostic, ctxt);
    }

    private final void processUnusedParameter(VariableUseContext ctxt, KtParameter element, VariableDescriptor variableDescriptor) {
        FunctionDescriptor functionDescriptor;
        block22: {
            block21: {
                DeclarationDescriptor declarationDescriptor = variableDescriptor.getContainingDeclaration();
                Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                functionDescriptor = (FunctionDescriptor)declarationDescriptor;
                if (functionDescriptor.isExpect() || functionDescriptor.isActual() || DescriptorUtilsKt.isEffectivelyExternal(functionDescriptor)) break block21;
                BindingContext bindingContext = this.trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                if (this.diagnosticSuppressor.shouldReportUnusedParameter(variableDescriptor, bindingContext) && this.diagnosticSuppressor.shouldReportUnusedParameter(variableDescriptor)) break block22;
            }
            return;
        }
        PsiElement owner = element.getParent().getParent();
        if (owner instanceof KtPrimaryConstructor) {
            if (!element.hasValOrVar()) {
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)functionDescriptor).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptorWithTypeParameters, (String)"getContainingDeclaration(...)");
                ClassifierDescriptorWithTypeParameters containingClass = classifierDescriptorWithTypeParameters;
                if (!DescriptorUtils.isAnnotationClass(containingClass)) {
                    ParametrizedDiagnostic<KtParameter> parametrizedDiagnostic = Errors.UNUSED_PARAMETER.on((KtParameter)((PsiElement)element), variableDescriptor);
                    Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                    this.report(parametrizedDiagnostic, ctxt);
                }
            }
        } else if (owner instanceof KtFunction) {
            boolean anonymous;
            boolean bl = anonymous = owner instanceof KtFunctionLiteral || owner instanceof KtNamedFunction && ((KtNamedFunction)owner).getName() == null;
            if (anonymous && !this.languageVersionSettings.supportsFeature(LanguageFeature.SingleUnderscoreForParameterName)) {
                return;
            }
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(bindingContext, this.languageVersionSettings);
            boolean isMain = owner instanceof KtNamedFunction && MainFunctionDetector.isMain$default(mainFunctionDetector, (KtNamedFunction)owner, false, false, 6, null);
            Name name2 = functionDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
            Name functionName = name2;
            if (isMain) {
                if (!this.languageVersionSettings.supportsFeature(LanguageFeature.ExtendedMainConvention)) {
                    return;
                }
                if (!this.languageVersionSettings.supportsFeature(LanguageFeature.WarningOnMainUnusedParameter)) {
                    if (KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)owner) == null) {
                        this.trace.record(BindingContext.UNUSED_MAIN_PARAMETER, element);
                    }
                    return;
                }
                if (KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)owner) != null) {
                    return;
                }
            }
            if (functionDescriptor.isOperator() && OperatorNameConventions.DELEGATED_PROPERTY_OPERATORS.contains(functionName)) {
                this.trace.record(BindingContext.UNUSED_DELEGATED_PROPERTY_OPERATOR_PARAMETER, variableDescriptor, true);
                return;
            }
            if (ModalityUtilsKt.isOverridableOrOverrides(functionDescriptor) || ((KtFunction)owner).hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                return;
            }
            if (anonymous) {
                ParametrizedDiagnostic<KtParameter> parametrizedDiagnostic = Errors.UNUSED_ANONYMOUS_PARAMETER.on((KtParameter)((PsiElement)element), variableDescriptor);
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                this.report(parametrizedDiagnostic, ctxt);
            } else {
                ParametrizedDiagnostic<KtParameter> parametrizedDiagnostic = Errors.UNUSED_PARAMETER.on((KtParameter)((PsiElement)element), variableDescriptor);
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                this.report(parametrizedDiagnostic, ctxt);
            }
        } else if (owner instanceof KtPropertyAccessor) {
            ParametrizedDiagnostic<KtParameter> parametrizedDiagnostic = Errors.UNUSED_PARAMETER.on((KtParameter)((PsiElement)element), variableDescriptor);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
            this.report(parametrizedDiagnostic, ctxt);
        }
    }

    private final void markUnusedExpressions() {
        HashMap reportedDiagnosticMap = new HashMap();
        PseudocodeTraverserKt.traverse(this.pseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, Unit>)((Function1)new Function1<Instruction, Unit>(this, reportedDiagnosticMap){
            final /* synthetic */ ControlFlowInformationProviderImpl this$0;
            final /* synthetic */ HashMap<Instruction, DiagnosticFactory<?>> $reportedDiagnosticMap;
            {
                this.this$0 = $receiver;
                this.$reportedDiagnosticMap = $reportedDiagnosticMap;
                super(1);
            }

            public final void invoke(@NotNull Instruction instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                if (!(instruction instanceof KtElementInstruction)) {
                    return;
                }
                KtElement ktElement = ((KtElementInstruction)instruction).getElement();
                KtExpression ktExpression = ktElement instanceof KtExpression ? (KtExpression)ktElement : null;
                if (ktExpression == null) {
                    return;
                }
                KtExpression element = ktExpression;
                BindingContext bindingContext = ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                if (BindingContextUtilsKt.isUsedAsStatement(element, bindingContext) && PseudocodeUtilsKt.getSideEffectFree(instruction)) {
                    SimpleDiagnostic<KtElement> simpleDiagnostic;
                    VariableContext context2 = this.this$0.new VariableContext(instruction, (Map)this.$reportedDiagnosticMap);
                    if (element instanceof KtLambdaExpression) {
                        SimpleDiagnostic<KtLambdaExpression> simpleDiagnostic2 = Errors.UNUSED_LAMBDA_EXPRESSION.on((KtLambdaExpression)((PsiElement)element));
                        simpleDiagnostic = simpleDiagnostic2;
                        Intrinsics.checkNotNullExpressionValue(simpleDiagnostic2, (String)"on(...)");
                    } else {
                        SimpleDiagnostic<KtElement> simpleDiagnostic3 = Errors.UNUSED_EXPRESSION.on((KtElement)((PsiElement)element));
                        simpleDiagnostic = simpleDiagnostic3;
                        Intrinsics.checkNotNullExpressionValue(simpleDiagnostic3, (String)"on(...)");
                    }
                    ControlFlowInformationProviderImpl.access$report(this.this$0, simpleDiagnostic, context2);
                }
            }
        }));
    }

    private final void markStatements() {
        PseudocodeTraverserKt.traverseIncludingDeadCode(this.pseudocode, (Function1<? super Instruction, Unit>)((Function1)new Function1<Instruction, Unit>(this){
            final /* synthetic */ ControlFlowInformationProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Instruction instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                InstructionWithValue instructionWithValue = instruction instanceof InstructionWithValue ? (InstructionWithValue)instruction : null;
                PseudoValue value2 = instructionWithValue != null ? instructionWithValue.getOutputValue() : null;
                Pseudocode pseudocode = instruction.getOwner();
                List<Instruction> usages = pseudocode.getUsages(value2);
                boolean isUsedAsExpression = !((Collection)usages).isEmpty();
                boolean isUsedAsResultOfLambda = org.jetbrains.kotlin.cfg.ControlFlowInformationProviderImpl$Companion.access$isUsedAsResultOfLambda(ControlFlowInformationProviderImpl.Companion, usages);
                for (KtElement element : pseudocode.getValueElements(value2)) {
                    KtExpression ktExpression;
                    KtElement catchClause;
                    Object object;
                    BindingContextUtilsKt.recordUsedAsExpression(element, ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0), isUsedAsExpression);
                    ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).record(BindingContext.USED_AS_RESULT_OF_LAMBDA, element, isUsedAsResultOfLambda);
                    if (!isUsedAsExpression) continue;
                    KtElement ktElement = element;
                    if (ktElement instanceof KtTryExpression) {
                        KtBlockExpression ktBlockExpression = ((KtTryExpression)element).getTryBlock();
                        Intrinsics.checkNotNullExpressionValue((Object)ktBlockExpression, (String)"getTryBlock(...)");
                        ControlFlowInformationProviderImpl.access$recordUsedAsExpression(this.this$0, ktBlockExpression);
                        object = ((KtTryExpression)element).getCatchClauses().iterator();
                        while (object.hasNext()) {
                            catchClause = object.next();
                            ktExpression = ((KtCatchClause)catchClause).getCatchBody();
                            if (ktExpression == null) continue;
                            ControlFlowInformationProviderImpl.access$recordUsedAsExpression(this.this$0, ktExpression);
                        }
                        continue;
                    }
                    if (ktElement instanceof KtIfExpression) {
                        catchClause = ((KtIfExpression)element).getThen();
                        Object object2 = object = catchClause instanceof KtBlockExpression ? (KtBlockExpression)catchClause : null;
                        if (object != null) {
                            ControlFlowInformationProviderImpl.access$recordUsedAsExpression(this.this$0, (KtExpression)object);
                        }
                        if ((object = (catchClause = ((KtIfExpression)element).getElse()) instanceof KtBlockExpression ? (KtBlockExpression)catchClause : null) == null) continue;
                        ControlFlowInformationProviderImpl.access$recordUsedAsExpression(this.this$0, (KtExpression)object);
                        continue;
                    }
                    if (!(ktElement instanceof KtWhenExpression)) continue;
                    object = ((KtWhenExpression)element).getEntries().iterator();
                    while (object.hasNext()) {
                        KtWhenEntry entry = (KtWhenEntry)((Object)object.next());
                        KtExpression ktExpression2 = entry.getExpression();
                        ktExpression = ktExpression2 instanceof KtBlockExpression ? (KtBlockExpression)ktExpression2 : null;
                        if (ktExpression == null) continue;
                        ControlFlowInformationProviderImpl.access$recordUsedAsExpression(this.this$0, ktExpression);
                    }
                }
            }
        }));
    }

    private final void recordUsedAsExpression(KtExpression $this$recordUsedAsExpression) {
        BindingContextUtilsKt.recordUsedAsExpression($this$recordUsedAsExpression, this.trace, true);
    }

    private final void checkForSuspendLambdaAndMarkParameters(Pseudocode pseudocode) {
        for (Instruction instruction : pseudocode.getInstructionsIncludingDeadCode()) {
            DeclarationDescriptor descriptor2;
            if (!(instruction instanceof LocalFunctionDeclarationInstruction)) continue;
            KtElement psi = ((LocalFunctionDeclarationInstruction)instruction).getBody().getCorrespondingElement();
            if (psi instanceof KtFunctionLiteral && (descriptor2 = this.trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, psi)) instanceof AnonymousFunctionDescriptor && ((AnonymousFunctionDescriptor)descriptor2).isSuspend()) {
                this.markReadOfSuspendLambdaParameters(((LocalFunctionDeclarationInstruction)instruction).getBody());
                continue;
            }
            this.checkForSuspendLambdaAndMarkParameters(((LocalFunctionDeclarationInstruction)instruction).getBody());
        }
    }

    private final void markReadOfSuspendLambdaParameters(Pseudocode pseudocode) {
        List<Instruction> instructions = pseudocode.getInstructionsIncludingDeadCode();
        for (Instruction instruction : instructions) {
            if (instruction instanceof LocalFunctionDeclarationInstruction) {
                this.markReadOfSuspendLambdaParameters(((LocalFunctionDeclarationInstruction)instruction).getBody());
                continue;
            }
            this.markReadOfSuspendLambdaParameter(instruction);
            this.markImplicitReceiverOfSuspendLambda(instruction);
        }
    }

    private final void markReadOfSuspendLambdaParameter(Instruction instruction) {
        block5: {
            DeclarationDescriptor containing;
            Object descriptor2;
            block4: {
                if (!(instruction instanceof ReadValueInstruction)) {
                    return;
                }
                AccessTarget accessTarget = ((ReadValueInstruction)instruction).getTarget();
                AccessTarget.Call call2 = accessTarget instanceof AccessTarget.Call ? (AccessTarget.Call)accessTarget : null;
                if (call2 == null) {
                    return;
                }
                AccessTarget.Call target = call2;
                descriptor2 = target.getResolvedCall().getResultingDescriptor();
                if (!(descriptor2 instanceof ParameterDescriptor)) break block4;
                DeclarationDescriptor declarationDescriptor = ((ParameterDescriptor)descriptor2).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
                containing = declarationDescriptor;
                if (!(containing instanceof AnonymousFunctionDescriptor) || !((AnonymousFunctionDescriptor)containing).isSuspend()) break block5;
                this.trace.record(BindingContext.SUSPEND_LAMBDA_PARAMETER_USED, TuplesKt.to((Object)containing, (Object)KtDescriptorUtilKt.indexOrMinusOne((ParameterDescriptor)descriptor2)));
                break block5;
            }
            if (!(descriptor2 instanceof LocalVariableDescriptor)) break block5;
            DeclarationDescriptor declarationDescriptor = ((LocalVariableDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
            containing = declarationDescriptor;
            if (containing instanceof AnonymousFunctionDescriptor && ((AnonymousFunctionDescriptor)containing).isSuspend()) {
                ValueParameterDescriptor valueParameterDescriptor = CapturingInClosureCheckerKt.findDestructuredVariable((VariableDescriptor)descriptor2, containing);
                if (valueParameterDescriptor != null) {
                    ValueParameterDescriptor it = valueParameterDescriptor;
                    boolean bl = false;
                    this.trace.record(BindingContext.SUSPEND_LAMBDA_PARAMETER_USED, TuplesKt.to((Object)containing, (Object)it.getIndex()));
                }
            }
        }
    }

    private final void markImplicitReceiverOfSuspendLambda(Instruction instruction) {
        block7: {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2;
            KtElement element;
            block8: {
                Object object;
                ReceiverValue receiverValue;
                block6: {
                    if (!(instruction instanceof MagicInstruction) || ((MagicInstruction)instruction).getKind() != MagicKind.IMPLICIT_RECEIVER && ((MagicInstruction)instruction).getKind() != MagicKind.UNBOUND_CALLABLE_REFERENCE) {
                        return;
                    }
                    element = ((MagicInstruction)instruction).getElement();
                    if (!(element instanceof KtDestructuringDeclarationEntry ? true : element instanceof KtCallExpression)) break block6;
                    Set visited2 = new LinkedHashSet();
                    Instruction instruction2 = ((MagicInstruction)instruction).getNext();
                    if (instruction2 == null) break block7;
                    Instruction it = instruction2;
                    boolean bl = false;
                    ControlFlowInformationProviderImpl.markImplicitReceiverOfSuspendLambda$dfs(visited2, element, this, it);
                    break block7;
                }
                if (!((element instanceof KtNameReferenceExpression ? true : element instanceof KtBinaryExpression) ? true : element instanceof KtUnaryExpression)) break block8;
                BindingContext bindingContext = this.trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                ResolvedCall<? extends CallableDescriptor> call2 = CallUtilKt.getResolvedCall(element, bindingContext);
                if (call2 instanceof VariableAsFunctionResolvedCall) {
                    receiverValue = ((VariableAsFunctionResolvedCall)((Object)call2)).getVariableCall().getDispatchReceiver();
                    Object object2 = receiverValue instanceof ExtensionReceiver ? (ExtensionReceiver)receiverValue : null;
                    if (object2 != null && (object2 = ((ExtensionReceiver)object2).getDeclarationDescriptor()) != null) {
                        Object $this$markImplicitReceiverOfSuspendLambda_u24lambda_u2410 = object = object2;
                        boolean bl = false;
                        ControlFlowInformationProviderImpl.markImplicitReceiverOfSuspendLambda$markIfNeeded((CallableDescriptor)$this$markImplicitReceiverOfSuspendLambda_u24lambda_u2410, this);
                    }
                    receiverValue = ((VariableAsFunctionResolvedCall)((Object)call2)).getVariableCall().getExtensionReceiver();
                    Object object3 = receiverValue instanceof ExtensionReceiver ? (ExtensionReceiver)receiverValue : null;
                    if (object3 != null && (object3 = ((ExtensionReceiver)object3).getDeclarationDescriptor()) != null) {
                        Object $this$markImplicitReceiverOfSuspendLambda_u24lambda_u2411 = object = object3;
                        boolean bl = false;
                        ControlFlowInformationProviderImpl.markImplicitReceiverOfSuspendLambda$markIfNeeded((CallableDescriptor)$this$markImplicitReceiverOfSuspendLambda_u24lambda_u2411, this);
                    }
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall3 = call2;
                receiverValue = resolvedCall3 != null ? resolvedCall3.getDispatchReceiver() : null;
                Object object4 = receiverValue instanceof ExtensionReceiver ? (ExtensionReceiver)receiverValue : null;
                if (object4 != null && (object4 = ((ExtensionReceiver)object4).getDeclarationDescriptor()) != null) {
                    Object $this$markImplicitReceiverOfSuspendLambda_u24lambda_u2412 = object = object4;
                    boolean bl = false;
                    ControlFlowInformationProviderImpl.markImplicitReceiverOfSuspendLambda$markIfNeeded((CallableDescriptor)$this$markImplicitReceiverOfSuspendLambda_u24lambda_u2412, this);
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall4 = call2;
                receiverValue = resolvedCall4 != null ? resolvedCall4.getExtensionReceiver() : null;
                Object object5 = receiverValue instanceof ExtensionReceiver ? (ExtensionReceiver)receiverValue : null;
                if (object5 == null || (object5 = ((ExtensionReceiver)object5).getDeclarationDescriptor()) == null) break block7;
                Object $this$markImplicitReceiverOfSuspendLambda_u24lambda_u2413 = object = object5;
                boolean bl = false;
                ControlFlowInformationProviderImpl.markImplicitReceiverOfSuspendLambda$markIfNeeded((CallableDescriptor)$this$markImplicitReceiverOfSuspendLambda_u24lambda_u2413, this);
                break block7;
            }
            if (!(element instanceof KtCallableReferenceExpression)) break block7;
            KtElement ktElement = ((KtCallableReferenceExpression)element).getCallableReference();
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            ResolvedCall<? extends CallableDescriptor> resolvedCall5 = resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            ReceiverValue receiverValue = resolvedCall5 != null ? resolvedCall5.getDispatchReceiver() : null;
            Object object = receiverValue instanceof ExtensionReceiver ? (ExtensionReceiver)receiverValue : null;
            if (object != null && (object = ((ExtensionReceiver)object).getDeclarationDescriptor()) != null) {
                Object object6;
                Object $this$markImplicitReceiverOfSuspendLambda_u24lambda_u2414 = object6 = object;
                boolean bl = false;
                ControlFlowInformationProviderImpl.markImplicitReceiverOfSuspendLambda$markIfNeeded((CallableDescriptor)$this$markImplicitReceiverOfSuspendLambda_u24lambda_u2414, this);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void markAnnotationArguments() {
        if (this.subroutine.getContainingKtFile().isCompiled()) {
            return;
        }
        if (this.subroutine instanceof KtAnnotationEntry) {
            this.markAnnotationArguments((KtAnnotationEntry)this.subroutine);
        } else {
            PsiElement[] psiElementArray = this.subroutine.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object[] $this$forEach$iv = psiElementArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEachDescendantOfType$iv;
                PsiElement child = (PsiElement)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)child);
                PsiElement psiElement = child;
                Function1 action$iv = (Function1)new Function1<KtAnnotationEntry, Unit>(this){
                    final /* synthetic */ ControlFlowInformationProviderImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull KtAnnotationEntry it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ControlFlowInformationProviderImpl.access$markAnnotationArguments(this.this$0, it);
                    }
                };
                boolean $i$f$forEachDescendantOfType = false;
                PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv);
                $this$forEachDescendantOfType$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                    final /* synthetic */ Function1 $action;
                    {
                        this.$action = $action;
                    }

                    public void visitElement(@NotNull PsiElement element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        PsiElement it = element;
                        boolean bl = false;
                        if (!(it instanceof KtDeclaration) || it instanceof KtParameter) {
                            super.visitElement(element);
                        }
                        if (element instanceof KtAnnotationEntry) {
                            this.$action.invoke((Object)element);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void markAnnotationArguments(KtAnnotationEntry entry) {
        for (ValueArgument valueArgument : entry.getValueArguments()) {
            void $this$forEachDescendantOfType$iv;
            KtExpression ktExpression = valueArgument.getArgumentExpression();
            if (ktExpression == null) continue;
            PsiElement psiElement = (PsiElement)ktExpression;
            Function1 action$iv = (Function1)new Function1<KtExpression, Unit>(this){
                final /* synthetic */ ControlFlowInformationProviderImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull KtExpression it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    BindingContextUtilsKt.recordUsedAsExpression(it, ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0), true);
                }
            };
            boolean $i$f$forEachDescendantOfType = false;
            void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
            boolean $i$f$forEachDescendantOfType2 = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv);
            $this$forEachDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtExpression) {
                        this.$action.invoke((Object)element);
                    }
                }
            });
        }
    }

    private final void checkIfExpressions() {
        PseudocodeTraverserKt.traverse(this.pseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, Unit>)((Function1)new Function1<Instruction, Unit>(this){
            final /* synthetic */ ControlFlowInformationProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Instruction instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                InstructionWithValue instructionWithValue = instruction instanceof InstructionWithValue ? (InstructionWithValue)instruction : null;
                PseudoValue value2 = instructionWithValue != null ? instructionWithValue.getOutputValue() : null;
                for (KtElement element : instruction.getOwner().getValueElements(value2)) {
                    PsiElement parent2;
                    if (!(element instanceof KtIfExpression)) continue;
                    KtExpression thenExpression = ((KtIfExpression)element).getThen();
                    KtExpression elseExpression = ((KtIfExpression)element).getElse();
                    boolean isEhxaustive = thenExpression != null && elseExpression != null;
                    BindingContext bindingContext = ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                    if (BindingContextUtilsKt.isUsedAsExpression(element, bindingContext)) {
                        if (!isEhxaustive) {
                            ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).report(Errors.INVALID_IF_AS_EXPRESSION.on(((KtIfExpression)element).getIfKeyword()));
                            continue;
                        }
                        ControlFlowInformationProviderImpl.access$checkImplicitCastOnConditionalExpression(this.this$0, (KtExpression)element);
                        continue;
                    }
                    if (ControlFlowInformationProviderImpl.access$getLanguageVersionSettings$p(this.this$0).supportsFeature(LanguageFeature.ProhibitNonExhaustiveIfInRhsOfElvis) || isEhxaustive || !((parent2 = ControlFlowInformationProviderImpl.access$getDeparenthesizedParent(this.this$0, (PsiElement)element)) instanceof KtBinaryExpression) || ((KtBinaryExpression)parent2).getOperationToken() != KtTokens.ELVIS) continue;
                    ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).report(Errors.INVALID_IF_AS_EXPRESSION_WARNING.on(((KtIfExpression)element).getIfKeyword()));
                }
            }
        }));
    }

    private final void checkImplicitCastOnConditionalExpression(KtExpression expression2) {
        List branchExpressions = ControlFlowInformationProviderImpl.Companion.collectResultingExpressionsOfConditionalExpression(expression2);
        KotlinType expectedExpressionType = (KotlinType)this.trace.get(BindingContext.EXPECTED_EXPRESSION_TYPE, expression2);
        if (expectedExpressionType != null && expectedExpressionType != TypeUtils.DONT_CARE) {
            return;
        }
        KotlinType kotlinType = this.trace.getType(expression2);
        if (kotlinType == null) {
            return;
        }
        KotlinType expressionType2 = kotlinType;
        if (KotlinBuiltIns.isAnyOrNullableAny(expressionType2)) {
            KotlinType branchType;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            boolean isUsedAsResultOfLambda = BindingContextUtilsKt.isUsedAsResultOfLambda(expression2, bindingContext);
            for (KtExpression branchExpression : branchExpressions) {
                if (this.trace.getType(branchExpression) == null) {
                    return;
                }
                if (!KotlinBuiltIns.isAnyOrNullableAny(branchType) && (!isUsedAsResultOfLambda || !KotlinBuiltIns.isUnitOrNullableUnit(branchType))) continue;
                return;
            }
            for (KtExpression branchExpression : branchExpressions) {
                if (this.trace.getType(branchExpression) == null || KotlinBuiltIns.isNothing(branchType)) continue;
                this.trace.report(Errors.IMPLICIT_CAST_TO_ANY.on((KtExpression)((PsiElement)ControlFlowInformationProviderImpl.Companion.getResultingExpression(branchExpression)), branchType, expressionType2));
            }
        }
    }

    private final void checkWhenExpressions() {
        Map<Instruction, Edges<VariableInitReadOnlyControlFlowInfo>> initializers = this.getPseudocodeVariablesData().getVariableInitializers();
        PseudocodeTraverserKt.traverse(this.pseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, Unit>)((Function1)new Function1<Instruction, Unit>(initializers, this){
            final /* synthetic */ Map<Instruction, Edges<VariableInitReadOnlyControlFlowInfo>> $initializers;
            final /* synthetic */ ControlFlowInformationProviderImpl this$0;
            {
                this.$initializers = $initializers;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Instruction instruction) {
                Instruction next;
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                if (instruction instanceof MagicInstruction && ((MagicInstruction)instruction).getKind() == MagicKind.EXHAUSTIVE_WHEN_ELSE && (next = ((MagicInstruction)instruction).getNext()) instanceof MergeInstruction) {
                    VariableInitReadOnlyControlFlowInfo magicInfo;
                    Edges<VariableInitReadOnlyControlFlowInfo> edges = this.$initializers.get(next);
                    VariableInitReadOnlyControlFlowInfo mergeInfo = edges != null ? edges.getIncoming() : null;
                    Edges<VariableInitReadOnlyControlFlowInfo> edges2 = this.$initializers.get(instruction);
                    VariableInitReadOnlyControlFlowInfo variableInitReadOnlyControlFlowInfo = magicInfo = edges2 != null ? edges2.getOutgoing() : null;
                    if (mergeInfo != null && magicInfo != null && ((MergeInstruction)next).getElement() instanceof KtWhenExpression && magicInfo.checkDefiniteInitializationInWhen(mergeInfo)) {
                        ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).record(BindingContext.IMPLICIT_EXHAUSTIVE_WHEN, ((MergeInstruction)next).getElement());
                    }
                }
                InstructionWithValue instructionWithValue = instruction instanceof InstructionWithValue ? (InstructionWithValue)instruction : null;
                PseudoValue value2 = instructionWithValue != null ? instructionWithValue.getOutputValue() : null;
                for (KtElement element : instruction.getOwner().getValueElements(value2)) {
                    PsiElement parent2;
                    Object v6;
                    Object it;
                    List<WhenMissingCase> missingCases;
                    BindingContext context2;
                    boolean usedAsExpression;
                    block17: {
                        if (!(element instanceof KtWhenExpression)) continue;
                        BindingContext bindingContext = ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getBindingContext();
                        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                        usedAsExpression = BindingContextUtilsKt.isUsedAsExpression(element, bindingContext);
                        if (usedAsExpression) {
                            ControlFlowInformationProviderImpl.access$checkImplicitCastOnConditionalExpression(this.this$0, (KtExpression)element);
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getBindingContext(), (String)"getBindingContext(...)");
                        missingCases = WhenChecker.INSTANCE.getMissingCases((KtWhenExpression)element, context2);
                        List<KtWhenEntry> list2 = ((KtWhenExpression)element).getEntries();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"getEntries(...)");
                        Iterable iterable = list2;
                        for (T t : iterable) {
                            it = (KtWhenEntry)t;
                            boolean bl = false;
                            if (!((KtWhenEntry)it).isElse()) continue;
                            v6 = t;
                            break block17;
                        }
                        v6 = null;
                    }
                    KtWhenEntry elseEntry = v6;
                    KtExpression subjectExpression = ((KtWhenExpression)element).getSubjectExpression();
                    if (usedAsExpression && !((Collection)missingCases).isEmpty()) {
                        Object v7;
                        Object $this$firstOrNull$iv;
                        block18: {
                            if (elseEntry != null) continue;
                            ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).report(Errors.NO_ELSE_IN_WHEN.on((KtWhenExpression)((PsiElement)element), missingCases));
                            $this$firstOrNull$iv = missingCases;
                            boolean $i$f$firstOrNull = false;
                            it = $this$firstOrNull$iv.iterator();
                            while (it.hasNext()) {
                                E element$iv = it.next();
                                WhenMissingCase it2 = (WhenMissingCase)element$iv;
                                boolean bl = false;
                                if (!(it2 instanceof WhenMissingCase.ConditionTypeIsExpect)) continue;
                                v7 = element$iv;
                                break block18;
                            }
                            v7 = null;
                        }
                        WhenMissingCase whenMissingCase = v7;
                        if (whenMissingCase != null) {
                            $this$firstOrNull$iv = whenMissingCase;
                            ControlFlowInformationProviderImpl $i$f$firstOrNull = this.this$0;
                            it = $this$firstOrNull$iv;
                            boolean bl = false;
                            if (!(it instanceof WhenMissingCase.ConditionTypeIsExpect)) {
                                String string2 = "Failed requirement.";
                                throw new IllegalArgumentException(string2.toString());
                            }
                            ControlFlowInformationProviderImpl.access$getTrace$p($i$f$firstOrNull).report(Errors.EXPECT_TYPE_IN_WHEN_WITHOUT_ELSE.on((KtWhenExpression)((PsiElement)element), ((WhenMissingCase.ConditionTypeIsExpect)it).getTypeOfDeclaration()));
                        }
                    } else if (subjectExpression != null) {
                        KtWhenExpression ktWhenExpression = (KtWhenExpression)element;
                        BindingContext bindingContext = ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getBindingContext();
                        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                        KotlinType subjectType = WhenChecker.whenSubjectType(ktWhenExpression, bindingContext);
                        if (elseEntry != null) {
                            if (!missingCases.isEmpty() || subjectType == null || FlexibleTypesKt.isFlexible(subjectType)) continue;
                            ClassifierDescriptor $i$f$firstOrNull = subjectType.getConstructor().getDeclarationDescriptor();
                            ClassDescriptor subjectClass = $i$f$firstOrNull instanceof ClassDescriptor ? (ClassDescriptor)$i$f$firstOrNull : null;
                            KtElement pseudocodeElement = instruction.getOwner().getCorrespondingElement();
                            DeclarationDescriptor pseudocodeDescriptor = ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).get(BindingContext.DECLARATION_TO_DESCRIPTOR, pseudocodeElement);
                            if (subjectClass != null && !KotlinBuiltIns.isBooleanOrNullableBoolean(subjectType)) {
                                DeclarationDescriptor declarationDescriptor = pseudocodeDescriptor;
                                if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getModule(subjectClass), (Object)(declarationDescriptor != null ? DescriptorUtilsKt.getModule(declarationDescriptor) : null))) continue;
                            }
                            ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).report(Errors.REDUNDANT_ELSE_IN_WHEN.on((KtWhenEntry)((PsiElement)elseEntry)));
                            continue;
                        }
                        EnumWhenTracker enumWhenTracker = ControlFlowInformationProviderImpl.access$getEnumWhenTracker$p(this.this$0);
                        if (enumWhenTracker != null) {
                            IncrementalTrackerUtilKt.record(enumWhenTracker, subjectType, subjectExpression, elseEntry);
                        }
                        if (!usedAsExpression) {
                            if (ControlFlowInformationProviderImpl.access$getLanguageVersionSettings$p(this.this$0).supportsFeature(LanguageFeature.WarnAboutNonExhaustiveWhenOnAlgebraicTypes)) {
                                ControlFlowInformationProviderImpl.access$checkExhaustiveWhenStatement(this.this$0, subjectType, (KtWhenExpression)element, missingCases);
                            } else {
                                ControlFlowInformationProviderImpl.access$checkWhenStatement(this.this$0, subjectType, (KtWhenExpression)element, context2);
                            }
                        }
                    }
                    if (usedAsExpression || !(!((Collection)missingCases).isEmpty()) || elseEntry != null || ControlFlowInformationProviderImpl.access$getLanguageVersionSettings$p(this.this$0).supportsFeature(LanguageFeature.ProhibitNonExhaustiveIfInRhsOfElvis) || !((parent2 = ControlFlowInformationProviderImpl.access$getDeparenthesizedParent(this.this$0, (PsiElement)element)) instanceof KtBinaryExpression) || ((KtBinaryExpression)parent2).getOperationToken() != KtTokens.ELVIS) continue;
                    ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).report(Errors.NO_ELSE_IN_WHEN_WARNING.on((KtWhenExpression)((PsiElement)element), missingCases));
                }
            }
        }));
    }

    private final void checkWhenStatement(KotlinType subjectType, KtWhenExpression element, BindingContext context2) {
        List<WhenMissingCase> sealedMissingCases;
        ClassDescriptor sealedClassDescriptor;
        List<WhenMissingCase> enumMissingCases;
        ClassDescriptor enumClassDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum(subjectType);
        if (enumClassDescriptor != null && !((Collection)(enumMissingCases = WhenChecker.getEnumMissingCases(element, context2, enumClassDescriptor))).isEmpty()) {
            this.trace.report(Errors.NON_EXHAUSTIVE_WHEN.on((KtWhenExpression)((PsiElement)element), enumMissingCases));
        }
        if ((sealedClassDescriptor = WhenChecker.getClassDescriptorOfTypeIfSealed(subjectType)) != null && !((Collection)(sealedMissingCases = WhenChecker.getSealedMissingCases(element, context2, sealedClassDescriptor))).isEmpty()) {
            this.trace.report(Errors.NON_EXHAUSTIVE_WHEN_ON_SEALED_CLASS.on((KtWhenExpression)((PsiElement)element), sealedMissingCases));
        }
    }

    private final void checkExhaustiveWhenStatement(KotlinType subjectType, KtWhenExpression element, List<? extends WhenMissingCase> missingCases) {
        AlgebraicTypeKind kind;
        AlgebraicTypeKind algebraicTypeKind;
        if (missingCases.isEmpty()) {
            return;
        }
        if (WhenChecker.getClassDescriptorOfTypeIfSealed(subjectType) != null) {
            algebraicTypeKind = AlgebraicTypeKind.Sealed;
        } else if (WhenChecker.getClassDescriptorOfTypeIfEnum(subjectType) != null) {
            algebraicTypeKind = AlgebraicTypeKind.Enum;
        } else {
            KotlinType kotlinType = subjectType;
            algebraicTypeKind = kind = (kotlinType != null ? TypeUtilsKt.isBooleanOrNullableBoolean(kotlinType) : false) ? AlgebraicTypeKind.Boolean : null;
        }
        if (kind != null) {
            if (this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitNonExhaustiveWhenOnAlgebraicTypes)) {
                this.trace.report(Errors.NO_ELSE_IN_WHEN.on((KtWhenExpression)((PsiElement)element), missingCases));
            } else {
                this.trace.report(Errors.NON_EXHAUSTIVE_WHEN_STATEMENT.on((KtWhenExpression)((PsiElement)element), kind.getDisplayName(), missingCases));
            }
        }
    }

    private final void checkConstructorConsistency() {
        KtElement ktElement = this.subroutine;
        if (ktElement instanceof KtClassOrObject) {
            ConstructorConsistencyChecker.Companion.check((KtClassOrObject)this.subroutine, this.trace, this.pseudocode, this.getPseudocodeVariablesData());
        } else if (ktElement instanceof KtSecondaryConstructor) {
            ConstructorConsistencyChecker.Companion.check((KtSecondaryConstructor)this.subroutine, this.trace, this.pseudocode, this.getPseudocodeVariablesData());
        }
    }

    private final void markAndCheckTailCalls() {
        DeclarationDescriptor declarationDescriptor = this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, this.subroutine);
        FunctionDescriptor functionDescriptor = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor subroutineDescriptor = functionDescriptor;
        this.markAndCheckRecursiveTailCalls(subroutineDescriptor);
    }

    private final void markAndCheckRecursiveTailCalls(FunctionDescriptor subroutineDescriptor) {
        if (!subroutineDescriptor.isTailrec()) {
            return;
        }
        if (this.subroutine instanceof KtNamedFunction && !((KtNamedFunction)this.subroutine).hasBody()) {
            return;
        }
        HashMap calls = new HashMap();
        ControlFlowInformationProviderImpl this_$iv = this;
        boolean $i$f$traverseCalls = false;
        PseudocodeTraverserKt.traverse(this_$iv.pseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, Unit>)((Function1)new Function1<Instruction, Unit>(subroutineDescriptor, this, calls){
            final /* synthetic */ FunctionDescriptor $subroutineDescriptor$inlined;
            final /* synthetic */ ControlFlowInformationProviderImpl this$0;
            final /* synthetic */ HashMap $calls$inlined;
            {
                this.$subroutineDescriptor$inlined = functionDescriptor;
                this.this$0 = controlFlowInformationProviderImpl;
                this.$calls$inlined = hashMap;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Instruction instruction) {
                void resolvedCall2;
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                if (!(instruction instanceof CallInstruction)) {
                    return;
                }
                ResolvedCall<?> resolvedCall3 = ((CallInstruction)instruction).getResolvedCall();
                CallInstruction instruction2 = (CallInstruction)instruction;
                boolean bl = false;
                D functionDescriptor = resolvedCall2.getResultingDescriptor();
                if (Intrinsics.areEqual((Object)functionDescriptor.getOriginal(), (Object)this.$subroutineDescriptor$inlined) && (resolvedCall2.getCall().getValueArguments().size() == functionDescriptor.getValueParameters().size() || functionDescriptor.getOverriddenDescriptors().isEmpty())) {
                    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"org/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$markAndCheckRecursiveTailCalls$KindAndCall", "", "kind", "Lorg/jetbrains/kotlin/cfg/TailRecursionKind;", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "(Lorg/jetbrains/kotlin/cfg/TailRecursionKind;Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;)V", "getCall", "()Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getKind", "()Lorg/jetbrains/kotlin/cfg/TailRecursionKind;", "setKind", "(Lorg/jetbrains/kotlin/cfg/TailRecursionKind;)V", "cfg"})
                    public final class KindAndCall {
                        @NotNull
                        private TailRecursionKind kind;
                        @NotNull
                        private final ResolvedCall<?> call;

                        public KindAndCall(@NotNull TailRecursionKind kind, @NotNull ResolvedCall<?> call2) {
                            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
                            Intrinsics.checkNotNullParameter(call2, (String)"call");
                            this.kind = kind;
                            this.call = call2;
                        }

                        @NotNull
                        public final TailRecursionKind getKind() {
                            return this.kind;
                        }

                        public final void setKind(@NotNull TailRecursionKind tailRecursionKind) {
                            Intrinsics.checkNotNullParameter((Object)((Object)tailRecursionKind), (String)"<set-?>");
                            this.kind = tailRecursionKind;
                        }

                        @NotNull
                        public final ResolvedCall<?> getCall() {
                            return this.call;
                        }
                    }
                    KtElement element = instruction2.getElement();
                    if (ControlFlowInformationProviderImpl.access$isInsideTry(this.this$0, element)) {
                        ((Map)this.$calls$inlined).put(element, new KindAndCall(TailRecursionKind.IN_TRY, (ResolvedCall<?>)resolvedCall2));
                    } else {
                        BindingContext bindingContext = ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getBindingContext();
                        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                        boolean sameDispatchReceiver = ResolvedCallUtilKt.hasThisOrNoDispatchReceiver(resolvedCall2, bindingContext);
                        TailRecursionKind kind = sameDispatchReceiver && ControlFlowInformationProviderImpl.isTailCall$default(this.this$0, instruction2, null, 1, null) ? TailRecursionKind.TAIL_CALL : TailRecursionKind.NON_TAIL;
                        KindAndCall kindAndCall = (KindAndCall)this.$calls$inlined.get(element);
                        KindAndCall kindAndCall2 = kindAndCall;
                        ((Map)this.$calls$inlined).put(element, new KindAndCall(org.jetbrains.kotlin.cfg.ControlFlowInformationProviderImpl$Companion.access$combineKinds(ControlFlowInformationProviderImpl.Companion, kind, kindAndCall2 != null ? kindAndCall2.getKind() : null), (ResolvedCall<?>)resolvedCall2));
                    }
                }
            }
        }));
        boolean hasTailCalls = false;
        for (Map.Entry entry : ((Map)calls).entrySet()) {
            KtElement element = (KtElement)entry.getKey();
            KindAndCall kindAndCall = (KindAndCall)entry.getValue();
            switch (WhenMappings.$EnumSwitchMapping$1[kindAndCall.getKind().ordinal()]) {
                case 1: {
                    this.trace.record(BindingContext.TAIL_RECURSION_CALL, kindAndCall.getCall().getCall(), TailRecursionKind.TAIL_CALL);
                    hasTailCalls = true;
                    break;
                }
                case 2: {
                    this.trace.report(Errors.TAIL_RECURSION_IN_TRY_IS_NOT_SUPPORTED.on((PsiElement)element));
                    break;
                }
                case 3: {
                    this.trace.report(Errors.NON_TAIL_RECURSIVE_CALL.on((PsiElement)element));
                }
            }
        }
        if (!hasTailCalls && this.subroutine instanceof KtNamedFunction) {
            this.trace.report(Errors.NO_TAIL_CALLS_FOUND.on((KtNamedFunction)((PsiElement)this.subroutine)));
        }
    }

    private final boolean isInsideTry(KtElement element) {
        Class[] classArray = new Class[]{KtTryExpression.class, KtFunction.class, KtAnonymousInitializer.class};
        return PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), (Class[])classArray) instanceof KtTryExpression;
    }

    private final boolean isTailCall(CallInstruction $this$isTailCall, KtElement subroutine) {
        TailInstructionDetector tailInstructionDetector = new TailInstructionDetector(subroutine);
        return PseudocodeTraverserKt.traverseFollowingInstructions($this$isTailCall, new HashSet(), TraversalOrder.FORWARD, (Function1<? super Instruction, ? extends TraverseInstructionResult>)((Function1)new Function1<Instruction, TraverseInstructionResult>($this$isTailCall, tailInstructionDetector){
            final /* synthetic */ CallInstruction $this_isTailCall;
            final /* synthetic */ TailInstructionDetector $tailInstructionDetector;
            {
                this.$this_isTailCall = $receiver;
                this.$tailInstructionDetector = $tailInstructionDetector;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final TraverseInstructionResult invoke(@NotNull Instruction it) {
                TraverseInstructionResult traverseInstructionResult;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!Intrinsics.areEqual((Object)it, (Object)this.$this_isTailCall)) {
                    R r = it.accept(this.$tailInstructionDetector);
                    Intrinsics.checkNotNullExpressionValue(r, (String)"accept(...)");
                    if (!((Boolean)r).booleanValue()) {
                        traverseInstructionResult = TraverseInstructionResult.HALT;
                        return traverseInstructionResult;
                    }
                }
                traverseInstructionResult = TraverseInstructionResult.CONTINUE;
                return traverseInstructionResult;
            }
        }));
    }

    static /* synthetic */ boolean isTailCall$default(ControlFlowInformationProviderImpl controlFlowInformationProviderImpl, CallInstruction callInstruction, KtElement ktElement, int n, Object object) {
        if ((n & 1) != 0) {
            ktElement = controlFlowInformationProviderImpl.subroutine;
        }
        return controlFlowInformationProviderImpl.isTailCall(callInstruction, ktElement);
    }

    private final void traverseCalls(Function2<? super CallInstruction, ? super ResolvedCall<?>, Unit> onCall) {
        boolean $i$f$traverseCalls = false;
        PseudocodeTraverserKt.traverse(this.pseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, Unit>)((Function1)new Function1<Instruction, Unit>(onCall){
            final /* synthetic */ Function2<CallInstruction, ResolvedCall<?>, Unit> $onCall;
            {
                this.$onCall = $onCall;
                super(1);
            }

            public final void invoke(@NotNull Instruction instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                if (!(instruction instanceof CallInstruction)) {
                    return;
                }
                this.$onCall.invoke((Object)instruction, ((CallInstruction)instruction).getResolvedCall());
            }
        }));
    }

    private final void report(Diagnostic diagnostic, VariableContext ctxt) {
        Instruction instruction = ctxt.getInstruction$cfg();
        if (instruction.getCopies().isEmpty()) {
            this.trace.report(diagnostic);
            return;
        }
        Map<Instruction, DiagnosticFactory<?>> previouslyReported = ctxt.getReportedDiagnosticMap$cfg();
        previouslyReported.put(instruction, diagnostic.getFactory());
        boolean alreadyReported = false;
        boolean sameErrorForAllCopies = true;
        for (Instruction copy2 : instruction.getCopies()) {
            DiagnosticFactory<?> previouslyReportedErrorFactory = previouslyReported.get(copy2);
            if (previouslyReportedErrorFactory != null) {
                alreadyReported = true;
            }
            if (previouslyReportedErrorFactory == diagnostic.getFactory()) continue;
            sameErrorForAllCopies = false;
        }
        if (ControlFlowInformationProviderImpl.Companion.mustBeReportedOnAllCopies(diagnostic.getFactory())) {
            if (sameErrorForAllCopies) {
                this.trace.report(diagnostic);
            }
        } else if (!alreadyReported) {
            this.trace.report(diagnostic);
        }
    }

    private final PsiElement getDeparenthesizedParent(PsiElement $this$deparenthesizedParent) {
        PsiElement result2 = $this$deparenthesizedParent.getParent();
        while (result2 instanceof KtParenthesizedExpression || result2 instanceof KtLabeledExpression || result2 instanceof KtAnnotatedExpression) {
            result2 = result2.getParent();
        }
        PsiElement psiElement = result2;
        Intrinsics.checkNotNull((Object)psiElement);
        return psiElement;
    }

    private static final void markImplicitReceiverOfSuspendLambda$markIfNeeded(CallableDescriptor $this$markImplicitReceiverOfSuspendLambda_u24markIfNeeded, ControlFlowInformationProviderImpl this$0) {
        if ($this$markImplicitReceiverOfSuspendLambda_u24markIfNeeded instanceof AnonymousFunctionDescriptor && ((AnonymousFunctionDescriptor)$this$markImplicitReceiverOfSuspendLambda_u24markIfNeeded).isSuspend()) {
            this$0.trace.record(BindingContext.SUSPEND_LAMBDA_PARAMETER_USED, TuplesKt.to((Object)$this$markImplicitReceiverOfSuspendLambda_u24markIfNeeded, (Object)-1));
        }
    }

    private static final void markImplicitReceiverOfSuspendLambda$dfs(Set<Instruction> visited2, KtElement element, ControlFlowInformationProviderImpl this$0, Instruction insn) {
        if (!visited2.add(insn)) {
            return;
        }
        if (insn instanceof CallInstruction && Intrinsics.areEqual((Object)((CallInstruction)insn).getElement(), (Object)element)) {
            Iterator<Object> iterator2 = ((CallInstruction)insn).getReceiverValues().entrySet().iterator();
            while (iterator2.hasNext()) {
                ReceiverValue receiver = (ReceiverValue)((Map.Entry)iterator2.next()).getValue();
                Object object = receiver instanceof ExtensionReceiver ? (ExtensionReceiver)receiver : null;
                if (object != null && (object = ((ExtensionReceiver)object).getDeclarationDescriptor()) != null) {
                    Object object2;
                    Object $this$markImplicitReceiverOfSuspendLambda_u24dfs_u24lambda_u248 = object2 = object;
                    boolean bl = false;
                    ControlFlowInformationProviderImpl.markImplicitReceiverOfSuspendLambda$markIfNeeded((CallableDescriptor)$this$markImplicitReceiverOfSuspendLambda_u24dfs_u24lambda_u248, this$0);
                }
            }
        }
        for (Instruction next : insn.getNextInstructions()) {
            ControlFlowInformationProviderImpl.markImplicitReceiverOfSuspendLambda$dfs(visited2, element, this$0, next);
        }
    }

    public static final /* synthetic */ void access$checkIsInitialized(ControlFlowInformationProviderImpl $this, VariableInitContext ctxt, KtElement element, Collection varWithUninitializedErrorGenerated) {
        $this.checkIsInitialized(ctxt, element, varWithUninitializedErrorGenerated);
    }

    public static final /* synthetic */ boolean access$checkValReassignment(ControlFlowInformationProviderImpl $this, VariableInitContext ctxt, KtExpression expression2, WriteValueInstruction writeValueInstruction, Collection varWithValReassignErrorGenerated) {
        return $this.checkValReassignment(ctxt, expression2, writeValueInstruction, varWithValReassignErrorGenerated);
    }

    public static final /* synthetic */ boolean access$checkAssignmentBeforeDeclaration(ControlFlowInformationProviderImpl $this, VariableInitContext ctxt, KtExpression expression2) {
        return $this.checkAssignmentBeforeDeclaration(ctxt, expression2);
    }

    public static final /* synthetic */ boolean access$checkInitializationForCustomSetter(ControlFlowInformationProviderImpl $this, VariableInitContext ctxt, KtExpression expression2) {
        return $this.checkInitializationForCustomSetter(ctxt, expression2);
    }

    public static final /* synthetic */ PseudocodeVariablesData access$getPseudocodeVariablesData(ControlFlowInformationProviderImpl $this) {
        return $this.getPseudocodeVariablesData();
    }

    public static final /* synthetic */ void access$processUnusedDeclaration(ControlFlowInformationProviderImpl $this, KtNamedDeclaration element, VariableDescriptor variableDescriptor, VariableUseContext ctxt, VariableUseState variableUseState) {
        $this.processUnusedDeclaration(element, variableDescriptor, ctxt, variableUseState);
    }

    public static final /* synthetic */ void access$report(ControlFlowInformationProviderImpl $this, Diagnostic diagnostic, VariableContext ctxt) {
        $this.report(diagnostic, ctxt);
    }

    public static final /* synthetic */ void access$recordUsedAsExpression(ControlFlowInformationProviderImpl $this, KtExpression $receiver) {
        $this.recordUsedAsExpression($receiver);
    }

    public static final /* synthetic */ void access$checkImplicitCastOnConditionalExpression(ControlFlowInformationProviderImpl $this, KtExpression expression2) {
        $this.checkImplicitCastOnConditionalExpression(expression2);
    }

    public static final /* synthetic */ LanguageVersionSettings access$getLanguageVersionSettings$p(ControlFlowInformationProviderImpl $this) {
        return $this.languageVersionSettings;
    }

    public static final /* synthetic */ PsiElement access$getDeparenthesizedParent(ControlFlowInformationProviderImpl $this, PsiElement $receiver) {
        return $this.getDeparenthesizedParent($receiver);
    }

    public static final /* synthetic */ EnumWhenTracker access$getEnumWhenTracker$p(ControlFlowInformationProviderImpl $this) {
        return $this.enumWhenTracker;
    }

    public static final /* synthetic */ void access$checkExhaustiveWhenStatement(ControlFlowInformationProviderImpl $this, KotlinType subjectType, KtWhenExpression element, List missingCases) {
        $this.checkExhaustiveWhenStatement(subjectType, element, missingCases);
    }

    public static final /* synthetic */ void access$checkWhenStatement(ControlFlowInformationProviderImpl $this, KotlinType subjectType, KtWhenExpression element, BindingContext context2) {
        $this.checkWhenStatement(subjectType, element, context2);
    }

    public static final /* synthetic */ void access$markAnnotationArguments(ControlFlowInformationProviderImpl $this, KtAnnotationEntry entry) {
        $this.markAnnotationArguments(entry);
    }

    public static final /* synthetic */ boolean access$isInsideTry(ControlFlowInformationProviderImpl $this, KtElement element) {
        return $this.isInsideTry(element);
    }

    public static final /* synthetic */ Pseudocode access$getPseudocode$p(ControlFlowInformationProviderImpl $this) {
        return $this.pseudocode;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$AlgebraicTypeKind;", "", "displayName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getDisplayName", "()Ljava/lang/String;", "Sealed", "Enum", "Boolean", "cfg"})
    private static final class AlgebraicTypeKind
    extends Enum<AlgebraicTypeKind> {
        @NotNull
        private final String displayName;
        public static final /* enum */ AlgebraicTypeKind Sealed = new AlgebraicTypeKind("sealed class/interface");
        public static final /* enum */ AlgebraicTypeKind Enum = new AlgebraicTypeKind("enum");
        public static final /* enum */ AlgebraicTypeKind Boolean = new AlgebraicTypeKind("Boolean");
        private static final /* synthetic */ AlgebraicTypeKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private AlgebraicTypeKind(String displayName) {
            this.displayName = displayName;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public static AlgebraicTypeKind[] values() {
            return (AlgebraicTypeKind[])$VALUES.clone();
        }

        public static AlgebraicTypeKind valueOf(String value2) {
            return java.lang.Enum.valueOf(AlgebraicTypeKind.class, value2);
        }

        @NotNull
        public static EnumEntries<AlgebraicTypeKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = algebraicTypeKindArray = new AlgebraicTypeKind[]{AlgebraicTypeKind.Sealed, AlgebraicTypeKind.Enum, AlgebraicTypeKind.Boolean};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u000e2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0016\u0010\u0016\u001a\u00020\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\nH\u0002J\u0014\u0010\u0019\u001a\u00020\u00042\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$Companion;", "", "()V", "check", "", "a", "b", "x", "y", "collectResultingExpressionsOfConditionalExpression", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "collectResultingExpressionsOfConditionalExpressionRec", "", "resultingExpressions", "", "combineKinds", "Lorg/jetbrains/kotlin/cfg/TailRecursionKind;", "kind", "existingKind", "getResultingExpression", "isUsedAsResultOfLambda", "usages", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "mustBeReportedOnAllCopies", "diagnosticFactory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "cfg"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isUsedAsResultOfLambda(List<? extends Instruction> usages) {
            for (Instruction instruction : usages) {
                if (!(instruction instanceof ReturnValueInstruction)) continue;
                KtElement returnElement = ((ReturnValueInstruction)instruction).getElement();
                PsiElement parentElement = returnElement.getParent();
                if (returnElement instanceof KtReturnExpression || parentElement instanceof KtDeclaration && !(parentElement instanceof KtFunctionLiteral)) continue;
                return true;
            }
            return false;
        }

        private final List<KtExpression> collectResultingExpressionsOfConditionalExpression(KtExpression expression2) {
            ArrayList leafBranches = new ArrayList();
            this.collectResultingExpressionsOfConditionalExpressionRec(expression2, leafBranches);
            return leafBranches;
        }

        private final void collectResultingExpressionsOfConditionalExpressionRec(KtExpression expression2, List<KtExpression> resultingExpressions) {
            KtExpression ktExpression = expression2;
            if (ktExpression instanceof KtIfExpression) {
                this.collectResultingExpressionsOfConditionalExpressionRec(((KtIfExpression)expression2).getThen(), resultingExpressions);
                this.collectResultingExpressionsOfConditionalExpressionRec(((KtIfExpression)expression2).getElse(), resultingExpressions);
            } else if (ktExpression instanceof KtWhenExpression) {
                for (KtWhenEntry whenEntry : ((KtWhenExpression)expression2).getEntries()) {
                    this.collectResultingExpressionsOfConditionalExpressionRec(whenEntry.getExpression(), resultingExpressions);
                }
            } else if (ktExpression instanceof Object) {
                KtExpression resultingExpression = this.getResultingExpression(expression2);
                if (resultingExpression instanceof KtIfExpression || resultingExpression instanceof KtWhenExpression) {
                    this.collectResultingExpressionsOfConditionalExpressionRec(resultingExpression, resultingExpressions);
                } else {
                    resultingExpressions.add(resultingExpression);
                }
            }
        }

        private final KtExpression getResultingExpression(KtExpression expression2) {
            KtExpression finger = expression2;
            while (true) {
                KtExpression deparenthesized = KtPsiUtil.deparenthesize(finger);
                if ((deparenthesized = KtPsiUtil.getExpressionOrLastStatementInBlock(deparenthesized)) == null || deparenthesized == finger) break;
                finger = deparenthesized;
            }
            return finger;
        }

        private final TailRecursionKind combineKinds(TailRecursionKind kind, TailRecursionKind existingKind) {
            return existingKind == null || existingKind == kind ? kind : (this.check((Object)kind, (Object)existingKind, (Object)TailRecursionKind.IN_TRY, (Object)TailRecursionKind.TAIL_CALL) ? TailRecursionKind.IN_TRY : (this.check((Object)kind, (Object)existingKind, (Object)TailRecursionKind.IN_TRY, (Object)TailRecursionKind.NON_TAIL) ? TailRecursionKind.IN_TRY : TailRecursionKind.NON_TAIL));
        }

        private final boolean check(Object a, Object b, Object x, Object y) {
            return a == x && b == y || a == y && b == x;
        }

        private final boolean mustBeReportedOnAllCopies(DiagnosticFactory<?> diagnosticFactory) {
            return diagnosticFactory == Errors.UNUSED_VARIABLE || diagnosticFactory == Errors.UNUSED_PARAMETER || diagnosticFactory == Errors.UNUSED_ANONYMOUS_PARAMETER || diagnosticFactory == Errors.UNUSED_CHANGED_VALUE;
        }

        public static final /* synthetic */ boolean access$isUsedAsResultOfLambda(Companion $this, List usages) {
            return $this.isUsedAsResultOfLambda(usages);
        }

        public static final /* synthetic */ TailRecursionKind access$combineKinds(Companion $this, TailRecursionKind kind, TailRecursionKind existingKind) {
            return $this.combineKinds(kind, existingKind);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$Factory;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProvider$Factory;", "()V", "createControlFlowInformationProvider", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProvider;", "declaration", "Lorg/jetbrains/kotlin/psi/KtElement;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "diagnosticSuppressor", "Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;", "enumWhenTracker", "Lorg/jetbrains/kotlin/incremental/components/EnumWhenTracker;", "cfg"})
    public static final class Factory
    implements ControlFlowInformationProvider.Factory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        @NotNull
        public ControlFlowInformationProvider createControlFlowInformationProvider(@NotNull KtElement declaration, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull PlatformDiagnosticSuppressor diagnosticSuppressor, @NotNull EnumWhenTracker enumWhenTracker) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
            Intrinsics.checkNotNullParameter((Object)diagnosticSuppressor, (String)"diagnosticSuppressor");
            Intrinsics.checkNotNullParameter((Object)enumWhenTracker, (String)"enumWhenTracker");
            return new ControlFlowInformationProviderImpl(declaration, trace, languageVersionSettings2, diagnosticSuppressor, enumWhenTracker);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$ReturnedExpressionsInfo;", "", "returnedExpressions", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "hasReturnsInInlinedLambda", "", "(Ljava/util/Collection;Z)V", "getHasReturnsInInlinedLambda", "()Z", "getReturnedExpressions", "()Ljava/util/Collection;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "cfg"})
    private static final class ReturnedExpressionsInfo {
        @NotNull
        private final Collection<KtElement> returnedExpressions;
        private final boolean hasReturnsInInlinedLambda;

        public ReturnedExpressionsInfo(@NotNull Collection<? extends KtElement> returnedExpressions, boolean hasReturnsInInlinedLambda) {
            Intrinsics.checkNotNullParameter(returnedExpressions, (String)"returnedExpressions");
            this.returnedExpressions = returnedExpressions;
            this.hasReturnsInInlinedLambda = hasReturnsInInlinedLambda;
        }

        @NotNull
        public final Collection<KtElement> getReturnedExpressions() {
            return this.returnedExpressions;
        }

        public final boolean getHasReturnsInInlinedLambda() {
            return this.hasReturnsInInlinedLambda;
        }

        @NotNull
        public final Collection<KtElement> component1() {
            return this.returnedExpressions;
        }

        public final boolean component2() {
            return this.hasReturnsInInlinedLambda;
        }

        @NotNull
        public final ReturnedExpressionsInfo copy(@NotNull Collection<? extends KtElement> returnedExpressions, boolean hasReturnsInInlinedLambda) {
            Intrinsics.checkNotNullParameter(returnedExpressions, (String)"returnedExpressions");
            return new ReturnedExpressionsInfo(returnedExpressions, hasReturnsInInlinedLambda);
        }

        public static /* synthetic */ ReturnedExpressionsInfo copy$default(ReturnedExpressionsInfo returnedExpressionsInfo, Collection collection, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                collection = returnedExpressionsInfo.returnedExpressions;
            }
            if ((n & 2) != 0) {
                bl = returnedExpressionsInfo.hasReturnsInInlinedLambda;
            }
            return returnedExpressionsInfo.copy(collection, bl);
        }

        @NotNull
        public String toString() {
            return "ReturnedExpressionsInfo(returnedExpressions=" + this.returnedExpressions + ", hasReturnsInInlinedLambda=" + this.hasReturnsInInlinedLambda + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.returnedExpressions).hashCode();
            int n = this.hasReturnsInInlinedLambda ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReturnedExpressionsInfo)) {
                return false;
            }
            ReturnedExpressionsInfo returnedExpressionsInfo = (ReturnedExpressionsInfo)other;
            if (!Intrinsics.areEqual(this.returnedExpressions, returnedExpressionsInfo.returnedExpressions)) {
                return false;
            }
            return this.hasReturnsInInlinedLambda == returnedExpressionsInfo.hasReturnsInInlinedLambda;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0092\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableContext;", "", "instruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "reportedDiagnosticMap", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "(Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;Ljava/util/Map;)V", "getInstruction$cfg", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "getReportedDiagnosticMap$cfg", "()Ljava/util/Map;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "getVariableDescriptor$cfg", "()Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "cfg"})
    private class VariableContext {
        @NotNull
        private final Instruction instruction;
        @NotNull
        private final Map<Instruction, DiagnosticFactory<?>> reportedDiagnosticMap;
        @Nullable
        private final VariableDescriptor variableDescriptor;

        public VariableContext(@NotNull Instruction instruction, Map<Instruction, DiagnosticFactory<?>> reportedDiagnosticMap) {
            Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
            Intrinsics.checkNotNullParameter(reportedDiagnosticMap, (String)"reportedDiagnosticMap");
            this.instruction = instruction;
            this.reportedDiagnosticMap = reportedDiagnosticMap;
            this.variableDescriptor = PseudocodeUtil.extractVariableDescriptorFromReference(this.instruction, ControlFlowInformationProviderImpl.this.trace.getBindingContext());
        }

        @NotNull
        public final Instruction getInstruction$cfg() {
            return this.instruction;
        }

        @NotNull
        public final Map<Instruction, DiagnosticFactory<?>> getReportedDiagnosticMap$cfg() {
            return this.reportedDiagnosticMap;
        }

        @Nullable
        public final VariableDescriptor getVariableDescriptor$cfg() {
            return this.variableDescriptor;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ$\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\tH\u0002R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableInitContext;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableContext;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl;", "instruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "map", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "in", "Lorg/jetbrains/kotlin/cfg/variable/VariableInitReadOnlyControlFlowInfo;", "out", "blockScopeVariableInfo", "Lorg/jetbrains/kotlin/cfg/variable/BlockScopeVariableInfo;", "(Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;Ljava/util/Map;Lorg/jetbrains/kotlin/cfg/variable/VariableInitReadOnlyControlFlowInfo;Lorg/jetbrains/kotlin/cfg/variable/VariableInitReadOnlyControlFlowInfo;Lorg/jetbrains/kotlin/cfg/variable/BlockScopeVariableInfo;)V", "enterInitState", "Lorg/jetbrains/kotlin/cfg/variable/VariableControlFlowState;", "getEnterInitState$cfg", "()Lorg/jetbrains/kotlin/cfg/variable/VariableControlFlowState;", "exitInitState", "getExitInitState$cfg", "initialize", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "cfg"})
    private final class VariableInitContext
    extends VariableContext {
        @Nullable
        private final VariableControlFlowState enterInitState;
        @Nullable
        private final VariableControlFlowState exitInitState;

        public VariableInitContext(@NotNull Instruction instruction, @NotNull Map<Instruction, DiagnosticFactory<?>> map, @NotNull VariableInitReadOnlyControlFlowInfo in, @NotNull VariableInitReadOnlyControlFlowInfo out, BlockScopeVariableInfo blockScopeVariableInfo) {
            Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
            Intrinsics.checkNotNullParameter(map, (String)"map");
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)blockScopeVariableInfo, (String)"blockScopeVariableInfo");
            super(instruction, map);
            this.enterInitState = this.initialize(this.getVariableDescriptor$cfg(), blockScopeVariableInfo, in);
            this.exitInitState = this.initialize(this.getVariableDescriptor$cfg(), blockScopeVariableInfo, out);
        }

        @Nullable
        public final VariableControlFlowState getEnterInitState$cfg() {
            return this.enterInitState;
        }

        @Nullable
        public final VariableControlFlowState getExitInitState$cfg() {
            return this.exitInitState;
        }

        private final VariableControlFlowState initialize(VariableDescriptor variableDescriptor, BlockScopeVariableInfo blockScopeVariableInfo, VariableInitReadOnlyControlFlowInfo map) {
            VariableDescriptor variableDescriptor2 = variableDescriptor;
            if (variableDescriptor2 == null) {
                return null;
            }
            VariableControlFlowState state = (VariableControlFlowState)map.getOrNull(variableDescriptor2);
            if (state != null) {
                return state;
            }
            return PseudocodeVariablesData.Companion.getDefaultValueForInitializers(variableDescriptor, this.getInstruction$cfg(), blockScopeVariableInfo);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableUseContext;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableContext;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl;", "instruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "map", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "(Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;Ljava/util/Map;)V", "cfg"})
    private final class VariableUseContext
    extends VariableContext {
        public VariableUseContext(@NotNull Instruction instruction, Map<Instruction, DiagnosticFactory<?>> map) {
            Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(instruction, map);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TailRecursionKind.values().length];
            try {
                nArray[TailRecursionKind.TAIL_CALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TailRecursionKind.IN_TRY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TailRecursionKind.NON_TAIL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

