/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization.constant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.constant.AnnotationValue;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.ErrorValue;
import org.jetbrains.kotlin.constant.KClassValue;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;
import org.jetbrains.kotlin.fir.serialization.constant.FirToConstantValueTransformerData;
import org.jetbrains.kotlin.fir.serialization.constant.FirToConstantValueTransformerUnsafe;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.ClassLiteralValue;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001e\u0010\u0004\u001a\u0002H\u0005\"\n\b\u0000\u0010\u0005\u0018\u0001*\u00020\u0003*\u00020\u0006H\u0086\b\u00a2\u0006\u0002\u0010\u0007\u001a \u0010\b\u001a\u0004\u0018\u0001H\u0005\"\n\b\u0000\u0010\u0005\u0018\u0001*\u00020\u0003*\u00020\tH\u0086\b\u00a2\u0006\u0002\u0010\n\u001aJ\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\f*\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0000\u001a:\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\f*\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0000\u001a\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0003*\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a8\u0006\u0018"}, d2={"create", "Lorg/jetbrains/kotlin/constant/ConstantValue;", "argumentType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "coneType", "T", "Lorg/jetbrains/kotlin/constant/KClassValue$Value$LocalClass;", "(Lorg/jetbrains/kotlin/constant/KClassValue$Value$LocalClass;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "coneTypeSafe", "Lorg/jetbrains/kotlin/constant/AnnotationValue;", "(Lorg/jetbrains/kotlin/constant/AnnotationValue;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "convertToConstantValues", "", "Lorg/jetbrains/kotlin/name/Name;", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lkotlin/collections/LinkedHashMap;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "constValueProvider", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "getArgumentType", "Lorg/jetbrains/kotlin/constant/KClassValue;", "fir-serialization"})
@SourceDebugExtension(value={"SMAP\nConstantValueUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantValueUtils.kt\norg/jetbrains/kotlin/fir/serialization/constant/ConstantValueUtilsKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 FirToConstantValueTransformer.kt\norg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformerKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,84:1\n125#2:85\n152#2,2:86\n154#2:91\n125#2:92\n152#2,3:93\n33#3,2:88\n218#4:90\n*S KotlinDebug\n*F\n+ 1 ConstantValueUtils.kt\norg/jetbrains/kotlin/fir/serialization/constant/ConstantValueUtilsKt\n*L\n29#1:85\n29#1:86,2\n29#1:91\n44#1:92\n44#1:93,3\n31#1:88,2\n32#1:90\n*E\n"})
public final class ConstantValueUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<Name, ConstantValue<?>> convertToConstantValues(@NotNull Map<Name, ? extends FirExpression> $this$convertToConstantValues, @NotNull FirSession session, @Nullable ConstValueProvider constValueProvider) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$convertToConstantValues, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Map<Name, ? extends FirExpression> $this$map$iv = $this$convertToConstantValues;
        boolean $i$f$map = false;
        Map<Name, ? extends FirExpression> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Name name2 = (Name)entry.getKey();
            FirExpression firExpression2 = (FirExpression)entry.getValue();
            Object object = constValueProvider;
            if (object == null || (object = ((ConstValueProvider)object).findConstantValueFor(firExpression2)) == null) {
                ConstantValue constantValue;
                FirExpression $this$toConstantValue$iv = firExpression2;
                boolean $i$f$toConstantValue = false;
                ConstValueProvider constValueProvider2 = constValueProvider;
                ConstantValue constantValue2 = constValueProvider2 != null ? constValueProvider2.findConstantValueFor($this$toConstantValue$iv) : null;
                if (!(constantValue2 instanceof ConstantValue)) {
                    constantValue2 = constantValue = null;
                }
                if (constantValue2 == null) {
                    Object r = $this$toConstantValue$iv.accept(new FirToConstantValueTransformerUnsafe(), new FirToConstantValueTransformerData(session, constValueProvider));
                    if (!(r instanceof ConstantValue)) {
                        r = null;
                    }
                    constantValue = (ConstantValue)r;
                }
                object = constantValue;
                if (constantValue == null) {
                    ErrorValue.ErrorValueWithMessage errorValueWithMessage;
                    boolean condition$iv = FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).getFlag(AnalysisFlags.getMetadataCompilation());
                    boolean $i$f$runIf = false;
                    if (condition$iv) {
                        boolean bl2 = false;
                        errorValueWithMessage = new ErrorValue.ErrorValueWithMessage("Constant conversion can be ignored in metadata compilation mode");
                    } else {
                        errorValueWithMessage = null;
                    }
                    if (errorValueWithMessage != null) {
                        object = errorValueWithMessage;
                    } else {
                        throw new IllegalStateException(("Cannot convert expression " + UtilsKt.render(firExpression2) + " to constant").toString());
                    }
                }
            }
            ConstantValue constantValue = object;
            collection.add(TuplesKt.to((Object)name2, (Object)constantValue));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<Name, ConstantValue<?>> convertToConstantValues(@NotNull LinkedHashMap<FirExpression, FirValueParameter> $this$convertToConstantValues, @NotNull FirSession session, @Nullable ConstValueProvider constValueProvider) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$convertToConstantValues, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Map $this$map$iv = $this$convertToConstantValues;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FirExpression firExpression2 = (FirExpression)entry.getKey();
            FirValueParameter firValueParameter = (FirValueParameter)entry.getValue();
            collection.add(TuplesKt.to((Object)firValueParameter.getName(), (Object)firExpression2));
        }
        return ConstantValueUtilsKt.convertToConstantValues(MapsKt.toMap((Iterable)((List)destination$iv$iv)), session, constValueProvider);
    }

    public static final /* synthetic */ <T extends ConeKotlinType> T coneTypeSafe(AnnotationValue $this$coneTypeSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$coneTypeSafe, (String)"<this>");
        boolean $i$f$coneTypeSafe = false;
        KotlinTypeMarker kotlinTypeMarker = ((AnnotationValue.Value)$this$coneTypeSafe.getValue()).getType();
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)((ConeKotlinType)kotlinTypeMarker);
    }

    public static final /* synthetic */ <T extends ConeKotlinType> T coneType(KClassValue.Value.LocalClass $this$coneType) {
        Intrinsics.checkNotNullParameter((Object)$this$coneType, (String)"<this>");
        boolean $i$f$coneType = false;
        KotlinTypeMarker kotlinTypeMarker = $this$coneType.getType();
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)((ConeKotlinType)kotlinTypeMarker);
    }

    @Nullable
    public static final ConeKotlinType getArgumentType(@NotNull KClassValue $this$getArgumentType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$getArgumentType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        KClassValue.Value castedValue = (KClassValue.Value)$this$getArgumentType.getValue();
        if (castedValue instanceof KClassValue.Value.LocalClass) {
            KotlinTypeMarker kotlinTypeMarker = ((KClassValue.Value.LocalClass)castedValue).getType();
            Intrinsics.checkNotNull((Object)kotlinTypeMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            return (ConeKotlinType)kotlinTypeMarker;
        }
        if (castedValue instanceof KClassValue.Value.NormalClass) {
            ClassLiteralValue classLiteralValue = ((KClassValue.Value.NormalClass)castedValue).getValue();
            ClassId classId = classLiteralValue.component1();
            int arrayDimensions = classLiteralValue.component2();
            FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(session).getClassLikeSymbolByClassId(classId);
            FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
            FirRegularClass firRegularClass = firClassLikeDeclaration instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration : null;
            if (firRegularClass == null) {
                return null;
            }
            FirRegularClass klass = firRegularClass;
            ConeClassLikeType type2 = null;
            type2 = ConeTypeUtilsKt.replaceArgumentsWithStarProjections(ScopeUtilsKt.defaultType(klass));
            int n = 0;
            while (n < arrayDimensions) {
                int it = n++;
                boolean bl = false;
                type2 = ArrayUtilsKt.createArrayType$default(type2, false, false, 3, null);
            }
            return type2;
        }
        throw new NoWhenBranchMatchedException();
    }

    @Nullable
    public static final ConstantValue<?> create(@NotNull ConeKotlinType argumentType) {
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        if (argumentType instanceof ConeErrorType) {
            return null;
        }
        if (!(argumentType instanceof ConeClassLikeType)) {
            return null;
        }
        ConeKotlinType type2 = argumentType;
        int arrayDimensions = 0;
        while (!ConeBuiltinTypeUtilsKt.isPrimitiveArray(type2) && ArrayUtilsKt.arrayElementType(type2) != null) {
            ++arrayDimensions;
        }
        ClassId classId = ConeTypeUtilsKt.getClassId(type2);
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        return new KClassValue(classId2, arrayDimensions);
    }
}

