/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ConcurrentModificationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirOuterClassArgumentsRequiredChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolveState;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOuterClassArgumentsRequiredChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkOuterClassArgumentsRequired", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOuterClassArgumentsRequiredChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOuterClassArgumentsRequiredChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOuterClassArgumentsRequiredChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class FirOuterClassArgumentsRequiredChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirOuterClassArgumentsRequiredChecker INSTANCE = new FirOuterClassArgumentsRequiredChecker();

    private FirOuterClassArgumentsRequiredChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirResolveState oldResolveState = declaration.getResolveState();
        List oldList = CollectionsKt.toList((Iterable)declaration.getSuperTypeRefs());
        try {
            for (FirTypeRef superTypeRef : declaration.getSuperTypeRefs()) {
                this.checkOuterClassArgumentsRequired(superTypeRef, declaration, context2, reporter);
            }
        }
        catch (ConcurrentModificationException e) {
            FirResolveState newResolveState = declaration.getResolveState();
            List newList = CollectionsKt.toList((Iterable)declaration.getSuperTypeRefs());
            throw new IllegalStateException(StringsKt.trimIndent((String)("\n                CME while traversing superTypeRefs of declaration=" + UtilsKt.render(declaration) + ":\n                classId: " + FirDeclarationUtilKt.getClassId(declaration) + ",\n                oldState: " + oldResolveState + ", oldList: " + CollectionsKt.joinToString$default((Iterable)oldList, null, null, null, (int)0, null, (Function1)check.1.INSTANCE, (int)31, null) + ",\n                newState: " + newResolveState + ", newList: " + CollectionsKt.joinToString$default((Iterable)newList, null, null, null, (int)0, null, (Function1)check.2.INSTANCE, (int)31, null) + "\n                ")), e);
        }
    }

    private final void checkOuterClassArgumentsRequired(FirTypeRef typeRef, FirRegularClass declaration, CheckerContext context2, DiagnosticReporter reporter) {
        FirClassLikeSymbol<?> symbol2;
        if (!(typeRef instanceof FirResolvedTypeRef) || typeRef instanceof FirErrorTypeRef) {
            return;
        }
        ConeKotlinType type2 = ((FirResolvedTypeRef)typeRef).getType();
        FirTypeRef delegatedTypeRef = ((FirResolvedTypeRef)typeRef).getDelegatedTypeRef();
        if (delegatedTypeRef instanceof FirUserTypeRef && type2 instanceof ConeClassLikeType && (symbol2 = LookupTagUtilsKt.toSymbol(((ConeClassLikeType)type2).getLookupTag(), context2.getSession())) instanceof FirRegularClassSymbol) {
            ConeTypeProjection[] typeArguments = DeclarationUtilsKt.toTypeProjections(((FirUserTypeRef)delegatedTypeRef).getQualifier());
            List<FirTypeParameterSymbol> typeParameters2 = symbol2.getTypeParameterSymbols();
            int n = typeParameters2.size();
            for (int index2 = typeArguments.length; index2 < n; ++index2) {
                FirTypeParameterSymbol typeParameter2 = typeParameters2.get(index2);
                if (DeclarationUtilsKt.isValidTypeParameterFromOuterDeclaration(typeParameter2, declaration, context2.getSession())) continue;
                FirBasedSymbol<?> firBasedSymbol = typeParameter2.getContainingDeclarationSymbol();
                FirRegularClassSymbol firRegularClassSymbol = firBasedSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firBasedSymbol : null;
                if (firRegularClassSymbol == null) break;
                FirRegularClassSymbol outerClass = firRegularClassSymbol;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getOUTER_CLASS_ARGUMENTS_REQUIRED(), (Object)outerClass, (DiagnosticContext)context2, null, 16, null);
                break;
            }
        }
        List<FirTypeRefSource> list2 = FirHelpersKt.extractArgumentsTypeRefAndSource(typeRef);
        if (list2 == null) {
            return;
        }
        List<FirTypeRefSource> typeRefAndSourcesForArguments = list2;
        for (FirTypeRefSource firTypeRefSource : typeRefAndSourcesForArguments) {
            FirTypeRef it;
            if (firTypeRefSource.getTypeRef() == null) continue;
            boolean bl = false;
            INSTANCE.checkOuterClassArgumentsRequired(it, declaration, context2, reporter);
        }
    }
}

