/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import com.google.common.collect.ImmutableBiMap;
import com.intellij.psi.tree.IElementType;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;

public final class OperatorTable {
    private static final Map<KtToken, JsBinaryOperator> binaryOperatorsMap = ImmutableBiMap.builder().put((Object)KtTokens.PLUS, (Object)JsBinaryOperator.ADD).put((Object)KtTokens.MINUS, (Object)JsBinaryOperator.SUB).put((Object)KtTokens.MUL, (Object)JsBinaryOperator.MUL).put((Object)KtTokens.DIV, (Object)JsBinaryOperator.DIV).put((Object)KtTokens.EQ, (Object)JsBinaryOperator.ASG).put((Object)KtTokens.GT, (Object)JsBinaryOperator.GT).put((Object)KtTokens.GTEQ, (Object)JsBinaryOperator.GTE).put((Object)KtTokens.LT, (Object)JsBinaryOperator.LT).put((Object)KtTokens.LTEQ, (Object)JsBinaryOperator.LTE).put((Object)KtTokens.ANDAND, (Object)JsBinaryOperator.AND).put((Object)KtTokens.OROR, (Object)JsBinaryOperator.OR).put((Object)KtTokens.PERC, (Object)JsBinaryOperator.MOD).put((Object)KtTokens.PLUSEQ, (Object)JsBinaryOperator.ASG_ADD).put((Object)KtTokens.MINUSEQ, (Object)JsBinaryOperator.ASG_SUB).put((Object)KtTokens.DIVEQ, (Object)JsBinaryOperator.ASG_DIV).put((Object)KtTokens.MULTEQ, (Object)JsBinaryOperator.ASG_MUL).put((Object)KtTokens.PERCEQ, (Object)JsBinaryOperator.ASG_MOD).put((Object)KtTokens.IN_KEYWORD, (Object)JsBinaryOperator.INOP).put((Object)KtTokens.EQEQEQ, (Object)JsBinaryOperator.REF_EQ).put((Object)KtTokens.EXCLEQEQEQ, (Object)JsBinaryOperator.REF_NEQ).build();
    private static final ImmutableBiMap<KtToken, JsUnaryOperator> unaryOperatorsMap = ImmutableBiMap.builder().put((Object)KtTokens.PLUSPLUS, (Object)JsUnaryOperator.INC).put((Object)KtTokens.MINUSMINUS, (Object)JsUnaryOperator.DEC).put((Object)KtTokens.EXCL, (Object)JsUnaryOperator.NOT).put((Object)KtTokens.MINUS, (Object)JsUnaryOperator.NEG).put((Object)KtTokens.PLUS, (Object)JsUnaryOperator.POS).build();

    private OperatorTable() {
    }

    public static boolean hasCorrespondingOperator(@NotNull KtToken token) {
        if (token == null) {
            OperatorTable.$$$reportNull$$$0(0);
        }
        return binaryOperatorsMap.containsKey((Object)token) || unaryOperatorsMap.containsKey((Object)token);
    }

    public static boolean hasCorrespondingBinaryOperator(@NotNull KtToken token) {
        if (token == null) {
            OperatorTable.$$$reportNull$$$0(1);
        }
        return binaryOperatorsMap.containsKey((Object)token);
    }

    @NotNull
    public static JsBinaryOperator getBinaryOperator(@NotNull KtToken token) {
        if (token == null) {
            OperatorTable.$$$reportNull$$$0(2);
        }
        assert (KtTokens.OPERATIONS.contains((IElementType)token)) : "Token should represent an operation!";
        JsBinaryOperator jsBinaryOperator = binaryOperatorsMap.get((Object)token);
        if (jsBinaryOperator == null) {
            OperatorTable.$$$reportNull$$$0(3);
        }
        return jsBinaryOperator;
    }

    @NotNull
    public static JsUnaryOperator getUnaryOperator(@NotNull KtToken token) {
        if (token == null) {
            OperatorTable.$$$reportNull$$$0(4);
        }
        assert (KtTokens.OPERATIONS.contains((IElementType)token)) : "Token should represent an operation!";
        JsUnaryOperator jsUnaryOperator = (JsUnaryOperator)unaryOperatorsMap.get((Object)token);
        if (jsUnaryOperator == null) {
            OperatorTable.$$$reportNull$$$0(5);
        }
        return jsUnaryOperator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/operation/OperatorTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/operation/OperatorTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryOperator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnaryOperator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasCorrespondingOperator";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasCorrespondingBinaryOperator";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryOperator";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUnaryOperator";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

