/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueClassRepresentationKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.ValueClassesUtilsKt;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitAnyTypeRef;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u0014*\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0014*\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u0014*\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u0014*\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001bH\u0002J\u0014\u0010 \u001a\u00020\u0014*\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "boxAndUnboxNames", "", "", "cloneableFqName", "Lorg/jetbrains/kotlin/name/FqName;", "equalsAndHashCodeNames", "javaLangFqName", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isCloneableId", "", "Lorg/jetbrains/kotlin/name/ClassId;", "isGenericArrayOfTypeParameter", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isInapplicableParameterType", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "isNotFinalReadOnly", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "primaryConstructorProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "isRelatedToParameter", "parameter", "isSubtypeOfCloneable", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirValueClassDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,293:1\n35#2:294\n51#2:295\n11#2:296\n35#2:309\n90#3:297\n34#4:298\n1194#5,2:299\n1222#5,4:301\n1855#5,2:311\n1747#5,3:315\n125#6:305\n152#6,3:306\n36#7:310\n12474#8,2:313\n*S KotlinDebug\n*F\n+ 1 FirValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker\n*L\n48#1:294\n48#1:295\n52#1:296\n94#1:309\n59#1:297\n59#1:298\n79#1:299,2\n79#1:301,4\n223#1:311,2\n283#1:315,3\n81#1:305\n81#1:306,3\n113#1:310\n241#1:313,2\n*E\n"})
public final class FirValueClassDeclarationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirValueClassDeclarationChecker INSTANCE = new FirValueClassDeclarationChecker();
    @NotNull
    private static final Set<String> boxAndUnboxNames;
    @NotNull
    private static final Set<String> equalsAndHashCodeNames;
    @NotNull
    private static final FqName javaLangFqName;
    @NotNull
    private static final FqName cloneableFqName;

    private FirValueClassDeclarationChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block42: {
            block41: {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                if (!DeclarationUtilsKt.isInlineOrValueClass(declaration.getSymbol())) {
                    return;
                }
                FirMemberDeclaration $this$isInner$iv = declaration;
                boolean $i$f$isInner = false;
                if ($this$isInner$iv.getStatus().isInner()) break block41;
                FirClassLikeDeclaration $this$isLocal$iv = declaration;
                boolean $i$f$isLocal = false;
                if (!$this$isLocal$iv.getSymbol().getClassId().isLocal()) break block42;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_NOT_TOP_LEVEL(), (DiagnosticContext)context2, null, 8, null);
        }
        FirMemberDeclaration $this$modality$iv = declaration;
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getStatus().getModality() != Modality.FINAL) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_NOT_FINAL(), (DiagnosticContext)context2, null, 8, null);
        }
        for (FirTypeRef supertypeEntry : declaration.getSuperTypeRefs()) {
            boolean bl;
            if (supertypeEntry instanceof FirImplicitAnyTypeRef) continue;
            FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(supertypeEntry, context2.getSession());
            if (firRegularClassSymbol != null) {
                FirClassSymbol $this$isInterface$iv = firRegularClassSymbol;
                boolean $i$f$isInterface = false;
                ClassKind classKind = $this$isInterface$iv.getClassKind();
                boolean $i$f$isInterface2 = false;
                bl = classKind == ClassKind.INTERFACE;
            } else {
                bl = false;
            }
            if (bl) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)supertypeEntry.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_EXTEND_CLASSES(), (DiagnosticContext)context2, null, 8, null);
        }
        if (this.isSubtypeOfCloneable(declaration, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_CLONEABLE(), (DiagnosticContext)context2, null, 8, null);
        }
        FirConstructor primaryConstructor2 = null;
        Map primaryConstructorParametersByName = MapsKt.emptyMap();
        Map primaryConstructorPropertiesByName = new LinkedHashMap();
        Set primaryConstructorParametersSymbolsSet = SetsKt.emptySet();
        for (FirDeclaration firDeclaration : declaration.getDeclarations()) {
            FirDeclaration $i$f$isInterface2 = firDeclaration;
            if ($i$f$isInterface2 instanceof FirConstructor) {
                FirBlock body2;
                if (((FirConstructor)firDeclaration).isPrimary()) {
                    void $this$mapTo$iv$iv;
                    Object object;
                    void $this$associateByTo$iv$iv;
                    primaryConstructor2 = (FirConstructor)firDeclaration;
                    Iterable $this$associateBy$iv = ((FirConstructor)firDeclaration).getValueParameters();
                    boolean $i$f$associateBy = false;
                    int capacity$iv232 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                    Iterable iterable = $this$associateBy$iv;
                    Map destination$iv$iv = new LinkedHashMap(capacity$iv232);
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                        void it;
                        FirValueParameter firValueParameter = (FirValueParameter)element$iv$iv;
                        object = destination$iv$iv;
                        boolean bl = false;
                        object.put(it.getName(), element$iv$iv);
                    }
                    Map $this$map$iv = primaryConstructorParametersByName = destination$iv$iv;
                    boolean $i$f$map = false;
                    Map capacity$iv232 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
                    boolean $i$f$mapTo = false;
                    for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
                        Object element$iv$iv;
                        element$iv$iv = entry;
                        object = destination$iv$iv2;
                        boolean bl = false;
                        FirValueParameter parameter2 = (FirValueParameter)element$iv$iv.getValue();
                        object.add(parameter2.getSymbol());
                    }
                    primaryConstructorParametersSymbolsSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                    continue;
                }
                if (((FirConstructor)firDeclaration).getBody() == null || context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ValueClassesSecondaryConstructorWithBody)) continue;
                Intrinsics.checkNotNull((Object)((FirConstructor)firDeclaration).getBody());
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)body2.getSource(), FirErrors.INSTANCE.getSECONDARY_CONSTRUCTOR_WITH_BODY_INSIDE_VALUE_CLASS(), (DiagnosticContext)context2, null, 8, null);
                continue;
            }
            if ($i$f$isInterface2 instanceof FirRegularClass) {
                FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)firDeclaration;
                boolean $i$f$isInner = false;
                if (!$this$isInner$iv.getStatus().isInner()) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firDeclaration.getSource(), FirErrors.INSTANCE.getINNER_CLASS_INSIDE_VALUE_CLASS(), (DiagnosticContext)context2, null, 8, null);
                continue;
            }
            if ($i$f$isInterface2 instanceof FirSimpleFunction) {
                String functionName;
                Intrinsics.checkNotNullExpressionValue((Object)((FirSimpleFunction)firDeclaration).getName().asString(), (String)"asString(...)");
                if (!boxAndUnboxNames.contains(functionName) && (!equalsAndHashCodeNames.contains(functionName) || context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.CustomEqualsInValueClasses))) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firDeclaration.getSource(), FirErrors.INSTANCE.getRESERVED_MEMBER_INSIDE_VALUE_CLASS(), (Object)functionName, (DiagnosticContext)context2, null, 16, null);
                continue;
            }
            if ($i$f$isInterface2 instanceof FirField) {
                FirCallableSymbol<?> symbol2;
                FirDeclaration $this$isSynthetic$iv = firDeclaration;
                boolean $i$f$isSynthetic = false;
                if (!Intrinsics.areEqual((Object)$this$isSynthetic$iv.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.INSTANCE)) continue;
                FirExpression firExpression2 = ((FirField)firDeclaration).getInitializer();
                FirCallableSymbol<Object> firCallableSymbol = symbol2 = firExpression2 != null ? FirExpressionUtilKt.toResolvedCallableSymbol(firExpression2) : null;
                if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineClassImplementationByDelegation) && symbol2 != null && CollectionsKt.contains((Iterable)primaryConstructorParametersSymbolsSet, symbol2)) continue;
                FirTypeRef firTypeRef = ((FirField)firDeclaration).getReturnTypeRef();
                Intrinsics.checkNotNull((Object)firTypeRef, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirResolvedTypeRef");
                FirTypeRef firTypeRef2 = ((FirResolvedTypeRef)firTypeRef).getDelegatedTypeRef();
                KtSourceElement delegatedTypeRefSource = firTypeRef2 != null ? firTypeRef2.getSource() : null;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)delegatedTypeRefSource, FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_IMPLEMENT_INTERFACE_BY_DELEGATION(), (DiagnosticContext)context2, null, 8, null);
                continue;
            }
            if (!($i$f$isInterface2 instanceof FirProperty)) continue;
            if (this.isRelatedToParameter((FirProperty)firDeclaration, (FirValueParameter)primaryConstructorParametersByName.get(((FirProperty)firDeclaration).getName()))) {
                primaryConstructorPropertiesByName.put(((FirProperty)firDeclaration).getName(), firDeclaration);
                continue;
            }
            if (((FirProperty)firDeclaration).getDelegate() != null) {
                FirExpression firExpression3 = ((FirProperty)firDeclaration).getDelegate();
                Intrinsics.checkNotNull((Object)firExpression3);
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firExpression3.getSource(), FirErrors.INSTANCE.getDELEGATED_PROPERTY_INSIDE_VALUE_CLASS(), (DiagnosticContext)context2, null, 8, null);
                continue;
            }
            if (!DeclarationAttributesKt.getHasBackingField((FirProperty)firDeclaration)) continue;
            KtSourceElement ktSourceElement = firDeclaration.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firDeclaration.getSource(), FirErrors.INSTANCE.getPROPERTY_WITH_BACKING_FIELD_INSIDE_VALUE_CLASS(), (DiagnosticContext)context2, null, 8, null);
        }
        Object object = primaryConstructor2;
        if (!((object != null && (object = ((FirConstructor)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null) instanceof KtRealSourceElementKind)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getABSENCE_OF_PRIMARY_CONSTRUCTOR_FOR_VALUE_CLASS(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ValueClasses)) {
            if (primaryConstructorParametersByName.isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)primaryConstructor2.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_EMPTY_CONSTRUCTOR(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
        } else if (primaryConstructorParametersByName.size() != 1) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)primaryConstructor2.getSource(), FirErrors.INSTANCE.getINLINE_CLASS_CONSTRUCTOR_WRONG_PARAMETERS_SIZE(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        for (Map.Entry entry : primaryConstructorParametersByName.entrySet()) {
            Name name2 = (Name)entry.getKey();
            FirValueParameter primaryConstructorParameter = (FirValueParameter)entry.getValue();
            if (this.isNotFinalReadOnly(primaryConstructorParameter, (FirProperty)primaryConstructorPropertiesByName.get(name2))) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)primaryConstructorParameter.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
                continue;
            }
            if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.GenericInlineClassParameter)) {
                ConeKotlinType it = FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef());
                boolean bl = false;
                boolean bl2 = it instanceof ConeTypeParameterType || INSTANCE.isGenericArrayOfTypeParameter(it);
                if (bl2) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)primaryConstructorParameter.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)((Object)LanguageFeature.GenericInlineClassParameter), (Object)context2.getLanguageVersionSettings()), (DiagnosticContext)context2, null, 16, null);
                    continue;
                }
            }
            if (this.isInapplicableParameterType(primaryConstructorParameter.getReturnTypeRef())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)primaryConstructorParameter.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getVALUE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), (Object)FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), (DiagnosticContext)context2, null, 16, null);
                continue;
            }
            if (FirHelpersKt.isRecursiveValueClassType(FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), context2.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)primaryConstructorParameter.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_RECURSIVE(), (DiagnosticContext)context2, null, 8, null);
                continue;
            }
            if (FirValueClassRepresentationKt.getMultiFieldValueClassRepresentation(declaration) == null || primaryConstructorParameter.getDefaultValue() == null) continue;
            FirExpression firExpression4 = primaryConstructorParameter.getDefaultValue();
            Intrinsics.checkNotNull((Object)firExpression4);
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firExpression4.getSource(), FirErrors.INSTANCE.getMULTI_FIELD_VALUE_CLASS_PRIMARY_CONSTRUCTOR_DEFAULT_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.CustomEqualsInValueClasses)) {
            FirValueClassDeclarationChecker $this$check_u24lambda_u244 = this;
            boolean bl = false;
            FirDeclaration equalsFromAnyOverriding = null;
            FirDeclaration typedEquals = null;
            Iterable $this$forEach$iv = declaration.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object t : $this$forEach$iv) {
                FirDeclaration it = (FirDeclaration)t;
                boolean bl3 = false;
                if (!(it instanceof FirSimpleFunction)) continue;
                if (org.jetbrains.kotlin.fir.resolve.DeclarationUtilsKt.isEquals((FirSimpleFunction)it)) {
                    equalsFromAnyOverriding = it;
                }
                if (!ValueClassesUtilsKt.isTypedEqualsInValueClass((FirSimpleFunction)it, context2.getSession())) continue;
                typedEquals = it;
            }
            Iterator<Object> iterator2 = TuplesKt.to(equalsFromAnyOverriding, typedEquals);
            FirSimpleFunction firSimpleFunction = (FirSimpleFunction)iterator2.component1();
            FirSimpleFunction typedEquals2 = (FirSimpleFunction)iterator2.component2();
            if (typedEquals2 != null) {
                boolean bl3;
                FirTypeRef singleParameterReturnTypeRef;
                block40: {
                    if (!((Collection)typedEquals2.getTypeParameters()).isEmpty()) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typedEquals2.getSource(), FirErrors.INSTANCE.getTYPE_PARAMETERS_NOT_ALLOWED(), (DiagnosticContext)context2, null, 8, null);
                    }
                    singleParameterReturnTypeRef = ((FirValueParameter)CollectionsKt.single(typedEquals2.getValueParameters())).getReturnTypeRef();
                    ConeTypeProjection[] $this$any$iv = FirTypeUtilsKt.getConeType(singleParameterReturnTypeRef).getTypeArguments();
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        ConeTypeProjection element$iv;
                        ConeTypeProjection coneTypeProjection = element$iv = $this$any$iv[i];
                        boolean bl5 = false;
                        if (!(!ConeTypeProjectionKt.isStarProjection(coneTypeProjection))) continue;
                        bl3 = true;
                        break block40;
                    }
                    bl3 = false;
                }
                if (bl3) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)singleParameterReturnTypeRef.getSource(), FirErrors.INSTANCE.getTYPE_ARGUMENT_ON_TYPED_VALUE_CLASS_EQUALS(), (DiagnosticContext)context2, null, 8, null);
                }
            }
            if (firSimpleFunction != null && typedEquals2 == null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firSimpleFunction.getSource(), FirErrors.INSTANCE.getINEFFICIENT_EQUALS_OVERRIDING_IN_VALUE_CLASS(), (Object)ConeTypeUtilsKt.replaceArgumentsWithStarProjections(ScopeUtilsKt.defaultType(declaration)), (DiagnosticContext)context2, null, 16, null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRelatedToParameter(FirProperty $this$isRelatedToParameter, FirValueParameter parameter2) {
        FirValueParameter firValueParameter = parameter2;
        if (!Intrinsics.areEqual((Object)$this$isRelatedToParameter.getName(), (Object)(firValueParameter != null ? firValueParameter.getName() : null))) return false;
        KtSourceElement ktSourceElement = $this$isRelatedToParameter.getSource();
        if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) return false;
        return true;
    }

    private final boolean isNotFinalReadOnly(FirValueParameter $this$isNotFinalReadOnly, FirProperty primaryConstructorProperty) {
        if (primaryConstructorProperty == null) {
            return true;
        }
        FirElement firElement = $this$isNotFinalReadOnly;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"OPEN_KEYWORD");
        boolean isOpen = FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken);
        return $this$isNotFinalReadOnly.isVararg() || !primaryConstructorProperty.isVal() || isOpen;
    }

    private final boolean isInapplicableParameterType(FirTypeRef $this$isInapplicableParameterType) {
        return FirTypeUtilsKt.isUnit($this$isInapplicableParameterType) || FirTypeUtilsKt.isNothing($this$isInapplicableParameterType);
    }

    private final boolean isGenericArrayOfTypeParameter(ConeKotlinType $this$isGenericArrayOfTypeParameter) {
        if (ArraysKt.firstOrNull((Object[])$this$isGenericArrayOfTypeParameter.getTypeArguments()) instanceof ConeStarProjection || !ArrayUtilsKt.isPotentiallyArray($this$isGenericArrayOfTypeParameter)) {
            return false;
        }
        ConeKotlinType coneKotlinType = ArrayUtilsKt.arrayElementType($this$isGenericArrayOfTypeParameter);
        if (coneKotlinType == null || (coneKotlinType = coneKotlinType.getType()) == null) {
            return false;
        }
        ConeKotlinType arrayElementType = coneKotlinType;
        return arrayElementType instanceof ConeTypeParameterType || this.isGenericArrayOfTypeParameter(arrayElementType);
    }

    private final boolean isSubtypeOfCloneable(FirRegularClass $this$isSubtypeOfCloneable, FirSession session) {
        boolean bl;
        block4: {
            if (this.isCloneableId(FirDeclarationUtilKt.getClassId($this$isSubtypeOfCloneable))) {
                return true;
            }
            Iterable $this$any$iv = SupertypeUtilsKt.lookupSuperTypes$default($this$isSubtypeOfCloneable, true, true, session, false, null, 32, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeClassLikeType superType2 = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    Object object = superType2 instanceof ConeClassLikeType ? superType2 : null;
                    boolean bl3 = object != null && (object = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)object, session, null, 2, null)) != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null && (object = ((ConeClassLikeLookupTag)object).getClassId()) != null ? INSTANCE.isCloneableId((ClassId)object) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isCloneableId(ClassId $this$isCloneableId) {
        return Intrinsics.areEqual((Object)$this$isCloneableId.getRelativeClassName(), (Object)cloneableFqName) && (Intrinsics.areEqual((Object)$this$isCloneableId.getPackageFqName(), (Object)StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE()) || Intrinsics.areEqual((Object)$this$isCloneableId.getPackageFqName(), (Object)javaLangFqName));
    }

    static {
        Object[] objectArray = new String[]{"box", "unbox"};
        boxAndUnboxNames = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"equals", "hashCode"};
        equalsAndHashCodeNames = SetsKt.setOf((Object[])objectArray);
        javaLangFqName = new FqName("java.lang");
        cloneableFqName = new FqName("Cloneable");
    }
}

