/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.mangle.MangleMode;
import org.jetbrains.kotlin.fir.backend.FirMangleComputer;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaField;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012H\u0014R\u0018\u0010\b\u001a\u00060\tR\u00020\u0001X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmMangleComputer;", "Lorg/jetbrains/kotlin/fir/backend/FirMangleComputer;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "mode", "Lorg/jetbrains/kotlin/backend/common/serialization/mangle/MangleMode;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/backend/common/serialization/mangle/MangleMode;)V", "visitor", "Lorg/jetbrains/kotlin/fir/backend/FirMangleComputer$Visitor;", "getVisitor", "()Lorg/jetbrains/kotlin/fir/backend/FirMangleComputer$Visitor;", "addReturnType", "", "copy", "newMode", "platformSpecificSuffix", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "JvmVisitor", "jvm-backend"})
public final class FirJvmMangleComputer
extends FirMangleComputer {
    @NotNull
    private final FirMangleComputer.Visitor visitor;

    public FirJvmMangleComputer(@NotNull StringBuilder builder2, @NotNull MangleMode mode) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        super(builder2, mode);
        this.visitor = new JvmVisitor();
    }

    @Override
    @NotNull
    protected FirMangleComputer.Visitor getVisitor() {
        return this.visitor;
    }

    @Override
    @Nullable
    protected String platformSpecificSuffix(@NotNull FirFunction $this$platformSpecificSuffix) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$platformSpecificSuffix, (String)"<this>");
        if ($this$platformSpecificSuffix instanceof FirSimpleFunction && Intrinsics.areEqual((Object)((FirSimpleFunction)$this$platformSpecificSuffix).getName().asString(), (Object)"main")) {
            FirFile firFile = FirProviderKt.getFirProvider($this$platformSpecificSuffix.getModuleData().getSession()).getFirCallableContainerFile(((FirSimpleFunction)$this$platformSpecificSuffix).getSymbol());
            string2 = firFile != null ? firFile.getName() : null;
        } else {
            string2 = null;
        }
        return string2;
    }

    @Override
    protected boolean addReturnType() {
        return true;
    }

    @Override
    @NotNull
    public FirJvmMangleComputer copy(@NotNull MangleMode newMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)newMode), (String)"newMode");
        return new FirJvmMangleComputer(this.getBuilder(), newMode);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmMangleComputer$JvmVisitor;", "Lorg/jetbrains/kotlin/fir/backend/FirMangleComputer$Visitor;", "Lorg/jetbrains/kotlin/fir/backend/FirMangleComputer;", "(Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmMangleComputer;)V", "visitField", "", "field", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "jvm-backend"})
    private final class JvmVisitor
    extends FirMangleComputer.Visitor {
        public JvmVisitor() {
            super(FirJvmMangleComputer.this);
        }

        @Override
        public void visitField(@NotNull FirField field2) {
            Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
            if (field2 instanceof FirJavaField) {
                FirDeclaration firDeclaration = field2;
                String string2 = field2.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                FirJvmMangleComputer.this.mangleSimpleDeclaration(firDeclaration, string2);
            } else {
                this.visitVariable(field2);
            }
        }
    }
}

