/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.SuspendCallArgumentKind;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirNoReceiverExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedCallableReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u0016\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J4\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u001e\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010 2\f\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"H\u0002J8\u0010#\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010 \u0012\u0006\u0012\u0004\u0018\u00010 \u0012\u0006\u0012\u0004\u0018\u00010%0$*\u00020\u00022\u0006\u0010&\u001a\u00020'2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J\u000e\u0010(\u001a\u0004\u0018\u00010)*\u00020\u0002H\u0002J\u0014\u0010*\u001a\u00020\u0013*\u00020%2\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "BUILTIN_SUSPEND_NAME", "Lorg/jetbrains/kotlin/name/Name;", "KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID", "Lorg/jetbrains/kotlin/name/CallableId;", "getKOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID$checkers", "()Lorg/jetbrains/kotlin/name/CallableId;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkNonLocalReturnUsage", "", "enclosingSuspendFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "checkRestrictsSuspension", "calledDeclarationSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "checkSuspendModifierForm", "reference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "symbol", "findEnclosingSuspendFunction", "sameInstanceOfReceiver", "useSiteReceiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "declarationSiteReceiverOwnerSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "computeReceiversInfo", "Lkotlin/Triple;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "formOfSuspendModifierForLambdaOrFun", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/SuspendCallArgumentKind;", "isRestrictSuspensionReceiver", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSuspendCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSuspendCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 5 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 6 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n40#2:251\n1747#3,3:252\n533#3,4:257\n538#3:263\n1747#3,3:278\n1747#3,3:281\n47#4:255\n47#4:256\n43#5:261\n43#5:262\n56#6,11:264\n20#6,2:275\n1#7:277\n*S KotlinDebug\n*F\n+ 1 FirSuspendCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker\n*L\n52#1:251\n107#1:252,3\n131#1:257,4\n131#1:263\n198#1:278,3\n201#1:281,3\n108#1:255\n118#1:256\n134#1:261\n136#1:262\n144#1:264,11\n144#1:275,2\n*E\n"})
public final class FirSuspendCallChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirSuspendCallChecker INSTANCE = new FirSuspendCallChecker();
    @NotNull
    private static final Name BUILTIN_SUSPEND_NAME = StandardClassIds.Callables.INSTANCE.getSuspend().getCallableName();
    @NotNull
    private static final CallableId KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID = new CallableId(StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE(), BUILTIN_SUSPEND_NAME);

    private FirSuspendCallChecker() {
    }

    @NotNull
    public final CallableId getKOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID$checkers() {
        return KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID;
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirFunction enclosingSuspendFunction;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved(expression2.getCalleeReference());
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference = firResolvedNamedReference;
        FirCallableSymbol firCallableSymbol = reference.getResolvedSymbol();
        FirCallableSymbol firCallableSymbol2 = firCallableSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firCallableSymbol : null;
        if (firCallableSymbol2 == null) {
            return;
        }
        FirCallableSymbol symbol2 = firCallableSymbol2;
        if (Intrinsics.areEqual((Object)reference.getName(), (Object)BUILTIN_SUSPEND_NAME) || symbol2 instanceof FirNamedFunctionSymbol && Intrinsics.areEqual((Object)symbol2.getName(), (Object)BUILTIN_SUSPEND_NAME)) {
            this.checkSuspendModifierForm(expression2, reference, symbol2, context, reporter);
        }
        if (reference instanceof FirResolvedCallableReference) {
            return;
        }
        FirCallableSymbol firCallableSymbol3 = symbol2;
        if (firCallableSymbol3 instanceof FirNamedFunctionSymbol) {
            FirCallableSymbol $this$isSuspend$iv = symbol2;
            boolean $i$f$isSuspend = false;
            if (!$this$isSuspend$iv.getRawStatus().isSuspend()) {
                return;
            }
        } else if (firCallableSymbol3 instanceof FirPropertySymbol) {
            if (!Intrinsics.areEqual((Object)symbol2.getCallableId(), (Object)StandardClassIds.Callables.INSTANCE.getCoroutineContext())) {
                return;
            }
        } else {
            return;
        }
        if ((enclosingSuspendFunction = this.findEnclosingSuspendFunction(context)) == null) {
            firCallableSymbol = symbol2;
            if (firCallableSymbol instanceof FirNamedFunctionSymbol) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_SUSPEND_FUNCTION_CALL(), (Object)symbol2, (DiagnosticContext)context, null, 16, null);
            } else if (firCallableSymbol instanceof FirPropertySymbol) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_SUSPEND_PROPERTY_ACCESS(), (Object)symbol2, (DiagnosticContext)context, null, 16, null);
            }
        } else {
            if (!this.checkNonLocalReturnUsage(enclosingSuspendFunction, context)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getNON_LOCAL_SUSPENSION_POINT(), (DiagnosticContext)context, null, 8, null);
            }
            if (!this.checkRestrictsSuspension(expression2, enclosingSuspendFunction, symbol2, context)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_RESTRICTED_SUSPENDING_FUNCTION_CALL(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }

    private final void checkSuspendModifierForm(FirQualifiedAccessExpression expression2, FirResolvedNamedReference reference, FirCallableSymbol<?> symbol2, CheckerContext context, DiagnosticReporter reporter) {
        if (Intrinsics.areEqual((Object)symbol2.getCallableId(), (Object)KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID)) {
            if (!Intrinsics.areEqual((Object)reference.getName(), (Object)BUILTIN_SUSPEND_NAME) || expression2.getExplicitReceiver() != null || this.formOfSuspendModifierForLambdaOrFun(expression2) == null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getNON_MODIFIER_FORM_FOR_BUILT_IN_SUSPEND(), (DiagnosticContext)context, null, 8, null);
            }
        } else if (Intrinsics.areEqual((Object)reference.getName(), (Object)BUILTIN_SUSPEND_NAME)) {
            SuspendCallArgumentKind suspendCallArgumentKind = this.formOfSuspendModifierForLambdaOrFun(expression2);
            switch (suspendCallArgumentKind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[suspendCallArgumentKind.ordinal()]) {
                case 1: {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getMODIFIER_FORM_FOR_NON_BUILT_IN_SUSPEND_FUN(), (DiagnosticContext)context, null, 8, null);
                    break;
                }
                case 2: {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getMODIFIER_FORM_FOR_NON_BUILT_IN_SUSPEND(), (DiagnosticContext)context, null, 8, null);
                }
            }
        }
    }

    private final SuspendCallArgumentKind formOfSuspendModifierForLambdaOrFun(FirQualifiedAccessExpression $this$formOfSuspendModifierForLambdaOrFun) {
        boolean bl;
        block19: {
            if (!($this$formOfSuspendModifierForLambdaOrFun instanceof FirFunctionCall)) {
                return null;
            }
            FirNamedReference reference = ((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getCalleeReference();
            if (reference instanceof FirResolvedCallableReference) {
                return null;
            }
            Iterable $this$any$iv = $this$formOfSuspendModifierForLambdaOrFun.getTypeArguments();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirTypeProjection it = (FirTypeProjection)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSource() != null)) continue;
                    bl = true;
                    break block19;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        FirCall $this$arguments$iv = (FirCall)((Object)$this$formOfSuspendModifierForLambdaOrFun);
        boolean $i$f$getArguments = false;
        if (CollectionsKt.singleOrNull($this$arguments$iv.getArgumentList().getArguments()) instanceof FirLambdaArgumentExpression) {
            KtSourceElement ktSourceElement;
            KtSourceElement callExpressionSource;
            KtSourceElement ktSourceElement2;
            if ($this$formOfSuspendModifierForLambdaOrFun.getExplicitReceiver() == null) {
                ktSourceElement2 = $this$formOfSuspendModifierForLambdaOrFun.getSource();
            } else {
                KtSourceElement ktSourceElement3 = $this$formOfSuspendModifierForLambdaOrFun.getSource();
                if (ktSourceElement3 != null) {
                    IElementType iElementType = KtNodeTypes.CALL_EXPRESSION;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CALL_EXPRESSION");
                    ktSourceElement2 = FirSourceUtilsKt.getChild$default(ktSourceElement3, iElementType, 1, 1, false, 8, null);
                } else {
                    ktSourceElement2 = null;
                }
            }
            KtSourceElement ktSourceElement4 = callExpressionSource = ktSourceElement2;
            if (ktSourceElement4 != null) {
                IElementType iElementType = KtNodeTypes.VALUE_ARGUMENT_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"VALUE_ARGUMENT_LIST");
                ktSourceElement = FirSourceUtilsKt.getChild$default(ktSourceElement4, iElementType, 0, 1, false, 10, null);
            } else {
                ktSourceElement = null;
            }
            if (ktSourceElement == null) {
                return SuspendCallArgumentKind.LAMBDA;
            }
        }
        if (((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getOrigin() == FirFunctionCallOrigin.Infix) {
            FirCall $this$arguments$iv2 = (FirCall)((Object)$this$formOfSuspendModifierForLambdaOrFun);
            boolean $i$f$getArguments2 = false;
            FirExpression lastArgument = (FirExpression)CollectionsKt.lastOrNull($this$arguments$iv2.getArgumentList().getArguments());
            if (lastArgument instanceof FirAnonymousFunctionExpression) {
                KtSourceElement ktSourceElement;
                KtSourceElement ktSourceElement5 = $this$formOfSuspendModifierForLambdaOrFun.getSource();
                if (ktSourceElement5 != null) {
                    IElementType iElementType = KtNodeTypes.PARENTHESIZED;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PARENTHESIZED");
                    ktSourceElement = FirSourceUtilsKt.getChild$default(ktSourceElement5, iElementType, 0, 1, false, 10, null);
                } else {
                    ktSourceElement = null;
                }
                if (ktSourceElement == null) {
                    KtSourceElement ktSourceElement6 = ((FirAnonymousFunctionExpression)lastArgument).getSource();
                    return Intrinsics.areEqual((Object)(ktSourceElement6 != null && (ktSourceElement6 = ktSourceElement6.getLighterASTNode()) != null ? ktSourceElement6.getTokenType() : null), (Object)((Object)KtStubElementTypes.FUNCTION)) ? SuspendCallArgumentKind.FUN : SuspendCallArgumentKind.LAMBDA;
                }
            }
        }
        return null;
    }

    private final FirFunction findEnclosingSuspendFunction(CheckerContext context) {
        FirDeclaration firDeclaration;
        block7: {
            List<FirDeclaration> $this$lastOrNull$iv = context.getContainingDeclarations();
            boolean $i$f$lastOrNull = false;
            ListIterator<FirDeclaration> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                boolean $i$f$isSuspend;
                FirMemberDeclaration $this$isSuspend$iv;
                boolean bl;
                FirDeclaration element$iv;
                FirDeclaration it = element$iv = iterator$iv.previous();
                boolean bl2 = false;
                FirDeclaration firDeclaration2 = it;
                if (firDeclaration2 instanceof FirAnonymousFunction) {
                    if (((FirAnonymousFunction)it).isLambda()) {
                        bl = FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType(FirTypeUtilsKt.getConeType(((FirAnonymousFunction)it).getTypeRef()), context.getSession());
                    } else {
                        $this$isSuspend$iv = (FirMemberDeclaration)it;
                        $i$f$isSuspend = false;
                        bl = $this$isSuspend$iv.getStatus().isSuspend();
                    }
                } else if (firDeclaration2 instanceof FirSimpleFunction) {
                    $this$isSuspend$iv = (FirMemberDeclaration)it;
                    $i$f$isSuspend = false;
                    bl = $this$isSuspend$iv.getStatus().isSuspend();
                } else {
                    bl = false;
                }
                if (!bl) continue;
                firDeclaration = element$iv;
                break block7;
            }
            firDeclaration = null;
        }
        FirDeclaration firDeclaration3 = firDeclaration;
        return firDeclaration3 instanceof FirFunction ? (FirFunction)firDeclaration3 : null;
    }

    private final boolean checkNonLocalReturnUsage(FirFunction enclosingSuspendFunction, CheckerContext context) {
        Object v0;
        block6: {
            Iterable $this$lastIsInstanceOrNull$iv = context.getContainingDeclarations();
            boolean $i$f$lastIsInstanceOrNull = false;
            if ($this$lastIsInstanceOrNull$iv instanceof List) {
                int n = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                if (0 <= n) {
                    do {
                        int i$iv;
                        Object element$iv;
                        if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n--)) instanceof FirFunction)) continue;
                        v0 = element$iv;
                        break block6;
                    } while (0 <= n);
                }
                v0 = null;
            } else {
                Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed((Iterable)$this$lastIsInstanceOrNull$iv);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                    if (!(element$iv$iv instanceof FirFunction)) continue;
                    v0 = element$iv$iv;
                    break block6;
                }
                v0 = null;
            }
        }
        FirFunction firFunction = v0;
        if (firFunction == null) {
            return false;
        }
        FirFunction containingFunction = firFunction;
        return containingFunction instanceof FirAnonymousFunction && enclosingSuspendFunction != containingFunction ? ((FirAnonymousFunction)containingFunction).getInlineStatus().getReturnAllowed() : enclosingSuspendFunction == containingFunction;
    }

    private final boolean checkRestrictsSuspension(FirQualifiedAccessExpression expression2, FirFunction enclosingSuspendFunction, FirCallableSymbol<?> calledDeclarationSymbol, CheckerContext context) {
        FirFunction firFunction;
        FirSession session = context.getSession();
        Triple<FirExpression, FirExpression, ConeKotlinType> triple = enclosingSuspendFunction.getDispatchReceiverType();
        Object object = triple instanceof ConeClassLikeType ? (ConeClassLikeType)triple : null;
        FirRegularClassSymbol enclosingSuspendFunctionDispatchReceiverOwnerSymbol = object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)object, session) : null;
        FirFunction it = firFunction = enclosingSuspendFunction;
        boolean bl = false;
        FirFunction firFunction2 = it.getReceiverParameter() != null ? firFunction : null;
        FirFunctionSymbol<? extends FirFunction> enclosingSuspendFunctionExtensionReceiverOwnerSymbol = firFunction2 != null ? firFunction2.getSymbol() : null;
        triple = this.computeReceiversInfo(expression2, session, calledDeclarationSymbol);
        FirExpression dispatchReceiverExpression = (FirExpression)triple.component1();
        FirExpression extensionReceiverExpression = (FirExpression)triple.component2();
        ConeKotlinType extensionReceiverParameterType = (ConeKotlinType)triple.component3();
        Object[] objectArray = new FirExpression[]{dispatchReceiverExpression, extensionReceiverExpression};
        for (FirExpression receiverExpression : CollectionsKt.listOfNotNull((Object[])objectArray)) {
            if (!this.isRestrictSuspensionReceiver(FirTypeUtilsKt.getConeType(receiverExpression.getTypeRef()), session) || this.sameInstanceOfReceiver(receiverExpression, enclosingSuspendFunctionDispatchReceiverOwnerSymbol) || this.sameInstanceOfReceiver(receiverExpression, (FirBasedSymbol)enclosingSuspendFunctionExtensionReceiverOwnerSymbol)) continue;
            return false;
        }
        FirFunctionSymbol<? extends FirFunction> firFunctionSymbol = enclosingSuspendFunctionExtensionReceiverOwnerSymbol;
        if (!(firFunctionSymbol != null && (firFunctionSymbol = firFunctionSymbol.getResolvedReceiverTypeRef()) != null && (firFunctionSymbol = FirTypeUtilsKt.getConeType((FirTypeRef)((Object)firFunctionSymbol))) != null ? this.isRestrictSuspensionReceiver((ConeKotlinType)((Object)firFunctionSymbol), session) : false)) {
            return true;
        }
        if (this.sameInstanceOfReceiver(dispatchReceiverExpression, (FirBasedSymbol)enclosingSuspendFunctionExtensionReceiverOwnerSymbol)) {
            return true;
        }
        if (this.sameInstanceOfReceiver(extensionReceiverExpression, (FirBasedSymbol)enclosingSuspendFunctionExtensionReceiverOwnerSymbol)) {
            ConeKotlinType coneKotlinType = extensionReceiverParameterType;
            boolean bl2 = coneKotlinType != null ? this.isRestrictSuspensionReceiver(coneKotlinType, session) : false;
            if (bl2) {
                return true;
            }
        }
        return false;
    }

    private final boolean isRestrictSuspensionReceiver(ConeKotlinType $this$isRestrictSuspensionReceiver, FirSession session) {
        ConeKotlinType coneKotlinType = $this$isRestrictSuspensionReceiver;
        if (coneKotlinType instanceof ConeClassLikeType) {
            boolean bl;
            block10: {
                FirRegularClassSymbol firRegularClassSymbol = LookupTagUtilsKt.toFirRegularClassSymbol(TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$isRestrictSuspensionReceiver, session, null, 2, null).getLookupTag(), session);
                if (firRegularClassSymbol == null) {
                    return false;
                }
                FirRegularClassSymbol regularClassSymbol = firRegularClassSymbol;
                if (FirAnnotationUtilsKt.getAnnotationByClassId(regularClassSymbol, StandardClassIds.Annotations.INSTANCE.getRestrictsSuspension(), session) != null) {
                    return true;
                }
                Iterable $this$any$iv = regularClassSymbol.getResolvedSuperTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv;
                        boolean bl2 = false;
                        if (!INSTANCE.isRestrictSuspensionReceiver(it, session)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        if (coneKotlinType instanceof ConeTypeParameterType) {
            boolean bl;
            block11: {
                Iterable $this$any$iv = ((ConeTypeParameterType)$this$isRestrictSuspensionReceiver).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
                        boolean bl3 = false;
                        if (!INSTANCE.isRestrictSuspensionReceiver(FirTypeUtilsKt.getConeType(it), session)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    private final boolean sameInstanceOfReceiver(FirExpression useSiteReceiverExpression, FirBasedSymbol<?> declarationSiteReceiverOwnerSymbol) {
        if (declarationSiteReceiverOwnerSymbol == null || useSiteReceiverExpression == null) {
            return false;
        }
        if (useSiteReceiverExpression instanceof FirThisReceiverExpression) {
            return Intrinsics.areEqual(((FirThisReceiverExpression)useSiteReceiverExpression).getCalleeReference().getBoundSymbol(), declarationSiteReceiverOwnerSymbol);
        }
        return false;
    }

    private final Triple<FirExpression, FirExpression, ConeKotlinType> computeReceiversInfo(FirQualifiedAccessExpression $this$computeReceiversInfo, FirSession session, FirCallableSymbol<?> calledDeclarationSymbol) {
        FirExpression firExpression2;
        if ($this$computeReceiversInfo instanceof FirImplicitInvokeCall && !Intrinsics.areEqual((Object)$this$computeReceiversInfo.getDispatchReceiver(), (Object)FirNoReceiverExpression.INSTANCE) && FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType(FirTypeUtilsKt.getConeType($this$computeReceiversInfo.getDispatchReceiver().getTypeRef()), session)) {
            Object object;
            FirExpression variableForInvoke = $this$computeReceiversInfo.getDispatchReceiver();
            ConeKotlinType variableForInvokeType = FirTypeUtilsKt.getConeType(variableForInvoke.getTypeRef());
            if (!CompilerConeAttributesKt.isExtensionFunctionType(variableForInvokeType)) {
                return new Triple(null, null, null);
            }
            return new Triple(null, CollectionsKt.getOrNull(((FirImplicitInvokeCall)$this$computeReceiversInfo).getArgumentList().getArguments(), (int)0), (Object)((object = ArraysKt.getOrNull((Object[])variableForInvokeType.getTypeArguments(), (int)0)) instanceof ConeKotlinType ? (ConeKotlinType)object : null));
        }
        FirExpression it = firExpression2 = $this$computeReceiversInfo.getDispatchReceiver();
        boolean bl = false;
        FirExpression firExpression3 = !(it instanceof FirNoReceiverExpression) ? firExpression2 : null;
        it = firExpression2 = $this$computeReceiversInfo.getExtensionReceiver();
        FirExpression firExpression4 = firExpression3;
        boolean bl2 = false;
        boolean bl3 = !(it instanceof FirNoReceiverExpression);
        FirResolvedTypeRef firResolvedTypeRef = calledDeclarationSymbol.getResolvedReceiverTypeRef();
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? FirTypeUtilsKt.getConeType(firResolvedTypeRef) : null;
        FirExpression firExpression5 = bl3 ? firExpression2 : null;
        FirExpression firExpression6 = firExpression4;
        return new Triple((Object)firExpression6, (Object)firExpression5, (Object)coneKotlinType);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SuspendCallArgumentKind.values().length];
            try {
                nArray[SuspendCallArgumentKind.FUN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SuspendCallArgumentKind.LAMBDA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

