/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterConfiguration;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.proxy.Proxy;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.platform.JsPlatformKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001SB\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010\u00012\u0006\u0010=\u001a\u00020>H\u0000\u00a2\u0006\u0002\b?J\u0006\u0010@\u001a\u00020\u0000J5\u0010A\u001a\u0004\u0018\u00010\u00152\u0006\u0010B\u001a\u00020\u00152\b\b\u0002\u0010C\u001a\u00020D2\b\b\u0002\u0010E\u001a\u00020D2\b\b\u0002\u0010F\u001a\u00020DH\u0000\u00a2\u0006\u0002\bGJ;\u0010H\u001a\u00020\u00152\u0006\u0010B\u001a\u00020\u00152\b\b\u0002\u0010C\u001a\u00020D2\b\b\u0002\u0010E\u001a\u00020D2\b\b\u0002\u0010F\u001a\u00020D2\u0006\u0010I\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\bJJ\u001d\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020;2\u0006\u0010N\u001a\u00020LH\u0000\u00a2\u0006\u0002\bOJ\u0016\u0010P\u001a\u0004\u0018\u00010$*\u00020$2\u0006\u0010Q\u001a\u00020RH\u0002R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR*\u0010\u001d\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e\u0012\u0004\u0012\u00020\u001a0\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001b\u0010#\u001a\u00020$8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b%\u0010&R\u001b\u0010)\u001a\u00020$8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010(\u001a\u0004\b*\u0010&R\u001b\u0010,\u001a\u00020$8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010(\u001a\u0004\b-\u0010&R\u001b\u0010/\u001a\u00020$8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010(\u001a\u0004\b0\u0010&R&\u00102\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u0002040\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010 \"\u0004\b6\u0010\"R&\u00107\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u0002040\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010 \"\u0004\b9\u0010\"\u00a8\u0006T"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "", "environment", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;)V", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "(Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;)V", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "configuration", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterConfiguration;", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterConfiguration;)V", "callStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "getCallStack$ir_interpreter", "()Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "getConfiguration", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterConfiguration;", "functionCache", "", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment$CacheFunctionSignature;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "irExceptions", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getIrExceptions$ir_interpreter", "()Ljava/util/List;", "javaClassToIrClass", "Ljava/lang/Class;", "getJavaClassToIrClass$ir_interpreter", "()Ljava/util/Map;", "setJavaClassToIrClass$ir_interpreter", "(Ljava/util/Map;)V", "kParameterClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getKParameterClass$ir_interpreter", "()Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "kParameterClass$delegate", "Lkotlin/Lazy;", "kTypeClass", "getKTypeClass$ir_interpreter", "kTypeClass$delegate", "kTypeParameterClass", "getKTypeParameterClass$ir_interpreter", "kTypeParameterClass$delegate", "kTypeProjectionClass", "getKTypeProjectionClass$ir_interpreter", "kTypeProjectionClass$delegate", "mapOfEnums", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "getMapOfEnums$ir_interpreter", "setMapOfEnums$ir_interpreter", "mapOfObjects", "getMapOfObjects$ir_interpreter", "setMapOfObjects$ir_interpreter", "convertToState", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "value", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "convertToState$ir_interpreter", "copyWithNewCallStack", "getCachedFunction", "symbol", "hasDispatchReceiver", "", "hasExtensionReceiver", "fromDelegatingCall", "getCachedFunction$ir_interpreter", "setCachedFunction", "newFunction", "setCachedFunction$ir_interpreter", "stateToIrExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "state", "original", "stateToIrExpression$ir_interpreter", "getIrClassOfReflectionFromList", "name", "", "CacheFunctionSignature", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nIrInterpreterEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInterpreterEnvironment.kt\norg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,148:1\n1360#2:149\n1446#2,5:150\n800#2,11:155\n766#2:166\n857#2,2:167\n1#3:169\n381#4,11:170\n*S KotlinDebug\n*F\n+ 1 IrInterpreterEnvironment.kt\norg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment\n*L\n71#1:149\n71#1:150,5\n72#1:155,11\n73#1:166\n73#1:167,2\n143#1:170,11\n*E\n"})
public final class IrInterpreterEnvironment {
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final IrInterpreterConfiguration configuration;
    @NotNull
    private final CallStack callStack;
    @NotNull
    private final List<IrClass> irExceptions;
    @NotNull
    private Map<IrSymbol, Complex> mapOfEnums;
    @NotNull
    private Map<IrSymbol, Complex> mapOfObjects;
    @NotNull
    private Map<Class<?>, IrClass> javaClassToIrClass;
    @NotNull
    private Map<CacheFunctionSignature, IrFunctionSymbol> functionCache;
    @NotNull
    private final Lazy kTypeParameterClass$delegate;
    @NotNull
    private final Lazy kParameterClass$delegate;
    @NotNull
    private final Lazy kTypeProjectionClass$delegate;
    @NotNull
    private final Lazy kTypeClass$delegate;

    public IrInterpreterEnvironment(@NotNull IrBuiltIns irBuiltIns, @NotNull IrInterpreterConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        this.irBuiltIns = irBuiltIns;
        this.configuration = configuration2;
        this.callStack = new CallStack();
        this.irExceptions = new ArrayList();
        this.mapOfEnums = new LinkedHashMap();
        this.mapOfObjects = new LinkedHashMap();
        this.javaClassToIrClass = new LinkedHashMap();
        this.functionCache = new LinkedHashMap();
        this.kTypeParameterClass$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IrClassSymbol>(this){
            final /* synthetic */ IrInterpreterEnvironment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IrClassSymbol invoke() {
                IrClassSymbol irClassSymbol = IrInterpreterEnvironment.access$getIrClassOfReflectionFromList(this.this$0, this.this$0.getIrBuiltIns().getKClassClass(), "typeParameters");
                Intrinsics.checkNotNull((Object)irClassSymbol);
                return irClassSymbol;
            }
        }));
        this.kParameterClass$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IrClassSymbol>(this){
            final /* synthetic */ IrInterpreterEnvironment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IrClassSymbol invoke() {
                IrClassSymbol irClassSymbol = IrInterpreterEnvironment.access$getIrClassOfReflectionFromList(this.this$0, this.this$0.getIrBuiltIns().getKFunctionClass(), "parameters");
                Intrinsics.checkNotNull((Object)irClassSymbol);
                return irClassSymbol;
            }
        }));
        this.kTypeProjectionClass$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IrClassSymbol>(this){
            final /* synthetic */ IrInterpreterEnvironment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IrClassSymbol invoke() {
                IrClassSymbol irClassSymbol = IrInterpreterEnvironment.access$getIrClassOfReflectionFromList(this.this$0, this.this$0.getKTypeClass$ir_interpreter(), "arguments");
                Intrinsics.checkNotNull((Object)irClassSymbol);
                return irClassSymbol;
            }
        }));
        this.kTypeClass$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IrClassSymbol>(this){
            final /* synthetic */ IrInterpreterEnvironment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IrClassSymbol invoke() {
                IrClassSymbol irClassSymbol = IrInterpreterEnvironment.access$getIrClassOfReflectionFromList(this.this$0, this.this$0.getIrBuiltIns().getKClassClass(), "supertypes");
                if (irClassSymbol == null) {
                    irClassSymbol = this.this$0.getIrBuiltIns().getAnyClass();
                }
                return irClassSymbol;
            }
        }));
        this.mapOfObjects.put(this.irBuiltIns.getUnitClass(), new Common((IrClass)this.irBuiltIns.getUnitClass().getOwner()));
    }

    public /* synthetic */ IrInterpreterEnvironment(IrBuiltIns irBuiltIns, IrInterpreterConfiguration irInterpreterConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            irInterpreterConfiguration = new IrInterpreterConfiguration(null, 0, 0, false, false, false, 63, null);
        }
        this(irBuiltIns, irInterpreterConfiguration);
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @NotNull
    public final IrInterpreterConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final CallStack getCallStack$ir_interpreter() {
        return this.callStack;
    }

    @NotNull
    public final List<IrClass> getIrExceptions$ir_interpreter() {
        return this.irExceptions;
    }

    @NotNull
    public final Map<IrSymbol, Complex> getMapOfEnums$ir_interpreter() {
        return this.mapOfEnums;
    }

    public final void setMapOfEnums$ir_interpreter(@NotNull Map<IrSymbol, Complex> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.mapOfEnums = map;
    }

    @NotNull
    public final Map<IrSymbol, Complex> getMapOfObjects$ir_interpreter() {
        return this.mapOfObjects;
    }

    public final void setMapOfObjects$ir_interpreter(@NotNull Map<IrSymbol, Complex> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.mapOfObjects = map;
    }

    @NotNull
    public final Map<Class<?>, IrClass> getJavaClassToIrClass$ir_interpreter() {
        return this.javaClassToIrClass;
    }

    public final void setJavaClassToIrClass$ir_interpreter(@NotNull Map<Class<?>, IrClass> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.javaClassToIrClass = map;
    }

    @NotNull
    public final IrClassSymbol getKTypeParameterClass$ir_interpreter() {
        Lazy lazy = this.kTypeParameterClass$delegate;
        return (IrClassSymbol)lazy.getValue();
    }

    @NotNull
    public final IrClassSymbol getKParameterClass$ir_interpreter() {
        Lazy lazy = this.kParameterClass$delegate;
        return (IrClassSymbol)lazy.getValue();
    }

    @NotNull
    public final IrClassSymbol getKTypeProjectionClass$ir_interpreter() {
        Lazy lazy = this.kTypeProjectionClass$delegate;
        return (IrClassSymbol)lazy.getValue();
    }

    @NotNull
    public final IrClassSymbol getKTypeClass$ir_interpreter() {
        Lazy lazy = this.kTypeClass$delegate;
        return (IrClassSymbol)lazy.getValue();
    }

    private IrInterpreterEnvironment(IrInterpreterEnvironment environment) {
        this(environment.irBuiltIns, environment.configuration);
        this.irExceptions.addAll((Collection<IrClass>)environment.irExceptions);
        this.mapOfEnums = environment.mapOfEnums;
        this.mapOfObjects = environment.mapOfObjects;
    }

    /*
     * WARNING - void declaration
     */
    public IrInterpreterEnvironment(@NotNull IrModuleFragment irModule) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        IrElementBase it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        this(irModule.getIrBuiltins(), null, 2, null);
        Iterable iterable = irModule.getFiles();
        List<IrClass> list2 = this.irExceptions;
        boolean $i$f$flatMap = false;
        void var4_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (IrFile)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getDeclarations();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$flatMapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrClass)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrClass)element$iv$iv;
            boolean bl = false;
            if (!IrUtilsKt.isSubclassOf((IrClass)it, (IrClass)this.irBuiltIns.getThrowableClass().getOwner())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list2.addAll((List)destination$iv$iv);
    }

    @NotNull
    public final IrInterpreterEnvironment copyWithNewCallStack() {
        return new IrInterpreterEnvironment(this);
    }

    @Nullable
    public final IrFunctionSymbol getCachedFunction$ir_interpreter(@NotNull IrFunctionSymbol symbol2, boolean hasDispatchReceiver, boolean hasExtensionReceiver, boolean fromDelegatingCall) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return this.functionCache.get(new CacheFunctionSignature(symbol2, hasDispatchReceiver, hasExtensionReceiver, fromDelegatingCall));
    }

    public static /* synthetic */ IrFunctionSymbol getCachedFunction$ir_interpreter$default(IrInterpreterEnvironment irInterpreterEnvironment, IrFunctionSymbol irFunctionSymbol, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        return irInterpreterEnvironment.getCachedFunction$ir_interpreter(irFunctionSymbol, bl, bl2, bl3);
    }

    @NotNull
    public final IrFunctionSymbol setCachedFunction$ir_interpreter(@NotNull IrFunctionSymbol symbol2, boolean hasDispatchReceiver, boolean hasExtensionReceiver, boolean fromDelegatingCall, @NotNull IrFunctionSymbol newFunction2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)newFunction2, (String)"newFunction");
        this.functionCache.put(new CacheFunctionSignature(symbol2, hasDispatchReceiver, hasExtensionReceiver, fromDelegatingCall), newFunction2);
        return newFunction2;
    }

    public static /* synthetic */ IrFunctionSymbol setCachedFunction$ir_interpreter$default(IrInterpreterEnvironment irInterpreterEnvironment, IrFunctionSymbol irFunctionSymbol, boolean bl, boolean bl2, boolean bl3, IrFunctionSymbol irFunctionSymbol2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        return irInterpreterEnvironment.setCachedFunction$ir_interpreter(irFunctionSymbol, bl, bl2, bl3, irFunctionSymbol2);
    }

    @NotNull
    public final State convertToState$ir_interpreter(@Nullable Object value2, @NotNull IrType irType) {
        State state;
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        Object object = value2;
        if (object instanceof Proxy) {
            state = ((Proxy)value2).getState();
        } else if (object instanceof State) {
            state = (State)value2;
        } else if (((((((((((((((((object instanceof Boolean ? true : object instanceof Character) ? true : object instanceof Byte) ? true : object instanceof Short) ? true : object instanceof Integer) ? true : object instanceof Long) ? true : object instanceof String) ? true : object instanceof Float) ? true : object instanceof Double) ? true : object instanceof Object[]) ? true : object instanceof byte[]) ? true : object instanceof char[]) ? true : object instanceof short[]) ? true : object instanceof int[]) ? true : object instanceof long[]) ? true : object instanceof float[]) ? true : object instanceof double[]) ? true : object instanceof boolean[]) {
            state = new Primitive<Object>(value2, irType);
        } else if (object == null) {
            state = Primitive.Companion.nullStateOfType(irType);
        } else {
            Wrapper wrapper;
            Object object2 = IrTypesKt.getClassOrNull(irType);
            if (object2 != null && (object2 = (IrClass)object2.getOwner()) != null) {
                Object it = object2;
                boolean bl = false;
                wrapper = new Wrapper(value2, (IrClass)it, this);
            } else {
                IrClass irClass2 = this.javaClassToIrClass.get(value2.getClass());
                Intrinsics.checkNotNull((Object)irClass2);
                wrapper = new Wrapper(value2, irClass2, this);
            }
            state = wrapper;
        }
        return state;
    }

    @NotNull
    public final IrExpression stateToIrExpression$ir_interpreter(@NotNull State state, @NotNull IrExpression original) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        int start = original.getStartOffset();
        int end = original.getEndOffset();
        IrType type2 = IrTypesKt.makeNotNull(original.getType());
        State state2 = state;
        if (state2 instanceof Primitive) {
            irExpression = JsPlatformKt.isJs(this.configuration.getPlatform()) && ((Primitive)state).getValue() instanceof Float ? (IrExpression)IrConstImpl.Companion.float(start, end, type2, ((Number)((Primitive)state).getValue()).floatValue()) : (JsPlatformKt.isJs(this.configuration.getPlatform()) && ((Primitive)state).getValue() instanceof Double ? (IrExpression)IrConstImpl.Companion.double(start, end, type2, ((Number)((Primitive)state).getValue()).doubleValue()) : (((Primitive)state).getValue() == null || IrTypePredicatesKt.isPrimitiveType$default(type2, false, 1, null) || IrTypePredicatesKt.isString(type2) ? (IrExpression)IrTreeBuildUtilsKt.toIrConst(((Primitive)state).getValue(), type2, start, end) : original));
        } else if (state2 instanceof ExceptionState) {
            String message = this.configuration.getPrintOnlyExceptionMessage() ? ((ExceptionState)state).getShortDescription() : '\n' + ((ExceptionState)state).getFullDescription();
            irExpression = new IrErrorExpressionImpl(original.getStartOffset(), original.getEndOffset(), original.getType(), message);
        } else if (state2 instanceof Complex) {
            IrSimpleType stateType = IrUtilsKt.getDefaultType(state.getIrClass());
            if (IrTypePredicatesKt.isUnsignedType$default(stateType, false, 1, null)) {
                Object object = CollectionsKt.single((Iterable)state.getFields().values());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive<*>");
                irExpression = IrTreeBuildUtilsKt.toIrConst(((Primitive)object).getValue(), type2, start, end);
            } else {
                irExpression = original;
            }
        } else {
            irExpression = original;
        }
        return irExpression;
    }

    private final IrClassSymbol getIrClassOfReflectionFromList(IrClassSymbol $this$getIrClassOfReflectionFromList, String name2) {
        IrProperty property;
        IrDeclarationBase irDeclarationBase;
        Object v0;
        block2: {
            Sequence<IrProperty> $this$singleOrNull$iv = IrUtilsKt.getProperties((IrDeclarationContainer)((Object)$this$getIrClassOfReflectionFromList.getOwner()));
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrProperty it = (IrProperty)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)name2)) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        IrType irType = (irDeclarationBase = (property = (IrProperty)v0)) != null && (irDeclarationBase = ((IrProperty)irDeclarationBase).getGetter()) != null ? ((IrFunction)irDeclarationBase).getReturnType() : null;
        IrSimpleType list2 = irType instanceof IrSimpleType ? (IrSimpleType)irType : null;
        Object object = list2;
        return object != null && (object = ((IrSimpleType)object).getArguments()) != null && (object = (IrTypeArgument)CollectionsKt.single((List)object)) != null && (object = IrTypesKt.getTypeOrNull((IrTypeArgument)object)) != null ? IrTypesKt.getClassOrNull((IrType)object) : null;
    }

    public static final /* synthetic */ IrClassSymbol access$getIrClassOfReflectionFromList(IrInterpreterEnvironment $this, IrClassSymbol $receiver, String name2) {
        return $this.getIrClassOfReflectionFromList($receiver, name2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment$CacheFunctionSignature;", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "hasDispatchReceiver", "", "hasExtensionReceiver", "fromDelegatingCall", "(Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;ZZZ)V", "getFromDelegatingCall", "()Z", "getHasDispatchReceiver", "getHasExtensionReceiver", "getSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "ir.interpreter"})
    private static final class CacheFunctionSignature {
        @NotNull
        private final IrFunctionSymbol symbol;
        private final boolean hasDispatchReceiver;
        private final boolean hasExtensionReceiver;
        private final boolean fromDelegatingCall;

        public CacheFunctionSignature(@NotNull IrFunctionSymbol symbol2, boolean hasDispatchReceiver, boolean hasExtensionReceiver, boolean fromDelegatingCall) {
            Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
            this.symbol = symbol2;
            this.hasDispatchReceiver = hasDispatchReceiver;
            this.hasExtensionReceiver = hasExtensionReceiver;
            this.fromDelegatingCall = fromDelegatingCall;
        }

        @NotNull
        public final IrFunctionSymbol getSymbol() {
            return this.symbol;
        }

        public final boolean getHasDispatchReceiver() {
            return this.hasDispatchReceiver;
        }

        public final boolean getHasExtensionReceiver() {
            return this.hasExtensionReceiver;
        }

        public final boolean getFromDelegatingCall() {
            return this.fromDelegatingCall;
        }

        @NotNull
        public final IrFunctionSymbol component1() {
            return this.symbol;
        }

        public final boolean component2() {
            return this.hasDispatchReceiver;
        }

        public final boolean component3() {
            return this.hasExtensionReceiver;
        }

        public final boolean component4() {
            return this.fromDelegatingCall;
        }

        @NotNull
        public final CacheFunctionSignature copy(@NotNull IrFunctionSymbol symbol2, boolean hasDispatchReceiver, boolean hasExtensionReceiver, boolean fromDelegatingCall) {
            Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
            return new CacheFunctionSignature(symbol2, hasDispatchReceiver, hasExtensionReceiver, fromDelegatingCall);
        }

        public static /* synthetic */ CacheFunctionSignature copy$default(CacheFunctionSignature cacheFunctionSignature, IrFunctionSymbol irFunctionSymbol, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                irFunctionSymbol = cacheFunctionSignature.symbol;
            }
            if ((n & 2) != 0) {
                bl = cacheFunctionSignature.hasDispatchReceiver;
            }
            if ((n & 4) != 0) {
                bl2 = cacheFunctionSignature.hasExtensionReceiver;
            }
            if ((n & 8) != 0) {
                bl3 = cacheFunctionSignature.fromDelegatingCall;
            }
            return cacheFunctionSignature.copy(irFunctionSymbol, bl, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "CacheFunctionSignature(symbol=" + this.symbol + ", hasDispatchReceiver=" + this.hasDispatchReceiver + ", hasExtensionReceiver=" + this.hasExtensionReceiver + ", fromDelegatingCall=" + this.fromDelegatingCall + ')';
        }

        public int hashCode() {
            int result2 = this.symbol.hashCode();
            int n = this.hasDispatchReceiver ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            int n2 = this.hasExtensionReceiver ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result2 = result2 * 31 + n2;
            int n3 = this.fromDelegatingCall ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result2 = result2 * 31 + n3;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheFunctionSignature)) {
                return false;
            }
            CacheFunctionSignature cacheFunctionSignature = (CacheFunctionSignature)other;
            if (!Intrinsics.areEqual((Object)this.symbol, (Object)cacheFunctionSignature.symbol)) {
                return false;
            }
            if (this.hasDispatchReceiver != cacheFunctionSignature.hasDispatchReceiver) {
                return false;
            }
            if (this.hasExtensionReceiver != cacheFunctionSignature.hasExtensionReceiver) {
                return false;
            }
            return this.fromDelegatingCall == cacheFunctionSignature.fromDelegatingCall;
        }
    }
}

