/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.linkage.partial;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.linkage.partial.ClassifierExplorer;
import org.jetbrains.kotlin.backend.common.linkage.partial.MissingDeclarationStubGenerator;
import org.jetbrains.kotlin.backend.common.linkage.partial.PartialLinkageSupportForLinker;
import org.jetbrains.kotlin.backend.common.linkage.partial.PartiallyLinkedIrTreePatcher;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideBuilder;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.linkage.partial.PartialLinkageLogLevel;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.SymbolTableKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J$\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001eH\u0016J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J\u001e\u0010#\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140\u001eH\u0002J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\"H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/common/linkage/partial/PartialLinkageSupportForLinkerImpl;", "Lorg/jetbrains/kotlin/backend/common/linkage/partial/PartialLinkageSupportForLinker;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "allowErrorTypes", "", "logLevel", "Lorg/jetbrains/kotlin/ir/linkage/partial/PartialLinkageLogLevel;", "messageLogger", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;ZLorg/jetbrains/kotlin/ir/linkage/partial/PartialLinkageLogLevel;Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;)V", "classifierExplorer", "Lorg/jetbrains/kotlin/backend/common/linkage/partial/ClassifierExplorer;", "isEnabled", "()Z", "patcher", "Lorg/jetbrains/kotlin/backend/common/linkage/partial/PartiallyLinkedIrTreePatcher;", "stubGenerator", "Lorg/jetbrains/kotlin/backend/common/linkage/partial/MissingDeclarationStubGenerator;", "exploreClassifiers", "", "fakeOverrideBuilder", "Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "exploreClassifiersInInlineLazyIrFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "generateStubsAndPatchUsages", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "roots", "Lkotlin/Function0;", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "root", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "generateStubsAndPatchUsagesInternal", "patchIrTree", "shouldBeSkipped", "declaration", "ir.serialization.common"})
public final class PartialLinkageSupportForLinkerImpl
implements PartialLinkageSupportForLinker {
    @NotNull
    private final MissingDeclarationStubGenerator stubGenerator;
    @NotNull
    private final ClassifierExplorer classifierExplorer;
    @NotNull
    private final PartiallyLinkedIrTreePatcher patcher;

    public PartialLinkageSupportForLinkerImpl(@NotNull IrBuiltIns builtIns2, boolean allowErrorTypes, @NotNull PartialLinkageLogLevel logLevel, @NotNull IrMessageLogger messageLogger) {
        Intrinsics.checkNotNullParameter((Object)builtIns2, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)messageLogger, (String)"messageLogger");
        this.stubGenerator = new MissingDeclarationStubGenerator(builtIns2);
        this.classifierExplorer = new ClassifierExplorer(builtIns2, this.stubGenerator, allowErrorTypes);
        this.patcher = new PartiallyLinkedIrTreePatcher(builtIns2, this.classifierExplorer, this.stubGenerator, logLevel, messageLogger);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean shouldBeSkipped(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.patcher.shouldBeSkipped(declaration);
    }

    @Override
    public void exploreClassifiers(@NotNull FakeOverrideBuilder fakeOverrideBuilder) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)fakeOverrideBuilder, (String)"fakeOverrideBuilder");
        Map<IrClass, CompatibilityMode> entries = fakeOverrideBuilder.getFakeOverrideCandidates();
        if (entries.isEmpty()) {
            return;
        }
        Set $this$exploreClassifiers_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        for (IrClass clazz : entries.keySet()) {
            if (this.classifierExplorer.exploreSymbol(clazz.getSymbol()) == null) continue;
            ((Collection)$this$exploreClassifiers_u24lambda_u240).add(clazz);
        }
        Set toExclude = SetsKt.build((Set)set);
        CollectionsKt.removeAll((Collection)entries.keySet(), (Iterable)toExclude);
    }

    @Override
    public void exploreClassifiersInInlineLazyIrFunction(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        this.classifierExplorer.exploreIrElement(function2);
    }

    @Override
    public void generateStubsAndPatchUsages(@NotNull SymbolTable symbolTable, @NotNull Function0<? extends Sequence<? extends IrModuleFragment>> roots2) {
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        this.generateStubsAndPatchUsagesInternal(symbolTable, (Function0<Unit>)((Function0)new Function0<Unit>(this, roots2){
            final /* synthetic */ PartialLinkageSupportForLinkerImpl this$0;
            final /* synthetic */ Function0<Sequence<IrModuleFragment>> $roots;
            {
                this.this$0 = $receiver;
                this.$roots = $roots;
                super(0);
            }

            public final void invoke() {
                PartialLinkageSupportForLinkerImpl.access$getPatcher$p(this.this$0).patchModuleFragments((Sequence<? extends IrModuleFragment>)((Sequence)this.$roots.invoke()));
            }
        }));
    }

    @Override
    public void generateStubsAndPatchUsages(@NotNull SymbolTable symbolTable, @NotNull IrDeclaration root) {
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.generateStubsAndPatchUsagesInternal(symbolTable, (Function0<Unit>)((Function0)new Function0<Unit>(this, root){
            final /* synthetic */ PartialLinkageSupportForLinkerImpl this$0;
            final /* synthetic */ IrDeclaration $root;
            {
                this.this$0 = $receiver;
                this.$root = $root;
                super(0);
            }

            public final void invoke() {
                PartialLinkageSupportForLinkerImpl.access$getPatcher$p(this.this$0).patchDeclarations(CollectionsKt.listOf((Object)this.$root));
            }
        }));
    }

    private final void generateStubsAndPatchUsagesInternal(SymbolTable symbolTable, Function0<Unit> patchIrTree) {
        for (IrSymbol symbol2 : SymbolTableKt.getAllUnbound(symbolTable)) {
            this.stubGenerator.getDeclaration(symbol2);
        }
        patchIrTree.invoke();
        this.patcher.patchDeclarations(this.stubGenerator.grabDeclarationsToPatch());
    }

    public static final /* synthetic */ PartiallyLinkedIrTreePatcher access$getPatcher$p(PartialLinkageSupportForLinkerImpl $this) {
        return $this.patcher;
    }
}

