/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrInlineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.mapping.MethodSignatureMapper;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00012\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\f\u0010\u0019\u001a\u00020\u0002*\u00020\fH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FakeInliningLocalVariablesAfterInlineLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitor;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "inlinedStack", "", "Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;", "handleInlineFunction", "expression", "data", "handleInlineLambda", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "processLocalDeclarations", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nFakeInliningLocalVariablesAfterInlineLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FakeInliningLocalVariablesAfterInlineLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FakeInliningLocalVariablesAfterInlineLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1855#2,2:124\n1855#2,2:126\n*S KotlinDebug\n*F\n+ 1 FakeInliningLocalVariablesAfterInlineLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FakeInliningLocalVariablesAfterInlineLowering\n*L\n90#1:124,2\n98#1:126,2\n*E\n"})
public final class FakeInliningLocalVariablesAfterInlineLowering
implements IrElementVisitor<Unit, IrDeclaration>,
FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final List<IrInlinedFunctionBlock> inlinedStack;

    public FakeInliningLocalVariablesAfterInlineLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.inlinedStack = new ArrayList();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.accept(this, null);
    }

    @Override
    public void visitElement(@NotNull IrElement element, @Nullable IrDeclaration data2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IrDeclaration newData = element instanceof IrDeclaration && !(element instanceof IrVariable) ? (IrDeclaration)element : data2;
        element.acceptChildren(this, newData);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2, @Nullable IrDeclaration data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2 instanceof IrInlinedFunctionBlock && IrInlineUtilsKt.isFunctionInlining((IrInlinedFunctionBlock)expression2)) {
            this.handleInlineFunction((IrInlinedFunctionBlock)expression2, data2);
        } else if (expression2 instanceof IrInlinedFunctionBlock && IrInlineUtilsKt.isLambdaInlining((IrInlinedFunctionBlock)expression2)) {
            this.handleInlineLambda((IrInlinedFunctionBlock)expression2, data2);
        } else {
            IrElementVisitor.DefaultImpls.visitBlock(this, expression2, data2);
        }
    }

    private final void handleInlineFunction(IrInlinedFunctionBlock expression2, IrDeclaration data2) {
        IrDeclaration declaration = IrInlineUtilsKt.getInlineDeclaration(expression2);
        ((Collection)this.inlinedStack).add(expression2);
        IrElementVisitor.DefaultImpls.visitBlock(this, expression2, data2);
        CollectionsKt.removeLast(this.inlinedStack);
        if (declaration instanceof IrFunction && ((IrFunction)declaration).isInline() && !declaration.getOrigin().isSynthetic() && ((IrFunction)declaration).getBody() != null && !JvmIrInlineUtilsKt.isInlineOnly(declaration)) {
            String currentFunctionName = MethodSignatureMapper.mapFunctionName$default(this.context.getDefaultMethodSignatureMapper(), (IrFunction)declaration, false, 2, null);
            String localName = "$i$f$" + currentFunctionName;
            BackendContext backendContext = this.context;
            IrDeclaration irDeclaration2 = data2;
            Intrinsics.checkNotNull((Object)irDeclaration2);
            DeclarationIrBuilder $this$handleInlineFunction_u24lambda_u240 = LowerUtilsKt.createIrBuilder$default(backendContext, irDeclaration2.getSymbol(), 0, 0, 6, null);
            boolean bl = false;
            IrVariable tmpVar = IrBuilderKt.createTmpVariable$default($this$handleInlineFunction_u24lambda_u240.getScope(), (IrExpression)ExpressionHelpersKt.irInt$default($this$handleInlineFunction_u24lambda_u240, 0, null, 2, null), StringsKt.removeSuffix((String)localName, (CharSequence)"$$forInline"), false, (IrDeclarationOrigin)IrDeclarationOrigin.DEFINED.INSTANCE, null, 20, null);
            IrInlineUtilsKt.putStatementsInFrontOfInlinedFunction(expression2, CollectionsKt.listOf((Object)tmpVar));
        }
        this.processLocalDeclarations(expression2);
    }

    private final void handleInlineLambda(IrInlinedFunctionBlock expression2, IrDeclaration data2) {
    }

    private final void processLocalDeclarations(IrInlinedFunctionBlock $this$processLocalDeclarations) {
        IrStatement it;
        Iterable $this$forEach$iv = IrInlineUtilsKt.getAdditionalStatementsFromInlinedBlock($this$processLocalDeclarations);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrStatement)element$iv;
            boolean bl = false;
            if (!(it instanceof IrVariable) || !Intrinsics.areEqual((Object)((IrVariable)it).getOrigin(), (Object)IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE)) continue;
            String string2 = ((IrVariable)it).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            String varName = StringsKt.substringAfterLast$default((String)string2, (String)"_", null, (int)2, null);
            IrVariable irVariable2 = (IrVariable)it;
            Name name2 = Name.identifier((Intrinsics.areEqual((Object)varName, (Object)SpecialNames.THIS.asString()) ? "this_" : varName) + "$iv");
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            irVariable2.setName(name2);
            ((IrVariable)it).setOrigin(IrDeclarationOrigin.DEFINED.INSTANCE);
        }
        $this$forEach$iv = IrInlineUtilsKt.getOriginalStatementsFromInlinedBlock($this$processLocalDeclarations);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrStatement)element$iv;
            boolean bl = false;
            IrVisitorsKt.acceptVoid(it, new IrElementVisitorVoid(){

                public void visitElement(@NotNull IrElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    IrVisitorsKt.acceptChildrenVoid(element, this);
                }

                public void visitVariable(@NotNull IrVariable declaration) {
                    Name name2;
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    String string2 = declaration.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                    String varName = string2;
                    if (Intrinsics.areEqual((Object)varName, (Object)SpecialNames.THIS.asString())) {
                        Name name3 = Name.identifier("this_$iv");
                        Intrinsics.checkNotNull((Object)name3);
                        name2 = name3;
                    } else if (!StringsKt.startsWith$default((String)varName, (String)"$i$f$", (boolean)false, (int)2, null)) {
                        Name name4 = Name.identifier(varName + "$iv");
                        Intrinsics.checkNotNull((Object)name4);
                        name2 = name4;
                    } else {
                        name2 = declaration.getName();
                    }
                    declaration.setName(name2);
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
                }

                public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
                }

                public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data2);
                }

                public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
                }

                public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
                }

                public void visitBlock(@NotNull IrBlock expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
                }

                public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
                }

                public void visitBlockBody(@NotNull IrBlockBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
                }

                public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
                }

                public void visitBody(@NotNull IrBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
                }

                public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
                }

                public void visitBranch(@NotNull IrBranch branch) {
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
                }

                public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
                }

                public void visitBreak(@NotNull IrBreak jump) {
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
                }

                public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
                }

                public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
                }

                public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
                }

                public void visitCall(@NotNull IrCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
                }

                public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
                }

                public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
                }

                public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
                }

                public void visitCatch(@NotNull IrCatch aCatch) {
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
                }

                public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
                }

                public void visitClass(@NotNull IrClass declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
                }

                public void visitClass(@NotNull IrClass declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data2);
                }

                public void visitClassReference(@NotNull IrClassReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
                }

                public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
                }

                public void visitComposite(@NotNull IrComposite expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
                }

                public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
                }

                public void visitConst(@NotNull IrConst<?> expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
                }

                public void visitConst(@NotNull IrConst<?> expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
                }

                public void visitConstantArray(@NotNull IrConstantArray expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
                }

                public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data2);
                }

                public void visitConstantObject(@NotNull IrConstantObject expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
                }

                public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data2);
                }

                public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
                }

                public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
                }

                public void visitConstantValue(@NotNull IrConstantValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
                }

                public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data2);
                }

                public void visitConstructor(@NotNull IrConstructor declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
                }

                public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data2);
                }

                public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
                }

                public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
                }

                public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
                }

                public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
                }

                public void visitContinue(@NotNull IrContinue jump) {
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
                }

                public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
                }

                public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
                }

                public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data2);
                }

                public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
                }

                public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
                }

                public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
                }

                public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
                }

                public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
                }

                public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
                }

                public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
                }

                public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
                }

                public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
                }

                public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
                }

                public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
                }

                public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
                }

                public void visitElseBranch(@NotNull IrElseBranch branch) {
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
                }

                public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
                }

                public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
                }

                public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
                }

                public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
                }

                public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data2);
                }

                public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
                }

                public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
                }

                public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
                }

                public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
                }

                public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
                }

                public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
                }

                public void visitExpression(@NotNull IrExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
                }

                public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
                }

                public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
                }

                public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
                }

                public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
                }

                public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
                }

                public void visitField(@NotNull IrField declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
                }

                public void visitField(@NotNull IrField declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data2);
                }

                public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
                }

                public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
                }

                public void visitFile(@NotNull IrFile declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
                }

                public void visitFile(@NotNull IrFile declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data2);
                }

                public void visitFunction(@NotNull IrFunction declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
                }

                public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data2);
                }

                public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
                }

                public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
                }

                public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
                }

                public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
                }

                public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
                }

                public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
                }

                public void visitGetClass(@NotNull IrGetClass expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
                }

                public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
                }

                public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
                }

                public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
                }

                public void visitGetField(@NotNull IrGetField expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
                }

                public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
                }

                public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
                }

                public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
                }

                public void visitGetValue(@NotNull IrGetValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
                }

                public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
                }

                public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
                }

                public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
                }

                public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
                }

                public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
                }

                public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
                }

                public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
                }

                public void visitLoop(@NotNull IrLoop loop2) {
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
                }

                public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
                }

                public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
                }

                public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
                }

                public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
                }

                public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data2);
                }

                public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
                }

                public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data2);
                }

                public void visitProperty(@NotNull IrProperty declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
                }

                public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data2);
                }

                public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
                }

                public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
                }

                public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
                }

                public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
                }

                public void visitReturn(@NotNull IrReturn expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
                }

                public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
                }

                public void visitScript(@NotNull IrScript declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
                }

                public void visitScript(@NotNull IrScript declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data2);
                }

                public void visitSetField(@NotNull IrSetField expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
                }

                public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
                }

                public void visitSetValue(@NotNull IrSetValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
                }

                public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
                }

                public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
                }

                public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data2);
                }

                public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
                }

                public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
                }

                public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
                }

                public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
                }

                public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
                }

                public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
                }

                public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
                }

                public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
                }

                public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
                }

                public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
                }

                public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
                }

                public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
                }

                public void visitThrow(@NotNull IrThrow expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
                }

                public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
                }

                public void visitTry(@NotNull IrTry aTry) {
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
                }

                public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
                }

                public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
                }

                public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data2);
                }

                public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
                }

                public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
                }

                public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
                }

                public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data2);
                }

                public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
                }

                public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
                }

                public void visitValueParameter(@NotNull IrValueParameter declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
                }

                public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data2);
                }

                public void visitVararg(@NotNull IrVararg expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
                }

                public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
                }

                public void visitWhen(@NotNull IrWhen expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
                }

                public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
                }

                public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
                }

                public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
                }
            });
        }
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitBlockBody(this, body2, data2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitBody(this, body2, data2);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitBranch(this, branch, data2);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitBreak(this, jump, data2);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitBreakContinue(this, jump, data2);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitCall(this, expression2, data2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitCallableReference(this, expression2, data2);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitCatch(this, aCatch, data2);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitClass(this, declaration, data2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitClassReference(this, expression2, data2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitComposite(this, expression2, data2);
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitConst(this, expression2, data2);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitConstantArray(this, expression2, data2);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitConstantObject(this, expression2, data2);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitConstantValue(this, expression2, data2);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitConstructor(this, declaration, data2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitContainerExpression(this, expression2, data2);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitContinue(this, jump, data2);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitDeclaration(this, declaration, data2);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitDeclarationReference(this, expression2, data2);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitDynamicExpression(this, expression2, data2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitElseBranch(this, branch, data2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitEnumEntry(this, declaration, data2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitErrorExpression(this, expression2, data2);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitExpression(this, expression2, data2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitExpressionBody(this, body2, data2);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
    }

    @Override
    public void visitField(@NotNull IrField declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitField(this, declaration, data2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitFieldAccess(this, expression2, data2);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitFile(this, declaration, data2);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitFunction(this, declaration, data2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitFunctionAccess(this, expression2, data2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitFunctionExpression(this, expression2, data2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitFunctionReference(this, expression2, data2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitGetClass(this, expression2, data2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitGetEnumValue(this, expression2, data2);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitGetField(this, expression2, data2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitGetObjectValue(this, expression2, data2);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitGetValue(this, expression2, data2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitLoop(this, loop2, data2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitMemberAccess(this, expression2, data2);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitModuleFragment(this, declaration, data2);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitPackageFragment(this, declaration, data2);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitProperty(this, declaration, data2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitPropertyReference(this, expression2, data2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitReturn(this, expression2, data2);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitScript(this, declaration, data2);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitSetField(this, expression2, data2);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitSetValue(this, expression2, data2);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitSimpleFunction(this, declaration, data2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitSingletonReference(this, expression2, data2);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitSpreadElement(this, spread, data2);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitStringConcatenation(this, expression2, data2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitSyntheticBody(this, body2, data2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitThrow(this, expression2, data2);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitTry(this, aTry, data2);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitTypeAlias(this, declaration, data2);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitTypeOperator(this, expression2, data2);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitTypeParameter(this, declaration, data2);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitValueAccess(this, expression2, data2);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitValueParameter(this, declaration, data2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitVararg(this, expression2, data2);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitVariable(this, declaration, data2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitWhen(this, expression2, data2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable IrDeclaration data2) {
        IrElementVisitor.DefaultImpls.visitWhileLoop(this, loop2, data2);
    }
}

