/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLoop;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/LabeledBlockToDoWhileTransformation;", "", "()V", "apply", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "labelLoopBreaksAndContinues", "loopOrSwitch", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "fakeLoops", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsDoWhile;", "label", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "js.translator"})
public final class LabeledBlockToDoWhileTransformation {
    @NotNull
    public static final LabeledBlockToDoWhileTransformation INSTANCE = new LabeledBlockToDoWhileTransformation();

    private LabeledBlockToDoWhileTransformation() {
    }

    public final void apply(@NotNull JsNode root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        new JsVisitorWithContextImpl(){
            @NotNull
            private final Stack<JsStatement> loopOrSwitchStack;
            @NotNull
            private final HashSet<JsDoWhile> newFakeLoops;
            @NotNull
            private final HashMap<JsStatement, JsLabel> statementsLabels;
            @NotNull
            private final HashSet<JsStatement> loopsAndSwitchesToLabel;
            {
                this.loopOrSwitchStack = new Stack<E>();
                this.newFakeLoops = new HashSet<E>();
                this.statementsLabels = new HashMap<K, V>();
                this.loopsAndSwitchesToLabel = new HashSet<E>();
            }

            @NotNull
            public final Stack<JsStatement> getLoopOrSwitchStack() {
                return this.loopOrSwitchStack;
            }

            @NotNull
            public final HashSet<JsDoWhile> getNewFakeLoops() {
                return this.newFakeLoops;
            }

            @NotNull
            public final HashMap<JsStatement, JsLabel> getStatementsLabels() {
                return this.statementsLabels;
            }

            @NotNull
            public final HashSet<JsStatement> getLoopsAndSwitchesToLabel() {
                return this.loopsAndSwitchesToLabel;
            }

            public void endVisit(@NotNull JsLabel x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                if (x.getStatement() instanceof JsBlock) {
                    CollectionsKt.addIfNotNull((Collection)this.loopsAndSwitchesToLabel, kotlin.collections.CollectionsKt.lastOrNull((List)this.loopOrSwitchStack));
                    JsDoWhile fakeLoop = new JsDoWhile(new JsBooleanLiteral(false), x.getStatement());
                    this.newFakeLoops.add(fakeLoop);
                    x.setStatement(fakeLoop);
                }
                super.endVisit(x, ctx);
            }

            public boolean visit(@NotNull JsLabel x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                if (x.getStatement() instanceof JsLoop) {
                    Map map = this.statementsLabels;
                    JsStatement jsStatement = x.getStatement();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"getStatement(...)");
                    map.put(jsStatement, x);
                }
                return true;
            }

            public boolean visit(@NotNull JsLoop x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                this.loopOrSwitchStack.push(x);
                return true;
            }

            public boolean visit(@NotNull JsSwitch x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                this.loopOrSwitchStack.push(x);
                return true;
            }

            public final void endVisitLoopOrSwitch(@NotNull JsStatement x, @NotNull JsContext<JsNode> ctx) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                JsStatement top = this.loopOrSwitchStack.pop();
                boolean bl2 = bl = top == x;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                if (this.loopsAndSwitchesToLabel.contains(x)) {
                    JsLabel label = this.statementsLabels.get(x);
                    if (label == null) {
                        JsName jsName = JsScope.declareTemporaryName("loop_label");
                        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"declareTemporaryName(...)");
                        JsName labelName = jsName;
                        label = new JsLabel(labelName, x);
                        ((Map)this.statementsLabels).put(x, label);
                        ctx.replaceMe((JsNode)label);
                    }
                    Set set = this.newFakeLoops;
                    JsNameRef jsNameRef = label.getName().makeRef();
                    Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"makeRef(...)");
                    LabeledBlockToDoWhileTransformation.access$labelLoopBreaksAndContinues(LabeledBlockToDoWhileTransformation.INSTANCE, x, set, jsNameRef);
                }
            }

            public void endVisit(@NotNull JsSwitch x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                this.endVisitLoopOrSwitch(x, ctx);
            }

            public void endVisit(@NotNull JsLoop x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                this.endVisitLoopOrSwitch(x, ctx);
            }
        }.accept(root);
    }

    private final void labelLoopBreaksAndContinues(JsStatement loopOrSwitch, Set<? extends JsDoWhile> fakeLoops, JsNameRef label) {
        new JsVisitorWithContextImpl(fakeLoops, loopOrSwitch, label){
            final /* synthetic */ Set<JsDoWhile> $fakeLoops;
            final /* synthetic */ JsStatement $loopOrSwitch;
            final /* synthetic */ JsNameRef $label;
            {
                this.$fakeLoops = $fakeLoops;
                this.$loopOrSwitch = $loopOrSwitch;
                this.$label = $label;
            }

            public boolean visit(@NotNull JsLoop x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                return kotlin.collections.CollectionsKt.contains((Iterable)this.$fakeLoops, (Object)x) || x == this.$loopOrSwitch;
            }

            public boolean visit(@NotNull JsSwitch x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                return x == this.$loopOrSwitch;
            }

            public void endVisit(@NotNull JsBreak x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                if (x.getLabel() == null) {
                    ctx.replaceMe((JsNode)new JsBreak(this.$label));
                }
                super.endVisit(x, ctx);
            }

            public void endVisit(@NotNull JsContinue x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                if (x.getLabel() == null) {
                    ctx.replaceMe((JsNode)new JsContinue(this.$label));
                }
                super.endVisit(x, ctx);
            }
        }.accept((JsNode)loopOrSwitch);
    }

    public static final /* synthetic */ void access$labelLoopBreaksAndContinues(LabeledBlockToDoWhileTransformation $this, JsStatement loopOrSwitch, Set fakeLoops, JsNameRef label) {
        $this.labelLoopBreaksAndContinues(loopOrSwitch, fakeLoops, label);
    }
}

