/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeObjCRefinementAnnotationCheckerKt;
import org.jetbrains.kotlin.fir.analysis.native.checkers.ObjCExportMetaAnnotations;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "hidesFromObjCSupportedTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "[Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "refinesInSwiftSupportedTargets", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
public final class FirNativeObjCRefinementAnnotationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirNativeObjCRefinementAnnotationChecker INSTANCE = new FirNativeObjCRefinementAnnotationChecker();
    @NotNull
    private static final KotlinTarget[] hidesFromObjCSupportedTargets;
    @NotNull
    private static final KotlinTarget[] refinesInSwiftSupportedTargets;

    private FirNativeObjCRefinementAnnotationChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block6: {
            FirAnnotation it;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (declaration.getClassKind() != ClassKind.ANNOTATION_CLASS) {
                return;
            }
            FirSession session = context.getSession();
            ObjCExportMetaAnnotations objCExportMetaAnnotations = FirNativeObjCRefinementAnnotationCheckerKt.findMetaAnnotations(declaration.getAnnotations(), session);
            FirAnnotation objCAnnotation = objCExportMetaAnnotations.component1();
            FirAnnotation swiftAnnotation = objCExportMetaAnnotations.component2();
            if (objCAnnotation == null && swiftAnnotation == null) {
                return;
            }
            if (objCAnnotation != null && swiftAnnotation != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)swiftAnnotation.getSource(), FirNativeErrors.INSTANCE.getREDUNDANT_SWIFT_REFINEMENT(), (DiagnosticContext)context, null, 8, null);
            }
            Set<KotlinTarget> targets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(declaration, session);
            FirAnnotation firAnnotation = objCAnnotation;
            if (firAnnotation != null) {
                it = firAnnotation;
                boolean bl = false;
                if (!((Collection)SetsKt.minus(targets, (Object[])hidesFromObjCSupportedTargets)).isEmpty()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirNativeErrors.INSTANCE.getINVALID_OBJC_HIDES_TARGETS(), (DiagnosticContext)context, null, 8, null);
                }
            }
            FirAnnotation firAnnotation2 = swiftAnnotation;
            if (firAnnotation2 == null) break block6;
            it = firAnnotation2;
            boolean bl = false;
            if (!((Collection)SetsKt.minus(targets, (Object[])refinesInSwiftSupportedTargets)).isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirNativeErrors.INSTANCE.getINVALID_REFINES_IN_SWIFT_TARGETS(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }

    static {
        KotlinTarget[] kotlinTargetArray = new KotlinTarget[]{KotlinTarget.FUNCTION, KotlinTarget.PROPERTY, KotlinTarget.CLASS};
        hidesFromObjCSupportedTargets = kotlinTargetArray;
        kotlinTargetArray = new KotlinTarget[]{KotlinTarget.FUNCTION, KotlinTarget.PROPERTY};
        refinesInSwiftSupportedTargets = kotlinTargetArray;
    }
}

