/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers.impl;

import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.providers.KotlinDeclarationProvider;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinStaticDeclarationIndex;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTypeAlias;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00102\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010#\u001a\u00020$H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\r2\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00102\u0006\u0010#\u001a\u00020$H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020&0\r2\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00102\u0006\u0010#\u001a\u00020$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProvider;", "Lorg/jetbrains/kotlin/analysis/providers/KotlinDeclarationProvider;", "index", "Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationIndex;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationIndex;Lcom/intellij/psi/search/GlobalSearchScope;)V", "inScope", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "getInScope", "(Lorg/jetbrains/kotlin/psi/KtElement;)Z", "computePackageSetWithTopLevelCallableDeclarations", "", "", "findFilesForFacade", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "facadeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "findFilesForFacadeByPackage", "packageFqName", "findFilesForScript", "Lorg/jetbrains/kotlin/psi/KtScript;", "scriptFqName", "findInternalFilesForFacade", "getAllClassesByClassId", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getAllTypeAliasesByClassId", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "getClassLikeDeclarationByClassId", "Lorg/jetbrains/kotlin/psi/KtClassLikeDeclaration;", "getTopLevelCallableFiles", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "getTopLevelCallableNamesInPackage", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelFunctions", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "getTopLevelKotlinClassLikeDeclarationNamesInPackage", "getTopLevelProperties", "Lorg/jetbrains/kotlin/psi/KtProperty;", "analysis-api-providers"})
@SourceDebugExtension(value={"SMAP\nKotlinStaticDeclarationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStaticDeclarationProvider.kt\norg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,371:1\n766#2:372\n857#2,2:373\n766#2:375\n857#2,2:376\n766#2:378\n857#2,2:379\n1611#2:381\n1855#2:382\n1856#2:384\n1612#2:385\n766#2:386\n857#2,2:387\n1611#2:389\n1855#2:390\n1856#2:392\n1612#2:393\n766#2:394\n857#2,2:395\n766#2:397\n857#2,2:398\n766#2:400\n857#2,2:401\n766#2:403\n857#2,2:404\n1620#2,3:406\n766#2:409\n857#2,2:410\n766#2:412\n857#2,2:413\n1620#2,3:415\n1620#2,3:418\n1#3:383\n1#3:391\n*S KotlinDebug\n*F\n+ 1 KotlinStaticDeclarationProvider.kt\norg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProvider\n*L\n55#1:372\n55#1:373,2\n62#1:375\n62#1:376,2\n69#1:378\n69#1:379,2\n70#1:381\n70#1:382\n70#1:384\n70#1:385\n76#1:386\n76#1:387,2\n77#1:389\n77#1:390\n77#1:392\n77#1:393\n81#1:394\n81#1:395,2\n87#1:397\n87#1:398,2\n91#1:400\n91#1:401,2\n95#1:403\n95#1:404,2\n100#1:406,3\n105#1:409\n105#1:410,2\n112#1:412\n112#1:413,2\n118#1:415,3\n119#1:418,3\n70#1:383\n77#1:391\n*E\n"})
public final class KotlinStaticDeclarationProvider
extends KotlinDeclarationProvider {
    @NotNull
    private final KotlinStaticDeclarationIndex index;
    @NotNull
    private final GlobalSearchScope scope;

    public KotlinStaticDeclarationProvider(@NotNull KotlinStaticDeclarationIndex index2, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.index = index2;
        this.scope = scope2;
    }

    private final boolean getInScope(KtElement $this$inScope) {
        return this.scope.contains($this$inScope.getContainingKtFile().getVirtualFile());
    }

    @Override
    @Nullable
    public KtClassLikeDeclaration getClassLikeDeclarationByClassId(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        KtClassOrObject ktClassOrObject = (KtClassOrObject)CollectionsKt.firstOrNull((Iterable)this.getAllClassesByClassId(classId));
        return ktClassOrObject != null ? (KtClassLikeDeclaration)ktClassOrObject : (KtClassLikeDeclaration)CollectionsKt.firstOrNull((Iterable)this.getAllTypeAliasesByClassId(classId));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtClassOrObject> getAllClassesByClassId(@NotNull ClassId classId) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Set<KtClassOrObject> set = this.index.getClassMap$analysis_api_providers().get(classId.getPackageFqName());
        if (set != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtClassOrObject ktClassOrObject = (KtClassOrObject)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)ktClassOrObject.getClassId(), (Object)classId) && this.getInScope(ktClassOrObject))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtTypeAlias> getAllTypeAliasesByClassId(@NotNull ClassId classId) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Set<KtTypeAlias> set = this.index.getTypeAliasMap$analysis_api_providers().get(classId.getPackageFqName());
        if (set != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtTypeAlias ktTypeAlias = (KtTypeAlias)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)ktTypeAlias.getClassId(), (Object)classId) && this.getInScope(ktTypeAlias))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<Name> getTopLevelKotlinClassLikeDeclarationNamesInPackage(@NotNull FqName packageFqName) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        void $this$filterTo$iv$iv;
        Set set;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Set set2 = this.index.getClassMap$analysis_api_providers().get(packageFqName);
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        if ((set = this.index.getTypeAliasMap$analysis_api_providers().get(packageFqName)) == null) {
            set = SetsKt.emptySet();
        }
        Set classifiers = SetsKt.plus((Set)set2, (Iterable)set);
        Iterable $this$filter$iv = classifiers;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtNamedDeclaration it = (KtNamedDeclaration)element$iv$iv;
            boolean bl = false;
            if (!this.getInScope(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection $i$f$filter22 = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Name it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
            boolean bl2 = false;
            if (((KtClassLikeDeclaration)it).getNameAsName() == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<Name> getTopLevelCallableNamesInPackage(@NotNull FqName packageFqName) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Object element$iv$iv;
        void $this$filterTo$iv$iv;
        Set set;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Set set2 = this.index.getTopLevelPropertyMap$analysis_api_providers().get(packageFqName);
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        if ((set = this.index.getTopLevelFunctionMap$analysis_api_providers().get(packageFqName)) == null) {
            set = SetsKt.emptySet();
        }
        Set callables = SetsKt.plus((Set)set2, (Iterable)set);
        Iterable $this$filter$iv = callables;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!this.getInScope((KtElement)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection $i$f$filter22 = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Name it$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Object it = element$iv;
            boolean bl2 = false;
            if (((KtCallableDeclaration)it).getNameAsName() == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtFile> findFilesForFacadeByPackage(@NotNull FqName packageFqName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Set set = this.index.getFacadeFileMap$analysis_api_providers().get(packageFqName);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!this.scope.contains(it.getVirtualFile())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtFile> findFilesForFacade(@NotNull FqName facadeFqName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)facadeFqName, (String)"facadeFqName");
        if (facadeFqName.shortNameOrSpecial().isSpecial()) {
            return CollectionsKt.emptyList();
        }
        FqName fqName2 = facadeFqName.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"parent(...)");
        Iterable $this$filter$iv = this.findFilesForFacadeByPackage(fqName2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)JvmFileClassUtilKt.getJavaFileFacadeFqName(it), (Object)facadeFqName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtFile> findInternalFilesForFacade(@NotNull FqName facadeFqName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)facadeFqName, (String)"facadeFqName");
        Set set = this.index.getMultiFileClassPartMap$analysis_api_providers().get(facadeFqName);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!this.scope.contains(it.getVirtualFile())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtScript> findFilesForScript(@NotNull FqName scriptFqName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)scriptFqName, (String)"scriptFqName");
        Set set = this.index.getScriptMap$analysis_api_providers().get(scriptFqName);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtScript it = (KtScript)element$iv$iv;
            boolean bl = false;
            if (!this.scope.contains(it.getContainingKtFile().getVirtualFile())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> computePackageSetWithTopLevelCallableDeclarations() {
        void var3_3;
        void $this$mapTo$iv;
        Set packageNames = SetsKt.plus(this.index.getTopLevelPropertyMap$analysis_api_providers().keySet(), (Iterable)this.index.getTopLevelFunctionMap$analysis_api_providers().keySet());
        Iterable iterable = packageNames;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            FqName fqName2 = (FqName)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.asString());
        }
        return (Set)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtProperty> getTopLevelProperties(@NotNull CallableId callableId) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        Set<KtProperty> set = this.index.getTopLevelPropertyMap$analysis_api_providers().get(callableId.getPackageName());
        if (set != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtProperty ktProperty = (KtProperty)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)ktProperty.getNameAsName(), (Object)callableId.getCallableName()) && this.getInScope(ktProperty))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtNamedFunction> getTopLevelFunctions(@NotNull CallableId callableId) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        Set<KtNamedFunction> set = this.index.getTopLevelFunctionMap$analysis_api_providers().get(callableId.getPackageName());
        if (set != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtNamedFunction ktNamedFunction = (KtNamedFunction)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)ktNamedFunction.getNameAsName(), (Object)callableId.getCallableName()) && this.getInScope(ktNamedFunction))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<KtFile> getTopLevelCallableFiles(@NotNull CallableId callableId) {
        KtNamedFunction it;
        Collection collection;
        Set set;
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        Set $this$getTopLevelCallableFiles_u24lambda_u2415 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable $this$mapTo$iv = this.getTopLevelProperties(callableId);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            KtProperty ktProperty = (KtProperty)item$iv;
            collection = $this$getTopLevelCallableFiles_u24lambda_u2415;
            boolean bl2 = false;
            collection.add(it.getContainingKtFile());
        }
        $this$mapTo$iv = this.getTopLevelFunctions(callableId);
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (KtNamedFunction)item$iv;
            collection = $this$getTopLevelCallableFiles_u24lambda_u2415;
            boolean bl3 = false;
            collection.add(it.getContainingKtFile());
        }
        return SetsKt.build((Set)set);
    }
}

