/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationMemberGenerator;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformerKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.MethodsFromAnyGeneratorForLowerings;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H&J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J8\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0016J&\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020$J\u0010\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020(H&J \u0010-\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u0015H&J\u0016\u0010/\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fJ\u0018\u00100\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0018\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u00020\u0018H\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u000fH\u0016J\u0010\u00107\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\f\u00108\u001a\u00020\u001c*\u00020\u000fH\u0004J\u0010\u00109\u001a\b\u0012\u0004\u0012\u00020;0:*\u00020\u000fJ\f\u0010<\u001a\u00020\u001c*\u00020\u000fH\u0016J\u001c\u0010=\u001a\u00020$*\u00020$2\u0006\u0010'\u001a\u00020(2\u0006\u0010%\u001a\u00020&H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "forbidDirectFieldAccessInMethods", "", "getForbidDirectFieldAccessInMethods", "()Z", "implementations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getImplementations$ir_backend_common", "()Ljava/util/Map;", "getIrFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "chooseConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "implClass", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "createAnnotationImplementation", "annotationClass", "generateFunctionBodies", "", "eqFun", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "hcFun", "toStringFun", "generator", "Lorg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationMemberGenerator;", "generatedEquals", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "irBuilder", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "arg1", "arg2", "getArrayContentEqualsSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "implementAnnotationPropertiesAndConstructor", "generatedConstructor", "implementGeneratedFunctions", "implementPlatformSpecificParts", "moveValueArgumentsUsingNames", "source", "destination", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "visitConstructorCall", "addConstructorBodyForCompatibility", "getAnnotationProperties", "", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "platformSetup", "transformArrayEqualsArgument", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nAnnotationImplementationTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationImplementationTransformer.kt\norg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer\n+ 2 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 3 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 8 CollectionUtil.kt\norg/jetbrains/kotlin/utils/CollectionUtilKt\n*L\n1#1,276:1\n409#2,5:277\n72#3,2:282\n1#4:284\n1#4:348\n372#5,7:285\n1208#6,2:292\n1238#6,4:294\n1864#6,3:298\n800#6,11:319\n1603#6,9:338\n1855#6:347\n1856#6:349\n1612#6:350\n38#7,4:301\n231#7:305\n225#7,13:306\n32#8,2:330\n9#8,6:332\n*S KotlinDebug\n*F\n+ 1 AnnotationImplementationTransformer.kt\norg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer\n*L\n66#1:277,5\n66#1:282,2\n162#1:348\n85#1:285,7\n101#1:292,2\n101#1:294,4\n106#1:298,3\n158#1:319,11\n162#1:338,9\n162#1:347\n162#1:349\n162#1:350\n121#1:301,4\n138#1:305\n138#1:306,13\n161#1:330,2\n161#1:332,6\n*E\n"})
public abstract class AnnotationImplementationTransformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final BackendContext context;
    @Nullable
    private final IrFile irFile;
    @NotNull
    private final Map<IrClass, IrClass> implementations;
    private final boolean forbidDirectFieldAccessInMethods;

    public AnnotationImplementationTransformer(@NotNull BackendContext context, @Nullable IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.irFile = irFile;
        this.implementations = new LinkedHashMap();
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    @Nullable
    public final IrFile getIrFile() {
        return this.irFile;
    }

    @NotNull
    public final Map<IrClass, IrClass> getImplementations$ir_backend_common() {
        return this.implementations;
    }

    @Override
    @NotNull
    public IrStatement visitClassNew(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.addConstructorBodyForCompatibility(declaration);
        return super.visitClassNew(declaration);
    }

    /*
     * WARNING - void declaration
     */
    protected final void addConstructorBodyForCompatibility(@NotNull IrClass $this$addConstructorBodyForCompatibility) {
        void $this$addConstructorBodyForCompatibility_u24lambda_u240;
        void this_$iv$iv;
        void startOffset$iv;
        void $this$irBlockBody$iv;
        Intrinsics.checkNotNullParameter((Object)$this$addConstructorBodyForCompatibility, (String)"<this>");
        if (!IrUtilsKt.isAnnotationClass($this$addConstructorBodyForCompatibility)) {
            return;
        }
        IrConstructor irConstructor2 = (IrConstructor)SequencesKt.singleOrNull(IrUtilsKt.getConstructors($this$addConstructorBodyForCompatibility));
        if (irConstructor2 == null) {
            return;
        }
        IrConstructor primaryConstructor2 = irConstructor2;
        if (primaryConstructor2.getBody() != null) {
            return;
        }
        $this$addConstructorBodyForCompatibility.setModality(Modality.OPEN);
        IrBuilderWithScope irBuilderWithScope = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)$this$addConstructorBodyForCompatibility.getSymbol(), 0, 0, 6, null);
        int n = -2;
        int endOffset$iv = -2;
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void var9_9 = this_$iv$iv;
        IrConstructor irConstructor3 = primaryConstructor2;
        boolean bl = false;
        $this$addConstructorBodyForCompatibility_u24lambda_u240.unaryPlus(ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$addConstructorBodyForCompatibility_u24lambda_u240, (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)$this$addConstructorBodyForCompatibility_u24lambda_u240.getContext().getIrBuiltIns().getAnyClass().getOwner()))));
        $this$addConstructorBodyForCompatibility_u24lambda_u240.unaryPlus(new IrInstanceInitializerCallImpl($this$addConstructorBodyForCompatibility_u24lambda_u240.getStartOffset(), $this$addConstructorBodyForCompatibility_u24lambda_u240.getEndOffset(), $this$addConstructorBodyForCompatibility.getSymbol(), $this$addConstructorBodyForCompatibility_u24lambda_u240.getContext().getIrBuiltIns().getUnitType()));
        irConstructor3.setBody(this_$iv$iv.doBuild());
    }

    @NotNull
    public abstract IrConstructor chooseConstructor(@NotNull IrClass var1, @NotNull IrConstructorCall var2);

    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        IrClass irClass2;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Object object = IrTypesKt.getClassOrNull(expression2.getType());
        if (object == null || (object = (IrClass)object.getOwner()) == null) {
            return super.visitConstructorCall(expression2);
        }
        Object constructedClass = object;
        if (!IrUtilsKt.isAnnotationClass((IrClass)constructedClass)) {
            return super.visitConstructorCall(expression2);
        }
        if (!((Collection)constructedClass.getTypeParameters()).isEmpty()) {
            return super.visitConstructorCall(expression2);
        }
        if (!((IrConstructor)expression2.getSymbol().getOwner()).isPrimary()) {
            boolean $i$a$-require-AnnotationImplementationTransformer$visitConstructorCall$22 = false;
            String $i$a$-require-AnnotationImplementationTransformer$visitConstructorCall$22 = "Non-primary constructors of annotations are not supported";
            throw new IllegalArgumentException($i$a$-require-AnnotationImplementationTransformer$visitConstructorCall$22.toString());
        }
        Map<IrClass, IrClass> $this$getOrPut$iv = this.implementations;
        boolean $i$f$getOrPut = false;
        IrClass value$iv = $this$getOrPut$iv.get(constructedClass);
        if (value$iv == null) {
            boolean bl = false;
            IrClass answer$iv = this.createAnnotationImplementation((IrClass)constructedClass);
            $this$getOrPut$iv.put((IrClass)constructedClass, answer$iv);
            irClass2 = answer$iv;
        } else {
            irClass2 = value$iv;
        }
        IrClass implClass = irClass2;
        IrConstructor ctor = this.chooseConstructor(implClass, expression2);
        IrConstructorCallImpl newCall2 = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, expression2.getStartOffset(), expression2.getEndOffset(), IrUtilsKt.getDefaultType(implClass), ctor.getSymbol(), null, 16, null);
        this.moveValueArgumentsUsingNames(expression2, newCall2);
        this.transformChildrenVoid(newCall2);
        return newCall2;
    }

    public void platformSetup(@NotNull IrClass $this$platformSetup) {
        Intrinsics.checkNotNullParameter((Object)$this$platformSetup, (String)"<this>");
    }

    /*
     * WARNING - void declaration
     */
    private final void moveValueArgumentsUsingNames(IrConstructorCall source, IrConstructorCall destination) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = IrUtilsKt.getArgumentsWithIr(source);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            IrExpression value2;
            Pair pair = (Pair)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            IrValueParameter param = (IrValueParameter)pair.component1();
            pair = (Pair)element$iv$iv;
            Name name2 = param.getName();
            boolean bl2 = false;
            IrExpression irExpression = value2 = (IrExpression)pair.component2();
            map.put(name2, irExpression);
        }
        Map argumentsByName = destination$iv$iv;
        Iterable $this$forEachIndexed$iv = ((IrConstructor)destination.getSymbol().getOwner()).getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void parameter2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            int index2 = n;
            boolean bl = false;
            IrExpression valueArg = (IrExpression)argumentsByName.get(parameter2.getName());
            if (parameter2.getDefaultValue() == null && valueArg == null) {
                Object object;
                String string2 = "Usage of default value argument for this annotation is not yet possible.\nPlease specify value for '" + ((object = IrTypesKt.getClassOrNull(source.getType())) != null && (object = (IrClass)object.getOwner()) != null ? object.getName() : null) + '.' + parameter2.getName() + "' explicitly";
                throw new IllegalStateException(string2.toString());
            }
            destination.putValueArgument(index2, valueArg);
        }
    }

    private final IrClass createAnnotationImplementation(IrClass annotationClass) {
        IrConstructor irConstructor2;
        Object subclass;
        Object object = this.getCurrentClass();
        IrDeclarationParent irDeclarationParent = object != null && (object = ((ScopeWithIr)object).getScope()) != null ? ((Scope)object).getLocalDeclarationParent() : null;
        IrClass localDeclarationParent = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(annotationClass);
        Intrinsics.checkNotNull((Object)fqName2);
        String string2 = fqName2.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String parentFqName = StringsKt.replace$default((String)string2, (char)'.', (char)'_', (boolean)false, (int)4, null);
        Name name2 = Name.identifier("annotationImpl$" + parentFqName + "$0");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        Name wrapperName = name2;
        Object $this$buildClass$iv = this.context.getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$createAnnotationImplementation_u24lambda_u246 = $this$buildClass_u24lambda_u241$iv;
        boolean bl2 = false;
        $this$createAnnotationImplementation_u24lambda_u246.setStartOffset(-2);
        $this$createAnnotationImplementation_u24lambda_u246.setEndOffset(-2);
        $this$createAnnotationImplementation_u24lambda_u246.setName(wrapperName);
        $this$createAnnotationImplementation_u24lambda_u246.setOrigin(AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION());
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.INTERNAL;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"INTERNAL");
        $this$createAnnotationImplementation_u24lambda_u246.setVisibility(descriptorVisibility);
        Object $this$createAnnotationImplementation_u24lambda_u247 = $this$buildClass$iv = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
        boolean bl3 = false;
        IrElementBase irElementBase = localDeclarationParent;
        if (irElementBase == null) {
            irElementBase = this.irFile;
        }
        if ((bl = irElementBase) == null) {
            throw new IllegalStateException("irFile in transformer should be specified when creating synthetic implementation".toString());
        }
        $this$createAnnotationImplementation_u24lambda_u247.setParent(bl);
        IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$createAnnotationImplementation_u24lambda_u247);
        ((IrClass)$this$createAnnotationImplementation_u24lambda_u247).setSuperTypes(CollectionsKt.listOf((Object)IrUtilsKt.getDefaultType(annotationClass)));
        this.platformSetup((IrClass)$this$createAnnotationImplementation_u24lambda_u247);
        Object $this$addConstructor$iv = subclass = $this$buildClass$iv;
        boolean $i$f$addConstructor = false;
        IrFactory $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2422$iv$iv = new IrFunctionBuilder();
        boolean bl4 = false;
        IrFunctionBuilder $this$addConstructor_u24lambda_u2423$iv = $this$buildConstructor_u24lambda_u2422$iv$iv;
        boolean bl5 = false;
        IrFunctionBuilder $this$createAnnotationImplementation_u24lambda_u248 = $this$addConstructor_u24lambda_u2423$iv;
        boolean bl6 = false;
        $this$createAnnotationImplementation_u24lambda_u248.setStartOffset(-2);
        $this$createAnnotationImplementation_u24lambda_u248.setEndOffset(-2);
        DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PUBLIC");
        $this$createAnnotationImplementation_u24lambda_u248.setVisibility(descriptorVisibility2);
        $this$addConstructor_u24lambda_u2423$iv.setReturnType(IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
        IrConstructor constructor$iv = irConstructor2 = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u2422$iv$iv);
        boolean bl7 = false;
        $this$addConstructor$iv.getDeclarations().add(constructor$iv);
        constructor$iv.setParent((IrDeclarationParent)$this$addConstructor$iv);
        IrConstructor ctor = irConstructor2;
        this.implementAnnotationPropertiesAndConstructor((IrClass)subclass, annotationClass, ctor);
        this.implementGeneratedFunctions(annotationClass, (IrClass)subclass);
        this.implementPlatformSpecificParts(annotationClass, (IrClass)subclass);
        return subclass;
    }

    public abstract void implementAnnotationPropertiesAndConstructor(@NotNull IrClass var1, @NotNull IrClass var2, @NotNull IrConstructor var3);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IrProperty> getAnnotationProperties(@NotNull IrClass $this$getAnnotationProperties) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceAndTo$iv$iv;
        List list2;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getAnnotationProperties, (String)"<this>");
        Iterable $this$filterIsInstance$iv = $this$getAnnotationProperties.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrProperty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List props = (List)destination$iv$iv;
        if (!((Collection)props).isEmpty()) {
            return props;
        }
        Collection $this$filterIsInstanceAnd$iv = $this$getAnnotationProperties.getDeclarations();
        boolean $i$f$filterIsInstanceAnd = false;
        if ($this$filterIsInstanceAnd$iv.isEmpty()) {
            list2 = CollectionsKt.emptyList();
        } else {
            $this$filterIsInstanceTo$iv$iv = $this$filterIsInstanceAnd$iv;
            destination$iv$iv = new SmartList();
            boolean $i$f$filterIsInstanceAndTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceAndTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrDeclarationOrigin.DEFAULT_PROPERTY_ACCESSOR.INSTANCE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceAndTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrProperty it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
            boolean bl2 = false;
            IrPropertySymbol irPropertySymbol = it.getCorrespondingPropertySymbol();
            if ((irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public abstract IrFunctionSymbol getArrayContentEqualsSymbol(@NotNull IrType var1);

    @NotNull
    public IrExpression transformArrayEqualsArgument(@NotNull IrExpression $this$transformArrayEqualsArgument, @NotNull IrType type2, @NotNull IrBlockBodyBuilder irBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$transformArrayEqualsArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)irBuilder, (String)"irBuilder");
        return $this$transformArrayEqualsArgument;
    }

    @NotNull
    public final IrExpression generatedEquals(@NotNull IrBlockBodyBuilder irBuilder, @NotNull IrType type2, @NotNull IrExpression arg1, @NotNull IrExpression arg2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)irBuilder, (String)"irBuilder");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)arg1, (String)"arg1");
        Intrinsics.checkNotNullParameter((Object)arg2, (String)"arg2");
        if (IrTypePredicatesKt.isArray(type2) || IrTypeUtilsKt.isPrimitiveArray(type2) || IrTypeUtilsKt.isUnsignedArray(type2)) {
            IrFunctionAccessExpression irFunctionAccessExpression;
            IrFunctionSymbol requiredSymbol = this.getArrayContentEqualsSymbol(type2);
            IrExpression lhs = this.transformArrayEqualsArgument(arg1, type2, irBuilder);
            IrExpression rhs = this.transformArrayEqualsArgument(arg2, type2, irBuilder);
            IrFunctionAccessExpression $this$generatedEquals_u24lambda_u2411 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)irBuilder, requiredSymbol);
            boolean bl = false;
            if (requiredSymbol.getOwner().getExtensionReceiverParameter() != null) {
                $this$generatedEquals_u24lambda_u2411.setExtensionReceiver(lhs);
                $this$generatedEquals_u24lambda_u2411.putValueArgument(0, rhs);
            } else {
                $this$generatedEquals_u24lambda_u2411.putValueArgument(0, lhs);
                $this$generatedEquals_u24lambda_u2411.putValueArgument(1, rhs);
            }
            irExpression = irFunctionAccessExpression;
        } else {
            irExpression = ExpressionHelpersKt.irEquals$default(irBuilder, arg1, arg2, null, 4, null);
        }
        return irExpression;
    }

    public boolean getForbidDirectFieldAccessInMethods() {
        return this.forbidDirectFieldAccessInMethods;
    }

    public void generateFunctionBodies(@NotNull IrClass annotationClass, @NotNull IrClass implClass, @NotNull IrSimpleFunction eqFun, @NotNull IrSimpleFunction hcFun, @NotNull IrSimpleFunction toStringFun, @NotNull AnnotationImplementationMemberGenerator generator2) {
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        Intrinsics.checkNotNullParameter((Object)eqFun, (String)"eqFun");
        Intrinsics.checkNotNullParameter((Object)hcFun, (String)"hcFun");
        Intrinsics.checkNotNullParameter((Object)toStringFun, (String)"toStringFun");
        Intrinsics.checkNotNullParameter((Object)generator2, (String)"generator");
        List<IrProperty> properties2 = this.getAnnotationProperties(annotationClass);
        generator2.generateEqualsUsingGetters(eqFun, IrUtilsKt.getDefaultType(annotationClass), properties2);
        generator2.generateHashCodeMethod(hcFun, properties2);
        generator2.generateToStringMethod(toStringFun, properties2);
    }

    public final void implementGeneratedFunctions(@NotNull IrClass annotationClass, @NotNull IrClass implClass) {
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        MethodsFromAnyGeneratorForLowerings creator = new MethodsFromAnyGeneratorForLowerings(this.context, implClass, AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION());
        IrSimpleFunction eqFun = creator.createEqualsMethodDeclaration();
        IrSimpleFunction hcFun = creator.createHashCodeMethodDeclaration();
        IrSimpleFunction toStringFun = creator.createToStringMethodDeclaration();
        if (!Intrinsics.areEqual((Object)annotationClass, (Object)implClass)) {
            IrUtilsKt.addFakeOverrides$default(implClass, this.context.getTypeSystem(), null, null, 6, null);
        }
        StringBuilder stringBuilder2 = new StringBuilder().append('@');
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(annotationClass);
        Intrinsics.checkNotNull((Object)fqName2);
        AnnotationImplementationMemberGenerator generator2 = new AnnotationImplementationMemberGenerator(this.context, implClass, stringBuilder2.append(fqName2.asString()).toString(), this.getForbidDirectFieldAccessInMethods(), (Function4<? super IrBlockBodyBuilder, ? super IrType, ? super IrExpression, ? super IrExpression, ? extends IrExpression>)((Function4)new Function4<IrBlockBodyBuilder, IrType, IrExpression, IrExpression, IrExpression>(this){
            final /* synthetic */ AnnotationImplementationTransformer this$0;
            {
                this.this$0 = $receiver;
                super(4);
            }

            @NotNull
            public final IrExpression invoke(@NotNull IrBlockBodyBuilder $this$$receiver, @NotNull IrType type2, @NotNull IrExpression a, @NotNull IrExpression b) {
                Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                return this.this$0.generatedEquals($this$$receiver, type2, a, b);
            }
        }));
        this.generateFunctionBodies(annotationClass, implClass, eqFun, hcFun, toStringFun, generator2);
    }

    public void implementPlatformSpecificParts(@NotNull IrClass annotationClass, @NotNull IrClass implClass) {
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
    }
}

