/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.symbols.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.mpp.ConstructorSymbolMarker;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqNamesUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "Lorg/jetbrains/kotlin/mpp/ConstructorSymbolMarker;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/name/ClassId;)V", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "(Lorg/jetbrains/kotlin/name/CallableId;)V", "delegatedConstructorCallIsSuper", "", "getDelegatedConstructorCallIsSuper", "()Z", "delegatedConstructorCallIsThis", "getDelegatedConstructorCallIsThis", "isPrimary", "resolvedDelegatedConstructor", "getResolvedDelegatedConstructor", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "resolvedDelegatedConstructorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "getResolvedDelegatedConstructorCall", "()Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "tree"})
public final class FirConstructorSymbol
extends FirFunctionSymbol<FirConstructor>
implements ConstructorSymbolMarker {
    public FirConstructorSymbol(@NotNull CallableId callableId) {
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        super(callableId, null);
    }

    public FirConstructorSymbol(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        this(FqNamesUtilKt.callableIdForConstructor(classId));
    }

    public final boolean isPrimary() {
        return ((FirConstructor)this.getFir()).isPrimary();
    }

    @Nullable
    public final FirConstructorSymbol getResolvedDelegatedConstructor() {
        FirPureAbstractElement firPureAbstractElement = this.getResolvedDelegatedConstructorCall();
        return firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getCalleeReference()) != null ? FirReferenceUtilsKt.toResolvedConstructorSymbol$default((FirReference)firPureAbstractElement, false, 1, null) : null;
    }

    @Nullable
    public final FirDelegatedConstructorCall getResolvedDelegatedConstructorCall() {
        if (((FirConstructor)this.getFir()).getDelegatedConstructor() == null) {
            return null;
        }
        FirLazyDeclarationResolverKt.lazyResolveToPhase(this, FirResolvePhase.BODY_RESOLVE);
        return ((FirConstructor)this.getFir()).getDelegatedConstructor();
    }

    public final boolean getDelegatedConstructorCallIsThis() {
        FirDelegatedConstructorCall firDelegatedConstructorCall = ((FirConstructor)this.getFir()).getDelegatedConstructor();
        return firDelegatedConstructorCall != null ? firDelegatedConstructorCall.isThis() : false;
    }

    public final boolean getDelegatedConstructorCallIsSuper() {
        FirDelegatedConstructorCall firDelegatedConstructorCall = ((FirConstructor)this.getFir()).getDelegatedConstructor();
        return firDelegatedConstructorCall != null ? firDelegatedConstructorCall.isSuper() : false;
    }
}

