/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKindKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FakeOverrideTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeKindService;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeKindServiceKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0012\u0010\t\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u001a0\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0006\u001a\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u001a\u0016\u0010\u0015\u001a\u0004\u0018\u00010\b*\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0015\u001a\u0004\u0018\u00010\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0017\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0018\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0012H\u0002\u001a3\u0010\u001a\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0019\u001a\u00020\u00122\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00120\u001cH\u0082\b\u001a\u0012\u0010\u001d\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u001e\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u001f\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010 \u001a\u00020\u0012*\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010 \u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010!\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\"\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010#\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010$\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010%\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010&\u001a\u0004\u0018\u00010\b*\u00020'2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010(\u001a\u00020\u0002*\u00020)2\u0006\u0010*\u001a\u00020\u0002H\u0002\u001a\u0018\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006-"}, d2={"contextReceiversTypes", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "createFunctionTypeWithNewKind", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "kind", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "customFunctionTypeToSimpleFunctionType", "findBaseInvokeSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "findContributedInvokeSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "expectedFunctionType", "shouldCalculateReturnTypesOfFakeOverrides", "", "findSubtypeOfBasicFunctionType", "findSubtypeOfBasicFunctionTypeImpl", "functionTypeKind", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "isBasicFunctionType", "isFunctionOrKFunctionType", "errorOnNotFunctionType", "isFunctionTypeWithPredicate", "predicate", "Lkotlin/Function1;", "isNonReflectFunctionType", "isNotBasicFunctionType", "isReflectFunctionType", "isSomeFunctionType", "isSubtypeOfFunctionType", "isSuspendOrKSuspendFunctionType", "receiverType", "reflectFunctionTypeToNonReflectFunctionType", "returnType", "specialFunctionTypeKind", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "typeOrDefault", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "default", "valueParameterTypesIncludingReceiver", "valueParameterTypesWithoutReceivers", "providers"})
@SourceDebugExtension(value={"SMAP\nFunctionalTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionalTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FunctionalTypeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,290:1\n43#1,8:291\n43#1,8:299\n43#1,8:307\n43#1,8:315\n48#1,3:323\n48#1,3:326\n1747#2,3:329\n1549#2:334\n1620#2,3:335\n1747#2,3:338\n1549#2:342\n1620#2,3:343\n1549#2:346\n1620#2,3:347\n1549#2:350\n1620#2,3:351\n219#3:332\n219#3:341\n1#4:333\n*S KotlinDebug\n*F\n+ 1 FunctionalTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FunctionalTypeUtilsKt\n*L\n55#1:291,8\n60#1:299,8\n67#1:307,8\n72#1:315,8\n87#1:323,3\n138#1:326,3\n156#1:329,3\n162#1:334\n162#1:335,3\n163#1:338,3\n244#1:342\n244#1:343,3\n269#1:346\n269#1:347,3\n275#1:350\n275#1:351,3\n156#1:332\n163#1:341\n*E\n"})
public final class FunctionalTypeUtilsKt {
    @Nullable
    public static final FunctionTypeKind functionTypeKind(@NotNull ConeKotlinType $this$functionTypeKind, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$functionTypeKind, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!($this$functionTypeKind instanceof ConeClassLikeType)) {
            return null;
        }
        return FunctionalTypeUtilsKt.functionTypeKind(TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$functionTypeKind, session, null, 2, null).getLookupTag(), session);
    }

    private static final FunctionTypeKind functionTypeKind(ConeClassLikeLookupTag $this$functionTypeKind, FirSession session) {
        ClassId classId = $this$functionTypeKind.getClassId();
        FirFunctionTypeKindService firFunctionTypeKindService = FirFunctionTypeKindServiceKt.getFunctionTypeService(session);
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.packageFqName");
        String string2 = classId.getShortClassName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classId.shortClassName.asString()");
        return firFunctionTypeKindService.getKindByClassNamePrefix(fqName2, string2);
    }

    private static final boolean isFunctionTypeWithPredicate(ConeKotlinType $this$isFunctionTypeWithPredicate, FirSession session, boolean errorOnNotFunctionType, Function1<? super FunctionTypeKind, Boolean> predicate) {
        boolean $i$f$isFunctionTypeWithPredicate = false;
        FunctionTypeKind functionTypeKind = FunctionalTypeUtilsKt.functionTypeKind($this$isFunctionTypeWithPredicate, session);
        if (functionTypeKind == null) {
            if (errorOnNotFunctionType) {
                throw new IllegalStateException(($this$isFunctionTypeWithPredicate + " is not a function type").toString());
            }
            return false;
        }
        FunctionTypeKind kind = functionTypeKind;
        return (Boolean)predicate.invoke((Object)kind);
    }

    static /* synthetic */ boolean isFunctionTypeWithPredicate$default(ConeKotlinType $this$isFunctionTypeWithPredicate_u24default, FirSession session, boolean errorOnNotFunctionType, Function1 predicate, int n, Object object) {
        if ((n & 2) != 0) {
            errorOnNotFunctionType = false;
        }
        boolean $i$f$isFunctionTypeWithPredicate = false;
        FunctionTypeKind functionTypeKind = FunctionalTypeUtilsKt.functionTypeKind($this$isFunctionTypeWithPredicate_u24default, session);
        if (functionTypeKind == null) {
            if (errorOnNotFunctionType) {
                throw new IllegalStateException(($this$isFunctionTypeWithPredicate_u24default + " is not a function type").toString());
            }
            return false;
        }
        FunctionTypeKind kind = functionTypeKind;
        return (Boolean)predicate.invoke((Object)kind);
    }

    public static final boolean isBasicFunctionType(@NotNull ConeKotlinType $this$isBasicFunctionType, @NotNull FirSession session) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isBasicFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ConeKotlinType $this$isFunctionTypeWithPredicate_u24default$iv = $this$isBasicFunctionType;
        boolean errorOnNotFunctionType$iv = false;
        boolean $i$f$isFunctionTypeWithPredicate = false;
        FunctionTypeKind functionTypeKind = FunctionalTypeUtilsKt.functionTypeKind($this$isFunctionTypeWithPredicate_u24default$iv, session);
        if (functionTypeKind == null) {
            bl = false;
        } else {
            FunctionTypeKind kind$iv;
            FunctionTypeKind it = kind$iv = functionTypeKind;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it, (Object)FunctionTypeKind.Function.INSTANCE);
        }
        return bl;
    }

    public static final boolean isSuspendOrKSuspendFunctionType(@NotNull ConeKotlinType $this$isSuspendOrKSuspendFunctionType, @NotNull FirSession session) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendOrKSuspendFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ConeKotlinType $this$isFunctionTypeWithPredicate_u24default$iv = $this$isSuspendOrKSuspendFunctionType;
        boolean errorOnNotFunctionType$iv = false;
        boolean $i$f$isFunctionTypeWithPredicate = false;
        FunctionTypeKind functionTypeKind = FunctionalTypeUtilsKt.functionTypeKind($this$isFunctionTypeWithPredicate_u24default$iv, session);
        if (functionTypeKind == null) {
            bl = false;
        } else {
            FunctionTypeKind kind$iv;
            FunctionTypeKind it = kind$iv = functionTypeKind;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it, (Object)FunctionTypeKind.SuspendFunction.INSTANCE) || Intrinsics.areEqual((Object)it, (Object)FunctionTypeKind.KSuspendFunction.INSTANCE);
        }
        return bl;
    }

    public static final boolean isReflectFunctionType(@NotNull ConeKotlinType $this$isReflectFunctionType, @NotNull FirSession session) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isReflectFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ConeKotlinType $this$isFunctionTypeWithPredicate_u24default$iv = $this$isReflectFunctionType;
        boolean errorOnNotFunctionType$iv = false;
        boolean $i$f$isFunctionTypeWithPredicate = false;
        FunctionTypeKind functionTypeKind = FunctionalTypeUtilsKt.functionTypeKind($this$isFunctionTypeWithPredicate_u24default$iv, session);
        if (functionTypeKind == null) {
            bl = false;
        } else {
            FunctionTypeKind kind$iv;
            FunctionTypeKind it = kind$iv = functionTypeKind;
            boolean bl2 = false;
            bl = it.isReflectType();
        }
        return bl;
    }

    public static final boolean isNonReflectFunctionType(@NotNull ConeKotlinType $this$isNonReflectFunctionType, @NotNull FirSession session) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isNonReflectFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ConeKotlinType $this$isFunctionTypeWithPredicate_u24default$iv = $this$isNonReflectFunctionType;
        boolean errorOnNotFunctionType$iv = false;
        boolean $i$f$isFunctionTypeWithPredicate = false;
        FunctionTypeKind functionTypeKind = FunctionalTypeUtilsKt.functionTypeKind($this$isFunctionTypeWithPredicate_u24default$iv, session);
        if (functionTypeKind == null) {
            bl = false;
        } else {
            FunctionTypeKind kind$iv;
            FunctionTypeKind it = kind$iv = functionTypeKind;
            boolean bl2 = false;
            bl = !it.isReflectType();
        }
        return bl;
    }

    public static final boolean isSomeFunctionType(@NotNull ConeKotlinType $this$isSomeFunctionType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$isSomeFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return FunctionalTypeUtilsKt.functionTypeKind($this$isSomeFunctionType, session) != null;
    }

    public static final boolean isSomeFunctionType(@NotNull ConeClassLikeLookupTag $this$isSomeFunctionType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$isSomeFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return FunctionalTypeUtilsKt.functionTypeKind($this$isSomeFunctionType, session) != null;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isNotBasicFunctionType(@NotNull ConeKotlinType $this$isNotBasicFunctionType, @NotNull FirSession session) {
        boolean bl;
        void $this$isFunctionTypeWithPredicate$iv;
        Intrinsics.checkNotNullParameter((Object)$this$isNotBasicFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ConeKotlinType coneKotlinType = $this$isNotBasicFunctionType;
        boolean errorOnNotFunctionType$iv = false;
        boolean $i$f$isFunctionTypeWithPredicate = false;
        FunctionTypeKind functionTypeKind = FunctionalTypeUtilsKt.functionTypeKind((ConeKotlinType)$this$isFunctionTypeWithPredicate$iv, session);
        if (functionTypeKind == null) {
            bl = false;
        } else {
            FunctionTypeKind kind$iv;
            FunctionTypeKind it = kind$iv = functionTypeKind;
            boolean bl2 = false;
            bl = !FunctionTypeKindKt.isBasicFunctionOrKFunction(it);
        }
        return bl;
    }

    @NotNull
    public static final ConeClassLikeType customFunctionTypeToSimpleFunctionType(@NotNull ConeKotlinType $this$customFunctionTypeToSimpleFunctionType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$customFunctionTypeToSimpleFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        FunctionTypeKind kind = FunctionalTypeUtilsKt.functionTypeKind($this$customFunctionTypeToSimpleFunctionType, session);
        if (!(kind != null && !Intrinsics.areEqual((Object)kind, (Object)FunctionTypeKind.Function.INSTANCE) && !Intrinsics.areEqual((Object)kind, (Object)FunctionTypeKind.KFunction.INSTANCE))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        FunctionTypeKind newKind = kind.isReflectType() ? (FunctionTypeKind)FunctionTypeKind.KFunction.INSTANCE : (FunctionTypeKind)FunctionTypeKind.Function.INSTANCE;
        return FunctionalTypeUtilsKt.createFunctionTypeWithNewKind($this$customFunctionTypeToSimpleFunctionType, session, newKind);
    }

    @NotNull
    public static final ConeClassLikeType reflectFunctionTypeToNonReflectFunctionType(@NotNull ConeKotlinType $this$reflectFunctionTypeToNonReflectFunctionType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$reflectFunctionTypeToNonReflectFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        FunctionTypeKind kind = FunctionalTypeUtilsKt.functionTypeKind($this$reflectFunctionTypeToNonReflectFunctionType, session);
        if (!(kind != null && kind.isReflectType())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return FunctionalTypeUtilsKt.createFunctionTypeWithNewKind($this$reflectFunctionTypeToNonReflectFunctionType, session, kind.nonReflectKind());
    }

    private static final ConeClassLikeType createFunctionTypeWithNewKind(ConeKotlinType $this$createFunctionTypeWithNewKind, FirSession session, FunctionTypeKind kind) {
        ConeKotlinType expandedType2 = TypeExpansionUtilsKt.fullyExpandedType($this$createFunctionTypeWithNewKind, session);
        ClassId functionTypeId = new ClassId(kind.getPackageFqName(), kind.numberedClassName(expandedType2.getTypeArguments().length - 1));
        return TypeConstructionUtilsKt.constructClassType(TypeConstructionUtilsKt.toLookupTag(functionTypeId), expandedType2.getTypeArguments(), false, expandedType2.getAttributes());
    }

    @Nullable
    public static final ConeKotlinType findSubtypeOfBasicFunctionType(@NotNull ConeKotlinType $this$findSubtypeOfBasicFunctionType, @NotNull FirSession session, @NotNull ConeClassLikeType expectedFunctionType) {
        Intrinsics.checkNotNullParameter((Object)$this$findSubtypeOfBasicFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)expectedFunctionType, (String)"expectedFunctionType");
        if (!FunctionalTypeUtilsKt.isFunctionOrKFunctionType(expectedFunctionType, session, true)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return FunctionalTypeUtilsKt.findSubtypeOfBasicFunctionTypeImpl($this$findSubtypeOfBasicFunctionType, session, expectedFunctionType);
    }

    private static final boolean isFunctionOrKFunctionType(ConeKotlinType $this$isFunctionOrKFunctionType, FirSession session, boolean errorOnNotFunctionType) {
        boolean bl;
        ConeKotlinType $this$isFunctionTypeWithPredicate$iv = $this$isFunctionOrKFunctionType;
        boolean $i$f$isFunctionTypeWithPredicate = false;
        FunctionTypeKind functionTypeKind = FunctionalTypeUtilsKt.functionTypeKind($this$isFunctionTypeWithPredicate$iv, session);
        if (functionTypeKind == null) {
            if (errorOnNotFunctionType) {
                throw new IllegalStateException(($this$isFunctionTypeWithPredicate$iv + " is not a function type").toString());
            }
            bl = false;
        } else {
            FunctionTypeKind kind$iv;
            FunctionTypeKind it = kind$iv = functionTypeKind;
            boolean bl2 = false;
            bl = FunctionTypeKindKt.isBasicFunctionOrKFunction(it);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final ConeKotlinType findSubtypeOfBasicFunctionTypeImpl(ConeKotlinType $this$findSubtypeOfBasicFunctionTypeImpl, FirSession session, ConeClassLikeType expectedFunctionType) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType coneKotlinType2 = $this$findSubtypeOfBasicFunctionTypeImpl;
        if (coneKotlinType2 instanceof ConeClassLikeType) {
            coneKotlinType = FunctionalTypeUtilsKt.isNotBasicFunctionType($this$findSubtypeOfBasicFunctionTypeImpl, session) ? null : (FunctionalTypeUtilsKt.isSubtypeOfFunctionType($this$findSubtypeOfBasicFunctionTypeImpl, session, expectedFunctionType) ? (ConeClassLikeType)$this$findSubtypeOfBasicFunctionTypeImpl : null);
        } else if (coneKotlinType2 instanceof ConeIntersectionType) {
            void condition$iv;
            Object it;
            boolean bl;
            block19: {
                Iterable $this$any$iv = ((ConeIntersectionType)$this$findSubtypeOfBasicFunctionTypeImpl).getIntersectedTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (ConeKotlinType)element$iv;
                        boolean bl2 = false;
                        if (!FunctionalTypeUtilsKt.isNotBasicFunctionType((ConeKotlinType)it, session)) continue;
                        bl = true;
                        break block19;
                    }
                    bl = false;
                }
            }
            boolean $this$any$iv = bl;
            boolean $i$f$runUnless = false;
            if (condition$iv != false) {
                coneKotlinType = null;
            } else {
                Object v2;
                block20: {
                    Object element$iv;
                    boolean bl3 = false;
                    element$iv = ((ConeIntersectionType)$this$findSubtypeOfBasicFunctionTypeImpl).getIntersectedTypes();
                    it = element$iv.iterator();
                    while (it.hasNext()) {
                        Object bl2 = it.next();
                        ConeKotlinType it2 = (ConeKotlinType)bl2;
                        boolean bl4 = false;
                        if (!(FunctionalTypeUtilsKt.findSubtypeOfBasicFunctionTypeImpl(it2, session, expectedFunctionType) != null)) continue;
                        v2 = bl2;
                        break block20;
                    }
                    v2 = null;
                }
                coneKotlinType = v2;
            }
        } else if (coneKotlinType2 instanceof ConeTypeParameterType) {
            void condition$iv;
            boolean bl;
            List bounds;
            block21: {
                Iterator $this$mapTo$iv$iv;
                Iterable $this$map$iv = ((ConeTypeParameterType)$this$findSubtypeOfBasicFunctionTypeImpl).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
                boolean $i$f$map = false;
                Iterable element$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator it2 = $this$mapTo$iv$iv.iterator();
                while (it2.hasNext()) {
                    void it;
                    Object item$iv$iv = it2.next();
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl5 = false;
                    collection.add(FirTypeUtilsKt.getConeType((FirTypeRef)it));
                }
                bounds = (List)destination$iv$iv;
                Iterable $this$any$iv = bounds;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv2;
                        boolean bl6 = false;
                        if (!FunctionalTypeUtilsKt.isNotBasicFunctionType(it, session)) continue;
                        bl = true;
                        break block21;
                    }
                    bl = false;
                }
            }
            boolean $this$any$iv = bl;
            boolean $i$f$runUnless = false;
            if (condition$iv != false) {
                coneKotlinType = null;
            } else {
                Object v4;
                block22: {
                    boolean bl7 = false;
                    Iterable iterable = bounds;
                    for (Object t : iterable) {
                        ConeKotlinType it = (ConeKotlinType)t;
                        boolean bl8 = false;
                        if (!(FunctionalTypeUtilsKt.findSubtypeOfBasicFunctionTypeImpl(it, session, expectedFunctionType) != null)) continue;
                        v4 = t;
                        break block22;
                    }
                    v4 = null;
                }
                coneKotlinType = v4;
            }
        } else {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    private static final boolean isSubtypeOfFunctionType(ConeKotlinType $this$isSubtypeOfFunctionType, FirSession session, ConeClassLikeType expectedFunctionType) {
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(session), (KotlinTypeMarker)$this$isSubtypeOfFunctionType, (KotlinTypeMarker)ConeTypeUtilsKt.replaceArgumentsWithStarProjections(expectedFunctionType), false, 8, null);
    }

    @Nullable
    public static final FirNamedFunctionSymbol findBaseInvokeSymbol(@NotNull ConeClassLikeType $this$findBaseInvokeSymbol, @NotNull FirSession session, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)$this$findBaseInvokeSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        if (!FunctionalTypeUtilsKt.isSomeFunctionType($this$findBaseInvokeSymbol, session)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol($this$findBaseInvokeSymbol.getLookupTag(), session);
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        FirClass firClass = firClassLikeDeclaration instanceof FirClass ? (FirClass)firClassLikeDeclaration : null;
        if (firClass == null) {
            return null;
        }
        FirClass functionN2 = firClass;
        Ref.ObjectRef baseInvokeSymbol = new Ref.ObjectRef();
        FirKotlinScopeProviderKt.unsubstitutedScope(functionN2, session, scopeSession, false, null).processFunctionsByName(OperatorNameConventions.INVOKE, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>((Ref.ObjectRef<FirNamedFunctionSymbol>)baseInvokeSymbol){
            final /* synthetic */ Ref.ObjectRef<FirNamedFunctionSymbol> $baseInvokeSymbol;
            {
                this.$baseInvokeSymbol = $baseInvokeSymbol;
                super(1);
            }

            public final void invoke(@NotNull FirNamedFunctionSymbol functionSymbol) {
                Intrinsics.checkNotNullParameter((Object)functionSymbol, (String)"functionSymbol");
                this.$baseInvokeSymbol.element = functionSymbol;
            }
        }));
        return (FirNamedFunctionSymbol)baseInvokeSymbol.element;
    }

    @Nullable
    public static final FirFunctionSymbol<?> findContributedInvokeSymbol(@NotNull ConeKotlinType $this$findContributedInvokeSymbol, @NotNull FirSession session, @NotNull ScopeSession scopeSession, @NotNull ConeClassLikeType expectedFunctionType, boolean shouldCalculateReturnTypesOfFakeOverrides) {
        Intrinsics.checkNotNullParameter((Object)$this$findContributedInvokeSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)expectedFunctionType, (String)"expectedFunctionType");
        FirNamedFunctionSymbol firNamedFunctionSymbol = FunctionalTypeUtilsKt.findBaseInvokeSymbol(expectedFunctionType, session, scopeSession);
        if (firNamedFunctionSymbol == null) {
            return null;
        }
        FirNamedFunctionSymbol baseInvokeSymbol = firNamedFunctionSymbol;
        FakeOverrideTypeCalculator fakeOverrideTypeCalculator = shouldCalculateReturnTypesOfFakeOverrides ? (FakeOverrideTypeCalculator)FakeOverrideTypeCalculator.Forced.INSTANCE : (FakeOverrideTypeCalculator)FakeOverrideTypeCalculator.DoNothing.INSTANCE;
        FirTypeScope firTypeScope = ScopeUtilsKt.scope($this$findContributedInvokeSymbol, session, scopeSession, fakeOverrideTypeCalculator, FirResolvePhase.STATUS);
        if (firTypeScope == null) {
            return null;
        }
        FirTypeScope scope2 = firTypeScope;
        Ref.ObjectRef declaredInvoke = new Ref.ObjectRef();
        scope2.processFunctionsByName(OperatorNameConventions.INVOKE, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(baseInvokeSymbol, (Ref.ObjectRef<FirNamedFunctionSymbol>)declaredInvoke){
            final /* synthetic */ FirNamedFunctionSymbol $baseInvokeSymbol;
            final /* synthetic */ Ref.ObjectRef<FirNamedFunctionSymbol> $declaredInvoke;
            {
                this.$baseInvokeSymbol = $baseInvokeSymbol;
                this.$declaredInvoke = $declaredInvoke;
                super(1);
            }

            public final void invoke(@NotNull FirNamedFunctionSymbol functionSymbol) {
                Intrinsics.checkNotNullParameter((Object)functionSymbol, (String)"functionSymbol");
                if (((FirSimpleFunction)functionSymbol.getFir()).getValueParameters().size() == ((FirSimpleFunction)this.$baseInvokeSymbol.getFir()).getValueParameters().size()) {
                    this.$declaredInvoke.element = functionSymbol;
                    return;
                }
            }
        }));
        Ref.ObjectRef overriddenInvoke = new Ref.ObjectRef();
        if (declaredInvoke.element != null) {
            Object object = declaredInvoke.element;
            Intrinsics.checkNotNull((Object)object);
            FirTypeScopeKt.processOverriddenFunctions(scope2, (FirNamedFunctionSymbol)object, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)new Function1<FirNamedFunctionSymbol, ProcessorAction>(baseInvokeSymbol, overriddenInvoke){
                final /* synthetic */ FirNamedFunctionSymbol $baseInvokeSymbol;
                final /* synthetic */ Ref.ObjectRef<FirFunctionSymbol<?>> $overriddenInvoke;
                {
                    this.$baseInvokeSymbol = $baseInvokeSymbol;
                    this.$overriddenInvoke = $overriddenInvoke;
                    super(1);
                }

                /*
                 * Unable to fully structure code
                 */
                @NotNull
                public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol functionSymbol) {
                    Intrinsics.checkNotNullParameter((Object)functionSymbol, (String)"functionSymbol");
                    if (Intrinsics.areEqual((Object)functionSymbol, (Object)this.$baseInvokeSymbol)) ** GOTO lbl-1000
                    $this$originalForSubstitutionOverride$iv = functionSymbol;
                    $i$f$getOriginalForSubstitutionOverride = false;
                    $this$originalForSubstitutionOverride$iv$iv = (FirCallableDeclaration)$this$originalForSubstitutionOverride$iv.getFir();
                    $i$f$getOriginalForSubstitutionOverride = false;
                    if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv)) ** GOTO lbl-1000
                    $this$isSynthetic$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv;
                    $i$f$isSynthetic = false;
                    if (Intrinsics.areEqual((Object)$this$isSynthetic$iv$iv$iv.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.INSTANCE)) lbl-1000:
                    // 2 sources

                    {
                        v0 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv);
                    } else {
                        v0 = null;
                    }
                    if (Intrinsics.areEqual((Object)((FirNamedFunctionSymbol)(v0 != null ? v0.getSymbol() : null)), (Object)this.$baseInvokeSymbol)) lbl-1000:
                    // 2 sources

                    {
                        this.$overriddenInvoke.element = functionSymbol;
                        v1 = ProcessorAction.STOP;
                    } else {
                        v1 = ProcessorAction.NEXT;
                    }
                    return v1;
                }
            }));
        }
        return overriddenInvoke.element != null ? (FirFunctionSymbol)declaredInvoke.element : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ConeKotlinType> contextReceiversTypes(@NotNull ConeKotlinType $this$contextReceiversTypes, @NotNull FirSession session) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$contextReceiversTypes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!FunctionalTypeUtilsKt.isSomeFunctionType($this$contextReceiversTypes, session)) {
            return CollectionsKt.emptyList();
        }
        ConeKotlinType expanded = TypeExpansionUtilsKt.fullyExpandedType($this$contextReceiversTypes, session);
        boolean bl = false;
        List contextReceivers = ArraysKt.take((Object[])expanded.getTypeArguments(), (int)CompilerConeAttributesKt.getContextReceiversNumberForFunctionType(expanded));
        Iterable $this$map$iv = contextReceivers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConeTypeProjection coneTypeProjection = (ConeTypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(FunctionalTypeUtilsKt.typeOrDefault((ConeTypeProjection)it, session.getBuiltinTypes().getNothingType().getType()));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final ConeKotlinType receiverType(@NotNull ConeKotlinType $this$receiverType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$receiverType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!FunctionalTypeUtilsKt.isSomeFunctionType($this$receiverType, session) || !TypeUtilsKt.isExtensionFunctionType($this$receiverType, session)) {
            return null;
        }
        ConeKotlinType expanded = TypeExpansionUtilsKt.fullyExpandedType($this$receiverType, session);
        boolean bl = false;
        return FunctionalTypeUtilsKt.typeOrDefault(expanded.getTypeArguments()[CompilerConeAttributesKt.getContextReceiversNumberForFunctionType(expanded)], session.getBuiltinTypes().getNothingType().getType());
    }

    @NotNull
    public static final ConeKotlinType returnType(@NotNull ConeKotlinType $this$returnType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$returnType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!($this$returnType instanceof ConeClassLikeType)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return FunctionalTypeUtilsKt.typeOrDefault((ConeTypeProjection)ArraysKt.last((Object[])TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$returnType, session, null, 2, null).getTypeArguments()), session.getBuiltinTypes().getNullableAnyType().getType());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ConeKotlinType> valueParameterTypesWithoutReceivers(@NotNull ConeKotlinType $this$valueParameterTypesWithoutReceivers, @NotNull FirSession session) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$valueParameterTypesWithoutReceivers, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!($this$valueParameterTypesWithoutReceivers instanceof ConeClassLikeType)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        ConeClassLikeType expandedType2 = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$valueParameterTypesWithoutReceivers, session, null, 2, null);
        int receiversNumber = CompilerConeAttributesKt.getContextReceiversNumberForFunctionType(expandedType2) + (CompilerConeAttributesKt.isExtensionFunctionType(expandedType2) ? 1 : 0);
        List valueParameters2 = CollectionsKt.dropLast((List)ArraysKt.drop((Object[])expandedType2.getTypeArguments(), (int)receiversNumber), (int)1);
        Iterable $this$map$iv = valueParameters2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConeTypeProjection coneTypeProjection = (ConeTypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FunctionalTypeUtilsKt.typeOrDefault((ConeTypeProjection)it, session.getBuiltinTypes().getNothingType().getType()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ConeKotlinType> valueParameterTypesIncludingReceiver(@NotNull ConeKotlinType $this$valueParameterTypesIncludingReceiver, @NotNull FirSession session) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$valueParameterTypesIncludingReceiver, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!($this$valueParameterTypesIncludingReceiver instanceof ConeClassLikeType)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Iterable $this$map$iv = ArraysKt.dropLast((Object[])TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$valueParameterTypesIncludingReceiver, session, null, 2, null).getTypeArguments(), (int)1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConeTypeProjection coneTypeProjection = (ConeTypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FunctionalTypeUtilsKt.typeOrDefault((ConeTypeProjection)it, session.getBuiltinTypes().getNothingType().getType()));
        }
        return (List)destination$iv$iv;
    }

    private static final ConeKotlinType typeOrDefault(ConeTypeProjection $this$typeOrDefault, ConeKotlinType coneKotlinType) {
        ConeKotlinType coneKotlinType2;
        ConeTypeProjection coneTypeProjection = $this$typeOrDefault;
        if (coneTypeProjection instanceof ConeKotlinTypeProjection) {
            coneKotlinType2 = ((ConeKotlinTypeProjection)$this$typeOrDefault).getType();
        } else if (coneTypeProjection instanceof ConeStarProjection) {
            coneKotlinType2 = coneKotlinType;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType2;
    }

    @Nullable
    public static final FunctionTypeKind specialFunctionTypeKind(@NotNull FirFunction $this$specialFunctionTypeKind, @NotNull FirSession session) {
        FunctionTypeKind functionTypeKind;
        Intrinsics.checkNotNullParameter((Object)$this$specialFunctionTypeKind, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        FirFunctionSymbol<? extends FirFunction> firFunctionSymbol = $this$specialFunctionTypeKind.getSymbol();
        FirNamedFunctionSymbol firNamedFunctionSymbol = firFunctionSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firFunctionSymbol : null;
        if (firNamedFunctionSymbol != null) {
            FirNamedFunctionSymbol it = firNamedFunctionSymbol;
            boolean bl = false;
            functionTypeKind = FirFunctionTypeKindServiceKt.getFunctionTypeService(session).extractSingleSpecialKindForFunction(it);
        } else {
            functionTypeKind = null;
        }
        return functionTypeKind;
    }
}

