/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.mangle.BaseKotlinMangleComputer;
import org.jetbrains.kotlin.backend.common.serialization.mangle.MangleConstant;
import org.jetbrains.kotlin.backend.common.serialization.mangle.MangleMode;
import org.jetbrains.kotlin.backend.common.serialization.mangle.MangleUtilsKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticPropertyAccessor;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.signaturer.FirManglerUtilKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeRawType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\b\u0016\u0018\u00002,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0001:\u00010B\u0019\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0004H\u0014J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0006H\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0004H\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\bH\u0014J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0005H\u0014J\u0010\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0005H\u0014J$\u0010#\u001a\u00020$2\n\u0010%\u001a\u00060\nj\u0002`\u000b2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\bH\u0014J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u0002H\u0014J$\u0010*\u001a\u00020$*\u00020\u00072\u0006\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u0002H\u0002J$\u0010-\u001a\u00020$*\u00020\u00072\u0006\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u0002H\u0002J\f\u0010.\u001a\u00020$*\u00020\u0002H\u0014J\f\u0010/\u001a\u00020$*\u00020\u0002H\u0014R\u0018\u0010\u000f\u001a\u00060\u0010R\u00020\u0000X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/fir/backend/FirMangleComputer;", "Lorg/jetbrains/kotlin/backend/common/serialization/mangle/BaseKotlinMangleComputer;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/symbols/ConeTypeParameterLookupTag;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/FirSession;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "mode", "Lorg/jetbrains/kotlin/backend/common/serialization/mangle/MangleMode;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/backend/common/serialization/mangle/MangleMode;)V", "visitor", "Lorg/jetbrains/kotlin/fir/backend/FirMangleComputer$Visitor;", "getVisitor", "()Lorg/jetbrains/kotlin/fir/backend/FirMangleComputer$Visitor;", "copy", "newMode", "getEffectiveParent", "typeParameter", "getIndexOfTypeParameter", "", "container", "getTypeParameterName", "", "getTypeSystemContext", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "session", "getValueParameterType", "valueParameter", "isVararg", "", "mangleType", "", "tBuilder", "type", "declarationSiteSession", "renderDeclaration", "declaration", "mangleFunction", "isCtor", "isStatic", "mangleSignature", "visit", "visitParent", "Visitor", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFirMangleComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMangleComputer.kt\norg/jetbrains/kotlin/fir/backend/FirMangleComputer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,297:1\n1#2:298\n34#3:299\n1855#4,2:300\n*S KotlinDebug\n*F\n+ 1 FirMangleComputer.kt\norg/jetbrains/kotlin/fir/backend/FirMangleComputer\n*L\n81#1:299\n120#1:300,2\n*E\n"})
public class FirMangleComputer
extends BaseKotlinMangleComputer<FirDeclaration, ConeKotlinType, ConeTypeParameterLookupTag, FirValueParameter, FirMemberDeclaration, FirFunction, FirSession> {
    @NotNull
    private final Visitor visitor;

    public FirMangleComputer(@NotNull StringBuilder builder2, @NotNull MangleMode mode) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        super(builder2, mode, false, 4, null);
        this.visitor = new Visitor();
    }

    @NotNull
    protected Visitor getVisitor() {
        return this.visitor;
    }

    @NotNull
    public FirMangleComputer copy(@NotNull MangleMode newMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)newMode), (String)"newMode");
        return new FirMangleComputer(this.getBuilder(), newMode);
    }

    @NotNull
    protected ConeInferenceContext getTypeSystemContext(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new ConeInferenceContext(session){
            final /* synthetic */ FirSession $session;
            {
                this.$session = $session;
            }

            @NotNull
            public FirSession getSession() {
                return this.$session;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void visitParent(@NotNull FirDeclaration $this$visitParent) {
        Pair pair;
        Object it;
        Intrinsics.checkNotNullParameter((Object)$this$visitParent, (String)"<this>");
        FirDeclaration firDeclaration = $this$visitParent;
        if (firDeclaration instanceof FirCallableDeclaration) {
            it = ((FirCallableDeclaration)$this$visitParent).getSymbol().getCallableId().getPackageName();
            boolean bl = false;
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag((FirCallableDeclaration)$this$visitParent);
            pair = TuplesKt.to((Object)it, (Object)(coneClassLikeLookupTag != null ? coneClassLikeLookupTag.getClassId() : null));
        } else {
            if (!(firDeclaration instanceof FirClassLikeDeclaration)) return;
            it = ((FirClassLikeDeclaration)$this$visitParent).getSymbol().getClassId();
            boolean bl = false;
            pair = TuplesKt.to((Object)((ClassId)it).getPackageFqName(), (Object)((ClassId)it).getOuterClassId());
        }
        Pair pair2 = pair;
        FqName parentPackageFqName = (FqName)pair2.component1();
        ClassId parentClassId = (ClassId)pair2.component2();
        if (parentClassId != null && !parentClassId.isLocal()) {
            FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider($this$visitParent.getModuleData().getSession()).getClassLikeSymbolByClassId(parentClassId);
            if (firClassLikeSymbol == null || (firClassLikeSymbol = (FirClassLikeDeclaration)firClassLikeSymbol.getFir()) == null) {
                throw new IllegalStateException(("Attempt to find parent (" + parentClassId + ") for probably-local declaration!").toString());
            }
            FirClassLikeSymbol<?> parentClassLike = firClassLikeSymbol;
            if (!(parentClassLike instanceof FirRegularClass) && !(parentClassLike instanceof FirTypeAlias)) throw new IllegalStateException(("Strange class-like declaration: " + UtilsKt.render((FirElement)((Object)parentClassLike))).toString());
            this.visit((FirDeclaration)((Object)parentClassLike));
            return;
        } else {
            if (parentClassId != null || parentPackageFqName.isRoot()) return;
            StringBuilder stringBuilder2 = this.getBuilder();
            String string2 = parentPackageFqName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parentPackageFqName.asString()");
            this.appendName(stringBuilder2, string2);
        }
    }

    @Override
    protected void visit(@NotNull FirDeclaration $this$visit) {
        Intrinsics.checkNotNullParameter((Object)$this$visit, (String)"<this>");
        $this$visit.accept(this.getVisitor(), null);
    }

    /*
     * Unable to fully structure code
     */
    private final void mangleFunction(FirFunction $this$mangleFunction, boolean isCtor, boolean isStatic, FirDeclaration container) {
        if (this.isRealExpect()) ** GOTO lbl-1000
        v0 = $this$mangleFunction instanceof FirMemberDeclaration != false ? (FirMemberDeclaration)$this$mangleFunction : null;
        if (v0 != null) {
            $this$isExpect$iv = v0;
            $i$f$isExpect = false;
            v1 = $this$isExpect$iv.getStatus().isExpect();
        } else {
            v1 = false;
        }
        if (v1) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        this.setRealExpect(v2);
        if (container instanceof FirMemberDeclaration) {
            this.getTypeParameterContainers().add(container);
        }
        this.visitParent($this$mangleFunction);
        this.appendName(this.getBuilder(), '#');
        var5_8 = this.platformSpecificFunctionName($this$mangleFunction);
        if (var5_8 != null) {
            it = var5_8;
            $i$a$-let-FirMangleComputer$mangleFunction$1 = false;
            this.getBuilder().append(it);
            return;
        }
        name = FirManglerUtilKt.getIrName($this$mangleFunction);
        this.getBuilder().append(name.asString());
        v3 = this.platformSpecificSuffix($this$mangleFunction);
        if (v3 != null) {
            it = v3;
            $i$a$-let-FirMangleComputer$mangleFunction$2 = false;
            this.getBuilder().append('%');
            this.getBuilder().append(it);
        }
        this.mangleSignature($this$mangleFunction, isCtor, isStatic, container);
    }

    private final void mangleSignature(FirFunction $this$mangleSignature, boolean isCtor, boolean isStatic, FirDeclaration container) {
        List list2;
        FirPureAbstractElement receiverType;
        if (!this.getMode().getSignature()) {
            return;
        }
        if (isStatic) {
            this.appendSignature(this.getBuilder(), "#static");
        }
        List<FirContextReceiver> contextReceivers = $this$mangleSignature instanceof FirPropertyAccessor ? ((FirProperty)((FirPropertyAccessor)$this$mangleSignature).getPropertySymbol().getFir()).getContextReceivers() : $this$mangleSignature.getContextReceivers();
        Iterable $this$forEach$iv = contextReceivers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirContextReceiver it = (FirContextReceiver)element$iv;
            boolean bl = false;
            this.appendSignature(this.getBuilder(), '!');
            this.mangleType(this.getBuilder(), FirTypeUtilsKt.getConeType(it.getTypeRef()), $this$mangleSignature.getModuleData().getSession());
        }
        FirPureAbstractElement firPureAbstractElement = $this$mangleSignature.getReceiverParameter();
        if (firPureAbstractElement == null || (firPureAbstractElement = firPureAbstractElement.getTypeRef()) == null) {
            Object object = $this$mangleSignature instanceof FirPropertyAccessor ? (FirPropertyAccessor)$this$mangleSignature : null;
            firPureAbstractElement = object != null && (object = ((FirPropertyAccessor)object).getPropertySymbol()) != null && (object = (FirProperty)((FirBasedSymbol)object).getFir()) != null && (object = ((FirProperty)object).getReceiverParameter()) != null ? ((FirReceiverParameter)object).getTypeRef() : null;
        }
        FirPureAbstractElement firPureAbstractElement2 = receiverType = firPureAbstractElement;
        if (firPureAbstractElement2 != null) {
            FirPureAbstractElement it = firPureAbstractElement2;
            boolean bl = false;
            this.appendSignature(this.getBuilder(), '@');
            this.mangleType(this.getBuilder(), FirTypeUtilsKt.getConeType((FirTypeRef)it), $this$mangleSignature.getModuleData().getSession());
        }
        MangleUtilsKt.collectForMangler((Iterable)$this$mangleSignature.getValueParameters(), this.getBuilder(), MangleConstant.VALUE_PARAMETERS, (Function2)new Function2<StringBuilder, FirValueParameter, Unit>(this, $this$mangleSignature){
            final /* synthetic */ FirMangleComputer this$0;
            final /* synthetic */ FirFunction $this_mangleSignature;
            {
                this.this$0 = $receiver;
                this.$this_mangleSignature = $receiver2;
                super(2);
            }

            public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull FirValueParameter it) {
                Intrinsics.checkNotNullParameter((Object)$this$collectForMangler, (String)"$this$collectForMangler");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FirMangleComputer.access$appendSignature(this.this$0, $this$collectForMangler, FirMangleComputer.access$specialValueParamPrefix(this.this$0, this.$this_mangleSignature, it));
                FirMangleComputer.access$mangleValueParameter(this.this$0, $this$collectForMangler, it, this.$this_mangleSignature.getModuleData().getSession());
            }
        });
        Object object = container instanceof FirTypeParametersOwner ? (FirTypeParametersOwner)((Object)container) : null;
        if ((object != null && (object = object.getTypeParameters()) != null && (object = CollectionsKt.withIndex((Iterable)((Iterable)object))) != null ? CollectionsKt.toList((Iterable)object) : (list2 = null)) == null) {
            list2 = CollectionsKt.emptyList();
        }
        MangleUtilsKt.collectForMangler(list2, this.getBuilder(), MangleConstant.TYPE_PARAMETERS, (Function2)new Function2<StringBuilder, IndexedValue<? extends FirTypeParameter>, Unit>(this, $this$mangleSignature){
            final /* synthetic */ FirMangleComputer this$0;
            final /* synthetic */ FirFunction $this_mangleSignature;
            {
                this.this$0 = $receiver;
                this.$this_mangleSignature = $receiver2;
                super(2);
            }

            public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull IndexedValue<? extends FirTypeParameter> indexedValue) {
                Intrinsics.checkNotNullParameter((Object)$this$collectForMangler, (String)"$this$collectForMangler");
                Intrinsics.checkNotNullParameter(indexedValue, (String)"<name for destructuring parameter 0>");
                int index2 = indexedValue.component1();
                FirTypeParameter typeParameter2 = (FirTypeParameter)indexedValue.component2();
                FirMangleComputer.access$mangleTypeParameter(this.this$0, $this$collectForMangler, typeParameter2.getSymbol().toLookupTag(), index2, this.$this_mangleSignature.getModuleData().getSession());
            }
        });
        if (!isCtor && !FirTypeUtilsKt.isUnit($this$mangleSignature.getReturnTypeRef()) && this.addReturnType()) {
            this.mangleType(this.getBuilder(), FirTypeUtilsKt.getConeType($this$mangleSignature.getReturnTypeRef()), $this$mangleSignature.getModuleData().getSession());
        }
    }

    @Override
    @NotNull
    protected FirMemberDeclaration getEffectiveParent(@NotNull ConeTypeParameterLookupTag typeParameter2) {
        Intrinsics.checkNotNullParameter((Object)typeParameter2, (String)"typeParameter");
        FirTypeParameter $this$getEffectiveParent_u24lambda_u246 = (FirTypeParameter)typeParameter2.getSymbol().getFir();
        boolean bl = false;
        Object obj = $this$getEffectiveParent_u24lambda_u246.getContainingDeclarationSymbol().getFir();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration");
        return (FirMemberDeclaration)obj;
    }

    @Override
    @NotNull
    protected String renderDeclaration(@NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return UtilsKt.render(declaration);
    }

    @Override
    @NotNull
    protected String getTypeParameterName(@NotNull ConeTypeParameterLookupTag typeParameter2) {
        Intrinsics.checkNotNullParameter((Object)typeParameter2, (String)"typeParameter");
        String string2 = typeParameter2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"typeParameter.name.asString()");
        return string2;
    }

    @Override
    protected boolean isVararg(@NotNull FirValueParameter valueParameter2) {
        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
        return valueParameter2.isVararg();
    }

    @Override
    @NotNull
    protected ConeKotlinType getValueParameterType(@NotNull FirValueParameter valueParameter2) {
        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
        return FirTypeUtilsKt.getConeType(valueParameter2.getReturnTypeRef());
    }

    @Override
    protected int getIndexOfTypeParameter(@NotNull ConeTypeParameterLookupTag typeParameter2, @NotNull FirMemberDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)typeParameter2, (String)"typeParameter");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return container.getTypeParameters().indexOf(typeParameter2.getSymbol().getFir());
    }

    @Override
    protected void mangleType(@NotNull StringBuilder tBuilder, @NotNull ConeKotlinType type2, @NotNull FirSession declarationSiteSession) {
        Intrinsics.checkNotNullParameter((Object)tBuilder, (String)"tBuilder");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)declarationSiteSession, (String)"declarationSiteSession");
        ConeKotlinType coneKotlinType = type2;
        if (coneKotlinType instanceof ConeLookupTagBasedType) {
            FirClassifierSymbol<?> symbol2 = LookupTagUtilsKt.toSymbol(((ConeLookupTagBasedType)type2).getLookupTag(), declarationSiteSession);
            if (symbol2 instanceof FirTypeAliasSymbol) {
                this.mangleType(tBuilder, TypeExpansionUtilsKt.fullyExpandedType((ConeSimpleKotlinType)type2, declarationSiteSession), declarationSiteSession);
                return;
            }
            if (symbol2 instanceof FirClassSymbol) {
                FirMangleComputer $this$mangleType_u24lambda_u247 = this.copy(MangleMode.FQNAME);
                boolean bl = false;
                $this$mangleType_u24lambda_u247.visit((FirDeclaration)symbol2.getFir());
            } else if (symbol2 instanceof FirTypeParameterSymbol) {
                this.mangleTypeParameterReference(tBuilder, (TypeParameterMarker)((FirTypeParameterSymbol)symbol2).toLookupTag());
            } else if (symbol2 == null) {
                ConeClassifierLookupTag $this$mangleType_u24lambda_u247 = ((ConeLookupTagBasedType)type2).getLookupTag();
                ConeClassLikeLookupTag coneClassLikeLookupTag = $this$mangleType_u24lambda_u247 instanceof ConeClassLikeLookupTag ? (ConeClassLikeLookupTag)$this$mangleType_u24lambda_u247 : null;
                if (coneClassLikeLookupTag != null) {
                    ConeClassLikeLookupTag it = coneClassLikeLookupTag;
                    boolean bl2 = false;
                    tBuilder.append(it.getClassId());
                }
            }
            this.mangleTypeArguments(tBuilder, (KotlinTypeMarker)type2, declarationSiteSession);
            if (ConeTypeUtilsKt.isMarkedNullable(type2)) {
                this.appendSignature(tBuilder, '?');
            }
            if (CompilerConeAttributesKt.getHasEnhancedNullability(type2)) {
                this.appendSignature(tBuilder, "{EnhancedNullability}");
            }
        } else if (coneKotlinType instanceof ConeRawType) {
            this.mangleType(tBuilder, ((ConeRawType)type2).getLowerBound(), declarationSiteSession);
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            ConeInferenceContext $this$mangleType_u24lambda_u249 = TypeComponentsKt.getTypeContext(declarationSiteSession);
            boolean bl = false;
            ConeSimpleKotlinType upper = ((ConeFlexibleType)type2).getUpperBound();
            if (upper instanceof ConeClassLikeType) {
                ConeSimpleKotlinType bl2 = ((ConeFlexibleType)type2).getLowerBound();
                ConeClassLikeType coneClassLikeType = bl2 instanceof ConeClassLikeType ? (ConeClassLikeType)bl2 : null;
                if (coneClassLikeType == null) {
                    throw new IllegalStateException(("Expecting class-like type, got " + ((ConeFlexibleType)type2).getLowerBound()).toString());
                }
                ConeClassLikeType lower2 = coneClassLikeType;
                SimpleTypeMarker intermediate = Intrinsics.areEqual((Object)lower2.getLookupTag(), (Object)((ConeClassLikeType)upper).getLookupTag()) ? $this$mangleType_u24lambda_u249.replaceArguments((SimpleTypeMarker)lower2, $this$mangleType_u24lambda_u249.getArguments(upper)) : (SimpleTypeMarker)lower2;
                KotlinTypeMarker mixed = ConeTypeUtilsKt.isNullable(upper) ? $this$mangleType_u24lambda_u249.makeNullable(intermediate) : $this$mangleType_u24lambda_u249.makeDefinitelyNotNullOrNotNull(intermediate);
                Intrinsics.checkNotNull((Object)mixed, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                this.mangleType(tBuilder, (ConeKotlinType)mixed, declarationSiteSession);
            } else {
                this.mangleType(tBuilder, upper, declarationSiteSession);
            }
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            this.mangleType(tBuilder, ((ConeDefinitelyNotNullType)type2).getOriginal(), declarationSiteSession);
        } else if (coneKotlinType instanceof ConeCapturedType) {
            ConeKotlinType coneKotlinType2 = ((ConeCapturedType)type2).getLowerType();
            if (coneKotlinType2 == null) {
                List<ConeKotlinType> list2 = ((ConeCapturedType)type2).getConstructor().getSupertypes();
                Intrinsics.checkNotNull(list2);
                coneKotlinType2 = (ConeKotlinType)CollectionsKt.first(list2);
            }
            this.mangleType(tBuilder, coneKotlinType2, declarationSiteSession);
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            this.mangleType(tBuilder, (ConeKotlinType)CollectionsKt.first((Iterable)((ConeIntersectionType)type2).getIntersectedTypes()), declarationSiteSession);
        } else {
            throw new IllegalStateException(("Unexpected type " + type2).toString());
        }
    }

    public static final /* synthetic */ String access$specialValueParamPrefix(FirMangleComputer $this, FirFunction $receiver, FirValueParameter param) {
        return $this.specialValueParamPrefix($receiver, param);
    }

    public static final /* synthetic */ void access$mangleValueParameter(FirMangleComputer $this, StringBuilder vpBuilder, FirValueParameter param, FirSession declarationSiteSession) {
        $this.mangleValueParameter(vpBuilder, param, declarationSiteSession);
    }

    public static final /* synthetic */ void access$mangleTypeParameter(FirMangleComputer $this, StringBuilder tpBuilder, ConeTypeParameterLookupTag param, int index2, FirSession declarationSiteSession) {
        $this.mangleTypeParameter(tpBuilder, (TypeParameterMarker)param, index2, declarationSiteSession);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0094\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%H\u0016\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/backend/FirMangleComputer$Visitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "(Lorg/jetbrains/kotlin/fir/backend/FirMangleComputer;)V", "visitAnonymousObject", "", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "visitField", "field", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "visitVariable", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "fir2ir"})
    @SourceDebugExtension(value={"SMAP\nFirMangleComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMangleComputer.kt\norg/jetbrains/kotlin/fir/backend/FirMangleComputer$Visitor\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,297:1\n34#2:298\n34#2:299\n36#2:300\n34#2:301\n36#2:302\n36#2:303\n*S KotlinDebug\n*F\n+ 1 FirMangleComputer.kt\norg/jetbrains/kotlin/fir/backend/FirMangleComputer$Visitor\n*L\n232#1:298\n242#1:299\n246#1:300\n280#1:301\n281#1:302\n293#1:303\n*E\n"})
    protected class Visitor
    extends FirVisitorVoid {
        @NotNull
        public Void visitElement(@NotNull FirElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            throw new IllegalStateException(("unexpected element " + UtilsKt.render(element)).toString());
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass) {
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            FirMemberDeclaration $this$isExpect$iv = regularClass;
            boolean $i$f$isExpect = false;
            FirMangleComputer.this.setRealExpect(FirMangleComputer.this.isRealExpect() | $this$isExpect$iv.getStatus().isExpect());
            FirMangleComputer.this.getTypeParameterContainers().add(regularClass);
            FirDeclaration firDeclaration = regularClass;
            String string2 = regularClass.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"regularClass.name.asString()");
            FirMangleComputer.this.mangleSimpleDeclaration(firDeclaration, string2);
        }

        @Override
        public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject) {
            Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
            FirMangleComputer.this.mangleSimpleDeclaration(anonymousObject, "<anonymous>");
        }

        @Override
        public void visitVariable(@NotNull FirVariable variable2) {
            FirPureAbstractElement firPureAbstractElement;
            Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
            FirMemberDeclaration $this$isExpect$iv = variable2;
            boolean $i$f$isExpect = false;
            FirMangleComputer.this.setRealExpect(FirMangleComputer.this.isRealExpect() | $this$isExpect$iv.getStatus().isExpect());
            FirMangleComputer.this.getTypeParameterContainers().add(variable2);
            FirMangleComputer.this.visitParent(variable2);
            FirMemberDeclaration $this$isStatic$iv = variable2;
            boolean $i$f$isStatic = false;
            boolean isStaticProperty = $this$isStatic$iv.getStatus().isStatic();
            if (isStaticProperty) {
                FirMangleComputer.this.appendSignature(FirMangleComputer.this.getBuilder(), "#static");
            }
            if ((firPureAbstractElement = variable2.getReceiverParameter()) != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null) {
                FirPureAbstractElement firPureAbstractElement2 = firPureAbstractElement;
                FirMangleComputer firMangleComputer = FirMangleComputer.this;
                FirPureAbstractElement it = firPureAbstractElement2;
                boolean bl = false;
                firMangleComputer.appendSignature(firMangleComputer.getBuilder(), '@');
                firMangleComputer.mangleType(firMangleComputer.getBuilder(), FirTypeUtilsKt.getConeType((FirTypeRef)it), variable2.getModuleData().getSession());
            }
            MangleUtilsKt.collectForMangler(CollectionsKt.toList((Iterable)CollectionsKt.withIndex((Iterable)variable2.getTypeParameters())), FirMangleComputer.this.getBuilder(), MangleConstant.TYPE_PARAMETERS, (Function2)new Function2<StringBuilder, IndexedValue<? extends FirTypeParameterRef>, Unit>(FirMangleComputer.this, variable2){
                final /* synthetic */ FirMangleComputer this$0;
                final /* synthetic */ FirVariable $variable;
                {
                    this.this$0 = $receiver;
                    this.$variable = $variable;
                    super(2);
                }

                public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull IndexedValue<? extends FirTypeParameterRef> indexedValue) {
                    Intrinsics.checkNotNullParameter((Object)$this$collectForMangler, (String)"$this$collectForMangler");
                    Intrinsics.checkNotNullParameter(indexedValue, (String)"<name for destructuring parameter 0>");
                    int index2 = indexedValue.component1();
                    FirTypeParameterRef typeParameter2 = (FirTypeParameterRef)indexedValue.component2();
                    FirMangleComputer.access$mangleTypeParameter(this.this$0, $this$collectForMangler, typeParameter2.getSymbol().toLookupTag(), index2, this.$variable.getModuleData().getSession());
                }
            });
            FirMangleComputer.this.getBuilder().append(variable2.getName().asString());
        }

        @Override
        public void visitProperty(@NotNull FirProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            this.visitVariable(property);
        }

        @Override
        public void visitField(@NotNull FirField field2) {
            Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
            this.visitVariable(field2);
        }

        @Override
        public void visitEnumEntry(@NotNull FirEnumEntry enumEntry) {
            Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
            FirDeclaration firDeclaration = enumEntry;
            String string2 = enumEntry.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"enumEntry.name.asString()");
            FirMangleComputer.this.mangleSimpleDeclaration(firDeclaration, string2);
        }

        @Override
        public void visitTypeAlias(@NotNull FirTypeAlias typeAlias) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            FirDeclaration firDeclaration = typeAlias;
            String string2 = typeAlias.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"typeAlias.name.asString()");
            FirMangleComputer.this.mangleSimpleDeclaration(firDeclaration, string2);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction) {
            Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
            if (FirMangleComputer.access$isRealExpect(FirMangleComputer.this)) ** GOTO lbl-1000
            $this$isExpect$iv = simpleFunction;
            $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            FirMangleComputer.access$setRealExpect(FirMangleComputer.this, v0);
            $this$isStatic$iv = simpleFunction;
            $i$f$isStatic = false;
            isStatic = $this$isStatic$iv.getStatus().isStatic();
            FirMangleComputer.access$mangleFunction(FirMangleComputer.this, simpleFunction, false, isStatic, simpleFunction);
        }

        @Override
        public void visitConstructor(@NotNull FirConstructor constructor2) {
            Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
            FirMangleComputer.this.mangleFunction(constructor2, true, false, constructor2);
        }

        @Override
        public void visitPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor) {
            Intrinsics.checkNotNullParameter((Object)propertyAccessor, (String)"propertyAccessor");
            if (propertyAccessor instanceof FirSyntheticPropertyAccessor) {
                this.visitSimpleFunction(((FirSyntheticPropertyAccessor)propertyAccessor).getDelegate());
            } else {
                FirMemberDeclaration $this$isStatic$iv = propertyAccessor;
                boolean $i$f$isStatic = false;
                FirMangleComputer.this.mangleFunction(propertyAccessor, false, $this$isStatic$iv.getStatus().isStatic(), propertyAccessor.getPropertySymbol().getFir());
            }
        }
    }
}

