/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.overrides;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.linkage.partial.IrUnimplementedOverridesStrategy;
import org.jetbrains.kotlin.ir.overrides.CopyIrTreeWithSymbolsForFakeOverrides;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001aD\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u001a\b\u0002\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020 0!0\u001f2\b\b\u0002\u0010\"\u001a\u00020#\u001a2\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020 0!0\u001fH\u0002\u001a\n\u0010(\u001a\u00020\t*\u00020\u0006\u001a\n\u0010)\u001a\u00020\t*\u00020*\u001a\n\u0010+\u001a\u00020\t*\u00020\u0003\u001a6\u0010,\u001a\u00020\t*\u00020\u00122\u0006\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020 0!0\u001fH\u0002\"\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\"\u001a\u0010\b\u001a\u00020\t*\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u001a\u0010\f\u001a\u00020\t*\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\"\u0018\u0010\u000e\u001a\u00020\t*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0018\u0010\u0010\u001a\u00020\u0011*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0001*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0001*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0005\u00a8\u0006/"}, d2={"compiledValueParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getCompiledValueParameters", "(Lorg/jetbrains/kotlin/ir/declarations/IrProperty;)Ljava/util/List;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Ljava/util/List;", "hasDispatchReceiver", "", "getHasDispatchReceiver", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Z", "hasExtensionReceiver", "getHasExtensionReceiver", "isInline", "(Lorg/jetbrains/kotlin/ir/declarations/IrProperty;)Z", "returnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableMember;", "getReturnType", "(Lorg/jetbrains/kotlin/ir/declarations/IrOverridableMember;)Lorg/jetbrains/kotlin/ir/types/IrType;", "typeParameters", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "getTypeParameters", "(Lorg/jetbrains/kotlin/ir/declarations/IrOverridableMember;)Ljava/util/List;", "buildFakeOverrideMember", "superType", "member", "clazz", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "friendModules", "", "", "", "unimplementedOverridesStrategy", "Lorg/jetbrains/kotlin/ir/linkage/partial/IrUnimplementedOverridesStrategy;", "isInFriendModules", "fromModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "toModule", "isOverridableFunction", "isOverridableMemberOrAccessor", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isOverridableProperty", "isPrivateToThisModule", "thisClass", "memberClass", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrOverridingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrOverridingUtil.kt\norg/jetbrains/kotlin/ir/overrides/IrOverridingUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,764:1\n1#2:765\n*E\n"})
public final class IrOverridingUtilKt {
    private static final boolean isPrivateToThisModule(IrOverridableMember $this$isPrivateToThisModule, IrClass thisClass, IrClass memberClass, Map<String, ? extends Collection<String>> friendModules) {
        ModuleDescriptor memberModule;
        if (!Intrinsics.areEqual((Object)$this$isPrivateToThisModule.getVisibility(), (Object)DescriptorVisibilities.INTERNAL)) {
            return false;
        }
        ModuleDescriptor thisModule = IrUtilsKt.getPackageFragment(thisClass).getPackageFragmentDescriptor().getContainingDeclaration();
        return !Intrinsics.areEqual((Object)thisModule, (Object)(memberModule = IrUtilsKt.getPackageFragment(memberClass).getPackageFragmentDescriptor().getContainingDeclaration())) && !IrOverridingUtilKt.isInFriendModules(thisModule, memberModule, friendModules);
    }

    private static final boolean isInFriendModules(ModuleDescriptor fromModule, ModuleDescriptor toModule, Map<String, ? extends Collection<String>> friendModules) {
        if (friendModules.isEmpty()) {
            return false;
        }
        String string2 = fromModule.getName().asStringStripSpecialMarkers();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fromModule.name.asStringStripSpecialMarkers()");
        String fromModuleName = string2;
        Collection<String> collection = friendModules.get(fromModuleName);
        if (collection == null) {
            return false;
        }
        Collection<String> fromFriends = collection;
        String string3 = toModule.getName().asStringStripSpecialMarkers();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toModule.name.asStringStripSpecialMarkers()");
        String toModuleName = string3;
        return fromFriends.contains(toModuleName);
    }

    @NotNull
    public static final IrOverridableMember buildFakeOverrideMember(@NotNull IrType superType2, @NotNull IrOverridableMember member2, @NotNull IrClass clazz, @NotNull Map<String, ? extends Collection<String>> friendModules, @NotNull IrUnimplementedOverridesStrategy unimplementedOverridesStrategy) {
        IrOverridableMember irOverridableMember;
        Intrinsics.checkNotNullParameter((Object)superType2, (String)"superType");
        Intrinsics.checkNotNullParameter((Object)member2, (String)"member");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(friendModules, (String)"friendModules");
        Intrinsics.checkNotNullParameter((Object)unimplementedOverridesStrategy, (String)"unimplementedOverridesStrategy");
        if (!(superType2 instanceof IrSimpleType)) {
            boolean $i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$62 = false;
            String $i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$62 = "superType is " + superType2 + ", expected IrSimpleType";
            throw new IllegalArgumentException($i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$62.toString());
        }
        IrClassifierSymbol classifier = ((IrSimpleType)superType2).getClassifier();
        if (!(classifier instanceof IrClassSymbol)) {
            boolean $i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$72 = false;
            String $i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$72 = "superType classifier is not IrClassSymbol: " + classifier;
            throw new IllegalArgumentException($i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$72.toString());
        }
        List<IrTypeParameter> typeParameters2 = IrTypeSystemContextKt.extractTypeParameters((IrDeclarationParent)((Object)((IrClassSymbol)classifier).getOwner()));
        List<IrTypeArgument> superArguments = ((IrSimpleType)superType2).getArguments();
        if (!(typeParameters2.size() == superArguments.size())) {
            boolean $i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$82 = false;
            String $i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$82 = "typeParameters = " + typeParameters2 + " size != typeArguments = " + superArguments + " size ";
            throw new IllegalArgumentException($i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$82.toString());
        }
        Map substitutionMap = new LinkedHashMap();
        int n = typeParameters2.size();
        for (int i = 0; i < n; ++i) {
            IrTypeParameter tp = typeParameters2.get(i);
            IrTypeArgument ta = superArguments.get(i);
            if (!(ta instanceof IrTypeProjection)) {
                boolean $i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$92 = false;
                String $i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$92 = "Unexpected super type argument: " + RenderIrElementKt.render$default(ta, null, 1, null) + " @ " + i;
                throw new IllegalArgumentException($i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$92.toString());
            }
            if (!(((IrTypeProjection)ta).getVariance() == Variance.INVARIANT)) {
                boolean bl = false;
                String string2 = "Unexpected variance in super type argument: " + (Object)((Object)((IrTypeProjection)ta).getVariance()) + " @" + i;
                throw new IllegalArgumentException(string2.toString());
            }
            substitutionMap.put(tp.getSymbol(), ((IrTypeProjection)ta).getType());
        }
        IrOverridableMember $this$buildFakeOverrideMember_u24lambda_u245 = irOverridableMember = new CopyIrTreeWithSymbolsForFakeOverrides(member2, substitutionMap, clazz, unimplementedOverridesStrategy).copy();
        boolean bl = false;
        if (IrOverridingUtilKt.isPrivateToThisModule($this$buildFakeOverrideMember_u24lambda_u245, clazz, (IrClass)((IrClassSymbol)classifier).getOwner(), friendModules)) {
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.INVISIBLE_FAKE;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"INVISIBLE_FAKE");
            $this$buildFakeOverrideMember_u24lambda_u245.setVisibility(descriptorVisibility);
        }
        return irOverridableMember;
    }

    public static /* synthetic */ IrOverridableMember buildFakeOverrideMember$default(IrType irType, IrOverridableMember irOverridableMember, IrClass irClass2, Map map, IrUnimplementedOverridesStrategy irUnimplementedOverridesStrategy, int n, Object object) {
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            irUnimplementedOverridesStrategy = IrUnimplementedOverridesStrategy.ProcessAsFakeOverrides.INSTANCE;
        }
        return IrOverridingUtilKt.buildFakeOverrideMember(irType, irOverridableMember, irClass2, map, irUnimplementedOverridesStrategy);
    }

    private static final boolean getHasExtensionReceiver(IrSimpleFunction $this$hasExtensionReceiver) {
        IrSimpleFunction irSimpleFunction = $this$hasExtensionReceiver;
        return (irSimpleFunction != null ? irSimpleFunction.getExtensionReceiverParameter() : null) != null;
    }

    private static final boolean getHasDispatchReceiver(IrSimpleFunction $this$hasDispatchReceiver) {
        IrSimpleFunction irSimpleFunction = $this$hasDispatchReceiver;
        return (irSimpleFunction != null ? irSimpleFunction.getDispatchReceiverParameter() : null) != null;
    }

    private static final List<IrValueParameter> getCompiledValueParameters(IrSimpleFunction $this$compiledValueParameters) {
        ArrayList<IrValueParameter> arrayList;
        ArrayList<IrValueParameter> $this$_get_compiledValueParameters__u24lambda_u246 = arrayList = new ArrayList<IrValueParameter>($this$compiledValueParameters.getValueParameters().size() + 1);
        boolean bl = false;
        IrValueParameter irValueParameter = $this$compiledValueParameters.getExtensionReceiverParameter();
        if (irValueParameter != null) {
            IrValueParameter p0 = irValueParameter;
            boolean bl2 = false;
            $this$_get_compiledValueParameters__u24lambda_u246.add(p0);
        }
        $this$_get_compiledValueParameters__u24lambda_u246.addAll((Collection)$this$compiledValueParameters.getValueParameters());
        return arrayList;
    }

    private static final List<IrValueParameter> getCompiledValueParameters(IrProperty $this$compiledValueParameters) {
        List list2;
        List list3;
        IrDeclarationBase irDeclarationBase = $this$compiledValueParameters.getGetter();
        if (irDeclarationBase != null && (irDeclarationBase = irDeclarationBase.getExtensionReceiverParameter()) != null) {
            IrDeclarationBase p0 = irDeclarationBase;
            boolean bl = false;
            list3 = CollectionsKt.listOf((Object)p0);
        } else {
            list3 = list2 = null;
        }
        if (list3 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private static final List<IrTypeParameter> getTypeParameters(IrProperty $this$typeParameters) {
        IrSimpleFunction irSimpleFunction = $this$typeParameters.getGetter();
        List list2 = irSimpleFunction != null ? irSimpleFunction.getTypeParameters() : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInline(IrProperty $this$isInline) {
        boolean bl;
        IrSimpleFunction irSimpleFunction = $this$isInline.getGetter();
        if (irSimpleFunction != null) {
            if (irSimpleFunction.isInline()) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        IrSimpleFunction irSimpleFunction2 = $this$isInline.getSetter();
        if (irSimpleFunction2 == null) return false;
        if (!irSimpleFunction2.isInline()) return false;
        return true;
    }

    private static final List<IrTypeParameter> getTypeParameters(IrOverridableMember $this$typeParameters) {
        List<IrTypeParameter> list2;
        IrOverridableMember irOverridableMember = $this$typeParameters;
        if (irOverridableMember instanceof IrSimpleFunction) {
            list2 = ((IrSimpleFunction)$this$typeParameters).getTypeParameters();
        } else if (irOverridableMember instanceof IrProperty) {
            IrSimpleFunction irSimpleFunction = ((IrProperty)$this$typeParameters).getGetter();
            list2 = irSimpleFunction != null ? irSimpleFunction.getTypeParameters() : null;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
        } else {
            throw new IllegalStateException(("Unexpected type of declaration: " + $this$typeParameters.getClass() + ", " + $this$typeParameters).toString());
        }
        return list2;
    }

    private static final IrType getReturnType(IrOverridableMember $this$returnType) {
        IrType irType;
        IrOverridableMember irOverridableMember = $this$returnType;
        if (irOverridableMember instanceof IrSimpleFunction) {
            irType = ((IrSimpleFunction)$this$returnType).getReturnType();
        } else if (irOverridableMember instanceof IrProperty) {
            IrSimpleFunction irSimpleFunction = ((IrProperty)$this$returnType).getGetter();
            Intrinsics.checkNotNull((Object)irSimpleFunction);
            irType = irSimpleFunction.getReturnType();
        } else {
            throw new IllegalStateException(("Unexpected type of declaration: " + $this$returnType.getClass() + ", " + $this$returnType).toString());
        }
        return irType;
    }

    public static final boolean isOverridableFunction(@NotNull IrSimpleFunction $this$isOverridableFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isOverridableFunction, (String)"<this>");
        return !Intrinsics.areEqual((Object)$this$isOverridableFunction.getVisibility(), (Object)DescriptorVisibilities.PRIVATE) && IrOverridingUtilKt.getHasDispatchReceiver($this$isOverridableFunction);
    }

    public static final boolean isOverridableProperty(@NotNull IrProperty $this$isOverridableProperty) {
        Intrinsics.checkNotNullParameter((Object)$this$isOverridableProperty, (String)"<this>");
        return !Intrinsics.areEqual((Object)$this$isOverridableProperty.getVisibility(), (Object)DescriptorVisibilities.PRIVATE) && (IrOverridingUtilKt.getHasDispatchReceiver($this$isOverridableProperty.getGetter()) || IrOverridingUtilKt.getHasDispatchReceiver($this$isOverridableProperty.getSetter()));
    }

    public static final boolean isOverridableMemberOrAccessor(@NotNull IrDeclaration $this$isOverridableMemberOrAccessor) {
        Intrinsics.checkNotNullParameter((Object)$this$isOverridableMemberOrAccessor, (String)"<this>");
        IrDeclaration irDeclaration2 = $this$isOverridableMemberOrAccessor;
        return irDeclaration2 instanceof IrSimpleFunction ? IrOverridingUtilKt.isOverridableFunction((IrSimpleFunction)$this$isOverridableMemberOrAccessor) : (irDeclaration2 instanceof IrProperty ? IrOverridingUtilKt.isOverridableProperty((IrProperty)$this$isOverridableMemberOrAccessor) : false);
    }

    public static final /* synthetic */ List access$getTypeParameters(IrOverridableMember $receiver) {
        return IrOverridingUtilKt.getTypeParameters($receiver);
    }

    public static final /* synthetic */ IrType access$getReturnType(IrOverridableMember $receiver) {
        return IrOverridingUtilKt.getReturnType($receiver);
    }

    public static final /* synthetic */ boolean access$getHasExtensionReceiver(IrSimpleFunction $receiver) {
        return IrOverridingUtilKt.getHasExtensionReceiver($receiver);
    }

    public static final /* synthetic */ List access$getCompiledValueParameters(IrSimpleFunction $receiver) {
        return IrOverridingUtilKt.getCompiledValueParameters($receiver);
    }

    public static final /* synthetic */ boolean access$isInline(IrProperty $receiver) {
        return IrOverridingUtilKt.isInline($receiver);
    }

    public static final /* synthetic */ List access$getTypeParameters(IrProperty $receiver) {
        return IrOverridingUtilKt.getTypeParameters($receiver);
    }

    public static final /* synthetic */ List access$getCompiledValueParameters(IrProperty $receiver) {
        return IrOverridingUtilKt.getCompiledValueParameters($receiver);
    }
}

