/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrStringConcatenationImpl;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterConfiguration;
import org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import org.jetbrains.kotlin.ir.interpreter.checker.IrConstTransformer;
import org.jetbrains.kotlin.ir.types.IrType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001Bo\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u001e\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000b\u0012\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u001a\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u001e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/IrConstExpressionTransformer;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/IrConstTransformer;", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "mode", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "evaluatedConstTracker", "Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;", "onWarning", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/ir/expressions/IrErrorExpression;", "", "onError", "suppressExceptions", "", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function3;Z)V", "visitCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "data", "", "visitField", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nIrConstExpressionTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrConstExpressionTransformer.kt\norg/jetbrains/kotlin/ir/interpreter/checker/IrConstExpressionTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1855#2,2:100\n*S KotlinDebug\n*F\n+ 1 IrConstExpressionTransformer.kt\norg/jetbrains/kotlin/ir/interpreter/checker/IrConstExpressionTransformer\n*L\n92#1:100,2\n*E\n"})
public final class IrConstExpressionTransformer
extends IrConstTransformer {
    public IrConstExpressionTransformer(@NotNull IrInterpreter interpreter2, @NotNull IrFile irFile, @NotNull EvaluationMode mode, @Nullable EvaluatedConstTracker evaluatedConstTracker, @NotNull Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit> onWarning, @NotNull Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit> onError, boolean suppressExceptions) {
        Intrinsics.checkNotNullParameter((Object)interpreter2, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter(onWarning, (String)"onWarning");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        super(interpreter2, irFile, mode, evaluatedConstTracker, onWarning, onError, suppressExceptions);
    }

    @Override
    @NotNull
    public IrElement visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (IrConstTransformer.canBeInterpreted$default(this, expression2, null, null, 3, null)) {
            return this.interpret(expression2, false);
        }
        return super.visitCall(expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitField(@NotNull IrField declaration, @Nullable Void data2) {
        boolean isConst;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrExpressionBody initializer2 = declaration.getInitializer();
        IrElementBase irElementBase = initializer2;
        if (irElementBase == null || (irElementBase = irElementBase.getExpression()) == null) {
            return declaration;
        }
        IrElementBase expression2 = irElementBase;
        Object object = declaration.getCorrespondingPropertySymbol();
        boolean bl = object != null && (object = (IrProperty)object.getOwner()) != null ? ((IrProperty)object).isConst() : (isConst = false);
        if (!isConst) {
            return super.visitField(declaration, data2);
        }
        if (this.canBeInterpreted((IrExpression)expression2, declaration, IrInterpreterConfiguration.copy$default(this.getInterpreter().getEnvironment$ir_interpreter().getConfiguration(), 0, 0, false, false, false, false, 31, null))) {
            initializer2.setExpression(this.interpret((IrExpression)expression2, true));
        }
        return super.visitField(declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
        IrConst foldedConst;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        List folded = new ArrayList();
        List buildersList = new ArrayList();
        for (IrExpression irExpression : expression2.getArguments()) {
            IrExpression last = (IrExpression)CollectionsKt.lastOrNull((List)folded);
            if (!IrConstTransformer.canBeInterpreted$default(this, IrConstExpressionTransformer.visitStringConcatenation$wrapInStringConcat(irExpression, expression2), null, null, 3, null)) {
                ((Collection)folded).add(irExpression);
                buildersList.add(new StringBuilder());
                continue;
            }
            if (last == null || !IrConstTransformer.canBeInterpreted$default(this, IrConstExpressionTransformer.visitStringConcatenation$wrapInStringConcat(last, expression2), null, null, 3, null)) {
                IrExpression result2 = IrConstExpressionTransformer.visitStringConcatenation$wrapInToStringConcatAndInterpret(irExpression, this, expression2);
                ((Collection)folded).add(result2);
                Object object = result2 instanceof IrConst ? (IrConst)result2 : null;
                if (object == null || (object = ((IrConst)object).getValue()) == null || (object = object.toString()) == null) {
                    object = "";
                }
                buildersList.add(new StringBuilder((String)object));
                continue;
            }
            IrExpression nextAsConst = IrConstExpressionTransformer.visitStringConcatenation$wrapInToStringConcatAndInterpret(irExpression, this, expression2);
            if (!(nextAsConst instanceof IrConst)) {
                ((Collection)folded).add(irExpression);
                buildersList.add(new StringBuilder());
                continue;
            }
            folded.set(folded.size() - 1, IrConstImpl.Companion.string(Math.min(last.getStartOffset(), irExpression.getStartOffset()), Math.max(last.getEndOffset(), irExpression.getEndOffset()), expression2.getType(), ""));
            ((StringBuilder)CollectionsKt.last((List)buildersList)).append(String.valueOf(((IrConst)nextAsConst).getValue()));
        }
        Object object = CollectionsKt.singleOrNull((List)folded);
        IrConst irConst = foldedConst = object instanceof IrConst ? (IrConst)object : null;
        if (foldedConst != null) {
            int n = expression2.getStartOffset();
            int n2 = expression2.getEndOffset();
            IrType irType = expression2.getType();
            String string2 = ((StringBuilder)CollectionsKt.single((List)buildersList)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"buildersList.single().toString()");
            return IrConstImpl.Companion.string(n, n2, irType, string2);
        }
        Iterable iterable = CollectionsKt.zip((Iterable)folded, (Iterable)buildersList);
        boolean $i$f$forEach = false;
        for (Object element$iv : iterable) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Object object2 = it.getFirst();
            IrConst irConst2 = object2 instanceof IrConst ? (IrConst)object2 : null;
            if (irConst2 == null) continue;
            String string3 = ((StringBuilder)it.getSecond()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.second.toString()");
            irConst2.setValue(string3);
        }
        return new IrStringConcatenationImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), folded);
    }

    private static final IrExpression visitStringConcatenation$wrapInStringConcat(IrExpression $this$visitStringConcatenation_u24wrapInStringConcat, IrStringConcatenation $expression) {
        return new IrStringConcatenationImpl($this$visitStringConcatenation_u24wrapInStringConcat.getStartOffset(), $this$visitStringConcatenation_u24wrapInStringConcat.getEndOffset(), $expression.getType(), CollectionsKt.listOf((Object)$this$visitStringConcatenation_u24wrapInStringConcat));
    }

    private static final IrExpression visitStringConcatenation$wrapInToStringConcatAndInterpret(IrExpression $this$visitStringConcatenation_u24wrapInToStringConcatAndInterpret, IrConstExpressionTransformer this$0, IrStringConcatenation $expression) {
        return this$0.interpret(IrConstExpressionTransformer.visitStringConcatenation$wrapInStringConcat($this$visitStringConcatenation_u24wrapInToStringConcatAndInterpret, $expression), false);
    }
}

