/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.ImmutableList;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.PrivateForInline;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguouslyResolvedAnnotationFromPlugin;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeCyclicTypeBound;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSpecificTypeResolverTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTypeResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.ScopeClassDeclaration;
import org.jetbrains.kotlin.fir.resolve.transformers.TransformUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ImportingScopesKt;
import org.jetbrains.kotlin.fir.scopes.ScopesKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirMemberTypeParameterScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeWithSubstitutionKt;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u000e\u00101\u001a\u00020/2\u0006\u00102\u001a\u000203J\u0016\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020807H\u0002J&\u00109\u001a\u0002052\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020;0>H\u0002J\u001a\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u000e2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0002J\u0010\u0010C\u001a\u00020/2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u00020/2\u0006\u0010G\u001a\u00020HH\u0002J\u001a\u0010I\u001a\u00020@2\u0006\u0010J\u001a\u00020K2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010L\u001a\u00020@2\u0006\u0010M\u001a\u00020N2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010O\u001a\u00020@2\u0006\u0010P\u001a\u00020Q2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010R\u001a\u00020@2\u0006\u0010S\u001a\u00020T2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010U\u001a\u00020@2\u0006\u0010V\u001a\u00020W2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016J\u0018\u0010X\u001a\u00020/2\u0006\u0010Y\u001a\u00020Z2\b\u0010B\u001a\u0004\u0018\u00010\u0002J\u001a\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\\2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016J\u000e\u0010^\u001a\u00020/2\u0006\u0010]\u001a\u00020\\J\u001a\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020`2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020c2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010e\u001a\u00020\u000b2\u0006\u0010f\u001a\u00020\u000b2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020j2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010k\u001a\u00020H2\u0006\u0010G\u001a\u00020H2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020m2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010o\u001a\u00020@2\u0006\u0010Y\u001a\u00020Z2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010p\u001a\u00020q2\u0006\u0010r\u001a\u00020q2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010s\u001a\u00020t2\u0006\u0010u\u001a\u00020t2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020h2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010y\u001a\u00020@2\u0006\u0010z\u001a\u00020{2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010|\u001a\u00020/2\u0006\u0010}\u001a\u00020~H\u0002J3\u0010\u007f\u001a\u0003H\u0080\u0001\"\u0005\b\u0000\u0010\u0080\u00012\u0006\u0010Y\u001a\u00020Z2\u000f\u0010\u0081\u0001\u001a\n\u0012\u0005\u0012\u0003H\u0080\u00010\u0082\u0001H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0083\u0001JH\u0010\u0084\u0001\u001a\u0003H\u0080\u0001\"\u0005\b\u0000\u0010\u0080\u00012\u0006\u0010A\u001a\u00020\u000e2\u0010\b\u0006\u0010\u0085\u0001\u001a\t\u0012\u0004\u0012\u00020/0\u0082\u00012\u0011\b\u0004\u0010\u0081\u0001\u001a\n\u0012\u0005\u0012\u0003H\u0080\u00010\u0082\u0001H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0086\u0001J4\u0010\u0087\u0001\u001a\u0003H\u0088\u0001\"\u0005\b\u0000\u0010\u0088\u00012\u0007\u0010\u0089\u0001\u001a\u00020\u00152\u0011\b\u0004\u0010\u0081\u0001\u001a\n\u0012\u0005\u0012\u0003H\u0088\u00010\u0082\u0001H\u0082\b\u00a2\u0006\u0003\u0010\u008a\u0001J6\u0010\u008b\u0001\u001a\u0003H\u0080\u0001\"\u0005\b\u0000\u0010\u0080\u00012\u0006\u0010f\u001a\u00020\u000b2\u0011\b\u0004\u0010\u0081\u0001\u001a\n\u0012\u0005\u0012\u0003H\u0080\u00010\u0082\u0001H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u008c\u0001J.\u0010\u008d\u0001\u001a\u0003H\u0088\u0001\"\u0005\b\u0000\u0010\u0088\u00012\u0011\b\u0004\u0010\u008e\u0001\u001a\n\u0012\u0005\u0012\u0003H\u0088\u00010\u0082\u0001H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u008f\u0001J\u000e\u0010\u0090\u0001\u001a\u00020/*\u00030\u0091\u0001H\u0002R\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0016\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0017\u0010\u0011\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001c\u0010\u0011\u001a\u0004\b\u001d\u0010\u001eR*\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b!\u0010\u0011\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R*\u0010(\u001a\b\u0012\u0004\u0012\u00020\t0 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b)\u0010\u0011\u001a\u0004\b*\u0010#\"\u0004\b+\u0010%R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0092\u0001\u00b2\u0006\u0012\u0010\u0093\u0001\u001a\t\u0012\u0004\u0012\u00020K0\u0094\u0001X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirTypeResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "initialScopes", "", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "initialCurrentFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "classDeclarationsStack", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Ljava/util/List;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lkotlin/collections/ArrayDeque;)V", "getClassDeclarationsStack$annotations", "()V", "getClassDeclarationsStack", "()Lkotlin/collections/ArrayDeque;", "currentDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "currentFile", "getCurrentFile$annotations", "getCurrentFile", "()Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "setCurrentFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;)V", "getScopeSession$annotations", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopes", "Lkotlinx/collections/immutable/PersistentList;", "getScopes$annotations", "getScopes", "()Lkotlinx/collections/immutable/PersistentList;", "setScopes", "(Lkotlinx/collections/immutable/PersistentList;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "staticScopes", "getStaticScopes$annotations", "getStaticScopes", "setStaticScopes", "typeResolverTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;", "addScopes", "", "list", "addTypeParametersScope", "firMemberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "annotationShouldBeMovedToField", "", "allowedTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "hasSupertypePathToParameter", "currentTypeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "typeParameter", "visited", "", "resolveClassContent", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "firClass", "data", "resolveConstructedTypeRefForDelegatedConstructorCall", "delegatedConstructorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "setAccessorTypesByPropertyType", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "transformAnnotation", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "transformAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "transformAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "transformBackingField", "backingField", "Lorg/jetbrains/kotlin/fir/declarations/FirBackingField;", "transformBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "transformClassTypeParameters", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "transformConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "constructor", "transformDelegatedConstructorCall", "transformEnumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "enumEntry", "transformField", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "field", "transformFile", "file", "transformImplicitTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "implicitTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirImplicitTypeRef;", "transformProperty", "transformReceiverParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirReceiverParameter;", "receiverParameter", "transformRegularClass", "transformSimpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "simpleFunction", "transformTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "typeAlias", "transformTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "typeRef", "transformValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "unboundCyclesInTypeParametersSupertypes", "typeParametersOwner", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRefsOwner;", "withClassDeclarationCleanup", "R", "action", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withClassScopes", "actionInsideStaticScope", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withDeclaration", "T", "declaration", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withFileScope", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withScopeCleanup", "l", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "moveOrDeleteIrrelevantAnnotations", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "resolve", "backingFieldAnnotations", ""})
@SourceDebugExtension(value={"SMAP\nFirTypeResolveTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirTypeResolveTransformer\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 TransformUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/TransformUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FirErrorTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirErrorTypeRefBuilderKt\n+ 6 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 7 FirSpecificTypeResolverTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 9 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,516:1\n104#1,2:517\n369#1,4:519\n106#1,2:523\n374#1,4:525\n369#1,9:529\n131#1:540\n369#1,4:548\n374#1,4:554\n369#1,9:572\n369#1,9:585\n369#1,4:602\n82#1,4:606\n87#1,2:612\n374#1,4:614\n369#1,9:626\n369#1,4:643\n82#1,7:647\n374#1,4:654\n82#1,7:680\n413#1:698\n369#1,4:699\n415#1:703\n416#1,4:706\n369#1,4:710\n374#1,4:725\n427#1:729\n423#1,4:730\n422#1,18:734\n440#1,13:753\n374#1,4:766\n453#1:770\n369#1,4:771\n374#1,4:777\n369#1,4:781\n374#1,4:787\n145#2,2:538\n147#2,2:546\n145#2,2:570\n147#2,2:581\n145#2,2:583\n147#2,2:594\n145#2,4:596\n145#2,2:600\n147#2,2:618\n145#2,2:624\n147#2,2:635\n145#2,4:637\n145#2,2:641\n147#2,2:658\n145#2,2:678\n147#2,2:687\n145#2,2:689\n147#2,2:696\n64#3,5:541\n64#3,6:558\n64#3,6:564\n1855#4,2:552\n1855#4,2:610\n1549#4:620\n1620#4,3:621\n1747#4,2:664\n1749#4:670\n800#4,11:714\n766#4:791\n857#4,2:792\n57#5,4:660\n57#5,4:692\n24#6,4:666\n68#7,7:671\n1#8:691\n1#8:752\n35#9:704\n51#9:705\n35#9:775\n51#9:776\n35#9:785\n51#9:786\n*S KotlinDebug\n*F\n+ 1 FirTypeResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirTypeResolveTransformer\n*L\n98#1:517,2\n98#1:519,4\n98#1:523,2\n98#1:525,4\n105#1:529,9\n113#1:540\n121#1:548,4\n121#1:554,4\n141#1:572,9\n158#1:585,9\n176#1:602,4\n177#1:606,4\n177#1:612,2\n176#1:614,4\n229#1:626,9\n244#1:643,4\n245#1:647,7\n244#1:654,4\n309#1:680,7\n383#1:698\n383#1:699,4\n383#1:703\n383#1:706,4\n386#1:710,4\n386#1:725,4\n383#1:729\n383#1:730,4\n383#1:734,18\n383#1:753,13\n383#1:766,4\n383#1:770\n413#1:771,4\n413#1:777,4\n413#1:781,4\n413#1:787,4\n112#1:538,2\n112#1:546,2\n140#1:570,2\n140#1:581,2\n157#1:583,2\n157#1:594,2\n164#1:596,4\n175#1:600,2\n175#1:618,2\n228#1:624,2\n228#1:635,2\n235#1:637,4\n243#1:641,2\n243#1:658,2\n308#1:678,2\n308#1:687,2\n328#1:689,2\n328#1:696,2\n113#1:541,5\n131#1:558,6\n135#1:564,6\n123#1:552,2\n207#1:610,2\n225#1:620\n225#1:621,3\n276#1:664,2\n276#1:670\n394#1:714,11\n490#1:791\n490#1:792,2\n258#1:660,4\n343#1:692,4\n277#1:666,4\n288#1:671,7\n383#1:752\n383#1:704\n383#1:705\n415#1:775\n415#1:776\n415#1:785\n415#1:786\n*E\n"})
public class FirTypeResolveTransformer
extends FirAbstractTreeTransformer<Object> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final ArrayDeque<FirClass> classDeclarationsStack;
    @NotNull
    private PersistentList<? extends FirScope> scopes;
    @NotNull
    private PersistentList<? extends FirScope> staticScopes;
    @Nullable
    private FirDeclaration currentDeclaration;
    @NotNull
    private final FirSpecificTypeResolverTransformer typeResolverTransformer;
    @Nullable
    private FirFile currentFile;

    public FirTypeResolveTransformer(@NotNull FirSession session, @NotNull ScopeSession scopeSession, @NotNull List<? extends FirScope> initialScopes, @Nullable FirFile initialCurrentFile, @NotNull ArrayDeque<FirClass> classDeclarationsStack) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter(initialScopes, (String)"initialScopes");
        Intrinsics.checkNotNullParameter(classDeclarationsStack, (String)"classDeclarationsStack");
        super(FirResolvePhase.TYPES);
        this.session = session;
        this.scopeSession = scopeSession;
        this.classDeclarationsStack = classDeclarationsStack;
        this.scopes = ExtensionsKt.toPersistentList((Iterable)CollectionsKt.asReversed(initialScopes));
        this.staticScopes = this.scopes;
        this.typeResolverTransformer = new FirSpecificTypeResolverTransformer(this.session, false, false, null, 14, null);
        this.currentFile = initialCurrentFile;
    }

    public /* synthetic */ FirTypeResolveTransformer(FirSession firSession, ScopeSession scopeSession, List list2, FirFile firFile, ArrayDeque arrayDeque, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            firFile = null;
        }
        if ((n & 0x10) != 0) {
            arrayDeque = new ArrayDeque();
        }
        this(firSession, scopeSession, list2, firFile, (ArrayDeque<FirClass>)arrayDeque);
    }

    @Override
    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @PrivateForInline
    public static /* synthetic */ void getScopeSession$annotations() {
    }

    @NotNull
    public final ArrayDeque<FirClass> getClassDeclarationsStack() {
        return this.classDeclarationsStack;
    }

    @PrivateForInline
    public static /* synthetic */ void getClassDeclarationsStack$annotations() {
    }

    @NotNull
    public final PersistentList<FirScope> getScopes() {
        return this.scopes;
    }

    public final void setScopes(@NotNull PersistentList<? extends FirScope> persistentList) {
        Intrinsics.checkNotNullParameter(persistentList, (String)"<set-?>");
        this.scopes = persistentList;
    }

    @PrivateForInline
    public static /* synthetic */ void getScopes$annotations() {
    }

    @NotNull
    public final PersistentList<FirScope> getStaticScopes() {
        return this.staticScopes;
    }

    public final void setStaticScopes(@NotNull PersistentList<? extends FirScope> persistentList) {
        Intrinsics.checkNotNullParameter(persistentList, (String)"<set-?>");
        this.staticScopes = persistentList;
    }

    @PrivateForInline
    public static /* synthetic */ void getStaticScopes$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withDeclaration(FirDeclaration declaration, Function0<? extends T> action) {
        Object object;
        boolean $i$f$withDeclaration = false;
        FirDeclaration oldDeclaration = this.currentDeclaration;
        try {
            this.currentDeclaration = declaration;
            object = action.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.currentDeclaration = oldDeclaration;
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    @Nullable
    public final FirFile getCurrentFile() {
        return this.currentFile;
    }

    public final void setCurrentFile(@Nullable FirFile firFile) {
        this.currentFile = firFile;
    }

    @PrivateForInline
    public static /* synthetic */ void getCurrentFile$annotations() {
    }

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.checkSessionConsistency(file2);
        FirTypeResolveTransformer this_$iv = this;
        boolean $i$f$withFileScope = false;
        this_$iv.setCurrentFile(file2);
        FirTypeResolveTransformer this_$iv$iv = this_$iv;
        boolean $i$f$withScopeCleanup = false;
        PersistentList<FirScope> scopesBefore$iv$iv = this_$iv$iv.getScopes();
        PersistentList<FirScope> staticScopesBefore$iv$iv = this_$iv$iv.getStaticScopes();
        boolean bl = false;
        this_$iv.addScopes(ImportingScopesKt.createImportingScopes$default(file2, this_$iv.getSession(), this_$iv.getScopeSession(), false, 8, null));
        boolean bl2 = false;
        FirFile result$iv$iv = FirTypeResolveTransformer.super.transformFile(file2, data2);
        this_$iv$iv.setScopes(scopesBefore$iv$iv);
        this_$iv$iv.setStaticScopes(staticScopesBefore$iv$iv);
        return result$iv$iv;
    }

    public final <R> R withFileScope(@NotNull FirFile file2, @NotNull Function0<? extends R> action) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$withFileScope = false;
        this.setCurrentFile(file2);
        FirTypeResolveTransformer this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        PersistentList<FirScope> scopesBefore$iv = this_$iv.getScopes();
        PersistentList<FirScope> staticScopesBefore$iv = this_$iv.getStaticScopes();
        boolean bl = false;
        this.addScopes(ImportingScopesKt.createImportingScopes$default(file2, this.getSession(), this.getScopeSession(), false, 8, null));
        Object result$iv = action.invoke();
        this_$iv.setScopes(scopesBefore$iv);
        this_$iv.setStaticScopes(staticScopesBefore$iv);
        return (R)result$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            FirTypeResolveTransformer this_$iv = this;
            boolean $i$f$withClassDeclarationCleanup = false;
            ArrayDeque<FirClass> classDeclarations$iv$iv = this_$iv.getClassDeclarationsStack();
            boolean $i$f$withClassDeclarationCleanup2 = false;
            classDeclarations$iv$iv.addLast((Object)regularClass);
            try {
                boolean bl2 = false;
                this.transformClassTypeParameters(regularClass, data2);
                FirStatement firStatement = this.resolveClassContent(regularClass, data2);
                return firStatement;
            }
            finally {
                classDeclarations$iv$iv.removeLast();
            }
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(regularClass, throwable$iv);
            throw null;
        }
    }

    public final void transformClassTypeParameters(@NotNull FirRegularClass regularClass, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        FirTypeResolveTransformer this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        PersistentList<FirScope> scopesBefore$iv = this_$iv.getScopes();
        PersistentList<FirScope> staticScopesBefore$iv = this_$iv.getStaticScopes();
        boolean bl = false;
        this.addTypeParametersScope(regularClass);
        Iterable $this$forEach$iv = regularClass.getTypeParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
            boolean bl2 = false;
            it.accept(this, data2);
        }
        this.unboundCyclesInTypeParametersSupertypes(regularClass);
        Unit result$iv = Unit.INSTANCE;
        this_$iv.setScopes(scopesBefore$iv);
        this_$iv.setStaticScopes(staticScopesBefore$iv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R withClassDeclarationCleanup(@NotNull FirRegularClass regularClass, @NotNull Function0<? extends R> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$withClassDeclarationCleanup = false;
        ArrayDeque<FirClass> classDeclarations$iv = this.getClassDeclarationsStack();
        boolean $i$f$withClassDeclarationCleanup2 = false;
        classDeclarations$iv.addLast((Object)regularClass);
        try {
            object = action.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            classDeclarations$iv.removeLast();
            InlineMarker.finallyEnd((int)1);
        }
        return (R)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FirStatement transformAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        ArrayDeque<FirClass> classDeclarations$iv = this.classDeclarationsStack;
        boolean $i$f$withClassDeclarationCleanup = false;
        classDeclarations$iv.addLast((Object)anonymousObject);
        try {
            boolean bl = false;
            FirStatement firStatement = this.resolveClassContent(anonymousObject, data2);
            return firStatement;
        }
        finally {
            classDeclarations$iv.removeLast();
        }
    }

    @NotNull
    public FirConstructor transformConstructor(@NotNull FirConstructor constructor2, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            FirTypeResolveTransformer this_$iv = this;
            boolean $i$f$withScopeCleanup = false;
            PersistentList<FirScope> scopesBefore$iv = this_$iv.getScopes();
            PersistentList<FirScope> staticScopesBefore$iv = this_$iv.getStaticScopes();
            boolean bl2 = false;
            this.addTypeParametersScope(constructor2);
            FirDeclaration firDeclaration = this.transformDeclaration(constructor2, data2);
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirConstructor");
            FirConstructor result2 = (FirConstructor)firDeclaration;
            if (result2.isPrimary()) {
                for (FirValueParameter valueParameter2 : result2.getValueParameters()) {
                    if (ClassMembersKt.getCorrespondingProperty(valueParameter2) == null) continue;
                    this.moveOrDeleteIrrelevantAnnotations(valueParameter2);
                }
            }
            FirConstructor result$iv = result2;
            this_$iv.setScopes(scopesBefore$iv);
            this_$iv.setStaticScopes(staticScopesBefore$iv);
            return result$iv;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(constructor2, throwable$iv);
            throw null;
        }
    }

    @NotNull
    public FirTypeAlias transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Object data2) {
        FirTypeAlias firTypeAlias;
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            FirTypeResolveTransformer this_$iv = this;
            boolean $i$f$withScopeCleanup = false;
            PersistentList<FirScope> scopesBefore$iv = this_$iv.getScopes();
            PersistentList<FirScope> staticScopesBefore$iv = this_$iv.getStaticScopes();
            boolean bl2 = false;
            this.addTypeParametersScope(typeAlias);
            FirDeclaration result$iv = this.transformDeclaration(typeAlias, data2);
            this_$iv.setScopes(scopesBefore$iv);
            this_$iv.setStaticScopes(staticScopesBefore$iv);
            FirDeclaration firDeclaration = result$iv;
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeAlias");
            firTypeAlias = (FirTypeAlias)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(typeAlias, throwable$iv);
            throw null;
        }
        return firTypeAlias;
    }

    @NotNull
    public FirEnumEntry transformEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable Object data2) {
        FirEnumEntry firEnumEntry;
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            enumEntry.transformReturnTypeRef(this, data2);
            enumEntry.transformTypeParameters(this, data2);
            enumEntry.transformAnnotations(this, data2);
            firEnumEntry = enumEntry;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(enumEntry, throwable$iv);
            throw null;
        }
        return firEnumEntry;
    }

    @Override
    @NotNull
    public FirReceiverParameter transformReceiverParameter(@NotNull FirReceiverParameter receiverParameter, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)receiverParameter, (String)"receiverParameter");
        return receiverParameter.transformAnnotations(this, data2).transformTypeRef(this, data2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FirProperty transformProperty(@NotNull FirProperty property, @Nullable Object data2) {
        FirProperty firProperty;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            FirProperty firProperty2;
            boolean bl = false;
            FirTypeResolveTransformer this_$iv = this;
            boolean $i$f$withScopeCleanup = false;
            PersistentList<FirScope> scopesBefore$iv = this_$iv.getScopes();
            PersistentList<FirScope> staticScopesBefore$iv = this_$iv.getStaticScopes();
            boolean bl2 = false;
            FirTypeResolveTransformer this_$iv2 = this;
            boolean $i$f$withDeclaration = false;
            FirDeclaration oldDeclaration$iv = this_$iv2.currentDeclaration;
            try {
                this_$iv2.currentDeclaration = property;
                boolean bl3 = false;
                this.addTypeParametersScope(property);
                property.transformTypeParameters(this, data2).transformReturnTypeRef(this, data2).transformReceiverParameter(this, data2).transformContextReceivers(this, data2).transformGetter(this, data2).transformSetter(this, data2).transformBackingField(this, data2).transformAnnotations(this, data2);
                if (Intrinsics.areEqual((Object)DeclarationAttributesKt.isFromVararg(property), (Object)true)) {
                    TransformUtilsKt.transformTypeToArrayType(property);
                    FirBackingField firBackingField = property.getBackingField();
                    if (firBackingField != null) {
                        TransformUtilsKt.transformTypeToArrayType(firBackingField);
                    }
                    this.setAccessorTypesByPropertyType(property);
                }
                if (property.getReturnTypeRef() instanceof FirResolvedTypeRef && property.getDelegate() != null) {
                    this.setAccessorTypesByPropertyType(property);
                } else if (!(property.getReturnTypeRef() instanceof FirResolvedTypeRef) && property.getInitializer() == null) {
                    FirPropertyAccessor firPropertyAccessor = property.getGetter();
                    if ((firPropertyAccessor != null ? firPropertyAccessor.getReturnTypeRef() : null) instanceof FirResolvedTypeRef) {
                        Object object;
                        FirPropertyAccessor firPropertyAccessor2 = property.getGetter();
                        Intrinsics.checkNotNull((Object)firPropertyAccessor2);
                        FirTypeRef returnTypeRef = firPropertyAccessor2.getReturnTypeRef();
                        property.replaceReturnTypeRef(UtilsKt.copyWithNewSourceKind(returnTypeRef, KtFakeSourceElementKind.PropertyTypeFromGetterReturnType.INSTANCE));
                        FirBackingField firBackingField = property.getBackingField();
                        if (firBackingField != null) {
                            firBackingField.replaceReturnTypeRef(UtilsKt.copyWithNewSourceKind(returnTypeRef, KtFakeSourceElementKind.PropertyTypeFromGetterReturnType.INSTANCE));
                        }
                        if ((object = property.getSetter()) != null && (object = ((FirPropertyAccessor)object).getValueParameters()) != null) {
                            Iterable $this$forEach$iv = (Iterable)object;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                FirValueParameter it = (FirValueParameter)element$iv;
                                boolean bl4 = false;
                                it.replaceReturnTypeRef(UtilsKt.copyWithNewSourceKind(returnTypeRef, KtFakeSourceElementKind.PropertyTypeFromGetterReturnType.INSTANCE));
                            }
                        }
                    }
                }
                this.unboundCyclesInTypeParametersSupertypes(property);
                this.moveOrDeleteIrrelevantAnnotations(property);
                firProperty2 = property;
            }
            finally {
                this_$iv2.currentDeclaration = oldDeclaration$iv;
            }
            FirProperty result$iv = firProperty2;
            this_$iv.setScopes(scopesBefore$iv);
            this_$iv.setStaticScopes(staticScopesBefore$iv);
            firProperty = result$iv;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(property, throwable$iv);
            throw null;
        }
        return firProperty;
    }

    /*
     * WARNING - void declaration
     */
    private final void setAccessorTypesByPropertyType(FirProperty property) {
        block2: {
            void $this$mapTo$iv$iv;
            Object object;
            FirPropertyAccessor firPropertyAccessor = property.getGetter();
            if (firPropertyAccessor != null) {
                firPropertyAccessor.replaceReturnTypeRef(property.getReturnTypeRef());
            }
            if ((object = property.getSetter()) == null || (object = ((FirPropertyAccessor)object).getValueParameters()) == null) break block2;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                it.replaceReturnTypeRef(property.getReturnTypeRef());
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
    }

    @NotNull
    public FirField transformField(@NotNull FirField field2, @Nullable Object data2) {
        FirField firField;
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            FirTypeResolveTransformer this_$iv = this;
            boolean $i$f$withScopeCleanup = false;
            PersistentList<FirScope> scopesBefore$iv = this_$iv.getScopes();
            PersistentList<FirScope> staticScopesBefore$iv = this_$iv.getStaticScopes();
            boolean bl2 = false;
            field2.transformReturnTypeRef(this, data2).transformAnnotations(this, data2);
            FirField result$iv = field2;
            this_$iv.setScopes(scopesBefore$iv);
            this_$iv.setStaticScopes(staticScopesBefore$iv);
            firField = result$iv;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(field2, throwable$iv);
            throw null;
        }
        return firField;
    }

    @Override
    @NotNull
    public FirStatement transformBackingField(@NotNull FirBackingField backingField2, @Nullable Object data2) {
        FirStatement firStatement;
        Intrinsics.checkNotNullParameter((Object)backingField2, (String)"backingField");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            backingField2.transformAnnotations(this, data2);
            firStatement = super.transformBackingField(backingField2, data2);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(backingField2, throwable$iv);
            throw null;
        }
        return firStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FirSimpleFunction transformSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable Object data2) {
        FirSimpleFunction firSimpleFunction;
        Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            FirDeclaration firDeclaration;
            boolean bl = false;
            FirTypeResolveTransformer this_$iv = this;
            boolean $i$f$withScopeCleanup = false;
            PersistentList<FirScope> scopesBefore$iv = this_$iv.getScopes();
            PersistentList<FirScope> staticScopesBefore$iv = this_$iv.getStaticScopes();
            boolean bl2 = false;
            FirTypeResolveTransformer this_$iv2 = this;
            boolean $i$f$withDeclaration = false;
            FirDeclaration oldDeclaration$iv = this_$iv2.currentDeclaration;
            try {
                FirDeclaration firDeclaration2;
                this_$iv2.currentDeclaration = simpleFunction;
                boolean bl3 = false;
                this.addTypeParametersScope(simpleFunction);
                FirDeclaration it = firDeclaration2 = this.transformDeclaration(simpleFunction, data2);
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner");
                this.unboundCyclesInTypeParametersSupertypes((FirTypeParametersOwner)((Object)it));
                firDeclaration = firDeclaration2;
            }
            finally {
                this_$iv2.currentDeclaration = oldDeclaration$iv;
            }
            FirDeclaration result$iv = firDeclaration;
            this_$iv.setScopes(scopesBefore$iv);
            this_$iv.setStaticScopes(staticScopesBefore$iv);
            FirDeclaration firDeclaration3 = result$iv;
            Intrinsics.checkNotNull((Object)firDeclaration3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirSimpleFunction");
            firSimpleFunction = (FirSimpleFunction)firDeclaration3;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(simpleFunction, throwable$iv);
            throw null;
        }
        return firSimpleFunction;
    }

    private final void unboundCyclesInTypeParametersSupertypes(FirTypeParameterRefsOwner typeParametersOwner) {
        for (FirTypeParameterRef typeParameter2 : typeParametersOwner.getTypeParameters()) {
            FirErrorTypeRefBuilder firErrorTypeRefBuilder;
            if (!(typeParameter2 instanceof FirTypeParameter) || !this.hasSupertypePathToParameter((FirTypeParameter)typeParameter2, (FirTypeParameter)typeParameter2, new LinkedHashSet())) continue;
            boolean $i$f$buildErrorTypeRef = false;
            FirErrorTypeRefBuilder $this$unboundCyclesInTypeParametersSupertypes_u24lambda_u2424 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
            boolean bl = false;
            $this$unboundCyclesInTypeParametersSupertypes_u24lambda_u2424.setDiagnostic(new ConeCyclicTypeBound(typeParameter2.getSymbol(), (ImmutableList<? extends FirTypeRef>)ExtensionsKt.toImmutableList((Iterable)((FirTypeParameter)typeParameter2).getBounds())));
            FirErrorTypeRef errorType = firErrorTypeRefBuilder.build();
            ((FirTypeParameter)typeParameter2).replaceBounds(CollectionsKt.listOf((Object)errorType));
        }
    }

    private final boolean hasSupertypePathToParameter(FirTypeParameter currentTypeParameter, FirTypeParameter typeParameter2, Set<FirTypeParameter> visited2) {
        boolean bl;
        block8: {
            if (!((Collection)visited2).isEmpty() && Intrinsics.areEqual((Object)currentTypeParameter, (Object)typeParameter2)) {
                return true;
            }
            if (!visited2.add(currentTypeParameter)) {
                return false;
            }
            Iterable $this$any$iv = currentTypeParameter.getBounds();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    Object object;
                    FirTypeRef it = (FirTypeRef)element$iv;
                    boolean bl3 = false;
                    FirTypeRef $this$coneTypeSafe$iv = it;
                    boolean $i$f$coneTypeSafe = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeTypeParameterType)) {
                        coneKotlinType = null;
                    }
                    if ((object = (ConeTypeParameterType)((ConeKotlinType)((ConeTypeParameterType)coneKotlinType))) == null || (object = ((ConeTypeParameterType)object).getLookupTag()) == null || (object = ((ConeTypeParameterLookupTag)object).getTypeParameterSymbol()) == null || (object = (FirTypeParameter)((FirBasedSymbol)object).getFir()) == null) {
                        bl2 = false;
                    } else {
                        Object nextTypeParameter = object;
                        bl2 = this.hasSupertypePathToParameter((FirTypeParameter)nextTypeParameter, typeParameter2, visited2);
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public FirTypeRef transformImplicitTypeRef(@NotNull FirImplicitTypeRef implicitTypeRef, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)implicitTypeRef, (String)"implicitTypeRef");
        return implicitTypeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public FirResolvedTypeRef transformTypeRef(@NotNull FirTypeRef typeRef, @Nullable Object data2) {
        FirResolvedTypeRef firResolvedTypeRef;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        FirSpecificTypeResolverTransformer firSpecificTypeResolverTransformer = this.typeResolverTransformer;
        FirFile file$iv = this.currentFile;
        boolean $i$f$withFile = false;
        FirFile oldValue$iv = this_$iv.currentFile;
        this_$iv.currentFile = file$iv;
        try {
            void $this$transformTypeRef_u24lambda_u2426 = this_$iv;
            boolean bl = false;
            PersistentList<? extends FirScope> scopes2 = this.scopes;
            Iterable<FirScope> reversedScopes2 = new Iterable<FirScope>(scopes2){
                final /* synthetic */ PersistentList<FirScope> $scopes;
                {
                    this.$scopes = $scopes;
                }

                @NotNull
                public transformTypeRef.1.reversedScopes.iterator.1 iterator() {
                    return new Iterator<FirScope>(this.$scopes){
                        @NotNull
                        private final ListIterator<FirScope> iter;
                        {
                            this.iter = $scopes.listIterator($scopes.size());
                        }

                        public boolean hasNext() {
                            return this.iter.hasPrevious();
                        }

                        @NotNull
                        public FirScope next() {
                            return this.iter.previous();
                        }

                        public void remove() {
                            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                        }
                    };
                }
            };
            firResolvedTypeRef = (FirResolvedTypeRef)typeRef.transform(this.typeResolverTransformer, new ScopeClassDeclaration(reversedScopes2, (List)this.classDeclarationsStack, null, this.currentDeclaration, 4, null));
        }
        finally {
            this_$iv.currentFile = oldValue$iv;
        }
        return firResolvedTypeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FirStatement transformValueParameter(@NotNull FirValueParameter valueParameter2, @Nullable Object data2) {
        FirValueParameter firValueParameter;
        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            FirValueParameter firValueParameter2;
            boolean bl = false;
            FirTypeResolveTransformer this_$iv = this;
            boolean $i$f$withDeclaration = false;
            FirDeclaration oldDeclaration$iv = this_$iv.currentDeclaration;
            try {
                this_$iv.currentDeclaration = valueParameter2;
                boolean bl2 = false;
                valueParameter2.transformReturnTypeRef(this, data2);
                valueParameter2.transformAnnotations(this, data2);
                TransformUtilsKt.transformVarargTypeToArrayType(valueParameter2);
                firValueParameter2 = valueParameter2;
            }
            finally {
                this_$iv.currentDeclaration = oldDeclaration$iv;
            }
            firValueParameter = firValueParameter2;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(valueParameter2, throwable$iv);
            throw null;
        }
        return firValueParameter;
    }

    @Override
    @NotNull
    public FirStatement transformBlock(@NotNull FirBlock block, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return block;
    }

    @Override
    @NotNull
    public FirStatement transformAnnotation(@NotNull FirAnnotation annotation2, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
        throw null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public FirStatement transformAnnotationCall(@NotNull FirAnnotationCall annotationCall, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            FirTypeRef originalTypeRef = annotationCall.getAnnotationTypeRef();
            if (originalTypeRef instanceof FirResolvedTypeRef) {
                switch (WhenMappings.$EnumSwitchMapping$0[annotationCall.getAnnotationResolvePhase().ordinal()]) {
                    case 1: {
                        if (originalTypeRef instanceof FirErrorTypeRef) {
                            FirAnnotationCall firAnnotationCall;
                            FirAnnotationCall it = firAnnotationCall = annotationCall;
                            boolean bl2 = false;
                            it.replaceAnnotationResolvePhase(FirAnnotationResolvePhase.Types);
                            return firAnnotationCall;
                        }
                        AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
                        throw null;
                    }
                    case 2: {
                        FirErrorTypeRefBuilder firErrorTypeRefBuilder;
                        annotationCall.replaceAnnotationResolvePhase(FirAnnotationResolvePhase.Types);
                        FirTypeRef firTypeRef = ((FirResolvedTypeRef)originalTypeRef).getDelegatedTypeRef();
                        if (firTypeRef == null || (firTypeRef = (FirTypeRef)FirTransformerUtilKt.transformSingle((FirElement)firTypeRef, this, data2)) == null) {
                            return annotationCall;
                        }
                        FirTypeRef alternativeResolvedTypeRef = firTypeRef;
                        ConeKotlinType coneTypeFromCompilerRequiredPhase = FirTypeUtilsKt.getConeType(originalTypeRef);
                        ConeKotlinType coneTypeFromTypesPhase = FirTypeUtilsKt.getConeType(alternativeResolvedTypeRef);
                        if (Intrinsics.areEqual((Object)coneTypeFromTypesPhase, (Object)coneTypeFromCompilerRequiredPhase)) return annotationCall;
                        boolean $i$f$buildErrorTypeRef = false;
                        FirErrorTypeRefBuilder $this$transformAnnotationCall_u24lambda_u2431_u24lambda_u2430 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
                        boolean bl3 = false;
                        $this$transformAnnotationCall_u24lambda_u2431_u24lambda_u2430.setSource(originalTypeRef.getSource());
                        $this$transformAnnotationCall_u24lambda_u2431_u24lambda_u2430.setType(coneTypeFromCompilerRequiredPhase);
                        $this$transformAnnotationCall_u24lambda_u2431_u24lambda_u2430.setDelegatedTypeRef(((FirResolvedTypeRef)originalTypeRef).getDelegatedTypeRef());
                        $this$transformAnnotationCall_u24lambda_u2431_u24lambda_u2430.setDiagnostic(new ConeAmbiguouslyResolvedAnnotationFromPlugin(coneTypeFromCompilerRequiredPhase, coneTypeFromTypesPhase));
                        FirErrorTypeRef errorTypeRef = firErrorTypeRefBuilder.build();
                        annotationCall.replaceAnnotationTypeRef(errorTypeRef);
                    }
                    default: {
                        return annotationCall;
                    }
                }
            } else {
                FirTypeRef transformedTypeRef = (FirTypeRef)FirTransformerUtilKt.transformSingle((FirElement)originalTypeRef, this, data2);
                annotationCall.replaceAnnotationResolvePhase(FirAnnotationResolvePhase.Types);
                annotationCall.replaceAnnotationTypeRef(transformedTypeRef);
            }
            return annotationCall;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(annotationCall, throwable$iv);
            throw null;
        }
    }

    public final <T> T withScopeCleanup(@NotNull Function0<? extends T> l) {
        Intrinsics.checkNotNullParameter(l, (String)"l");
        boolean $i$f$withScopeCleanup = false;
        PersistentList<FirScope> scopesBefore = this.getScopes();
        PersistentList<FirScope> staticScopesBefore = this.getStaticScopes();
        Object result2 = l.invoke();
        this.setScopes(scopesBefore);
        this.setStaticScopes(staticScopesBefore);
        return (T)result2;
    }

    /*
     * WARNING - void declaration
     */
    private final FirStatement resolveClassContent(FirClass firClass, Object data2) {
        void $this$filterIsInstanceTo$iv$iv;
        FirTypeResolveTransformer this_$iv = this;
        boolean $i$f$withClassScopes = false;
        FirTypeResolveTransformer this_$iv$iv = this_$iv;
        boolean $i$f$withScopeCleanup = false;
        PersistentList<FirScope> scopesBefore$iv$iv = this_$iv$iv.getScopes();
        PersistentList<FirScope> staticScopesBefore$iv$iv = this_$iv$iv.getStaticScopes();
        boolean bl = false;
        FirMemberDeclaration $this$isInner$iv$iv = firClass;
        boolean $i$f$isInner = false;
        if (!$this$isInner$iv$iv.getStatus().isInner()) {
            FirClassLikeDeclaration $this$isLocal$iv$iv = firClass;
            boolean $i$f$isLocal = false;
            if (!$this$isLocal$iv$iv.getSymbol().getClassId().isLocal()) {
                this_$iv.setScopes(this_$iv.getStaticScopes());
            }
        }
        boolean bl2 = false;
        FirTypeResolveTransformer this_$iv2 = this;
        boolean $i$f$withScopeCleanup2 = false;
        PersistentList<FirScope> scopesBefore$iv = this_$iv2.getScopes();
        PersistentList<FirScope> staticScopesBefore$iv = this_$iv2.getStaticScopes();
        boolean bl3 = false;
        firClass.transformAnnotations(this, null);
        if (firClass instanceof FirRegularClass) {
            this.addTypeParametersScope(firClass);
        }
        Iterable $this$filterIsInstance$iv = firClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirConstructor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (FirConstructor constructor2 : (List)destination$iv$iv) {
            this.transformDelegatedConstructorCall(constructor2);
        }
        Unit result$iv = Unit.INSTANCE;
        this_$iv2.setScopes(scopesBefore$iv);
        this_$iv2.setStaticScopes(staticScopesBefore$iv);
        FirSession $i$f$isLocal = this_$iv.getSession();
        List superTypes$iv = CollectionsKt.asReversed((List)SupertypeUtilsKt.lookupSuperTypes$default(firClass, false, true, $i$f$isLocal, true, null, 32, null));
        List scopesToAdd$iv = new ArrayList();
        for (ConeClassLikeType superType$iv : superTypes$iv) {
            FirContainingNamesAwareScope nestedClassifierScope$iv;
            if (ScopesKt.getNestedClassifierScope(superType$iv.getLookupTag(), this_$iv.getSession(), this_$iv.getScopeSession()) == null) continue;
            boolean bl4 = false;
            FirContainingNamesAwareScope scope$iv = FirNestedClassifierScopeWithSubstitutionKt.wrapNestedClassifierScopeWithSubstitutionForSuperType(nestedClassifierScope$iv, superType$iv, this_$iv.getSession());
            scopesToAdd$iv.add(scope$iv);
        }
        FirNestedClassifierScope firNestedClassifierScope = FirDeclaredMemberScopeProviderKt.nestedClassifierScope(this_$iv.getSession(), firClass);
        if (firNestedClassifierScope != null) {
            FirScope p0$iv = firNestedClassifierScope;
            boolean bl5 = false;
            scopesToAdd$iv.add(p0$iv);
        }
        if (firClass instanceof FirRegularClass) {
            FirRegularClass companionObject$iv;
            FirRegularClassSymbol firRegularClassSymbol = ((FirRegularClass)firClass).getCompanionObjectSymbol();
            FirRegularClass firRegularClass = companionObject$iv = firRegularClassSymbol != null ? (FirRegularClass)firRegularClassSymbol.getFir() : null;
            if (companionObject$iv != null) {
                FirNestedClassifierScope firNestedClassifierScope2 = FirDeclaredMemberScopeProviderKt.nestedClassifierScope(this_$iv.getSession(), companionObject$iv);
                if (firNestedClassifierScope2 != null) {
                    FirScope p0$iv = firNestedClassifierScope2;
                    boolean bl6 = false;
                    scopesToAdd$iv.add(p0$iv);
                }
            }
            this_$iv.addScopes(scopesToAdd$iv);
            this_$iv.addTypeParametersScope(firClass);
        } else {
            this_$iv.addScopes(scopesToAdd$iv);
        }
        boolean bl7 = false;
        FirClass result$iv$iv = (FirClass)this.transformElement((FirElement)firClass, data2);
        this_$iv$iv.setScopes(scopesBefore$iv$iv);
        this_$iv$iv.setStaticScopes(staticScopesBefore$iv$iv);
        return result$iv$iv;
    }

    public final void transformDelegatedConstructorCall(@NotNull FirConstructor constructor2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
            FirDelegatedConstructorCall firDelegatedConstructorCall = constructor2.getDelegatedConstructor();
            if (firDelegatedConstructorCall == null) break block0;
            FirDelegatedConstructorCall p0 = firDelegatedConstructorCall;
            boolean bl = false;
            this.resolveConstructedTypeRefForDelegatedConstructorCall(p0);
        }
    }

    public final <R> R withClassScopes(@NotNull FirClass firClass, @NotNull Function0<Unit> actionInsideStaticScope, @NotNull Function0<? extends R> action) {
        Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
        Intrinsics.checkNotNullParameter(actionInsideStaticScope, (String)"actionInsideStaticScope");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$withClassScopes = false;
        FirTypeResolveTransformer this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        PersistentList<FirScope> scopesBefore$iv = this_$iv.getScopes();
        PersistentList<FirScope> staticScopesBefore$iv = this_$iv.getStaticScopes();
        boolean bl = false;
        FirMemberDeclaration $this$isInner$iv = firClass;
        boolean $i$f$isInner = false;
        if (!$this$isInner$iv.getStatus().isInner()) {
            FirClassLikeDeclaration $this$isLocal$iv = firClass;
            boolean $i$f$isLocal = false;
            if (!$this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                this.setScopes(this.getStaticScopes());
            }
        }
        actionInsideStaticScope.invoke();
        FirSession $i$f$isLocal = this.getSession();
        List superTypes2 = CollectionsKt.asReversed((List)SupertypeUtilsKt.lookupSuperTypes$default(firClass, false, true, $i$f$isLocal, true, null, 32, null));
        List scopesToAdd = new ArrayList();
        for (ConeClassLikeType superType2 : superTypes2) {
            FirContainingNamesAwareScope nestedClassifierScope;
            if (ScopesKt.getNestedClassifierScope(superType2.getLookupTag(), this.getSession(), this.getScopeSession()) == null) continue;
            boolean bl2 = false;
            FirContainingNamesAwareScope scope2 = FirNestedClassifierScopeWithSubstitutionKt.wrapNestedClassifierScopeWithSubstitutionForSuperType(nestedClassifierScope, superType2, this.getSession());
            scopesToAdd.add(scope2);
        }
        FirNestedClassifierScope firNestedClassifierScope = FirDeclaredMemberScopeProviderKt.nestedClassifierScope(this.getSession(), firClass);
        if (firNestedClassifierScope != null) {
            FirScope p0 = firNestedClassifierScope;
            boolean bl3 = false;
            scopesToAdd.add(p0);
        }
        if (firClass instanceof FirRegularClass) {
            FirRegularClass companionObject2;
            FirRegularClassSymbol firRegularClassSymbol = ((FirRegularClass)firClass).getCompanionObjectSymbol();
            FirRegularClass firRegularClass = companionObject2 = firRegularClassSymbol != null ? (FirRegularClass)firRegularClassSymbol.getFir() : null;
            if (companionObject2 != null) {
                FirNestedClassifierScope firNestedClassifierScope2 = FirDeclaredMemberScopeProviderKt.nestedClassifierScope(this.getSession(), companionObject2);
                if (firNestedClassifierScope2 != null) {
                    FirScope p0 = firNestedClassifierScope2;
                    boolean bl4 = false;
                    scopesToAdd.add(p0);
                }
            }
            this.addScopes(scopesToAdd);
            this.addTypeParametersScope(firClass);
        } else {
            this.addScopes(scopesToAdd);
        }
        Object result$iv = action.invoke();
        this_$iv.setScopes(scopesBefore$iv);
        this_$iv.setStaticScopes(staticScopesBefore$iv);
        return (R)result$iv;
    }

    public static /* synthetic */ Object withClassScopes$default(FirTypeResolveTransformer $this, FirClass firClass, Function0 actionInsideStaticScope, Function0 action, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: withClassScopes");
        }
        if ((n & 2) != 0) {
            actionInsideStaticScope = withClassScopes.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
        Intrinsics.checkNotNullParameter((Object)actionInsideStaticScope, (String)"actionInsideStaticScope");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        boolean $i$f$withClassScopes = false;
        FirTypeResolveTransformer this_$iv = $this;
        boolean $i$f$withScopeCleanup = false;
        PersistentList<FirScope> scopesBefore$iv = this_$iv.getScopes();
        PersistentList<FirScope> staticScopesBefore$iv = this_$iv.getStaticScopes();
        boolean bl = false;
        FirMemberDeclaration $this$isInner$iv = firClass;
        boolean $i$f$isInner = false;
        if (!$this$isInner$iv.getStatus().isInner()) {
            FirClassLikeDeclaration $this$isLocal$iv = firClass;
            boolean $i$f$isLocal = false;
            if (!$this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                $this.setScopes($this.getStaticScopes());
            }
        }
        actionInsideStaticScope.invoke();
        FirSession $i$f$isLocal = $this.getSession();
        List superTypes2 = CollectionsKt.asReversed((List)SupertypeUtilsKt.lookupSuperTypes$default(firClass, false, true, $i$f$isLocal, true, null, 32, null));
        List scopesToAdd = new ArrayList();
        for (ConeClassLikeType superType2 : superTypes2) {
            FirContainingNamesAwareScope nestedClassifierScope;
            if (ScopesKt.getNestedClassifierScope(superType2.getLookupTag(), $this.getSession(), $this.getScopeSession()) == null) continue;
            boolean bl2 = false;
            FirContainingNamesAwareScope scope2 = FirNestedClassifierScopeWithSubstitutionKt.wrapNestedClassifierScopeWithSubstitutionForSuperType(nestedClassifierScope, superType2, $this.getSession());
            scopesToAdd.add(scope2);
        }
        FirNestedClassifierScope firNestedClassifierScope = FirDeclaredMemberScopeProviderKt.nestedClassifierScope($this.getSession(), firClass);
        if (firNestedClassifierScope != null) {
            FirScope p0 = firNestedClassifierScope;
            boolean bl3 = false;
            scopesToAdd.add(p0);
        }
        if (firClass instanceof FirRegularClass) {
            FirRegularClass companionObject2;
            FirRegularClassSymbol firRegularClassSymbol = ((FirRegularClass)firClass).getCompanionObjectSymbol();
            FirRegularClass firRegularClass = companionObject2 = firRegularClassSymbol != null ? (FirRegularClass)firRegularClassSymbol.getFir() : null;
            if (companionObject2 != null) {
                FirNestedClassifierScope firNestedClassifierScope2 = FirDeclaredMemberScopeProviderKt.nestedClassifierScope($this.getSession(), companionObject2);
                if (firNestedClassifierScope2 != null) {
                    FirScope p0 = firNestedClassifierScope2;
                    boolean bl4 = false;
                    scopesToAdd.add(p0);
                }
            }
            $this.addScopes(scopesToAdd);
            $this.addTypeParametersScope(firClass);
        } else {
            $this.addScopes(scopesToAdd);
        }
        Object result$iv = action.invoke();
        this_$iv.setScopes(scopesBefore$iv);
        this_$iv.setStaticScopes(staticScopesBefore$iv);
        return result$iv;
    }

    private final void resolveConstructedTypeRefForDelegatedConstructorCall(FirDelegatedConstructorCall delegatedConstructorCall) {
        delegatedConstructorCall.replaceConstructedTypeRef((FirTypeRef)FirTransformerUtilKt.transformSingle((FirElement)delegatedConstructorCall.getConstructedTypeRef(), this, null));
        delegatedConstructorCall.transformCalleeReference(this, null);
    }

    public final void addTypeParametersScope(@NotNull FirMemberDeclaration firMemberDeclaration) {
        Intrinsics.checkNotNullParameter((Object)firMemberDeclaration, (String)"firMemberDeclaration");
        if (!((Collection)firMemberDeclaration.getTypeParameters()).isEmpty()) {
            this.scopes = this.scopes.add((Object)new FirMemberTypeParameterScope(firMemberDeclaration));
        }
    }

    public final void addScopes(@NotNull List<? extends FirScope> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        boolean scopesAreTheSame = this.scopes == this.staticScopes;
        this.scopes = this.scopes.addAll((Collection)list2);
        this.staticScopes = scopesAreTheSame ? this.scopes : this.staticScopes.addAll((Collection)list2);
    }

    /*
     * WARNING - void declaration
     */
    private final void moveOrDeleteIrrelevantAnnotations(FirVariable $this$moveOrDeleteIrrelevantAnnotations) {
        block11: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            if ($this$moveOrDeleteIrrelevantAnnotations.getAnnotations().isEmpty()) {
                return;
            }
            Lazy backingFieldAnnotations$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<FirAnnotation>>($this$moveOrDeleteIrrelevantAnnotations){
                final /* synthetic */ FirVariable $this_moveOrDeleteIrrelevantAnnotations;
                {
                    this.$this_moveOrDeleteIrrelevantAnnotations = $receiver;
                    super(0);
                }

                @NotNull
                public final List<FirAnnotation> invoke() {
                    Object object = this.$this_moveOrDeleteIrrelevantAnnotations.getBackingField();
                    if (object == null || (object = ((FirBackingField)object).getAnnotations()) == null || (object = CollectionsKt.toMutableList((Collection)((Collection)object))) == null) {
                        object = new ArrayList<E>();
                    }
                    return object;
                }
            }));
            boolean replaceBackingFieldAnnotations = false;
            Iterable iterable = $this$moveOrDeleteIrrelevantAnnotations.getAnnotations();
            FirVariable firVariable = $this$moveOrDeleteIrrelevantAnnotations;
            boolean $i$f$filter = false;
            void var6_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                FirAnnotation annotation2 = (FirAnnotation)element$iv$iv;
                boolean bl2 = false;
                AnnotationUseSiteTarget annotationUseSiteTarget = annotation2.getUseSiteTarget();
                if ((annotationUseSiteTarget == null ? -1 : WhenMappings.$EnumSwitchMapping$1[annotationUseSiteTarget.ordinal()]) == -1) {
                    Set<AnnotationUseSiteTarget> allowedTargets = FirAnnotationUtilsKt.useSiteTargetsFromMetaAnnotation(annotation2, this.session);
                    if ($this$moveOrDeleteIrrelevantAnnotations instanceof FirValueParameter) {
                        bl = allowedTargets.contains((Object)AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER);
                    } else {
                        KtSourceElement ktSourceElement = $this$moveOrDeleteIrrelevantAnnotations.getSource();
                        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE) && allowedTargets.contains((Object)AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER)) {
                            bl = false;
                        } else if ($this$moveOrDeleteIrrelevantAnnotations instanceof FirProperty && $this$moveOrDeleteIrrelevantAnnotations.getBackingField() != null && this.annotationShouldBeMovedToField(allowedTargets)) {
                            ((Collection)FirTypeResolveTransformer.moveOrDeleteIrrelevantAnnotations$lambda$39((Lazy<? extends List<FirAnnotation>>)backingFieldAnnotations$delegate)).add(annotation2);
                            replaceBackingFieldAnnotations = true;
                            bl = false;
                        } else {
                            bl = true;
                        }
                    }
                } else {
                    bl = true;
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            firVariable.replaceAnnotations((List)destination$iv$iv);
            if (!replaceBackingFieldAnnotations) break block11;
            FirBackingField firBackingField = $this$moveOrDeleteIrrelevantAnnotations.getBackingField();
            if (firBackingField != null) {
                firBackingField.replaceAnnotations(FirTypeResolveTransformer.moveOrDeleteIrrelevantAnnotations$lambda$39((Lazy<? extends List<FirAnnotation>>)backingFieldAnnotations$delegate));
            }
        }
    }

    private final boolean annotationShouldBeMovedToField(Set<? extends AnnotationUseSiteTarget> allowedTargets) {
        return (allowedTargets.contains((Object)AnnotationUseSiteTarget.FIELD) || allowedTargets.contains((Object)AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD)) && !allowedTargets.contains((Object)AnnotationUseSiteTarget.PROPERTY);
    }

    private static final List<FirAnnotation> moveOrDeleteIrrelevantAnnotations$lambda$39(Lazy<? extends List<FirAnnotation>> $backingFieldAnnotations$delegate) {
        Lazy<? extends List<FirAnnotation>> lazy = $backingFieldAnnotations$delegate;
        return (List)lazy.getValue();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[FirAnnotationResolvePhase.values().length];
            try {
                nArray[FirAnnotationResolvePhase.Unresolved.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirAnnotationResolvePhase.CompilerRequiredAnnotations.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirAnnotationResolvePhase.Types.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            $EnumSwitchMapping$1 = new int[AnnotationUseSiteTarget.values().length];
        }
    }
}

