/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.LowerPriorityToPreserveCompatibilityDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverDescription;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.ImportedFromObjectOrStaticData;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a:\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u00030\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\f\u0010\f\u001a\u00020\r*\u00020\u0005H\u0002\u001a\u000e\u0010\u000e\u001a\u00020\r*\u0004\u0018\u00010\u000fH\u0002\u001a\f\u0010\u0010\u001a\u00020\r*\u00020\u000fH\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a$\u0010\u0014\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"DYNAMIC_EXTENSION_ANNOTATION_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "findClosestMatchingReceivers", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverDescription;", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "receiverGroups", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitReceiverValue;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "isJavaApplicableCandidate", "", "isSuperCall", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isSuperReferenceExpression", "markCandidateForCompatibilityResolve", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "prepareReceivers", "argumentExtensionReceiverValue", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/ResolutionStagesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 declarationUtils.kt\norg/jetbrains/kotlin/fir/declarations/DeclarationUtilsKt\n*L\n1#1,712:1\n1#2:713\n1549#3:714\n1620#3,3:715\n766#3:718\n857#3,2:719\n116#4:721\n107#4,11:722\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/ResolutionStagesKt\n*L\n243#1:714\n243#1:715,3\n244#1:718\n244#1:719,2\n471#1:721\n471#1:722,11\n*E\n"})
public final class ResolutionStagesKt {
    @NotNull
    private static final ClassId DYNAMIC_EXTENSION_ANNOTATION_CLASS_ID;

    private static final ReceiverDescription prepareReceivers(Candidate $this$prepareReceivers, ReceiverValue argumentExtensionReceiverValue, ConeKotlinType expectedType, ResolutionContext context) {
        ConeKotlinType it = ArgumentsKt.captureFromTypeParameterUpperBoundIfNeeded(argumentExtensionReceiverValue.getType(), expectedType, context.getSession());
        boolean bl = false;
        ConeKotlinType argumentType = ArgumentsKt.prepareCapturedType($this$prepareReceivers, it, context);
        return new ReceiverDescription(argumentExtensionReceiverValue.getReceiverExpression(), argumentType);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ReceiverDescription> findClosestMatchingReceivers(Candidate $this$findClosestMatchingReceivers, ConeKotlinType expectedType, List<? extends List<? extends ImplicitReceiverValue<?>>> receiverGroups, ResolutionContext context) {
        for (List<ImplicitReceiverValue<?>> list2 : receiverGroups) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            ReceiverDescription it;
            boolean bl;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = list2;
            boolean $i$f$map = false;
            void var9_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ImplicitReceiverValue implicitReceiverValue = (ImplicitReceiverValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                bl = false;
                collection.add(ResolutionStagesKt.prepareReceivers($this$findClosestMatchingReceivers, (ReceiverValue)((Object)it), expectedType, context));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ReceiverDescription)element$iv$iv;
                bl = false;
                if (!ConstraintSystemBuilderKt.isSubtypeConstraintCompatible($this$findClosestMatchingReceivers.getSystem(), it.getType(), expectedType, SimpleConstraintSystemConstraintPosition.INSTANCE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List currentResult = (List)destination$iv$iv;
            if (!(!((Collection)currentResult).isEmpty())) continue;
            return currentResult;
        }
        return CollectionsKt.emptyList();
    }

    private static final boolean isSuperCall(FirExpression $this$isSuperCall) {
        if (!($this$isSuperCall instanceof FirQualifiedAccessExpression)) {
            return false;
        }
        return ((FirQualifiedAccessExpression)$this$isSuperCall).getCalleeReference() instanceof FirSuperReference;
    }

    private static final boolean isSuperReferenceExpression(FirExpression $this$isSuperReferenceExpression) {
        boolean bl;
        if ($this$isSuperReferenceExpression instanceof FirQualifiedAccessExpression) {
            FirReference calleeReference = ((FirQualifiedAccessExpression)$this$isSuperReferenceExpression).getCalleeReference();
            bl = calleeReference instanceof FirSuperReference;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isJavaApplicableCandidate(Candidate $this$isJavaApplicableCandidate) {
        boolean bl;
        FirBasedSymbol<?> firBasedSymbol = $this$isJavaApplicableCandidate.getSymbol();
        if (!(firBasedSymbol instanceof FirFunctionSymbol)) return false;
        FirFunctionSymbol firFunctionSymbol = (FirFunctionSymbol)firBasedSymbol;
        if (firFunctionSymbol == null) {
            return false;
        }
        FirFunctionSymbol symbol2 = firFunctionSymbol;
        FirBasedSymbol $this$isJavaOrEnhancement$iv = symbol2;
        boolean $i$f$isJavaOrEnhancement = false;
        FirDeclarationOrigin $this$isJavaOrEnhancement$iv$iv = $this$isJavaOrEnhancement$iv.getOrigin();
        boolean $i$f$isJavaOrEnhancement2 = false;
        if ($this$isJavaOrEnhancement$iv$iv instanceof FirDeclarationOrigin.Java) return true;
        if (Intrinsics.areEqual((Object)$this$isJavaOrEnhancement$iv$iv, (Object)FirDeclarationOrigin.Enhancement.INSTANCE)) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        Object e = $this$isJavaOrEnhancement$iv.getFir();
        Object object = e instanceof FirCallableDeclaration ? (FirCallableDeclaration)e : null;
        if (object != null && (object = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData(object)) != null && (object = ((ImportedFromObjectOrStaticData)object).getOriginal()) != null) {
            if (DeclarationUtilsKt.isJavaOrEnhancement((FirDeclaration)object)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) {
            return true;
        }
        if (!($this$isJavaApplicableCandidate.getOriginScope() instanceof FirTypeScope)) {
            return false;
        }
        if (!(symbol2 instanceof FirNamedFunctionSymbol)) {
            return false;
        }
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        FirTypeScopeKt.processOverriddenFunctions((FirTypeScope)$this$isJavaApplicableCandidate.getOriginScope(), (FirNamedFunctionSymbol)symbol2, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)new Function1<FirNamedFunctionSymbol, ProcessorAction>(result2){
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.$result = $result;
                super(1);
            }

            /*
             * Unable to fully structure code
             */
            @NotNull
            public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                $this$isJavaOrEnhancement$iv = it;
                $i$f$isJavaOrEnhancement = false;
                $this$isJavaOrEnhancement$iv$iv = $this$isJavaOrEnhancement$iv.getOrigin();
                $i$f$isJavaOrEnhancement = false;
                if ($this$isJavaOrEnhancement$iv$iv instanceof FirDeclarationOrigin.Java != false || Intrinsics.areEqual((Object)$this$isJavaOrEnhancement$iv$iv, (Object)FirDeclarationOrigin.Enhancement.INSTANCE) != false) ** GOTO lbl-1000
                var5_6 = $this$isJavaOrEnhancement$iv.getFir();
                v0 = var5_6 instanceof FirCallableDeclaration != false ? (FirCallableDeclaration)var5_6 : null;
                v1 = v0 != null && (v0 = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData(v0)) != null && (v0 = v0.getOriginal()) != null ? DeclarationUtilsKt.isJavaOrEnhancement((FirDeclaration)v0) : false;
                if (v1) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                if (v2) {
                    this.$result.element = true;
                    v3 = ProcessorAction.STOP;
                } else {
                    v3 = ProcessorAction.NEXT;
                }
                return v3;
            }
        }));
        return result2.element;
    }

    private static final void markCandidateForCompatibilityResolve(CheckerSink $this$markCandidateForCompatibilityResolve, ResolutionContext context) {
        if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).supportsFeature(LanguageFeature.DisableCompatibilityModeForNewInference)) {
            return;
        }
        $this$markCandidateForCompatibilityResolve.reportDiagnostic(LowerPriorityToPreserveCompatibilityDiagnostic.INSTANCE);
    }

    public static final /* synthetic */ boolean access$isSuperReferenceExpression(FirExpression $receiver) {
        return ResolutionStagesKt.isSuperReferenceExpression($receiver);
    }

    public static final /* synthetic */ ReceiverDescription access$prepareReceivers(Candidate $receiver, ReceiverValue argumentExtensionReceiverValue, ConeKotlinType expectedType, ResolutionContext context) {
        return ResolutionStagesKt.prepareReceivers($receiver, argumentExtensionReceiverValue, expectedType, context);
    }

    public static final /* synthetic */ boolean access$isSuperCall(FirExpression $receiver) {
        return ResolutionStagesKt.isSuperCall($receiver);
    }

    public static final /* synthetic */ List access$findClosestMatchingReceivers(Candidate $receiver, ConeKotlinType expectedType, List receiverGroups, ResolutionContext context) {
        return ResolutionStagesKt.findClosestMatchingReceivers($receiver, expectedType, receiverGroups, context);
    }

    public static final /* synthetic */ boolean access$isJavaApplicableCandidate(Candidate $receiver) {
        return ResolutionStagesKt.isJavaApplicableCandidate($receiver);
    }

    public static final /* synthetic */ void access$markCandidateForCompatibilityResolve(CheckerSink $receiver, ResolutionContext context) {
        ResolutionStagesKt.markCandidateForCompatibilityResolve($receiver, context);
    }

    public static final /* synthetic */ ClassId access$getDYNAMIC_EXTENSION_ANNOTATION_CLASS_ID$p() {
        return DYNAMIC_EXTENSION_ANNOTATION_CLASS_ID;
    }

    static {
        ClassId classId = ClassId.topLevel(AnnotationsForResolveKt.getDYNAMIC_EXTENSION_FQ_NAME());
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(DYNAMIC_EXTENSION_FQ_NAME)");
        DYNAMIC_EXTENSION_ANNOTATION_CLASS_ID = classId;
    }
}

