/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayDeque;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ir.IrInlinable;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.JVMAssertionsMode;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrThrowImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002:\u0001%B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020 2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\u001e\u0010!\u001a\u00020\"*\u00020\u00112\u0006\u0010#\u001a\u00020\u000f2\b\u0010$\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\r\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/AssertionLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lorg/jetbrains/kotlin/backend/jvm/lower/AssertionLowering$ClassInfo;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "scopeOwnerStack", "Ljava/util/ArrayDeque;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isAssert", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "getAssertionDisabled", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "irBuilder", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "data", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitCall", "Lorg/jetbrains/kotlin/ir/IrElement;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "checkAssertion", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "assertCondition", "lambdaArgument", "ClassInfo", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nAssertionLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssertionLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/AssertionLowering\n+ 2 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 3 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n*L\n1#1,121:1\n377#2,13:122\n98#3,2:135\n*S KotlinDebug\n*F\n+ 1 AssertionLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/AssertionLowering\n*L\n103#1:122,13\n103#1:135,2\n*E\n"})
final class AssertionLowering
implements FileLoweringPass,
IrElementTransformer<ClassInfo> {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final ArrayDeque<IrDeclaration> scopeOwnerStack;

    public AssertionLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.scopeOwnerStack = new ArrayDeque();
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (this.context.getState().getAssertionsMode() != JVMAssertionsMode.LEGACY) {
            irFile.transformChildren(this, null);
        }
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable ClassInfo data2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.scopeOwnerStack.push(declaration);
        IrStatement result2 = IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration, data2);
        this.scopeOwnerStack.pop();
        return result2;
    }

    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration, @Nullable ClassInfo data2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Object object = data2;
            if (object == null || (object = ((ClassInfo)object).getTopLevelClass()) == null) {
                object = declaration;
            }
            ClassInfo info = new ClassInfo(declaration, (IrClass)object, null, 4, null);
            this.visitDeclaration((IrDeclarationBase)declaration, info);
            IrField irField = info.getAssertionsDisabledField();
            if (irField == null) break block1;
            IrField it = irField;
            boolean bl = false;
            declaration.getDeclarations().add(0, it);
        }
        return declaration;
    }

    @Override
    @NotNull
    public IrElement visitCall(@NotNull IrCall expression2, @Nullable ClassInfo data2) {
        IrElement irElement;
        IrExpression lambdaArgument;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunction function2 = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (!this.isAssert(function2)) {
            return IrElementTransformer.DefaultImpls.visitCall(this, expression2, data2);
        }
        JVMAssertionsMode mode = this.context.getState().getAssertionsMode();
        if (mode == JVMAssertionsMode.ALWAYS_DISABLE) {
            return new IrCompositeImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.context.getIrBuiltIns().getUnitType(), null, 8, null);
        }
        DeclarationIrBuilder $this$visitCall_u24lambda_u241 = LowerUtilsKt.createIrBuilder$default(this.context, this.scopeOwnerStack.peek().getSymbol(), 0, 0, 6, null);
        boolean bl = false;
        LowerUtilsKt.at((IrBuilder)$this$visitCall_u24lambda_u241, expression2);
        IrExpression irExpression = expression2.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression);
        IrExpression assertCondition = irExpression;
        IrExpression irExpression2 = lambdaArgument = function2.getValueParameters().size() == 2 ? expression2.getValueArgument(1) : null;
        if (mode == JVMAssertionsMode.ALWAYS_ENABLE) {
            irElement = this.checkAssertion($this$visitCall_u24lambda_u241, assertCondition, lambdaArgument);
        } else {
            if (!(mode == JVMAssertionsMode.JVM && data2 != null)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            irElement = LowerUtilsKt.irIfThen($this$visitCall_u24lambda_u241, LowerUtilsKt.irNot($this$visitCall_u24lambda_u241, this.getAssertionDisabled($this$visitCall_u24lambda_u241, data2)), this.checkAssertion($this$visitCall_u24lambda_u241, assertCondition, lambdaArgument));
        }
        return irElement;
    }

    /*
     * WARNING - void declaration
     */
    private final IrContainerExpression checkAssertion(IrBuilderWithScope $this$checkAssertion, IrExpression assertCondition, IrExpression lambdaArgument) {
        void $this$checkAssertion_u24lambda_u243_u24lambda_u242;
        IrConstructorCall irConstructorCall2;
        void this_$iv$iv;
        IrBuilderWithScope $this$irBlock_u24default$iv = $this$checkAssertion;
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$checkAssertion_u24lambda_u243 = this_$iv$iv;
        boolean bl = false;
        IrExpression irExpression = lambdaArgument;
        IrInlinable generator2 = irExpression != null ? IrInlineUtilsKt.asInlinable(irExpression, (IrStatementsBuilder)$this$checkAssertion_u24lambda_u243) : null;
        IrConstructorSymbol constructor2 = this.context.getIr().getSymbols().getAssertionErrorConstructor();
        IrConstructorCall irConstructorCall3 = irConstructorCall2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$checkAssertion_u24lambda_u243, constructor2);
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$checkAssertion_u24lambda_u243;
        boolean bl2 = false;
        Object object = generator2;
        if (object == null || (object = IrInlineUtilsKt.inline$default((IrInlinable)object, ExpressionHelpersKt.getParent((IrBuilderWithScope)$this$checkAssertion_u24lambda_u243), null, 2, null)) == null) {
            object = ExpressionHelpersKt.irString((IrBuilderWithScope)$this$checkAssertion_u24lambda_u243, "Assertion failed");
        }
        $this$checkAssertion_u24lambda_u243_u24lambda_u242.putValueArgument(0, (IrExpression)object);
        IrThrowImpl throwError = LowerUtilsKt.irThrow(irBuilderWithScope, irConstructorCall2);
        $this$checkAssertion_u24lambda_u243.unaryPlus(LowerUtilsKt.irIfThen((IrBuilderWithScope)$this$checkAssertion_u24lambda_u243, LowerUtilsKt.irNot((IrBuilderWithScope)$this$checkAssertion_u24lambda_u243, assertCondition), throwError));
        return this_$iv$iv.doBuild();
    }

    private final IrExpression getAssertionDisabled(IrBuilderWithScope irBuilder, ClassInfo data2) {
        if (data2.getAssertionsDisabledField() == null) {
            data2.setAssertionsDisabledField(JvmIrUtilsKt.buildAssertionsDisabledField(data2.getIrClass(), this.context, data2.getTopLevelClass()));
        }
        IrField irField = data2.getAssertionsDisabledField();
        Intrinsics.checkNotNull((Object)irField);
        return ExpressionHelpersKt.irGetField$default(irBuilder, null, irField, null, 4, null);
    }

    private final boolean isAssert(IrFunction $this$isAssert) {
        return Intrinsics.areEqual((Object)$this$isAssert.getName().asString(), (Object)"assert") && Intrinsics.areEqual((Object)IrUtilsKt.getPackageFragment($this$isAssert).getFqName(), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME);
    }

    @Override
    @NotNull
    public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrBody visitBlockBody(@NotNull IrBlockBody body2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitBlockBody(this, body2, data2);
    }

    @Override
    @NotNull
    public IrBody visitBody(@NotNull IrBody body2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitBody(this, body2, data2);
    }

    @Override
    @NotNull
    public IrBranch visitBranch(@NotNull IrBranch branch, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data2);
    }

    @Override
    @NotNull
    public IrExpression visitBreak(@NotNull IrBreak jump, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data2);
    }

    @Override
    @NotNull
    public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data2);
    }

    @Override
    @NotNull
    public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrCatch visitCatch(@NotNull IrCatch aCatch, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data2);
    }

    @Override
    @NotNull
    public IrExpression visitClassReference(@NotNull IrClassReference expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitComposite(@NotNull IrComposite expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitConst(@NotNull IrConst<?> expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantArray(@NotNull IrConstantArray expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitConstantArray(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantObject(@NotNull IrConstantObject expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitConstantObject(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantValue(@NotNull IrConstantValue expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitConstantValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitConstructor(@NotNull IrConstructor declaration, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitConstructorCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitContainerExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitContinue(@NotNull IrContinue jump, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitElement(@NotNull IrElement element, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitElement(this, element, data2);
    }

    @Override
    @NotNull
    public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data2);
    }

    @Override
    @NotNull
    public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitExpression(@NotNull IrExpression expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body2, data2);
    }

    @Override
    @NotNull
    public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitField(@NotNull IrField declaration, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitField(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrFile visitFile(@NotNull IrFile declaration, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitFile(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitFunction(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitFunctionExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetClass(@NotNull IrGetClass expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitGetValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitLoop(@NotNull IrLoop loop2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitLoop(this, loop2, data2);
    }

    @Override
    @NotNull
    public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitProperty(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitScript(@NotNull IrScript declaration, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitScript(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSetValue(@NotNull IrSetValue expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitSetValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data2);
    }

    @Override
    @NotNull
    public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitThrow(@NotNull IrThrow expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitTry(@NotNull IrTry aTry, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data2);
    }

    @Override
    @NotNull
    public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitValueParameter(@NotNull IrValueParameter declaration, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitVariable(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitWhen(@NotNull IrWhen expression2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitWhen(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable ClassInfo data2) {
        return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop2, data2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/AssertionLowering$ClassInfo;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "topLevelClass", "assertionsDisabledField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/declarations/IrField;)V", "getAssertionsDisabledField", "()Lorg/jetbrains/kotlin/ir/declarations/IrField;", "setAssertionsDisabledField", "(Lorg/jetbrains/kotlin/ir/declarations/IrField;)V", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getTopLevelClass", "backend.jvm.lower"})
    public static final class ClassInfo {
        @NotNull
        private final IrClass irClass;
        @NotNull
        private final IrClass topLevelClass;
        @Nullable
        private IrField assertionsDisabledField;

        public ClassInfo(@NotNull IrClass irClass2, @NotNull IrClass topLevelClass2, @Nullable IrField assertionsDisabledField) {
            Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
            Intrinsics.checkNotNullParameter((Object)topLevelClass2, (String)"topLevelClass");
            this.irClass = irClass2;
            this.topLevelClass = topLevelClass2;
            this.assertionsDisabledField = assertionsDisabledField;
        }

        public /* synthetic */ ClassInfo(IrClass irClass2, IrClass irClass3, IrField irField, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                irField = null;
            }
            this(irClass2, irClass3, irField);
        }

        @NotNull
        public final IrClass getIrClass() {
            return this.irClass;
        }

        @NotNull
        public final IrClass getTopLevelClass() {
            return this.topLevelClass;
        }

        @Nullable
        public final IrField getAssertionsDisabledField() {
            return this.assertionsDisabledField;
        }

        public final void setAssertionsDisabledField(@Nullable IrField irField) {
            this.assertionsDisabledField = irField;
        }
    }
}

