/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.InlineableResult;
import org.jetbrains.kotlin.js.inline.clean.RemoveDefaultInitializersKt;
import org.jetbrains.kotlin.js.inline.context.InliningContext;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import org.jetbrains.kotlin.js.inline.util.NamingUtilsKt;
import org.jetbrains.kotlin.js.inline.util.RewriteUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.ReturnReplacingVisitor;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 92\u00020\u0001:\u00019B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\"\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007H\u0002J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J\b\u0010\u000f\u001a\u00020)H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\u00032\u0006\u0010+\u001a\u00020(H\u0002J\u0006\u0010,\u001a\u00020)J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020.0'H\u0002J\b\u0010/\u001a\u00020)H\u0002J\n\u00100\u001a\u0004\u0018\u00010\u001bH\u0002J\b\u00101\u001a\u00020)H\u0002J\u0010\u00102\u001a\u0002032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u00104\u001a\u00020#H\u0002J\b\u00105\u001a\u00020#H\u0002J\u0010\u00106\u001a\u00020#2\u0006\u00107\u001a\u00020\nH\u0002J\u0010\u00108\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/js/inline/FunctionInlineMutator;", "", "call", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "inliningContext", "Lorg/jetbrains/kotlin/js/inline/context/InliningContext;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;Lorg/jetbrains/kotlin/js/inline/context/InliningContext;Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;)V", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "getBody", "()Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "breakLabel", "Lorg/jetbrains/kotlin/js/backend/ast/JsLabel;", "getBreakLabel", "()Lorg/jetbrains/kotlin/js/backend/ast/JsLabel;", "setBreakLabel", "(Lorg/jetbrains/kotlin/js/backend/ast/JsLabel;)V", "currentStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "invokedFunction", "namingContext", "Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "getNamingContext", "()Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "resultExpr", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "getResultExpr", "()Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "setResultExpr", "(Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;)V", "resultName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "applyCapturedArgs", "", "inner", "outer", "getArguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "", "getInnerCall", "qualifier", "getLabelPrefix", "getParameters", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "getResultLabel", "getResultReference", "getThisAlias", "isResultNeeded", "", "process", "processReturns", "replaceThis", "block", "uncoverClosure", "Companion", "js.translator"})
@SourceDebugExtension(value={"SMAP\nFunctionInlineMutator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionInlineMutator.kt\norg/jetbrains/kotlin/js/inline/FunctionInlineMutator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n1#2:214\n*E\n"})
public final class FunctionInlineMutator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsInvocation call;
    @NotNull
    private final InliningContext inliningContext;
    @NotNull
    private final JsFunction invokedFunction;
    @NotNull
    private final NamingContext namingContext;
    @NotNull
    private final JsBlock body;
    @Nullable
    private JsNameRef resultExpr;
    @Nullable
    private JsName resultName;
    @Nullable
    private JsLabel breakLabel;
    @Nullable
    private final JsStatement currentStatement;

    private FunctionInlineMutator(JsInvocation call2, InliningContext inliningContext, JsFunction function2) {
        this.call = call2;
        this.inliningContext = inliningContext;
        this.namingContext = this.inliningContext.newNamingContext();
        this.currentStatement = this.inliningContext.getCurrentStatement();
        JsFunction jsFunction = function2.deepCopy();
        Intrinsics.checkNotNullExpressionValue((Object)jsFunction, (String)"deepCopy(...)");
        this.invokedFunction = this.uncoverClosure(jsFunction);
        JsBlock jsBlock = this.invokedFunction.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        this.body = jsBlock;
    }

    @NotNull
    public final NamingContext getNamingContext() {
        return this.namingContext;
    }

    @NotNull
    public final JsBlock getBody() {
        return this.body;
    }

    @Nullable
    public final JsNameRef getResultExpr() {
        return this.resultExpr;
    }

    public final void setResultExpr(@Nullable JsNameRef jsNameRef) {
        this.resultExpr = jsNameRef;
    }

    @Nullable
    public final JsLabel getBreakLabel() {
        return this.breakLabel;
    }

    public final void setBreakLabel(@Nullable JsLabel jsLabel) {
        this.breakLabel = jsLabel;
    }

    /*
     * WARNING - void declaration
     */
    private final void process() {
        JsNameRef jsNameRef;
        List<JsExpression> arguments2 = null;
        arguments2 = this.getArguments();
        List<JsParameter> parameters2 = this.getParameters();
        if (arguments2.size() > parameters2.size()) {
            boolean bl;
            boolean bl2 = bl = arguments2.size() == parameters2.size() + 1;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "arguments.size (" + arguments2.size() + ") may only exceed the parameters.size (" + parameters2.size() + ") by one and only in case of suspend conversions";
                throw new AssertionError((Object)string2);
            }
            arguments2 = arguments2.subList(0, parameters2.size());
        }
        RemoveDefaultInitializersKt.removeDefaultInitializers(arguments2, parameters2, this.body);
        NamingUtilsKt.aliasArgumentsIfNeeded(this.namingContext, arguments2, parameters2, this.call.getSource());
        NamingUtilsKt.renameLocalNames(this.namingContext, this.invokedFunction);
        this.processReturns();
        this.namingContext.applyRenameTo(this.body);
        FunctionInlineMutator functionInlineMutator = this;
        JsNameRef jsNameRef2 = this.resultExpr;
        if (jsNameRef2 != null) {
            void it;
            JsNameRef jsNameRef3 = jsNameRef2;
            FunctionInlineMutator functionInlineMutator2 = functionInlineMutator;
            boolean bl = false;
            JsNode jsNode = this.namingContext.applyRenameTo((JsNode)it);
            Intrinsics.checkNotNull((Object)jsNode, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsNameRef");
            jsNameRef = (JsNameRef)jsNode;
            functionInlineMutator = functionInlineMutator2;
        } else {
            jsNameRef = null;
        }
        functionInlineMutator.resultExpr = jsNameRef;
    }

    private final JsFunction uncoverClosure(JsFunction invokedFunction) {
        JsFunction jsFunction;
        JsFunction innerFunction = FunctionUtilsKt.getInnerFunction(invokedFunction);
        JsExpression jsExpression = this.call.getQualifier();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getQualifier(...)");
        JsInvocation innerCall = this.getInnerCall(jsExpression);
        if (innerCall != null && innerFunction != null) {
            JsFunction jsFunction2;
            JsFunction $this$uncoverClosure_u24lambda_u242 = jsFunction2 = innerFunction;
            boolean bl = false;
            JsBlock jsBlock = $this$uncoverClosure_u24lambda_u242.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
            this.replaceThis(jsBlock);
            this.applyCapturedArgs(innerCall, $this$uncoverClosure_u24lambda_u242, invokedFunction);
            jsFunction = jsFunction2;
        } else {
            JsFunction jsFunction3;
            JsFunction $this$uncoverClosure_u24lambda_u243 = jsFunction3 = invokedFunction;
            boolean bl = false;
            JsBlock jsBlock = $this$uncoverClosure_u24lambda_u243.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
            this.replaceThis(jsBlock);
            jsFunction = jsFunction3;
        }
        return jsFunction;
    }

    private final JsInvocation getInnerCall(JsExpression qualifier2) {
        JsInvocation jsInvocation;
        JsExpression jsExpression = qualifier2;
        if (jsExpression instanceof JsInvocation) {
            jsInvocation = (JsInvocation)qualifier2;
        } else if (jsExpression instanceof JsNameRef) {
            JsExpression callee;
            JsExpression jsExpression2;
            if (Intrinsics.areEqual((Object)((JsNameRef)qualifier2).getIdent(), (Object)"call")) {
                jsExpression2 = ((JsNameRef)qualifier2).getQualifier();
            } else {
                JsName jsName = ((JsNameRef)qualifier2).getName();
                JsNode jsNode = jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
                jsExpression2 = jsNode instanceof JsExpression ? (JsExpression)jsNode : null;
            }
            JsExpression jsExpression3 = callee = jsExpression2;
            if (jsExpression3 != null) {
                JsExpression it = jsExpression3;
                boolean bl = false;
                jsInvocation = this.getInnerCall(it);
            } else {
                jsInvocation = null;
            }
        } else {
            jsInvocation = null;
        }
        return jsInvocation;
    }

    private final void applyCapturedArgs(JsInvocation call2, JsFunction inner, JsFunction outer) {
        NamingContext namingContext = this.inliningContext.newNamingContext();
        List<JsExpression> list2 = call2.getArguments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getArguments(...)");
        List<JsExpression> arguments2 = list2;
        List<JsParameter> list3 = outer.getParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getParameters(...)");
        List<JsParameter> parameters2 = list3;
        NamingUtilsKt.aliasArgumentsIfNeeded(namingContext, arguments2, parameters2, call2.getSource());
        namingContext.applyRenameTo(inner);
    }

    private final void replaceThis(JsBlock block) {
        if (!FunctionInlineMutator.Companion.hasThisReference(block)) {
            return;
        }
        JsExpression thisReplacement = FunctionInlineMutator.Companion.getThisReplacement(this.call);
        if (thisReplacement == null || thisReplacement instanceof JsThisRef) {
            return;
        }
        JsName jsName = JsScope.declareTemporaryName(this.getThisAlias());
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"declareTemporaryName(...)");
        JsName thisName = jsName;
        this.namingContext.newVar(thisName, thisReplacement, this.call.getSource());
        thisReplacement = thisName.makeRef();
        RewriteUtilsKt.replaceThisReference((JsNode)block, thisReplacement);
    }

    /*
     * WARNING - void declaration
     */
    private final void processReturns() {
        void $this$processReturns_u24lambda_u245;
        JsLabel jsLabel;
        this.resultExpr = this.getResultReference();
        JsName jsName = JsScope.declareTemporaryName(this.getBreakLabel());
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"declareTemporaryName(...)");
        JsName breakName = jsName;
        JsLabel jsLabel2 = jsLabel = new JsLabel(breakName);
        FunctionInlineMutator functionInlineMutator = this;
        boolean bl = false;
        MetadataProperties.setSynthetic((HasMetadata)$this$processReturns_u24lambda_u245, true);
        functionInlineMutator.breakLabel = jsLabel;
        ReturnReplacingVisitor visitor2 = new ReturnReplacingVisitor(this.resultExpr, breakName.makeRef(), this.invokedFunction, MetadataProperties.isSuspend(this.call));
        visitor2.accept((JsNode)this.body);
    }

    private final JsNameRef getResultReference() {
        JsName resultName;
        if (!this.isResultNeeded(this.call)) {
            return null;
        }
        JsName jsName = JsScope.declareTemporaryName(this.getResultLabel());
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"declareTemporaryName(...)");
        this.resultName = resultName = jsName;
        NamingContext.newVar$default(this.namingContext, resultName, null, this.call.getSource(), 2, null);
        return resultName.makeRef();
    }

    private final List<JsExpression> getArguments() {
        List<JsExpression> list2 = this.call.getArguments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getArguments(...)");
        List<JsExpression> arguments2 = list2;
        if (InvocationUtilsKt.isCallInvocation(this.call)) {
            return arguments2.subList(1, arguments2.size());
        }
        return arguments2;
    }

    private final boolean isResultNeeded(JsInvocation call2) {
        return !(this.currentStatement instanceof JsExpressionStatement) || !Intrinsics.areEqual((Object)call2, (Object)((JsExpressionStatement)this.currentStatement).getExpression());
    }

    private final List<JsParameter> getParameters() {
        List<JsParameter> list2 = this.invokedFunction.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getParameters(...)");
        return list2;
    }

    private final String getResultLabel() {
        return this.getLabelPrefix() + "result";
    }

    private final String getBreakLabel() {
        return this.getLabelPrefix() + "break";
    }

    private final String getThisAlias() {
        return "$this";
    }

    @NotNull
    public final String getLabelPrefix() {
        String labelPrefix;
        String ident = InvocationUtilsKt.getSimpleIdent(this.call);
        String string2 = ident;
        if (string2 == null) {
            string2 = "inline$";
        }
        if (StringsKt.endsWith$default((String)(labelPrefix = string2), (String)"$", (boolean)false, (int)2, null)) {
            return labelPrefix;
        }
        return labelPrefix + '$';
    }

    @JvmStatic
    @NotNull
    public static final InlineableResult getInlineableCallReplacement(@NotNull JsInvocation call2, @NotNull JsFunction function2, @NotNull InliningContext inliningContext) {
        return Companion.getInlineableCallReplacement(call2, function2, inliningContext);
    }

    @JvmStatic
    private static final JsExpression getThisReplacement(JsInvocation call2) {
        return FunctionInlineMutator.Companion.getThisReplacement(call2);
    }

    public /* synthetic */ FunctionInlineMutator(JsInvocation call2, InliningContext inliningContext, JsFunction function2, DefaultConstructorMarker $constructor_marker) {
        this(call2, inliningContext, function2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/js/inline/FunctionInlineMutator$Companion;", "", "()V", "getInlineableCallReplacement", "Lorg/jetbrains/kotlin/js/inline/InlineableResult;", "call", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "inliningContext", "Lorg/jetbrains/kotlin/js/inline/context/InliningContext;", "getThisReplacement", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "hasThisReference", "", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "js.translator"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final InlineableResult getInlineableCallReplacement(@NotNull JsInvocation call2, @NotNull JsFunction function2, @NotNull InliningContext inliningContext) {
            Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            Intrinsics.checkNotNullParameter((Object)inliningContext, (String)"inliningContext");
            FunctionInlineMutator mutator = new FunctionInlineMutator(call2, inliningContext, function2, null);
            mutator.process();
            JsStatement inlineableBody = mutator.getBody();
            JsLabel breakLabel = mutator.getBreakLabel();
            if (breakLabel != null) {
                breakLabel.setStatement(inlineableBody);
                inlineableBody = breakLabel;
            }
            return new InlineableResult(inlineableBody, mutator.getResultExpr());
        }

        @JvmStatic
        private final JsExpression getThisReplacement(JsInvocation call2) {
            if (InvocationUtilsKt.isCallInvocation(call2)) {
                return call2.getArguments().get(0);
            }
            if (InvocationUtilsKt.hasCallerQualifier(call2)) {
                return InvocationUtilsKt.getCallerQualifier(call2);
            }
            return null;
        }

        private final boolean hasThisReference(JsBlock body2) {
            List<JsThisRef> thisRefs = CollectUtilsKt.collectInstances(JsThisRef.class, body2);
            return !thisRefs.isEmpty();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

