/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0002J\u001c\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0002J,\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0002J\f\u0010\u001c\u001a\u00020\r*\u00020\u000fH\u0002J\f\u0010\u001c\u001a\u00020\r*\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\r*\u00020\u001dH\u0002J\u0014\u0010\u001f\u001a\u00020\r*\u00020\u001d2\u0006\u0010\u0018\u001a\u00020 H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeReplacedWithOperatorAssignmentChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVariableAssignmentChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isCommutativeOperator", "", "operator", "Lcom/intellij/lang/LighterASTNode;", "isHierarchicallyTrue", "currentOperation", "Lcom/intellij/psi/tree/IElementType;", "nextOperation", "isLightNodesHierarchicallyTrue", "first", "second", "lightTreeMatcher", "variable", "source", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "prevOperator", "canBeAugmented", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "isCommutative", "matcher", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "checkers"})
@SourceDebugExtension(value={"SMAP\nCanBeReplacedWithOperatorAssignmentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanBeReplacedWithOperatorAssignmentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeReplacedWithOperatorAssignmentChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n288#2,2:146\n1855#2,2:148\n1#3:150\n*S KotlinDebug\n*F\n+ 1 CanBeReplacedWithOperatorAssignmentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeReplacedWithOperatorAssignmentChecker\n*L\n79#1:146,2\n85#1:148,2\n*E\n"})
public final class CanBeReplacedWithOperatorAssignmentChecker
extends FirExpressionChecker<FirVariableAssignment> {
    @NotNull
    public static final CanBeReplacedWithOperatorAssignmentChecker INSTANCE = new CanBeReplacedWithOperatorAssignmentChecker();

    private CanBeReplacedWithOperatorAssignmentChecker() {
    }

    @Override
    public void check(@NotNull FirVariableAssignment expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirReference lValue = FirExpressionUtilKt.getCalleeReference(expression2);
        if (!(lValue instanceof FirResolvedNamedReference)) {
            return;
        }
        KtSourceElement ktSourceElement = expression2.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        FirExpression firExpression2 = expression2.getRValue();
        FirFunctionCall firFunctionCall = firExpression2 instanceof FirFunctionCall ? (FirFunctionCall)firExpression2 : null;
        if (firFunctionCall == null) {
            return;
        }
        FirFunctionCall rValue = firFunctionCall;
        KtSourceElement ktSourceElement2 = rValue.getSource();
        if ((ktSourceElement2 != null ? ktSourceElement2.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        Object object = rValue.getExplicitReceiver();
        if (!(object != null && (object = ((FirExpression)object).getTypeRef()) != null && (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) != null ? ConeBuiltinTypeUtilsKt.isPrimitive((ConeKotlinType)object) : false)) {
            return;
        }
        FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(rValue);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol<?> rValueResolvedSymbol = firCallableSymbol;
        ConeClassLikeType coneClassLikeType = ClassMembersKt.dispatchReceiverClassTypeOrNull(rValueResolvedSymbol);
        if (!(coneClassLikeType != null ? ConeBuiltinTypeUtilsKt.isPrimitive(coneClassLikeType) : false)) {
            return;
        }
        boolean needToReport = false;
        KtSourceElement assignmentSource = expression2.getSource();
        if (assignmentSource instanceof KtPsiSourceElement) {
            PsiElement psiElement = UtilsKt.getPsi(lValue);
            KtNameReferenceExpression ktNameReferenceExpression = psiElement instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)psiElement : null;
            if (ktNameReferenceExpression == null) {
                return;
            }
            KtNameReferenceExpression lValuePsi = ktNameReferenceExpression;
            PsiElement psiElement2 = UtilsKt.getPsi(rValue);
            KtBinaryExpression ktBinaryExpression = psiElement2 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement2 : null;
            if (ktBinaryExpression == null) {
                return;
            }
            KtBinaryExpression rValuePsi = ktBinaryExpression;
            if (this.matcher(rValuePsi, lValuePsi)) {
                needToReport = true;
            }
        } else if (assignmentSource instanceof KtLightSourceElement) {
            KtSourceElement ktSourceElement3 = ((FirResolvedNamedReference)lValue).getSource();
            Intrinsics.checkNotNull((Object)ktSourceElement3);
            LighterASTNode lValueLightTree = ktSourceElement3.getLighterASTNode();
            KtSourceElement ktSourceElement4 = rValue.getSource();
            Intrinsics.checkNotNull((Object)ktSourceElement4);
            LighterASTNode rValueLightTree = ktSourceElement4.getLighterASTNode();
            if (CanBeReplacedWithOperatorAssignmentChecker.lightTreeMatcher$default(this, lValueLightTree, rValueLightTree, (KtLightSourceElement)assignmentSource, null, 8, null)) {
                needToReport = true;
            }
        }
        if (needToReport) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getCAN_BE_REPLACED_WITH_OPERATOR_ASSIGNMENT(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean lightTreeMatcher(LighterASTNode variable2, LighterASTNode expression2, KtLightSourceElement source, LighterASTNode prevOperator) {
        Object v0;
        List<LighterASTNode> children2;
        block6: {
            FlyweightCapableTreeStructure<LighterASTNode> tree = source.getTreeStructure();
            children2 = LightTreeUtilsKt.getChildren(expression2, tree);
            Iterable $this$firstOrNull$iv = children2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LighterASTNode it = (LighterASTNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.OPERATION_REFERENCE)) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        LighterASTNode operator = v0;
        if (prevOperator != null && !this.isLightNodesHierarchicallyTrue(prevOperator, operator)) {
            return false;
        }
        LighterASTNode lighterASTNode2 = operator;
        boolean bl = lighterASTNode2 != null ? !this.canBeAugmented(lighterASTNode2) : false;
        if (bl) {
            return false;
        }
        boolean commutative = operator != null && this.isCommutativeOperator(operator);
        boolean afterOperatorNode = false;
        Iterable $this$forEach$iv = children2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LighterASTNode it = (LighterASTNode)element$iv;
            boolean bl2 = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.REFERENCE_EXPRESSION)) {
                if (!commutative && afterOperatorNode || !Intrinsics.areEqual((Object)it.toString(), (Object)variable2.toString())) continue;
                return true;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BINARY_EXPRESSION)) {
                return INSTANCE.lightTreeMatcher(variable2, it, source, operator);
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.OPERATION_REFERENCE)) continue;
            afterOperatorNode = true;
        }
        return false;
    }

    static /* synthetic */ boolean lightTreeMatcher$default(CanBeReplacedWithOperatorAssignmentChecker canBeReplacedWithOperatorAssignmentChecker, LighterASTNode lighterASTNode2, LighterASTNode lighterASTNode3, KtLightSourceElement ktLightSourceElement, LighterASTNode lighterASTNode4, int n, Object object) {
        if ((n & 8) != 0) {
            lighterASTNode4 = null;
        }
        return canBeReplacedWithOperatorAssignmentChecker.lightTreeMatcher(lighterASTNode2, lighterASTNode3, ktLightSourceElement, lighterASTNode4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean matcher(KtBinaryExpression $this$matcher, KtNameReferenceExpression variable2) {
        if (!this.canBeAugmented($this$matcher)) {
            return false;
        }
        KtExpression ktExpression = $this$matcher.getLeft();
        KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        if (Intrinsics.areEqual((Object)(ktNameReferenceExpression != null ? ktNameReferenceExpression.getReferencedName() : null), (Object)variable2.getReferencedName())) {
            return true;
        }
        ktExpression = $this$matcher.getRight();
        KtNameReferenceExpression ktNameReferenceExpression2 = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        if (Intrinsics.areEqual((Object)(ktNameReferenceExpression2 != null ? ktNameReferenceExpression2.getReferencedName() : null), (Object)variable2.getReferencedName()) && this.isCommutative($this$matcher)) {
            return true;
        }
        if (this.isCommutative($this$matcher)) {
            boolean isLeftMatch;
            ktExpression = $this$matcher.getLeft();
            KtBinaryExpression leftExpression = ktExpression instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression : null;
            KtExpression ktExpression2 = $this$matcher.getRight();
            KtBinaryExpression rightExpression = ktExpression2 instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression2 : null;
            IElementType iElementType = $this$matcher.getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
            KtBinaryExpression ktBinaryExpression = leftExpression;
            if (this.isHierarchicallyTrue(iElementType, (IElementType)(ktBinaryExpression != null ? ktBinaryExpression.getOperationToken() : null))) {
                boolean bl;
                KtBinaryExpression ktBinaryExpression2 = leftExpression;
                if (ktBinaryExpression2 != null) {
                    if (this.matcher(ktBinaryExpression2, variable2)) {
                        return true;
                    }
                    bl = false;
                } else {
                    bl = false;
                }
                if (bl) {
                    return true;
                }
            }
            boolean bl = isLeftMatch = false;
            if (isLeftMatch) {
                return true;
            }
            IElementType iElementType2 = $this$matcher.getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"getOperationToken(...)");
            KtBinaryExpression ktBinaryExpression3 = rightExpression;
            if (!this.isHierarchicallyTrue(iElementType2, (IElementType)(ktBinaryExpression3 != null ? ktBinaryExpression3.getOperationToken() : null))) return false;
            KtBinaryExpression ktBinaryExpression4 = rightExpression;
            if (ktBinaryExpression4 == null) return false;
            if (!this.matcher(ktBinaryExpression4, variable2)) return false;
            return true;
        }
        ktExpression = $this$matcher.getLeft();
        KtBinaryExpression leftExpression = ktExpression instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression : null;
        IElementType iElementType = $this$matcher.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
        KtBinaryExpression ktBinaryExpression = leftExpression;
        if (!this.isHierarchicallyTrue(iElementType, (IElementType)(ktBinaryExpression != null ? ktBinaryExpression.getOperationToken() : null))) return false;
        KtBinaryExpression ktBinaryExpression5 = leftExpression;
        if (ktBinaryExpression5 == null) return false;
        if (!this.matcher(ktBinaryExpression5, variable2)) return false;
        return true;
    }

    private final boolean isCommutative(KtBinaryExpression $this$isCommutative) {
        return Intrinsics.areEqual((Object)$this$isCommutative.getOperationToken(), (Object)((Object)KtTokens.PLUS)) || Intrinsics.areEqual((Object)$this$isCommutative.getOperationToken(), (Object)((Object)KtTokens.MUL));
    }

    private final boolean canBeAugmented(KtBinaryExpression $this$canBeAugmented) {
        return Intrinsics.areEqual((Object)$this$canBeAugmented.getOperationToken(), (Object)((Object)KtTokens.PLUS)) || Intrinsics.areEqual((Object)$this$canBeAugmented.getOperationToken(), (Object)((Object)KtTokens.MUL)) || Intrinsics.areEqual((Object)$this$canBeAugmented.getOperationToken(), (Object)((Object)KtTokens.MINUS)) || Intrinsics.areEqual((Object)$this$canBeAugmented.getOperationToken(), (Object)((Object)KtTokens.DIV)) || Intrinsics.areEqual((Object)$this$canBeAugmented.getOperationToken(), (Object)((Object)KtTokens.PERC));
    }

    private final boolean isHierarchicallyTrue(IElementType currentOperation, IElementType nextOperation) {
        return Intrinsics.areEqual((Object)currentOperation, (Object)nextOperation);
    }

    private final boolean isCommutativeOperator(LighterASTNode operator) {
        String it = operator.toString();
        boolean bl = false;
        return Intrinsics.areEqual((Object)it, (Object)"+") || Intrinsics.areEqual((Object)it, (Object)"*");
    }

    private final boolean isLightNodesHierarchicallyTrue(LighterASTNode first, LighterASTNode second) {
        return Intrinsics.areEqual((Object)String.valueOf(first), (Object)String.valueOf(second));
    }

    private final boolean canBeAugmented(LighterASTNode $this$canBeAugmented) {
        String it = $this$canBeAugmented.toString();
        boolean bl = false;
        return Intrinsics.areEqual((Object)it, (Object)"+") || Intrinsics.areEqual((Object)it, (Object)"*") || Intrinsics.areEqual((Object)it, (Object)"-") || Intrinsics.areEqual((Object)it, (Object)"/") || Intrinsics.areEqual((Object)it, (Object)"%");
    }
}

