/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsLoop;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.util.AstUtil;

public class JsForIn
extends SourceInfoAwareJsNode
implements JsLoop {
    private JsStatement body;
    private JsExpression iterExpression;
    private JsExpression objectExpression;
    private final JsName iterVarName;

    public JsForIn() {
        this(null);
    }

    public JsForIn(JsName iterVarName) {
        this.iterVarName = iterVarName;
    }

    public JsForIn(JsName iterVarName, JsExpression iterExpression, JsExpression objectExpression, JsStatement body2) {
        this.iterVarName = iterVarName;
        this.iterExpression = iterExpression;
        this.objectExpression = objectExpression;
        this.body = body2;
    }

    public JsStatement getBody() {
        return this.body;
    }

    public JsExpression getIterExpression() {
        return this.iterExpression;
    }

    public JsName getIterVarName() {
        return this.iterVarName;
    }

    public JsExpression getObjectExpression() {
        return this.objectExpression;
    }

    public void setBody(JsStatement body2) {
        this.body = body2;
    }

    public void setIterExpression(JsExpression iterExpression) {
        this.iterExpression = iterExpression;
    }

    public void setObjectExpression(JsExpression objectExpression) {
        this.objectExpression = objectExpression;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitForIn(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        if (this.iterExpression != null) {
            visitor2.acceptLvalue(this.iterExpression);
        }
        visitor2.accept(this.objectExpression);
        visitor2.accept(this.body);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            if (this.iterExpression != null) {
                this.iterExpression = v.acceptLvalue(this.iterExpression);
            }
            this.objectExpression = v.accept(this.objectExpression);
            this.body = v.acceptStatement(this.body);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsForIn deepCopy() {
        JsStatement bodyCopy = AstUtil.deepCopy(this.body);
        JsExpression iterCopy = AstUtil.deepCopy(this.iterExpression);
        JsExpression objectCopy = AstUtil.deepCopy(this.objectExpression);
        JsForIn jsForIn = (JsForIn)new JsForIn(this.iterVarName, iterCopy, objectCopy, bodyCopy).withMetadataFrom(this);
        if (jsForIn == null) {
            JsForIn.$$$reportNull$$$0(0);
        }
        if (jsForIn == null) {
            JsForIn.$$$reportNull$$$1(0);
        }
        if (jsForIn == null) {
            JsForIn.$$$reportNull$$$2(0);
        }
        return jsForIn;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsForIn", "deepCopy"));
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsForIn", "deepCopy"));
    }

    private static /* synthetic */ void $$$reportNull$$$2(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsForIn", "deepCopy"));
    }
}

